/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.logging;

import com.ebay.sdk.logging.CallMetrics;
import com.ebay.sdk.logging.SingleCallMetrics;
import com.ebay.sdk.logging.ThreadLocalSingleCallMetrics;

public class MetricsLogger {
    public static final String KEY_METRICS_LOGGING_ENABLED = "com.ebay.sdk.MetricsLogging";

    public static void enableMetricsLogging() {
        System.setProperty(KEY_METRICS_LOGGING_ENABLED, "true");
    }

    public static boolean metricsLoggingEnabled() {
        String string = System.getProperty(KEY_METRICS_LOGGING_ENABLED);
        return string != null && "true".equalsIgnoreCase(string);
    }

    public static void startRecordingSingleCallMetrics(String string) {
        if (!MetricsLogger.metricsLoggingEnabled()) {
            return;
        }
        ThreadLocalSingleCallMetrics.resetSingleCallMetrics();
        SingleCallMetrics singleCallMetrics = ThreadLocalSingleCallMetrics.getSingleCallMetrics();
        singleCallMetrics.setCallname(string);
        singleCallMetrics.setApiCallStarted(System.currentTimeMillis());
    }

    public static SingleCallMetrics endRecordingSingleCallMetrics() {
        if (!MetricsLogger.metricsLoggingEnabled()) {
            return null;
        }
        SingleCallMetrics singleCallMetrics = ThreadLocalSingleCallMetrics.getSingleCallMetrics();
        singleCallMetrics.setApiCallEnded(System.currentTimeMillis());
        return singleCallMetrics;
    }

    public static SingleCallMetrics getSingleCallMetrics() {
        if (!MetricsLogger.metricsLoggingEnabled()) {
            return null;
        }
        return ThreadLocalSingleCallMetrics.getSingleCallMetrics();
    }

    public static void collectMetrics(CallMetrics callMetrics) {
        if (!MetricsLogger.metricsLoggingEnabled()) {
            return;
        }
        SingleCallMetrics singleCallMetrics = ThreadLocalSingleCallMetrics.getSingleCallMetrics();
        if (null == singleCallMetrics) {
            return;
        }
        callMetrics.addCallMetrics(singleCallMetrics);
    }

    public static void startSdkJAXBCallInvoke() {
        if (!MetricsLogger.metricsLoggingEnabled()) {
            return;
        }
        SingleCallMetrics singleCallMetrics = ThreadLocalSingleCallMetrics.getSingleCallMetrics();
        singleCallMetrics.setSdkJAXBCallInvokeStarted(System.currentTimeMillis());
    }

    public static void recordServerProcessingTime(long l) {
        if (!MetricsLogger.metricsLoggingEnabled()) {
            return;
        }
        SingleCallMetrics singleCallMetrics = ThreadLocalSingleCallMetrics.getSingleCallMetrics();
        singleCallMetrics.setServerProcessingTime(l);
    }

    public static void endSdkJAXBCallInvoke() {
        if (!MetricsLogger.metricsLoggingEnabled()) {
            return;
        }
        SingleCallMetrics singleCallMetrics = ThreadLocalSingleCallMetrics.getSingleCallMetrics();
        singleCallMetrics.setSdkJAXBCallInvokeEnded(System.currentTimeMillis());
    }
}

