/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.logging;

import com.ebay.sdk.logging.CallMetrics;
import com.ebay.sdk.util.eBayUtil;
import java.io.PrintStream;
import java.util.Date;

public class SingleCallMetrics {
    private String callname;
    private long apiCallStarted;
    private long getSocketConnectionStarted;
    private long getSocketConnectionEnded;
    private long socketReadStarted;
    private long apiCallEnded;
    private long serverProcessingTime;
    private long sdkJAXBCallInvokeStarted;
    private long sdkJAXBCallInvokeEnded;

    public long getSdkJAXBCallInvokeStarted() {
        return this.sdkJAXBCallInvokeStarted;
    }

    public long getSdkJAXBCallInvokeEnded() {
        return this.sdkJAXBCallInvokeEnded;
    }

    public long getApiCallEnded() {
        return this.apiCallEnded;
    }

    public long getApiCallStarted() {
        return this.apiCallStarted;
    }

    public long getSocketEnded() {
        return this.getSocketConnectionEnded;
    }

    public long getSocketStarted() {
        return this.getSocketConnectionStarted;
    }

    public long getSocketReadStarted() {
        return this.socketReadStarted;
    }

    public void setSdkJAXBCallInvokeStarted(long l) {
        this.sdkJAXBCallInvokeStarted = l;
    }

    public void setSdkJAXBCallInvokeEnded(long l) {
        this.sdkJAXBCallInvokeEnded = l;
    }

    public void setApiCallEnded(long l) {
        this.apiCallEnded = l;
    }

    public void setApiCallStarted(long l) {
        this.apiCallStarted = l;
    }

    public void setGetSocketEnded(long l) {
        this.getSocketConnectionEnded = l;
    }

    public void setGetSocketStarted(long l) {
        this.getSocketConnectionStarted = l;
    }

    public void setServerProcessingTime(long l) {
        this.serverProcessingTime = l;
    }

    public void setSocketReadStarted(long l) {
        this.socketReadStarted = l;
    }

    public long getTurnaroundTime() {
        return this.getTimeInterval(this.getApiCallStarted(), this.getApiCallEnded());
    }

    public long getPreJAXBInvokeTime() {
        return this.getTimeInterval(this.getApiCallStarted(), this.getSdkJAXBCallInvokeStarted());
    }

    public long getPostJAXBInvokeTime() {
        return this.getTimeInterval(this.getSdkJAXBCallInvokeEnded(), this.getApiCallEnded());
    }

    public long getSocketConnectionTime() {
        return this.getTimeInterval(this.getSocketStarted(), this.getSocketEnded());
    }

    public long getNetworkAndServerTime() {
        return this.getTimeInterval(this.getSdkJAXBCallInvokeStarted(), this.getSdkJAXBCallInvokeEnded());
    }

    public long getServerProcessingTime() {
        return this.serverProcessingTime;
    }

    public long getNetworkTime() {
        return this.getTimeInterval(this.getServerProcessingTime(), this.getNetworkAndServerTime());
    }

    private long getTimeInterval(long l, long l2) {
        if (l == 0L || l2 == 0L) {
            return -1L;
        }
        return l2 - l;
    }

    public void generateReport(PrintStream printStream) {
        CallMetrics.printOneNumber(printStream, this.getTurnaroundTime());
        CallMetrics.printOneNumber(printStream, this.getPreJAXBInvokeTime());
        CallMetrics.printOneNumber(printStream, this.getPostJAXBInvokeTime());
        CallMetrics.printOneNumber(printStream, this.getNetworkTime());
        CallMetrics.printOneNumber(printStream, this.getServerProcessingTime());
        Date date = new Date(this.getApiCallStarted());
        CallMetrics.printOneString(printStream, eBayUtil.toAPITimeString(date), 20);
        printStream.println();
    }

    void updateTotals(long[] lArray) {
        lArray[0] = lArray[0] + this.getTurnaroundTime();
        lArray[1] = lArray[1] + this.getPreJAXBInvokeTime();
        lArray[2] = lArray[2] + this.getPostJAXBInvokeTime();
        lArray[3] = lArray[3] + this.getNetworkTime();
        lArray[4] = lArray[4] + this.getServerProcessingTime();
    }

    public String getCallname() {
        return this.callname;
    }

    public void setCallname(String string) {
        this.callname = string;
    }
}

