/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.util;

import com.ebay.soap.eBLBaseComponents.AttributeSetType;
import com.ebay.soap.eBLBaseComponents.AttributeType;
import com.ebay.soap.eBLBaseComponents.ValType;

public abstract class AttributeHelper {
    public static AttributeType findAttribute(AttributeSetType attributeSetType, int n) {
        AttributeType[] attributeTypeArray = attributeSetType.getAttribute();
        if (attributeTypeArray == null) {
            return null;
        }
        for (int i = 0; i < attributeTypeArray.length; ++i) {
            AttributeType attributeType = attributeTypeArray[i];
            if (attributeType.getAttributeID() != n) continue;
            return attributeType;
        }
        return null;
    }

    private static AttributeType appendNewAttribute(AttributeSetType attributeSetType) {
        AttributeType attributeType;
        AttributeType[] attributeTypeArray = attributeSetType.getAttribute();
        int n = attributeTypeArray == null ? 0 : attributeTypeArray.length;
        AttributeType[] attributeTypeArray2 = new AttributeType[n + 1];
        if (n > 0) {
            for (int i = 0; i < attributeTypeArray.length; ++i) {
                attributeTypeArray2[i] = attributeTypeArray[i];
            }
        }
        attributeTypeArray2[n] = attributeType = new AttributeType();
        attributeSetType.setAttribute(attributeTypeArray2);
        return attributeType;
    }

    public static void insertToAttributeSet(AttributeSetType attributeSetType, int n, int n2, String string) {
        AttributeType attributeType = AttributeHelper.findAttribute(attributeSetType, n);
        if (attributeType == null) {
            attributeType = AttributeHelper.appendNewAttribute(attributeSetType);
            attributeType.setAttributeID(n);
        }
        ValType valType = new ValType();
        if (n2 != 0) {
            valType.setValueID(new Integer(n2));
        }
        valType.setValueLiteral(string);
        ValType[] valTypeArray = new ValType[]{valType};
        attributeType.setValue(valTypeArray);
    }

    public static String getValueLiteral(AttributeSetType attributeSetType, int n) {
        AttributeType attributeType = AttributeHelper.findAttribute(attributeSetType, n);
        if (attributeType == null) {
            return null;
        }
        ValType[] valTypeArray = attributeType.getValue();
        if (attributeType != null && valTypeArray != null && valTypeArray.length > 0) {
            return valTypeArray[0].getValueLiteral();
        }
        return null;
    }

    public static int getValueID(AttributeSetType attributeSetType, int n) {
        AttributeType attributeType = AttributeHelper.findAttribute(attributeSetType, n);
        if (attributeType == null) {
            return 0;
        }
        ValType[] valTypeArray = attributeType.getValue();
        if (attributeType != null && valTypeArray != null && valTypeArray.length > 0) {
            Integer n2 = valTypeArray[0].getValueID();
            return n2 == null ? 0 : n2;
        }
        return 0;
    }

    public static boolean removeAttribute(AttributeSetType attributeSetType, int n) {
        AttributeType attributeType = AttributeHelper.findAttribute(attributeSetType, n);
        if (attributeType == null) {
            return false;
        }
        AttributeType[] attributeTypeArray = attributeSetType.getAttribute();
        AttributeType[] attributeTypeArray2 = new AttributeType[attributeTypeArray.length - 1];
        int n2 = 0;
        for (int i = 0; i < attributeTypeArray.length; ++i) {
            if (attributeTypeArray[i].getAttributeID() == n) continue;
            attributeTypeArray2[n2++] = attributeTypeArray[i];
        }
        attributeSetType.setAttribute(attributeTypeArray2);
        return true;
    }
}

