/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.util;

import com.ebay.sdk.util.XPathUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xpath.XPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class XmlUtil {
    public static String getXmlStringFromSource(Source source) {
        String string = null;
        StreamResult streamResult = new StreamResult(new StringWriter());
        if (source != null) {
            try {
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "1");
                transformer.transform(source, streamResult);
            }
            catch (TransformerException transformerException) {
                transformerException.printStackTrace();
            }
            string = streamResult.getWriter().toString();
        }
        return string;
    }

    public static String getXmlStringFromDom(Document document) {
        DOMSource dOMSource = new DOMSource(document.getDocumentElement());
        return XmlUtil.getXmlStringFromSource(dOMSource);
    }

    public static Document createDom(String string) throws SAXException, IOException, ParserConfigurationException {
        StringReader stringReader = new StringReader(string);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new InputSource(stringReader));
        return document;
    }

    public static Document createDom() throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        return document;
    }

    public static Document createDom(File file) throws SAXException, IOException, ParserConfigurationException {
        FileInputStream fileInputStream = new FileInputStream(file);
        return XmlUtil.createDom(fileInputStream);
    }

    public static Document createDom(InputStream inputStream) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(inputStream);
        return document;
    }

    public static Document createDomByPathname(String string) throws SAXException, IOException, ParserConfigurationException {
        File file = new File(string);
        return XmlUtil.createDom(file);
    }

    public static Element appendChildNode(Document document, Node node, String string) {
        Element element = document.createElement(string);
        node.appendChild(element);
        return element;
    }

    public static Element appendChildNode(Document document, String string, Node node, String string2) {
        Element element = document.createElementNS(string, string2);
        node.appendChild(element);
        return element;
    }

    public static Element appendChildNode(Document document, Node node, String string, int n) {
        Element element = document.createElement(string);
        element.appendChild(document.createTextNode(new Integer(n).toString()));
        node.appendChild(element);
        return element;
    }

    public static Element appendChildNode(Document document, Node node, String string, String string2) {
        Element element = document.createElement(string);
        element.appendChild(document.createTextNode(string2));
        node.appendChild(element);
        return element;
    }

    public static Element appendChildNode(Document document, String string, Node node, String string2, String string3) {
        Element element = document.createElementNS(string, string2);
        element.appendChild(document.createTextNode(string3));
        node.appendChild(element);
        return element;
    }

    public static void appendAttributeNode(Element element, String string, String string2) {
        element.setAttribute(string, string2);
    }

    public static void appendAttributeNode(String string, Element element, String string2, String string3) {
        element.setAttributeNS(string, string2, string3);
    }

    public static void appendAttributeNode(Element element, String string, int n) {
        element.setAttribute(string, new Integer(n).toString());
    }

    public static void appendAttributeNode(String string, Element element, String string2, int n) {
        element.setAttributeNS(string, string2, new Integer(n).toString());
    }

    public static Element appendChildNodeCDATA(Document document, Node node, String string, int n) {
        Element element = document.createElement(string);
        element.appendChild(document.createCDATASection(new Integer(n).toString()));
        node.appendChild(element);
        return element;
    }

    public static Element appendChildNodeCDATA(Document document, Node node, String string, String string2) {
        Element element = document.createElement(string);
        element.appendChild(document.createCDATASection(string2));
        node.appendChild(element);
        return element;
    }

    public static String getChildString(Node node, String string) throws TransformerException {
        Node node2;
        XPath xPath = XPathUtil.createXPath(string);
        NodeList nodeList = XPathUtil.execute(xPath, node);
        if (nodeList != null && nodeList.getLength() > 0 && (node2 = nodeList.item(0).getFirstChild()) != null) {
            return node2.getNodeValue();
        }
        return "";
    }

    public static String getChildStringNS(Element element, String string, String string2) {
        Node node;
        NodeList nodeList = element.getElementsByTagNameNS(string, string2);
        if (nodeList.getLength() > 0 && (node = nodeList.item(0).getFirstChild()) != null) {
            return node.getNodeValue();
        }
        return "";
    }

    public static int getChildInteger(Node node, String string) throws TransformerException {
        int n = -1;
        String string2 = XmlUtil.getChildString(node, string).trim();
        if (string2.length() > 0) {
            n = Integer.parseInt(string2);
        }
        return n;
    }

    public static boolean getChildBoolean(Node node, String string) throws TransformerException {
        boolean bl = false;
        String string2 = XmlUtil.getChildString(node, string).trim();
        if (string2.equals("1")) {
            bl = true;
        }
        return bl;
    }

    public static double getChildDouble(Node node, String string) throws TransformerException {
        double d = 0.0;
        String string2 = XmlUtil.getChildString(node, string).trim();
        if (string2.length() > 0) {
            d = Double.parseDouble(string2);
        }
        return d;
    }

    public static Date getChildDate(Node node, String string) throws TransformerException, ParseException {
        Date date = new Date(0L);
        String string2 = XmlUtil.getChildString(node, string).trim();
        if (string2.length() > 0) {
            DateFormat dateFormat = DateFormat.getInstance();
            date = dateFormat.parse(string2);
        }
        return date;
    }

    public static Node findNode(Node node, String string) {
        if (string.equals(node.getNodeName())) {
            return node;
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = XmlUtil.findNode(nodeList.item(i), string);
            if (node2 == null) continue;
            return node2;
        }
        return null;
    }

    public static Node getChildByName(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals(string)) continue;
            return node2;
        }
        return null;
    }

    public static String getChildStringByName(Node node, String string, String string2) {
        Node node2;
        Node node3 = XmlUtil.getChildByName(node, string);
        if (node3 != null && (node2 = node3.getFirstChild()) != null) {
            return node2.getNodeValue();
        }
        return string2;
    }

    public static int getChildIntegerByName(Node node, String string, int n) {
        String string2 = XmlUtil.getChildStringByName(node, string, "");
        if (string2.length() > 0) {
            return Integer.parseInt(string2);
        }
        return n;
    }

    public static boolean getChildBooleanByName(Node node, String string) {
        String string2 = XmlUtil.getChildStringByName(node, string, "");
        return string2.equals("1");
    }

    public static double getChildDoubleByName(Node node, String string, double d) {
        String string2 = XmlUtil.getChildStringByName(node, string, "");
        if (string2.length() > 0) {
            return Double.parseDouble(string2);
        }
        return d;
    }

    public static String xslTransform(Document document, Document document2) throws TransformerConfigurationException, TransformerException {
        DOMSource dOMSource = new DOMSource(document);
        DOMSource dOMSource2 = new DOMSource(document2);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer(dOMSource2);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        transformer.transform(dOMSource, streamResult);
        return stringWriter.toString();
    }

    public static Node findAttribute(Node node, String string) {
        Node node2 = null;
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Node node3 = namedNodeMap.item(i);
                if (node3.getNodeName().compareToIgnoreCase(string) != 0) continue;
                node2 = node3;
                break;
            }
        }
        return node2;
    }

    public static String getAttributeString(Node node, String string) {
        Node node2 = XmlUtil.findAttribute(node, string);
        if (node2 != null) {
            return node2.getNodeValue();
        }
        return null;
    }

    public static int getAttributeInteger(Node node, String string, int n) {
        String string2 = XmlUtil.getAttributeString(node, string);
        if (string2 != null && string2.length() > 0) {
            return Integer.parseInt(string2);
        }
        return n;
    }

    public static double getAttributeDouble(Node node, String string, double d) {
        String string2 = XmlUtil.getAttributeString(node, string);
        if (string2 != null && string2.length() > 0) {
            return Double.parseDouble(string2);
        }
        return d;
    }

    public static boolean getAttributeBoolean(Node node, String string) {
        String string2 = XmlUtil.getAttributeString(node, string);
        if (string2 != null && string2.length() > 0) {
            return string2.compareToIgnoreCase("1") == 0;
        }
        return false;
    }

    public static void setChildValue(Document document, Node node, String string, String string2) {
        Node node2 = XmlUtil.getChildByName(node, string);
        if (node2 == null) {
            node2 = XmlUtil.appendChildNode(document, node, string);
        }
        if (node2.getFirstChild() == null) {
            node2.appendChild(document.createTextNode(string2));
        } else {
            node2.getFirstChild().setNodeValue(string2);
        }
    }

    public static void setChildValue(Document document, Node node, String string, int n) {
        XmlUtil.setChildValue(document, node, string, new Integer(n).toString());
    }

    public static void saveDomToFile(Document document, String string) throws Exception {
        DOMSource dOMSource = new DOMSource(document);
        File file = new File(string);
        StreamResult streamResult = new StreamResult(file);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.transform(dOMSource, streamResult);
    }
}

