/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.util;

import com.ebay.sdk.SdkException;
import com.ebay.soap.eBLBaseComponents.CategoryType;
import com.ebay.soap.eBLBaseComponents.CharacteristicsSetType;
import com.ebay.soap.eBLBaseComponents.FeeType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.TimeZone;

public class eBayUtil {
    static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    static final String TIME_ZONE = "GMT";

    public static String toAPITimeString(Date date, String string, String string2) {
        SimpleDateFormat simpleDateFormat = null;
        simpleDateFormat = new SimpleDateFormat(string);
        if (string2 != null) {
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone(string2));
        }
        return simpleDateFormat.format(date);
    }

    public static String toAPITimeString(Date date) {
        return eBayUtil.toAPITimeString(date, DATE_FORMAT, TIME_ZONE);
    }

    public static Date fromAPITimeString(String string, String string2, String string3) throws ParseException {
        SimpleDateFormat simpleDateFormat = null;
        simpleDateFormat = new SimpleDateFormat(string2);
        if (string3 != null) {
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone(string3));
        }
        return simpleDateFormat.parse(string);
    }

    public static Date fromAPITimeString(String string) throws ParseException {
        return eBayUtil.fromAPITimeString(string, DATE_FORMAT, TIME_ZONE);
    }

    public static FeeType findFeeByName(FeeType[] feeTypeArray, String string) {
        FeeType feeType = null;
        for (int i = 0; i < feeTypeArray.length; ++i) {
            if (!feeTypeArray[i].getName().equals(string)) continue;
            feeType = feeTypeArray[i];
            break;
        }
        return feeType;
    }

    public static String convertInputStreamToString(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuffer stringBuffer = new StringBuffer();
        while ((string = bufferedReader.readLine()) != null) {
            stringBuffer.append(string + "\n");
        }
        return stringBuffer.toString();
    }

    public static boolean isNonZeroString(String string) {
        return string != null && string.length() > 0;
    }

    public static String intToString(int n) {
        return new Integer(n).toString();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void sortCategoryArray(CategoryType[] categoryTypeArray, int n, boolean bl) throws Exception {
        int n2;
        Hashtable<void, CategoryType> hashtable = new Hashtable<void, CategoryType>();
        for (n2 = 0; n2 < categoryTypeArray.length; ++n2) {
            void var5_5;
            Object var5_6 = null;
            if (n == 1) {
                CharacteristicsSetType[] characteristicsSetTypeArray = categoryTypeArray[n2].getCharacteristicsSets();
                if (characteristicsSetTypeArray == null || characteristicsSetTypeArray.length <= 0) throw new SdkException("No CharacteristicsSet cat be found for the category.");
                Integer n3 = characteristicsSetTypeArray[0].getAttributeSetID();
            } else {
                Integer n4 = new Integer(categoryTypeArray[n2].getCategoryID());
            }
            hashtable.put(var5_5, categoryTypeArray[n2]);
        }
        Object[] objectArray = hashtable.entrySet().toArray();
        for (n2 = 0; n2 < objectArray.length - 1; ++n2) {
            int n5 = (Integer)((Map.Entry)objectArray[n2]).getKey();
            for (int i = n2 + 1; i < objectArray.length; ++i) {
                boolean bl2;
                Map.Entry entry = (Map.Entry)objectArray[i];
                boolean bl3 = bl2 = n5 > (Integer)entry.getKey();
                if ((!bl || !bl2) && (bl || bl2)) continue;
                Object object = objectArray[n2];
                objectArray[n2] = objectArray[i];
                objectArray[i] = object;
                n5 = (Integer)entry.getKey();
            }
        }
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            categoryTypeArray[n2] = (CategoryType)((Map.Entry)objectArray[n2]).getValue();
        }
    }

    public static String getFullPathOfClass(Class clazz) {
        URL uRL = clazz.getProtectionDomain().getCodeSource().getLocation();
        String string = uRL.getPath();
        String[] stringArray = clazz.getName().split("\\.");
        for (int i = 0; i < stringArray.length - 1; ++i) {
            string = string + stringArray[i] + "/";
        }
        return string;
    }
}

