/*
 * Decompiled with CFR 0.152.
 */
package pnp.services.authenticationmanager;

import java.sql.Date;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import pnp.services.authenticationmanager.AuthenticationTimer;
import pnp.services.datatypes.RESTData;
import pnp.services.datatypes.StampsAccount;
import pnp.services.datatypes.webservices.EbayAccountTemp;
import pnp.services.datatypes.webservices.Ebayaccount;
import pnp.services.datatypes.webservices.PaypalAccountTemp;
import pnp.services.datatypes.webservices.Paypalaccount;
import pnp.services.datatypes.webservices.SubscriptionTemp;
import pnp.services.listenermanager.ListenerManager;
import pnp.services.util.LookupServicesUtil;

public class SubscriptionManager {
    private SubscriptionTemp subscription;
    private boolean Current;
    private boolean FinancialsActive;
    private boolean InventoryActive;
    private boolean WebsiteActive;
    private boolean MultiActive;
    private boolean PaypalActive;
    private boolean PrintActive;
    private String userName;
    private String password;
    private String license;
    private String message;
    private String tempAccount;
    private ArrayList<EbayAccountTemp> eBayAccounts;
    private ArrayList<PaypalAccountTemp> paypalAccounts;
    private static SubscriptionManager _instance;
    private String accessToken;
    private String tokenSecret;
    private StampsAccount stampsAccount;
    private Date expire;
    private boolean offline;
    private Date timer;

    public static SubscriptionManager getInstance() {
        if (null == _instance) {
            _instance = new SubscriptionManager();
        }
        return _instance;
    }

    private SubscriptionManager() {
        this.reset();
        this.message = "Invalid";
    }

    public void reset() {
        this.offline = false;
        this.subscription = new SubscriptionTemp();
        this.Current = false;
        this.FinancialsActive = false;
        this.InventoryActive = false;
        this.WebsiteActive = false;
        this.MultiActive = false;
        this.PaypalActive = false;
        this.PrintActive = false;
        this.userName = "";
        this.password = "";
        this.license = "";
        this.eBayAccounts = new ArrayList();
        this.paypalAccounts = new ArrayList();
        this.accessToken = null;
        this.tokenSecret = null;
        this.stampsAccount = new StampsAccount();
        this.expire = null;
        this.timer = null;
    }

    public void updateRESTData() {
        if (this.subscription != null && this.subscription.getCustomerUserName() != null && !this.subscription.getCustomerUserName().isEmpty()) {
            RESTData restData = new RESTData();
            restData.setCurrent(this.Current);
            restData.setFinance(this.FinancialsActive);
            restData.setInventory(this.InventoryActive);
            restData.setMulti(this.MultiActive);
            restData.setPaypal(this.PaypalActive);
            restData.setPrint(this.PrintActive);
            restData.setSubscription(this.subscription);
            restData.setWebsite(this.WebsiteActive);
            restData.setExpire(this.expire);
            restData.setOffline(this.offline);
            restData.setPassword(this.password);
            restData.setLicense(this.license);
            if (this.timer != null) {
                restData.setTimer(this.timer);
            }
            LookupServicesUtil.getDBServices().updateRESTData(restData);
        }
    }

    public void getRESTData() {
        AuthenticationTimer auth = new AuthenticationTimer();
        if ((this.subscription == null || this.subscription.getCustomerUserName() == null || this.subscription.getCustomerUserName().isEmpty()) && !auth.timer()) {
            RESTData restData = LookupServicesUtil.getDBServices().getRESTData(this.userName);
            if (restData.getPassword() != null && restData.getPassword().equalsIgnoreCase(this.password)) {
                this.Current = restData.isCurrent();
                this.FinancialsActive = restData.isFinance();
                this.InventoryActive = restData.isInventory();
                this.MultiActive = restData.isMulti();
                this.PaypalActive = restData.isPaypal();
                this.PrintActive = restData.isPrint();
                this.subscription = restData.getSubscription();
                this.WebsiteActive = restData.isWebsite();
                this.expire = restData.getExpire();
                this.license = restData.getLicense();
                this.offline = true;
                this.timer = restData.getTimer();
                for (Ebayaccount ebayaccount : this.subscription.getEbayaccountCollection()) {
                    this.eBayAccounts.add(new EbayAccountTemp(ebayaccount.getUserToken(), ebayaccount.getEbayAccountID()));
                }
                for (Paypalaccount paypalaccount : this.subscription.getPaypalaccountCollection()) {
                    this.paypalAccounts.add(new PaypalAccountTemp(paypalaccount.getAccessToken(), paypalaccount.getTokenSecret(), paypalaccount.getPaypalAccountID()));
                }
                ListenerManager.getInstance().notify(ListenerManager.EBAY_ACCOUNT_LISTENER);
                ListenerManager.getInstance().notify(ListenerManager.PAYPAL_ACCOUNT_LISTENER);
            } else {
                this.reset();
            }
        }
        this.updateRESTData();
    }

    public ArrayList<EbayAccountTemp> geteBayAccounts() {
        return this.eBayAccounts;
    }

    public void seteBayAccounts(ArrayList<EbayAccountTemp> eBayAccounts) {
        this.eBayAccounts = eBayAccounts;
    }

    public Date getExpire() {
        return this.expire;
    }

    public void setExpire(Date expire) {
        this.expire = expire;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public void setOffline(boolean offline) {
        this.offline = offline;
    }

    public StampsAccount getStampsAccount() {
        return this.stampsAccount;
    }

    public void removeStampsAccount() {
        this.stampsAccount = new StampsAccount();
    }

    public void setStampsAccount(StampsAccount stampsAccount) {
        this.stampsAccount = stampsAccount;
    }

    public boolean isPaypalActive() {
        return this.PaypalActive;
    }

    public void setPaypalActive(boolean PaypalActive) {
        this.PaypalActive = PaypalActive;
    }

    public ArrayList<PaypalAccountTemp> getPaypalAccounts() {
        return this.paypalAccounts;
    }

    public void setPaypalAccounts(ArrayList<PaypalAccountTemp> paypalAccounts) {
        this.paypalAccounts = paypalAccounts;
    }

    public SubscriptionTemp getSubscription() {
        return this.subscription;
    }

    public void setSubscription(SubscriptionTemp subscription) {
        this.subscription = subscription;
    }

    public String getTempAccount() {
        return this.tempAccount;
    }

    public void setTempAccount(String tempAccount) {
        this.tempAccount = tempAccount;
    }

    public boolean isMultiActive() {
        return this.MultiActive;
    }

    public void setMultiActive(boolean MultiActive) {
        this.MultiActive = MultiActive;
    }

    public void setCurrent(boolean Current) {
        this.Current = Current;
    }

    public void setFinancialsActive(boolean FinancialsActive) {
        this.FinancialsActive = FinancialsActive;
    }

    public void setInventoryActive(boolean InventoryActive) {
        this.InventoryActive = InventoryActive;
    }

    public void setWebsiteActive(boolean WebsiteActive) {
        this.WebsiteActive = WebsiteActive;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean isCurrent() {
        return this.Current;
    }

    public boolean isFinancialsActive() {
        return this.FinancialsActive;
    }

    public boolean isInventoryActive() {
        return this.InventoryActive;
    }

    public boolean isWebsiteActive() {
        return this.WebsiteActive;
    }

    public String getMessage() {
        return this.message;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public boolean createEbayAccount(EbayAccountTemp account) {
        boolean status = false;
        if ((this.eBayAccounts.isEmpty() || this.isMultiActive()) && !this.eBayAccounts.contains(account)) {
            this.eBayAccounts.add(account);
            status = true;
        }
        return status;
    }

    public ArrayList<EbayAccountTemp> getEbayAccounts() {
        return this.eBayAccounts;
    }

    public boolean removeEbayAccount(String username) {
        boolean status = false;
        for (int i = 0; i < this.eBayAccounts.size(); ++i) {
            if (!this.eBayAccounts.get(i).getUsername().equals(username)) continue;
            this.eBayAccounts.remove(i);
            status = true;
        }
        return status;
    }

    public boolean removePaypalAccount(String username) {
        boolean status = false;
        for (int i = 0; i < this.paypalAccounts.size(); ++i) {
            if (!this.paypalAccounts.get(i).getAccountID().equals(username)) continue;
            this.paypalAccounts.remove(i);
            status = true;
        }
        return status;
    }

    public void removeAllEBayAccounts() {
        this.eBayAccounts.clear();
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getTokenSecret() {
        return this.tokenSecret;
    }

    public void setTokenSecret(String tokenSecret) {
        this.tokenSecret = tokenSecret;
    }

    public void removeAllPaypalAccounts() {
        this.paypalAccounts.clear();
    }

    public boolean createPaypalAccount(PaypalAccountTemp account) {
        boolean status = false;
        if (this.paypalAccounts.isEmpty() || this.isMultiActive()) {
            if (!this.paypalAccounts.contains(account)) {
                this.paypalAccounts.add(account);
                status = true;
            } else {
                JOptionPane.showMessageDialog(null, "PayPal account: " + account.getAccountID() + ", already exists.");
            }
        } else {
            JOptionPane.showMessageDialog(null, "PayPal account limit exceeded.");
        }
        return status;
    }

    public boolean isPrintActive() {
        return this.PrintActive;
    }

    public void setPrintActive(boolean PrintActive) {
        this.PrintActive = PrintActive;
    }
}

