/*
 * Decompiled with CFR 0.152.
 */
package pnp.services.compare;

import java.util.Comparator;
import pnp.services.datatypes.CompleteOrder;
import pnp.services.datatypes.Item;
import pnp.services.util.LookupServicesUtil;

public class CompleteOrderComparator
implements Comparator<CompleteOrder> {
    public static int ORDER_DATE = 0;
    public static int CUSTOMER_ID = 1;
    public static int CUSTOMER_NAME = 2;
    public static int ITEM_ID = 3;
    public static int ITEM_NAME = 4;
    public static int ITEM_PRICE = 5;
    public static int CUSTOMER_ACCOUNTNAME = 6;
    public static int CUSTOMER_EMAIL = 7;
    public static int COUNTRY = 8;
    public static int EBAY_SITE = 9;
    private int sortBy = 0;

    public CompleteOrderComparator(int sortBy) {
        this.sortBy = sortBy;
    }

    public int getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(int sortBy) {
        this.sortBy = sortBy;
    }

    @Override
    public int compare(CompleteOrder o1, CompleteOrder o2) {
        int returnValue = 0;
        CompleteOrder CompleteOrderElement1 = o1;
        CompleteOrder CompleteOrderElement2 = o2;
        Item item1 = LookupServicesUtil.getDBServices().getItem(CompleteOrderElement1.getOrderDetails().get(0).getItemID());
        Item item2 = LookupServicesUtil.getDBServices().getItem(CompleteOrderElement2.getOrderDetails().get(0).getItemID());
        if (null == CompleteOrderElement1.getOrder()) {
            returnValue = null == CompleteOrderElement2.getOrder() ? 0 : -1;
        } else if (null == CompleteOrderElement2.getOrder()) {
            returnValue = 1;
        } else if (this.sortBy == ORDER_DATE) {
            returnValue = CompleteOrderElement1.getOrder().getOrderDate().compareTo(CompleteOrderElement2.getOrder().getOrderDate());
        } else if (this.sortBy == CUSTOMER_ID) {
            returnValue = CompleteOrderElement1.getOrder().getCustomer().getCustomerUserName().compareTo(CompleteOrderElement2.getOrder().getCustomer().getCustomerUserName());
        } else if (this.sortBy == CUSTOMER_NAME) {
            returnValue = CompleteOrderElement1.getOrder().getCustomer().getCustomerName().compareTo(CompleteOrderElement2.getOrder().getCustomer().getCustomerName());
        } else if (this.sortBy == ITEM_ID) {
            returnValue = CompleteOrderElement1.getOrderDetails().get(0).getItemID().compareTo(CompleteOrderElement2.getOrderDetails().get(0).getItemID());
        } else if (this.sortBy == ITEM_NAME) {
            returnValue = item1.getItemName().compareTo(item2.getItemName());
        } else if (this.sortBy == ITEM_PRICE) {
            returnValue = String.valueOf(CompleteOrderElement1.getOrderDetails().get(0).getItemCost()).compareTo(String.valueOf(CompleteOrderElement2.getOrderDetails().get(0).getItemCost()));
        } else if (this.sortBy == CUSTOMER_ACCOUNTNAME) {
            returnValue = CompleteOrderElement1.getOrderDetails().get(0).getAccountName().compareTo(CompleteOrderElement2.getOrderDetails().get(0).getAccountName());
        } else if (this.sortBy == CUSTOMER_EMAIL) {
            returnValue = CompleteOrderElement1.getOrder().getCustomer().getCustomerEmail().compareTo(CompleteOrderElement2.getOrder().getCustomer().getCustomerEmail());
        } else if (this.sortBy == COUNTRY) {
            returnValue = CompleteOrderElement1.getOrder().getCustomer().getCustomerCountry().compareTo(CompleteOrderElement2.getOrder().getCustomer().getCustomerCountry());
        } else if (this.sortBy == EBAY_SITE) {
            returnValue = CompleteOrderElement1.getOrderDetails().get(0).getEbaySite().compareTo(CompleteOrderElement2.getOrderDetails().get(0).getEbaySite());
        }
        return returnValue;
    }
}

