/*
 * Decompiled with CFR 0.152.
 */
package pnp.services.compare;

import java.sql.Date;
import java.util.Comparator;
import java.util.HashMap;
import pnp.services.datatypes.Distributor;
import pnp.services.datatypes.InventoryElement;
import pnp.services.util.LookupServicesUtil;

public class InventoryComparator
implements Comparator<InventoryElement> {
    public static int ITEM_ID = 0;
    public static int ITEM_QUANTITY = 1;
    public static int ITEM_PRICE = 2;
    public static int ITEM_DISTRIBUTOR = 3;
    public static int ITEM_DATE = 4;
    private int sortBy = 0;

    public InventoryComparator(int sortBy) {
        this.sortBy = sortBy;
    }

    public int getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(int sortBy) {
        this.sortBy = sortBy;
    }

    @Override
    public int compare(InventoryElement o1, InventoryElement o2) {
        int returnValue = 0;
        InventoryElement inventoryElement1 = o1;
        InventoryElement inventoryElement2 = o2;
        if (this.sortBy == ITEM_ID) {
            returnValue = inventoryElement1.getItemID().compareTo(inventoryElement2.getItemID());
        } else if (this.sortBy == ITEM_QUANTITY) {
            returnValue = Integer.valueOf(inventoryElement1.getItemQuantity()).compareTo(inventoryElement2.getItemQuantity());
        } else if (this.sortBy == ITEM_PRICE) {
            returnValue = Float.valueOf(inventoryElement1.getItemCost()).compareTo(Float.valueOf(inventoryElement2.getItemCost()));
        } else if (this.sortBy == ITEM_DISTRIBUTOR) {
            if (null == inventoryElement1.getItem()) {
                returnValue = null == inventoryElement2.getItem() ? 0 : -1;
            } else if (null == inventoryElement2.getItem()) {
                returnValue = 1;
            } else {
                Distributor[] distributors = LookupServicesUtil.getDBServices().getDistributors();
                HashMap<Integer, Distributor> distributorList = new HashMap<Integer, Distributor>();
                for (int i = 0; i < distributors.length; ++i) {
                    distributorList.put(distributors[i].getDistributorID(), distributors[i]);
                }
                returnValue = distributorList.containsKey(inventoryElement1.getItem().getDistributorID()) ? (distributorList.containsKey(inventoryElement2.getItem().getDistributorID()) ? ((Distributor)distributorList.get(inventoryElement1.getItem().getDistributorID())).getDistributorName().compareTo(((Distributor)distributorList.get(inventoryElement2.getItem().getDistributorID())).getDistributorName()) : 1) : (distributorList.containsKey(inventoryElement2.getItem().getDistributorID()) ? -1 : 0);
            }
        } else if (this.sortBy == ITEM_DATE) {
            Date first = inventoryElement1.getStockDate();
            Date second = inventoryElement2.getStockDate();
            returnValue = first == null && second == null ? 0 : (first == null ? 1 : (second == null ? -1 : second.compareTo(first)));
        }
        return returnValue;
    }
}

