/*
 * Decompiled with CFR 0.152.
 */
package pnp.services.compare;

import java.util.Comparator;
import pnp.services.datatypes.Order;

public class OrderComparator
implements Comparator<Order> {
    public static int CUSTOMER_USERNAME = 1;
    public static int CUSTOMER_NAME = 2;
    public static int CUSTOMER_EMAIL = 3;
    public static int ORDER_DATE = 4;
    public static int COUNTRY = 5;
    private int sortBy = 0;

    public OrderComparator(int sortBy) {
        this.sortBy = sortBy;
    }

    public int getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(int sortBy) {
        this.sortBy = sortBy;
    }

    @Override
    public int compare(Order o1, Order o2) {
        int returnValue = 0;
        Order order1 = o1;
        Order order2 = o2;
        if (null == order1.getCustomer()) {
            returnValue = null == order2.getCustomer() ? 0 : -1;
        } else if (null == order2.getCustomer()) {
            returnValue = 1;
        } else if (this.sortBy == CUSTOMER_EMAIL) {
            returnValue = order1.getCustomer().getCustomerEmail().compareTo(order2.getCustomer().getCustomerEmail());
        } else if (this.sortBy == CUSTOMER_NAME) {
            returnValue = order1.getCustomer().getCustomerName().compareTo(order2.getCustomer().getCustomerName());
        } else if (this.sortBy == CUSTOMER_USERNAME) {
            returnValue = order1.getCustomer().getCustomerUserName().compareTo(order2.getCustomer().getCustomerUserName());
        } else if (this.sortBy == ORDER_DATE) {
            if (null != order1.getOrderDate()) {
                returnValue = null == order2.getOrderDate() ? 1 : order1.getOrderDate().compareTo(order2.getOrderDate());
            } else if (null != order2.getOrderDate()) {
                returnValue = -1;
            }
        } else if (this.sortBy == COUNTRY) {
            returnValue = order1.getCustomer().getCustomerCountry().compareTo(order2.getCustomer().getCustomerCountry());
        }
        return returnValue;
    }
}

