/*
 * Decompiled with CFR 0.152.
 */
package pnp.services.compare;

import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import pnp.services.datatypes.PaypalDetails;
import pnp.services.util.ErrorsUtil;

public class PaypalComparator
implements Comparator<PaypalDetails> {
    private String selectedItem = "";

    public PaypalComparator(String selectedItem) {
        this.selectedItem = selectedItem;
    }

    public void setComparator(String selectedItem) {
        this.selectedItem = selectedItem;
    }

    @Override
    public int compare(PaypalDetails o1, PaypalDetails o2) {
        PaypalDetails detail1 = o1;
        PaypalDetails detail2 = o2;
        if (this.selectedItem.equalsIgnoreCase("Country")) {
            if (detail1.getCountryName() == null) {
                detail1.setCountryName("");
            }
            if (detail2.getCountryName() == null) {
                detail2.setCountryName("");
            }
            return detail1.getCountryName().compareTo(detail2.getCountryName());
        }
        if (this.selectedItem.equalsIgnoreCase("State")) {
            if (detail1.getStateOrProvince() == null) {
                detail1.setStateOrProvince("");
            }
            if (detail2.getStateOrProvince() == null) {
                detail2.setStateOrProvince("");
            }
            return detail1.getStateOrProvince().compareTo(detail2.getStateOrProvince());
        }
        if (this.selectedItem.equalsIgnoreCase("Status")) {
            return detail1.getPaymentStatus().compareTo(detail2.getPaymentStatus());
        }
        if (this.selectedItem.equalsIgnoreCase("First Name")) {
            return detail1.getFirstName().compareTo(detail2.getFirstName());
        }
        if (this.selectedItem.equalsIgnoreCase("Last Name")) {
            return detail1.getLastName().compareTo(detail2.getLastName());
        }
        if (this.selectedItem.equalsIgnoreCase("Payment Type")) {
            return detail1.getPaymentType().compareTo(detail2.getPaymentType());
        }
        if (this.selectedItem.equalsIgnoreCase("Payment Status")) {
            return detail1.getPaymentStatus().compareTo(detail2.getPaymentStatus());
        }
        try {
            String format = "yyyy-MM-dd'T'HH:mm:ss'Z'";
            SimpleDateFormat sdf = new SimpleDateFormat(format, Locale.US);
            Date firstDetail = sdf.parse(detail1.getPaymentDate());
            Date secondDetail = sdf.parse(detail2.getPaymentDate());
            return secondDetail.compareTo(firstDetail);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
            return 0;
        }
    }
}

