/*
 * Decompiled with CFR 0.152.
 */
package pnp.services.compare;

import java.util.Comparator;
import java.util.HashMap;
import pnp.services.datatypes.InventoryElement;

public class ReorderComparator
implements Comparator<InventoryElement> {
    public static int ITEM_ID = 0;
    public static int ITEM_SOLD = 1;
    public static int ITEM_REMAINING = 2;
    public static int ITEM_RESTOCK = 3;
    public static HashMap<String, String> remaining;
    public static HashMap<String, String> sold;
    public static HashMap<String, String> restock;
    private int sortBy = 0;

    public ReorderComparator(int sortBy) {
        this.sortBy = sortBy;
    }

    public int getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(int sortBy) {
        this.sortBy = sortBy;
    }

    @Override
    public int compare(InventoryElement o1, InventoryElement o2) {
        int returnValue = 0;
        InventoryElement inventoryElement1 = o1;
        InventoryElement inventoryElement2 = o2;
        if (null == inventoryElement1.getItem()) {
            returnValue = null == inventoryElement2.getItem() ? 0 : -1;
        } else if (null == inventoryElement2.getItem()) {
            returnValue = 1;
        } else if (this.sortBy == ITEM_ID) {
            returnValue = inventoryElement1.getItem().getItemID().compareTo(inventoryElement2.getItem().getItemID());
        } else if (this.sortBy == ITEM_REMAINING) {
            returnValue = this.compareToModify(Integer.parseInt(remaining.get(inventoryElement1.getItemID())), Integer.parseInt(remaining.get(inventoryElement2.getItemID())));
        } else if (this.sortBy == ITEM_RESTOCK) {
            returnValue = this.compareToModify(Integer.parseInt(restock.get(inventoryElement1.getItemID())), Integer.parseInt(restock.get(inventoryElement2.getItemID())));
        } else if (this.sortBy == ITEM_SOLD) {
            returnValue = this.compareToModify(Integer.parseInt(sold.get(inventoryElement1.getItemID())), Integer.parseInt(sold.get(inventoryElement2.getItemID())));
        }
        return returnValue;
    }

    private int compareToModify(int o1, int o2) {
        int returnValue = o1 == o2 ? 0 : (o1 < o2 ? 1 : -1);
        return returnValue;
    }
}

