/*
 * Decompiled with CFR 0.152.
 */
package pnp.services.compare;

import java.util.Comparator;
import pnp.services.datatypes.webservices.WebsiteProduct;

public class WebsiteComparator
implements Comparator<WebsiteProduct> {
    public static int ITEM_ID = 0;
    public static int ITEM_NAME = 1;
    public static int CATEGORY = 2;
    public static int ENABLED = 3;
    private int sortBy = 0;

    public WebsiteComparator(int sortBy) {
        this.sortBy = sortBy;
    }

    public int getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(int sortBy) {
        this.sortBy = sortBy;
    }

    @Override
    public int compare(WebsiteProduct o1, WebsiteProduct o2) {
        int returnValue = 0;
        WebsiteProduct websiteElement1 = o1;
        WebsiteProduct websiteElement2 = o2;
        if (null == websiteElement1.getItem()) {
            returnValue = null == websiteElement2.getItem() ? 0 : -1;
        } else if (null == websiteElement2.getItem()) {
            returnValue = 1;
        } else if (this.sortBy == ITEM_ID) {
            returnValue = websiteElement1.getWebsiteElement().getItemID().compareTo(websiteElement2.getWebsiteElement().getItemID());
        } else if (this.sortBy == ITEM_NAME) {
            returnValue = websiteElement1.getItem().getItemName().compareTo(websiteElement2.getItem().getItemName());
        } else if (this.sortBy == CATEGORY) {
            int value1 = Integer.valueOf(websiteElement1.getWebsiteElement().getCategoryID()) == 0 ? Integer.MAX_VALUE : Integer.valueOf(websiteElement1.getWebsiteElement().getCategoryID());
            int value2 = Integer.valueOf(websiteElement2.getWebsiteElement().getCategoryID()) == 0 ? Integer.MAX_VALUE : Integer.valueOf(websiteElement2.getWebsiteElement().getCategoryID());
            returnValue = Integer.valueOf(value1).compareTo(value2);
        } else if (this.sortBy == ENABLED) {
            returnValue = Boolean.valueOf(websiteElement1.getWebsiteElement().isEnabled()).compareTo(websiteElement2.getWebsiteElement().isEnabled());
        }
        return returnValue;
    }
}

