/*
 * Decompiled with CFR 0.152.
 */
package pnp.services.database;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import pnp.services.localsettings.LocalSettings;
import pnp.services.preferencemanager.Preferences;
import pnp.services.util.DatabaseConnector;
import pnp.services.util.ErrorsUtil;

public class DatabaseLoader {
    private static int VERSION = 5;
    private static boolean baseDatabase = false;

    public static void createArchiveDatabases() {
        baseDatabase = false;
        try {
            Connection archiveConnection = DriverManager.getConnection("jdbc:h2:" + LocalSettings.DIRECTORY + "ArchiveDB" + ";MV_STORE=FALSE" + "?dontTrackOpenResources=true", "admin", "ripcord");
            archiveConnection.setAutoCommit(true);
            DatabaseLoader.loadDatabase(archiveConnection, true);
            Connection newConnection = DriverManager.getConnection("jdbc:h2:" + LocalSettings.DIRECTORY + "NewDB" + ";MV_STORE=FALSE" + "?dontTrackOpenResources=true", "admin", "ripcord");
            newConnection.setAutoCommit(true);
            DatabaseLoader.loadDatabase(newConnection, true);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    public static void loadDatabase() {
        baseDatabase = true;
        Connection dbConnection = DatabaseConnector.selectDatabase();
        DatabaseLoader.loadDatabase(dbConnection, false);
    }

    public static void loadDatabase(Connection dbConnection, boolean overrideSQL) {
        try {
            if (dbConnection != null && (!DatabaseConnector.usingSQLDB || overrideSQL)) {
                Statement stmt = dbConnection.createStatement();
                DatabaseLoader.createTable(stmt, "Customers", "CustomerUserName", "VARCHAR(80)", "NOT NULL");
                DatabaseLoader.addColumn(stmt, "Customers", "CustomerEmail", "VARCHAR(80)");
                DatabaseLoader.addColumn(stmt, "Customers", "CustomerName", "VARCHAR(255)");
                DatabaseLoader.addColumn(stmt, "Customers", "CustomerCountry", "VARCHAR(32)");
                DatabaseLoader.addColumn(stmt, "Customers", "CustomerAddress", "VARCHAR(255)");
                DatabaseLoader.addColumn(stmt, "Customers", "CustomerCity", "VARCHAR(80)");
                DatabaseLoader.addColumn(stmt, "Customers", "CustomerState", "VARCHAR(32)");
                DatabaseLoader.addColumn(stmt, "Customers", "CustomerZipCode", "VARCHAR(12)");
                DatabaseLoader.addColumn(stmt, "Customers", "CustomerComments", "TEXT");
                DatabaseLoader.createTable(stmt, "Orders", "OrderID", "INTEGER", "NOT NULL AUTO_INCREMENT");
                DatabaseLoader.addColumn(stmt, "Orders", "CustomerUserName", "VARCHAR(80)");
                DatabaseLoader.addColumn(stmt, "Orders", "OrderDate", "DATE DEFAULT CURRENT_DATE");
                DatabaseLoader.addColumn(stmt, "Orders", "OrderTotal", "FLOAT");
                DatabaseLoader.addColumn(stmt, "Orders", "ShippingMethodID", "VARCHAR(50)");
                DatabaseLoader.addColumn(stmt, "Orders", "ShippingCost", "FLOAT");
                DatabaseLoader.addColumn(stmt, "Orders", "ShippingPaid", "FLOAT");
                DatabaseLoader.addColumn(stmt, "Orders", "OrderStatusID", "INTEGER");
                DatabaseLoader.addColumn(stmt, "Orders", "OrderComments", "MEDIUMTEXT");
                DatabaseLoader.createTable(stmt, "ShippingMethods", "ShippingMethodName", "VARCHAR(32)", "NOT NULL");
                DatabaseLoader.addColumn(stmt, "ShippingMethods", "DeliveryTimeMin", "INTEGER");
                DatabaseLoader.addColumn(stmt, "ShippingMethods", "DeliveryTimeMax", "INTEGER");
                DatabaseLoader.createTable(stmt, "OrderDetails", "OrderDetailsID", "INTEGER", "NOT NULL AUTO_INCREMENT");
                DatabaseLoader.addColumn(stmt, "OrderDetails", "TransactionID", "VARCHAR(80)");
                DatabaseLoader.addColumn(stmt, "OrderDetails", "OrderID", "INTEGER");
                DatabaseLoader.addColumn(stmt, "OrderDetails", "OrderNumber", "VARCHAR(32)");
                DatabaseLoader.addColumn(stmt, "OrderDetails", "AccountName", "VARCHAR(32)");
                DatabaseLoader.addColumn(stmt, "OrderDetails", "Backordered", "BOOLEAN");
                DatabaseLoader.addColumn(stmt, "OrderDetails", "EbaySite", "VARCHAR(32)");
                DatabaseLoader.addColumn(stmt, "OrderDetails", "ItemCost", "FLOAT");
                DatabaseLoader.addColumn(stmt, "OrderDetails", "ShipDate", "DATE");
                DatabaseLoader.addColumn(stmt, "OrderDetails", "ItemID", "VARCHAR(80)");
                DatabaseLoader.addColumn(stmt, "OrderDetails", "OrderDescription", "VARCHAR(255)");
                DatabaseLoader.addColumn(stmt, "OrderDetails", "SalesPrice", "FLOAT");
                DatabaseLoader.addColumn(stmt, "OrderDetails", "Inhouse", "BOOLEAN");
                DatabaseLoader.addColumn(stmt, "OrderDetails", "Deleted", "BOOLEAN");
                DatabaseLoader.addColumn(stmt, "OrderDetails", "TrackingNumber", "VARCHAR(32) DEFAULT ''");
                DatabaseLoader.addColumn(stmt, "OrderDetails", "Carrier", "VARCHAR(32) DEFAULT ''");
                DatabaseLoader.addColumn(stmt, "OrderDetails", "EbayWeight", "FLOAT");
                DatabaseLoader.createTable(stmt, "OrderStatus", "OrderStatusID", "INTEGER", "NOT NULL AUTO_INCREMENT");
                DatabaseLoader.addColumn(stmt, "OrderStatus", "OrderStatusType", "VARCHAR(32)");
                DatabaseLoader.createTable(stmt, "Inventory", "InventoryID", "INTEGER", "NOT NULL AUTO_INCREMENT");
                DatabaseLoader.addColumn(stmt, "Inventory", "ItemID", "VARCHAR(80)");
                DatabaseLoader.addColumn(stmt, "Inventory", "ItemCost", "FLOAT");
                DatabaseLoader.addColumn(stmt, "Inventory", "ItemQuantity", "INTEGER");
                DatabaseLoader.addColumn(stmt, "Inventory", "OOSItem", "BOOLEAN");
                DatabaseLoader.addColumn(stmt, "Inventory", "StockDate", "DATE");
                DatabaseLoader.createTable(stmt, "Expenses", "ExpenseID", "INTEGER", "NOT NULL AUTO_INCREMENT");
                DatabaseLoader.addColumn(stmt, "Expenses", "ExpenseComment", "VARCHAR(255)");
                DatabaseLoader.addColumn(stmt, "Expenses", "ExpenseCost", "FLOAT");
                DatabaseLoader.addColumn(stmt, "Expenses", "ExpenseDate", "DATE");
                DatabaseLoader.addColumn(stmt, "Expenses", "ExpenseReasonID", "INTEGER");
                DatabaseLoader.addColumn(stmt, "Expenses", "ExpenseReason", "VARCHAR(32)");
                DatabaseLoader.addColumn(stmt, "Expenses", "CompanyName", "VARCHAR(150) DEFAULT 'Default'");
                DatabaseLoader.createTable(stmt, "Items", "ItemID", "VARCHAR(80)", "NOT NULL");
                DatabaseLoader.addColumn(stmt, "Items", "ItemName", "VARCHAR(255)");
                DatabaseLoader.addColumn(stmt, "Items", "ItemWeight", "FLOAT");
                DatabaseLoader.addColumn(stmt, "Items", "ItemDescription", "VARCHAR(255)");
                DatabaseLoader.addColumn(stmt, "Items", "DistributorID", "INTEGER");
                DatabaseLoader.addColumn(stmt, "Items", "DropShipped", "BOOLEAN");
                DatabaseLoader.addColumn(stmt, "Items", "Discontinued", "BOOLEAN");
                DatabaseLoader.addColumn(stmt, "Items", "Location", "VARCHAR(20)");
                DatabaseLoader.addColumn(stmt, "Items", "DistributorProductID", "VARCHAR(80)");
                DatabaseLoader.addColumn(stmt, "Items", "PackedWeight", "FLOAT DEFAULT '0.0'");
                DatabaseLoader.createTable(stmt, "Distributors", "DistributorID", "INTEGER", "NOT NULL AUTO_INCREMENT");
                DatabaseLoader.addColumn(stmt, "Distributors", "DistributorName", "VARCHAR(80)");
                DatabaseLoader.addColumn(stmt, "Distributors", "DistributorContact", "VARCHAR(80)");
                DatabaseLoader.addColumn(stmt, "Distributors", "DistributorPhone", "VARCHAR(32)");
                DatabaseLoader.addColumn(stmt, "Distributors", "DistributorEmail", "VARCHAR(80)");
                DatabaseLoader.addColumn(stmt, "Distributors", "DistributorWebsite", "VARCHAR(80)");
                DatabaseLoader.createTable(stmt, "WebsiteProducts", "ItemID", "VARCHAR(80)", "NOT NULL");
                DatabaseLoader.addColumn(stmt, "WebsiteProducts", "Oem", "VARCHAR(80)");
                DatabaseLoader.addColumn(stmt, "WebsiteProducts", "Price", "FLOAT");
                DatabaseLoader.addColumn(stmt, "WebsiteProducts", "PriceRetail", "FLOAT");
                DatabaseLoader.addColumn(stmt, "WebsiteProducts", "BriefDescription", "TEXT");
                DatabaseLoader.addColumn(stmt, "WebsiteProducts", "Description", "TEXT");
                DatabaseLoader.addColumn(stmt, "WebsiteProducts", "Thumbnail", "VARCHAR(80)");
                DatabaseLoader.addColumn(stmt, "WebsiteProducts", "Photo1", "VARCHAR(80)");
                DatabaseLoader.addColumn(stmt, "WebsiteProducts", "Photo2", "VARCHAR(80)");
                DatabaseLoader.addColumn(stmt, "WebsiteProducts", "Photo3", "VARCHAR(80)");
                DatabaseLoader.addColumn(stmt, "WebsiteProducts", "CategoryID", "INTEGER");
                DatabaseLoader.addColumn(stmt, "WebsiteProducts", "KeyWords", "TEXT");
                DatabaseLoader.addColumn(stmt, "WebsiteProducts", "Enabled", "BOOLEAN");
                DatabaseLoader.addColumn(stmt, "WebsiteProducts", "Featured", "BOOLEAN");
                DatabaseLoader.addColumn(stmt, "WebsiteProducts", "Gender", "VARCHAR(80) DEFAULT 'Unisex'");
                DatabaseLoader.addColumn(stmt, "WebsiteProducts", "AgeGroup", "VARCHAR(80) DEFAULT 'Adult'");
                DatabaseLoader.createTable(stmt, "WebsiteCategories", "WebsiteCategoriesID", "INTEGER", "NOT NULL AUTO_INCREMENT");
                DatabaseLoader.addColumn(stmt, "WebsiteCategories", "WebsiteID", "INTEGER");
                DatabaseLoader.addColumn(stmt, "WebsiteCategories", "CategoryID", "INTEGER");
                DatabaseLoader.createTable(stmt, "Categories", "CategoryID", "INTEGER", "NOT NULL AUTO_INCREMENT");
                DatabaseLoader.addColumn(stmt, "Categories", "CategoryName", "VARCHAR(80)");
                DatabaseLoader.createTable(stmt, "Websites", "WebsiteID", "INTEGER", "NOT NULL AUTO_INCREMENT");
                DatabaseLoader.addColumn(stmt, "Websites", "WebsiteName", "VARCHAR(80)");
                DatabaseLoader.addColumn(stmt, "Websites", "WebsiteURI", "VARCHAR(255)");
                DatabaseLoader.addColumn(stmt, "Websites", "WebsiteActive", "BOOLEAN");
                DatabaseLoader.addColumn(stmt, "Websites", "LastUpdate", "LONG");
                DatabaseLoader.createTable(stmt, "ExpenseReasons", "ExpenseReasonID", "INTEGER", "NOT NULL AUTO_INCREMENT");
                DatabaseLoader.addColumn(stmt, "ExpenseReasons", "Reason", "VARCHAR(80)");
                DatabaseLoader.createTable(stmt, "SalesTax", "Abbreviation", "VARCHAR(2)", "NOT NULL");
                DatabaseLoader.addColumn(stmt, "SalesTax", "Identifier", "VARCHAR(32)");
                DatabaseLoader.addColumn(stmt, "SalesTax", "Cost", "FLOAT DEFAULT '0.0'");
                DatabaseLoader.addColumn(stmt, "SalesTax", "Enabled", "BOOLEAN DEFAULT 'FALSE'");
                DatabaseLoader.createTable(stmt, "CustomFees", "CustomFeeID", "INTEGER", "NOT NULL AUTO_INCREMENT");
                DatabaseLoader.addColumn(stmt, "CustomFees", "CustomFeeName", "VARCHAR(32)");
                DatabaseLoader.addColumn(stmt, "CustomFees", "CustomFeePercentage", "DOUBLE");
                DatabaseLoader.addColumn(stmt, "CustomFees", "CustomFeeFlatCost", "DOUBLE");
                DatabaseLoader.createTable(stmt, "RMADetails", "RmaNumberID", "INTEGER", "NOT NULL AUTO_INCREMENT");
                DatabaseLoader.addColumn(stmt, "RMADetails", "RMAComments", "TEXT");
                DatabaseLoader.addColumn(stmt, "RMADetails", "RMADate", "DATE");
                DatabaseLoader.addColumn(stmt, "RMADetails", "CustomerUserName", "VARCHAR(80)");
                DatabaseLoader.addColumn(stmt, "RMADetails", "OrderDetailsID", "INTEGER");
                DatabaseLoader.addColumn(stmt, "RMADetails", "ReplacementTracking", "VARCHAR(32)");
                DatabaseLoader.addColumn(stmt, "RMADetails", "ReturnTracking", "VARCHAR(32)");
                DatabaseLoader.addColumn(stmt, "RMADetails", "RmaReasonID", "INTEGER");
                DatabaseLoader.addColumn(stmt, "RMADetails", "RmaStatusID", "INTEGER");
                DatabaseLoader.createTable(stmt, "RMAReason", "RMAReasonID", "INTEGER", "NOT NULL AUTO_INCREMENT");
                DatabaseLoader.addColumn(stmt, "RMAReason", "RMAReasonType", "VARCHAR(32)");
                DatabaseLoader.createTable(stmt, "RMAStatus", "RMAStatusID", "INTEGER", "NOT NULL AUTO_INCREMENT");
                DatabaseLoader.addColumn(stmt, "RMAStatus", "RMAStatusType", "VARCHAR(32)");
                DatabaseLoader.createTable(stmt, "PaypalTransactions", "PayPalTransactionID", "VARCHAR(80)", "NOT NULL");
                DatabaseLoader.addColumn(stmt, "PaypalTransactions", "EmailAddress", "VARCHAR(80)");
                DatabaseLoader.addColumn(stmt, "PaypalTransactions", "FirstName", "VARCHAR(80)");
                DatabaseLoader.addColumn(stmt, "PaypalTransactions", "LastName", "VARCHAR(80)");
                DatabaseLoader.addColumn(stmt, "PaypalTransactions", "CountryCode", "VARCHAR(3)");
                DatabaseLoader.addColumn(stmt, "PaypalTransactions", "CountryName", "VARCHAR(80)");
                DatabaseLoader.addColumn(stmt, "PaypalTransactions", "Street1", "VARCHAR(150)");
                DatabaseLoader.addColumn(stmt, "PaypalTransactions", "Street2", "VARCHAR(150)");
                DatabaseLoader.addColumn(stmt, "PaypalTransactions", "CityName", "VARCHAR(80)");
                DatabaseLoader.addColumn(stmt, "PaypalTransactions", "StateOrProvince", "VARCHAR(128)");
                DatabaseLoader.addColumn(stmt, "PaypalTransactions", "PostalCode", "VARCHAR(20)");
                DatabaseLoader.addColumn(stmt, "PaypalTransactions", "TransactionType", "VARCHAR(80)");
                DatabaseLoader.addColumn(stmt, "PaypalTransactions", "PaymentType", "VARCHAR(80)");
                DatabaseLoader.addColumn(stmt, "PaypalTransactions", "PaymentDate", "VARCHAR(80)");
                DatabaseLoader.addColumn(stmt, "PaypalTransactions", "GrossAmount", "FLOAT");
                DatabaseLoader.addColumn(stmt, "PaypalTransactions", "PaymentStatus", "VARCHAR(80)");
                DatabaseLoader.addColumn(stmt, "PaypalTransactions", "ShippingMethod", "VARCHAR(80)");
                DatabaseLoader.addColumn(stmt, "PaypalTransactions", "Custom", "VARCHAR(128)");
                DatabaseLoader.addColumn(stmt, "PaypalTransactions", "Memo", "TEXT");
                DatabaseLoader.addColumn(stmt, "PaypalTransactions", "BuyerID", "VARCHAR(80)");
                DatabaseLoader.addColumn(stmt, "PaypalTransactions", "ClosingDate", "VARCHAR(80)");
                DatabaseLoader.addColumn(stmt, "PaypalTransactions", "MultiItem", "VARCHAR(80)");
                DatabaseLoader.addColumn(stmt, "PaypalTransactions", "Linked", "BOOLEAN");
                DatabaseLoader.addColumn(stmt, "PaypalTransactions", "Tax", "FLOAT");
                DatabaseLoader.addColumn(stmt, "PaypalTransactions", "CurrencyCode", "VARCHAR(10)");
                DatabaseLoader.addColumn(stmt, "PaypalTransactions", "ShippingAmount", "FLOAT");
                DatabaseLoader.addColumn(stmt, "PaypalTransactions", "PayPalAccount", "VARCHAR(150)");
                DatabaseLoader.createTable(stmt, "EbayTransactions", "EbayTransactionID", "VARCHAR(80)", "NOT NULL", "PaypalTransactions", "PayPalTransactionID", "VARCHAR(80)");
                DatabaseLoader.addColumn(stmt, "EbayTransactions", "AuctionName", "VARCHAR(256)");
                DatabaseLoader.addColumn(stmt, "EbayTransactions", "Quantity", "INTEGER");
                DatabaseLoader.addColumn(stmt, "EbayTransactions", "Cost", "FLOAT");
                DatabaseLoader.addColumn(stmt, "EbayTransactions", "ReferenceNumber", "VARCHAR(128)");
                DatabaseLoader.createTable(stmt, "PrintDetails", "OrderID", "VARCHAR(32)", "NOT NULL");
                DatabaseLoader.addColumn(stmt, "PrintDetails", "Customer", "VARCHAR(128)");
                DatabaseLoader.addColumn(stmt, "PrintDetails", "Email", "VARCHAR(256)");
                DatabaseLoader.addColumn(stmt, "PrintDetails", "FirstName", "VARCHAR(50)");
                DatabaseLoader.addColumn(stmt, "PrintDetails", "LastName", "VARCHAR(50)");
                DatabaseLoader.addColumn(stmt, "PrintDetails", "Street1", "VARCHAR(150)");
                DatabaseLoader.addColumn(stmt, "PrintDetails", "Street2", "VARCHAR(150)");
                DatabaseLoader.addColumn(stmt, "PrintDetails", "CountryCode", "VARCHAR(2)");
                DatabaseLoader.addColumn(stmt, "PrintDetails", "City", "VARCHAR(32)");
                DatabaseLoader.addColumn(stmt, "PrintDetails", "State", "VARCHAR(40)");
                DatabaseLoader.addColumn(stmt, "PrintDetails", "PostalCode", "VARCHAR(20)");
                DatabaseLoader.addColumn(stmt, "PrintDetails", "Weight", "DOUBLE");
                DatabaseLoader.addColumn(stmt, "PrintDetails", "Shipping", "OTHER");
                DatabaseLoader.addColumn(stmt, "PrintDetails", "Package", "OTHER");
                DatabaseLoader.addColumn(stmt, "PrintDetails", "ShippingType", "VARCHAR(150)");
                DatabaseLoader.addColumn(stmt, "PrintDetails", "PackageType", "VARCHAR(150)");
                DatabaseLoader.addColumn(stmt, "PrintDetails", "IndiciumID", "TEXT");
                DatabaseLoader.addColumn(stmt, "PrintDetails", "StampsID", "VARCHAR(80)");
                DatabaseLoader.addColumn(stmt, "PrintDetails", "Tracking", "VARCHAR(80)");
                DatabaseLoader.addColumn(stmt, "PrintDetails", "URL", "MEDIUMTEXT");
                DatabaseLoader.addColumn(stmt, "PrintDetails", "Cost", "DOUBLE");
                DatabaseLoader.addColumn(stmt, "PrintDetails", "Scan", "BOOLEAN");
                DatabaseLoader.addColumn(stmt, "PrintDetails", "Error", "BOOLEAN");
                DatabaseLoader.addColumn(stmt, "PrintDetails", "Canceled", "BOOLEAN");
                DatabaseLoader.addColumn(stmt, "PrintDetails", "Printed", "BOOLEAN");
                DatabaseLoader.addColumn(stmt, "PrintDetails", "LabelInstructions", "TEXT");
                DatabaseLoader.addColumn(stmt, "PrintDetails", "DateEntered", "DATE");
                DatabaseLoader.addColumn(stmt, "PrintDetails", "Copies", "INTEGER");
                DatabaseLoader.addColumn(stmt, "PrintDetails", "ParentOrderID", "VARCHAR(32)");
                DatabaseLoader.addColumn(stmt, "PrintDetails", "OrderTotal", "DOUBLE");
                DatabaseLoader.addColumn(stmt, "PrintDetails", "ShipDate", "DATE");
                DatabaseLoader.addColumn(stmt, "PrintDetails", "PackedWeight", "DOUBLE");
                DatabaseLoader.addColumn(stmt, "PrintDetails", "ActualErrorDetails", "TEXT");
                DatabaseLoader.addColumn(stmt, "PrintDetails", "DeclaredValue", "DOUBLE");
                DatabaseLoader.addColumn(stmt, "PrintDetails", "PrintDate", "TIMESTAMP");
                DatabaseLoader.addColumn(stmt, "PrintDetails", "PrintID", "INTEGER");
                DatabaseLoader.addColumn(stmt, "PrintDetails", "PrintPage", "INTEGER");
                DatabaseLoader.addColumn(stmt, "PrintDetails", "PayPalAccount", "VARCHAR(150)");
                DatabaseLoader.createTable(stmt, "CheckDetails", "CheckID", "INTEGER", "NOT NULL AUTO_INCREMENT", "PrintDetails", "OrderID", "VARCHAR(32)");
                DatabaseLoader.addColumn(stmt, "CheckDetails", "OrderDetailsID", "INTEGER");
                DatabaseLoader.addColumn(stmt, "CheckDetails", "Weight", "FLOAT");
                DatabaseLoader.addColumn(stmt, "CheckDetails", "PackedWeight", "FLOAT");
                DatabaseLoader.addColumn(stmt, "CheckDetails", "PayPalAccount", "VARCHAR(150)");
                DatabaseLoader.addColumn(stmt, "CheckDetails", "Discontinued", "BOOLEAN");
                DatabaseLoader.addColumn(stmt, "CheckDetails", "QuantityRemaining", "INTEGER");
                DatabaseLoader.addColumn(stmt, "CheckDetails", "ItemID", "VARCHAR(150)");
                DatabaseLoader.createTable(stmt, "AccountPreferences", "GenProfile", "VARCHAR(128)", "NOT NULL");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "GenProfiles", "OTHER");
                DatabaseLoader.createTable(stmt, "Profiles", "Profile", "VARCHAR(128)", "NOT NULL");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "GenNegativeNotification", "BOOLEAN");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "GenRefreshBehavior", "BOOLEAN");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "GenSalesPeriod", "INTEGER");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "GenStockNotification", "INTEGER");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "GenTrackingNotify", "BOOLEAN");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "GenUnmergeNotify", "BOOLEAN");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "GenBusinessName", "VARCHAR(128)");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "GenInvoiceComments", "TEXT");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "GenWebsiteAddress", "VARCHAR(128)");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "GenVersion", "INTEGER");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "GenSyncNotification", "BOOLEAN DEFAULT 'TRUE'");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "GenSplitRefresh", "BOOLEAN");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "GenInventoryRefresh", "BOOLEAN");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "GenBetaUpdates", "BOOLEAN");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "SubOfflineMode", "BOOLEAN");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "SubSaveCredentials", "BOOLEAN");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "SubLicense", "VARCHAR(128)");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "SubPassword", "VARCHAR(128)");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "SubUsername", "VARCHAR(128)");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "EbayLastUpdate", "LONG");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "PaypalAutoLink", "BOOLEAN");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "PaypalDomesticAddon", "DOUBLE");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "PaypalDomesticFee", "DOUBLE");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "PaypalInternationalAddon", "DOUBLE");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "PaypalInternationalFee", "DOUBLE");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "PaypalLastUpdate", "LONG");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "StampsSaveCredentials", "BOOLEAN");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "StampsSignatureConfirm", "BOOLEAN");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "StampsAddress", "VARCHAR(128)");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "StampsCity", "VARCHAR(128)");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "StampsCountry", "VARCHAR(2)");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "StampsFullName", "VARCHAR(128)");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "StampsImageLocation", "VARCHAR(128)");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "StampsPassword", "VARCHAR(128)");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "StampsPhoneNumber", "VARCHAR(128)");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "StampsPostalCode", "VARCHAR(5)");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "StampsState", "VARCHAR(2)");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "StampsUsername", "VARCHAR(128)");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "StampsLabelStatus", "VARCHAR(128)");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "StampsPrintLabels", "BOOLEAN");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "StampsPurchaseLabels", "BOOLEAN");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "StampsSaveLabels", "BOOLEAN");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "StampsTracking", "BOOLEAN");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "StampsPrintOptions", "VARCHAR(20)");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "StampsPageOptions", "VARCHAR(20)");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "StampsHideNotification", "BOOLEAN");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "StampsStorageDays", "INTEGER");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "StampsDateNotification", "BOOLEAN");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "StampsPackedWeight", "BOOLEAN");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "StampsAutoPurchase", "BOOLEAN");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "StampsAutoPurchaseLimit", "FLOAT");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "StampsAutoPurchaseWarning", "BOOLEAN");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "StampsInvalidPackageNotification", "BOOLEAN");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "StampsPurchaseDateNotification", "BOOLEAN");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "StampsComments", "BOOLEAN");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "StampsNIAFilter", "BOOLEAN");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "StampsMixedInventoryNotification", "BOOLEAN");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "StampsAccount", "VARCHAR(80)");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "StampsEndiciaUsername", "VARCHAR(80)");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "StampsEndiciaPassword", "VARCHAR(80)");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "StampsUPSUsername", "VARCHAR(80)");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "StampsUPSPassword", "VARCHAR(80)");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "StampsUPSAccessKey", "VARCHAR(80)");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "StampsUPSAccountNumber", "VARCHAR(80)");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "StampsCommercialPlus", "BOOLEAN");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "StampsInternationalWarning", "BOOLEAN");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "StampsInternationalWarningPrice", "FLOAT DEFAULT '100.0f'");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "CompanyDefaultCompany", "VARCHAR(150) DEFAULT 'Default'");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "StampsOOSWarning", "VARCHAR(80) DEFAULT 'Out Of Stock - Confirm Quantity'");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "StampsDiscoWarning", "VARCHAR(80) DEFAULT 'Discontinued - Confirm & Remove'");
                DatabaseLoader.addColumn(stmt, "AccountPreferences", "PaypalAccounts", "OTHER");
                DatabaseLoader.createTable(stmt, "PayPalAccounts", "PayPalAccount", "VARCHAR(128)", "NOT NULL");
                DatabaseLoader.addColumn(stmt, "Orders", "OrderPaypal", "VARCHAR(128) DEFAULT 'Default'");
                DatabaseLoader.createTable(stmt, "Companies", "CompanyName", "VARCHAR(128)", "NOT NULL");
                DatabaseLoader.addColumn(stmt, "Companies", "CompanyWebsite", "VARCHAR(128)");
                DatabaseLoader.addColumn(stmt, "Companies", "CompanyComments", "VARCHAR(128)");
                DatabaseLoader.addColumn(stmt, "Companies", "CompanyAddress", "VARCHAR(128)");
                DatabaseLoader.addColumn(stmt, "Companies", "CompanyCity", "VARCHAR(128)");
                DatabaseLoader.addColumn(stmt, "Companies", "CompanyCountry", "VARCHAR(2)");
                DatabaseLoader.addColumn(stmt, "Companies", "CompanyFullName", "VARCHAR(128)");
                DatabaseLoader.addColumn(stmt, "Companies", "CompanyPhoneNumber", "VARCHAR(128)");
                DatabaseLoader.addColumn(stmt, "Companies", "CompanyPostalCode", "VARCHAR(5)");
                DatabaseLoader.addColumn(stmt, "Companies", "CompanyState", "VARCHAR(2)");
                DatabaseLoader.addColumn(stmt, "Companies", "CompanyPaypalLinks", "OTHER");
                DatabaseLoader.createTable(stmt, "CompanyLinks", "PayPalLink", "VARCHAR(128)", "NOT NULL");
                DatabaseLoader.addColumn(stmt, "CompanyLinks", "CompanyName", "VARCHAR(128)");
                DatabaseLoader.createTable(stmt, "License", "License", "VARCHAR(80)", "NOT NULL");
                DatabaseLoader.createTable(stmt, "EbayAccount", "EbayAccountNumber", "INTEGER", "NOT NULL AUTO_INCREMENT");
                DatabaseLoader.addColumn(stmt, "EbayAccount", "EbayAccountID", "VARCHAR(80)");
                DatabaseLoader.addColumn(stmt, "EbayAccount", "UserToken", "TEXT");
                DatabaseLoader.addColumn(stmt, "EbayAccount", "UserName", "VARCHAR(80) NOT NULL");
                DatabaseLoader.createTable(stmt, "PaypalAccount", "PaypalAccountNumber", "INTEGER", "NOT NULL AUTO_INCREMENT");
                DatabaseLoader.addColumn(stmt, "PaypalAccount", "PaypalAccountID", "VARCHAR(80)");
                DatabaseLoader.addColumn(stmt, "PaypalAccount", "AccessToken", "TEXT");
                DatabaseLoader.addColumn(stmt, "PaypalAccount", "TokenSecret", "TEXT");
                DatabaseLoader.addColumn(stmt, "PaypalAccount", "UserName", "VARCHAR(80) NOT NULL");
                DatabaseLoader.createTable(stmt, "AmazonAccount", "AmazonAccountNumber", "INTEGER", "NOT NULL AUTO_INCREMENT");
                DatabaseLoader.addColumn(stmt, "AmazonAccount", "AmazonAccountID", "VARCHAR(80)");
                DatabaseLoader.addColumn(stmt, "AmazonAccount", "UserToken", "TEXT");
                DatabaseLoader.addColumn(stmt, "AmazonAccount", "UserName", "VARCHAR(80) NOT NULL");
                DatabaseLoader.addColumn(stmt, "AmazonAccount", "MwsAuthToken", "VARCHAR(80) NOT NULL");
                DatabaseLoader.createTable(stmt, "Subscription", "UserName", "VARCHAR(80)", "NOT NULL");
                DatabaseLoader.addColumn(stmt, "Subscription", "Password", "VARCHAR(80)");
                DatabaseLoader.addColumn(stmt, "Subscription", "Finance", "BOOLEAN");
                DatabaseLoader.addColumn(stmt, "Subscription", "Inventory", "BOOLEAN");
                DatabaseLoader.addColumn(stmt, "Subscription", "Website", "BOOLEAN");
                DatabaseLoader.addColumn(stmt, "Subscription", "Multi", "BOOLEAN");
                DatabaseLoader.addColumn(stmt, "Subscription", "Paypal", "BOOLEAN");
                DatabaseLoader.addColumn(stmt, "Subscription", "Print", "BOOLEAN");
                DatabaseLoader.addColumn(stmt, "Subscription", "Current", "BOOLEAN");
                DatabaseLoader.addColumn(stmt, "Subscription", "Offline", "BOOLEAN");
                DatabaseLoader.addColumn(stmt, "Subscription", "Expire", "DATE");
                DatabaseLoader.addColumn(stmt, "Subscription", "Timer", "DATE");
                DatabaseLoader.addColumn(stmt, "Subscription", "License", "VARCHAR(128)");
                DatabaseLoader.createTable(stmt, "ETSYACCOUNTS", "EtsyLogin", "EtsyStore", "VARCHAR(128)", "NOT NULL");
                DatabaseLoader.addColumn(stmt, "ETSYACCOUNTS", "Token", "VARCHAR(128)");
                DatabaseLoader.addColumn(stmt, "ETSYACCOUNTS", "TokenSecret", "VARCHAR(128)");
                DatabaseLoader.createTable(stmt, "PayPalFilterList", "FilterID", "VARCHAR(150)", "NOT NULL");
                DatabaseLoader.createTable(stmt, "Website_Category_Associations", "WebsiteCategoryID", "INTEGER", "NOT NULL");
                DatabaseLoader.addColumn(stmt, "Website_Category_Associations", "GoogleCategoryName", "VARCHAR(255)");
                DatabaseLoader.addColumn(stmt, "Website_Category_Associations", "BingCategoryName", "VARCHAR(255)");
                if (baseDatabase) {
                    DatabaseLoader.updateDatabase(stmt);
                } else {
                    DatabaseLoader.createIndexes("", stmt);
                }
                DatabaseConnector.removeObject(stmt);
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private static ResultSet executeQuery(String sql, Statement stmt) {
        return DatabaseConnector.createStatementResultSet(stmt, sql, "DBLoaderExecuteQuery");
    }

    private static void executeUpdate(String sql, Statement stmt) {
        try {
            stmt.executeUpdate(sql);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private static void alterTable(String sql, Statement stmt, String table, String column, String type) {
        sql = "ALTER TABLE " + table + " ALTER COLUMN " + column + " " + type;
        DatabaseLoader.executeUpdate(sql, stmt);
    }

    private static void updateDatabase(Statement stmt) {
        try {
            int Version = 0;
            String sql = "SELECT GenVersion FROM AccountPreferences";
            ResultSet rs = DatabaseLoader.executeQuery(sql, stmt);
            if (rs != null && rs.next()) {
                Version = rs.getInt("GenVersion");
            }
            if (Version <= 0) {
                DatabaseLoader.defaultValues(sql, stmt);
                Preferences.getInstance().updateAccountPreferences();
            }
            if (Version <= 1) {
                DatabaseLoader.alterTable(sql, stmt, "PrintDetails", "OrderID", "VARCHAR(32)");
            }
            if (Version <= 2) {
                DatabaseLoader.createOrder(sql, stmt, "Admin Hold");
            }
            if (Version <= 3) {
                DatabaseLoader.alterTable(sql, stmt, "PrintDetails", "Customer", "VARCHAR(128)");
                DatabaseLoader.alterTable(sql, stmt, "PrintDetails", "Email", "VARCHAR(256)");
                DatabaseLoader.alterTable(sql, stmt, "PrintDetails", "FirstName", "VARCHAR(50)");
                DatabaseLoader.alterTable(sql, stmt, "PrintDetails", "LastName", "VARCHAR(50)");
                DatabaseLoader.alterTable(sql, stmt, "PrintDetails", "Street1", "VARCHAR(150)");
                DatabaseLoader.alterTable(sql, stmt, "PrintDetails", "Street2", "VARCHAR(150)");
            }
            if (Version <= 4) {
                DatabaseLoader.alterTable(sql, stmt, "PaypalTransactions", "Memo", "TEXT");
                DatabaseLoader.alterTable(sql, stmt, "PaypalTransactions", "Street1", "VARCHAR(150)");
                DatabaseLoader.alterTable(sql, stmt, "PaypalTransactions", "Street2", "VARCHAR(150)");
            }
            if (Version <= 5) {
                DatabaseLoader.alterTable(sql, stmt, "PrintDetails", "IndiciumID", "TEXT");
            }
            if (Version <= 6) {
                DatabaseLoader.alterTable(sql, stmt, "OrderDetails", "SalesPrice", "FLOAT");
            }
            if (Version <= 7) {
                DatabaseLoader.alterTable(sql, stmt, "EbayTransactions", "ReferenceNumber", "VARCHAR(128)");
            }
            if (Version <= 8) {
                DatabaseLoader.alterTable(sql, stmt, "AmazonAccount", "MwsAuthToken", "VARCHAR(80)");
            }
            Version = 9;
            sql = "UPDATE AccountPreferences SET GenVersion = " + Version;
            DatabaseLoader.executeUpdate(sql, stmt);
            Preferences.getInstance().resetPreferences();
            DatabaseConnector.removeObject(rs);
            DatabaseConnector.removeObject(stmt);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private static void addColumn(Statement stmt, String table, String column, String type) {
        try {
            String sql = "ALTER TABLE " + table + " ADD IF NOT EXISTS " + column + " " + type;
            stmt.executeUpdate(sql);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private static void createTable(Statement stmt, String table, String column, String column2, String type, String addon) {
        try {
            String sql = "CREATE TABLE IF NOT EXISTS " + table + "(" + column + " " + type + " " + addon + ", " + column2 + " " + type + " " + addon + ", " + "PRIMARY KEY(" + column + ", " + column2 + "))";
            stmt.executeUpdate(sql);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private static void createTable(Statement stmt, String table, String column, String type, String addon) {
        try {
            String sql = "CREATE TABLE IF NOT EXISTS " + table + "(" + column + " " + type + " " + addon + ", " + "PRIMARY KEY(" + column + "))";
            stmt.executeUpdate(sql);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private static void createTable(Statement stmt, String table, String primaryKey, String primaryKeyType, String addon, String foreignTable, String foreignKey, String foreignType) {
        try {
            String sql = "CREATE TABLE IF NOT EXISTS " + table + " (" + primaryKey + " " + primaryKeyType + " " + addon + ", " + foreignKey + " " + foreignType + ", " + "foreign key(" + foreignKey + ") references " + foreignTable + "(" + foreignKey + "), " + "Primary key(" + primaryKey + "))";
            stmt.executeUpdate(sql);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private static void createShipping(String sql, Statement stmt, String name, String min, String max) {
        try {
            sql = "UPDATE ShippingMethods SET ShippingMethodName='" + name + "', " + "DeliveryTimeMin=" + min + ", DeliveryTimeMax=" + max + " " + " WHERE ShippingMethodName='" + name + "'";
            stmt.executeUpdate(sql);
            if (0 == stmt.getUpdateCount()) {
                sql = "INSERT INTO ShippingMethods  (ShippingMethodName, DeliveryTimeMin, DeliveryTimeMax) Values ('" + name + "', " + min + ", " + max + ")";
                stmt.executeUpdate(sql);
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private static void createOrder(String sql, Statement stmt, String name) {
        try {
            sql = "UPDATE OrderStatus SET OrderStatusType='" + name + "' " + " WHERE OrderStatusType='" + name + "'";
            stmt.executeUpdate(sql);
            if (0 == stmt.getUpdateCount()) {
                sql = "INSERT INTO OrderStatus  (OrderStatusType) Values ('" + name + "')";
                stmt.executeUpdate(sql);
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private static void createRMAReason(String sql, Statement stmt, String name) {
        try {
            sql = "UPDATE RMAReason SET RMAReasonType='" + name + "' " + " WHERE RMAReasonType='" + name + "'";
            stmt.executeUpdate(sql);
            if (0 == stmt.getUpdateCount()) {
                sql = "INSERT INTO RMAReason (RMAReasonType) Values ('" + name + "')";
                stmt.executeUpdate(sql);
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private static void createRMAStatus(String sql, Statement stmt, String name) {
        try {
            sql = "UPDATE RMAStatus SET RMAStatusType='" + name + "' " + " WHERE RMAStatusType='" + name + "'";
            stmt.executeUpdate(sql);
            if (0 == stmt.getUpdateCount()) {
                sql = "INSERT INTO RMAStatus (RMAStatusType) Values ('" + name + "')";
                stmt.executeUpdate(sql);
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private static void createDistributor(String sql, Statement stmt, String name) {
        try {
            sql = "INSERT INTO Distributors (DistributorName) Values ('" + name + "')";
            stmt.executeUpdate(sql);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private static void createCustomFee(String sql, Statement stmt, String name, String percent, String flatCost) {
        try {
            sql = "INSERT INTO CustomFees (CustomFeeName, CustomFeePercentage, CustomFeeFlatCost) Values ('" + name + "', " + percent + ", " + flatCost + ")";
            stmt.executeUpdate(sql);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private static void defaultValues(String sql, Statement stmt) {
        DatabaseLoader.createShipping(sql, stmt, "Standard", "5", "12");
        DatabaseLoader.createShipping(sql, stmt, "Expedited", "3", "6");
        DatabaseLoader.createShipping(sql, stmt, "2-Day", "1", "3");
        DatabaseLoader.createOrder(sql, stmt, "New");
        DatabaseLoader.createOrder(sql, stmt, "Pending");
        DatabaseLoader.createOrder(sql, stmt, "Pending Print");
        DatabaseLoader.createOrder(sql, stmt, "Print");
        DatabaseLoader.createOrder(sql, stmt, "Export Labels");
        DatabaseLoader.createOrder(sql, stmt, "Pending MO");
        DatabaseLoader.createOrder(sql, stmt, "Pending E-Check");
        DatabaseLoader.createOrder(sql, stmt, "OOS");
        DatabaseLoader.createOrder(sql, stmt, "NPB");
        DatabaseLoader.createOrder(sql, stmt, "Canceled");
        DatabaseLoader.createOrder(sql, stmt, "Complete");
        DatabaseLoader.createOrder(sql, stmt, "Admin Hold");
        DatabaseLoader.createRMAReason(sql, stmt, "");
        DatabaseLoader.createRMAReason(sql, stmt, "Defective");
        DatabaseLoader.createRMAReason(sql, stmt, "Wrong Item");
        DatabaseLoader.createRMAReason(sql, stmt, "Changed Mind");
        DatabaseLoader.createRMAReason(sql, stmt, "Wrong Size");
        DatabaseLoader.createRMAStatus(sql, stmt, "New RMA");
        DatabaseLoader.createRMAStatus(sql, stmt, "Pending Response");
        DatabaseLoader.createRMAStatus(sql, stmt, "Exchanging");
        DatabaseLoader.createRMAStatus(sql, stmt, "Return Label Issued");
        DatabaseLoader.createRMAStatus(sql, stmt, "Returning");
        DatabaseLoader.createRMAStatus(sql, stmt, "Return Processed");
        DatabaseLoader.createRMAStatus(sql, stmt, "Reshipped");
        DatabaseLoader.createRMAStatus(sql, stmt, "Refunded");
        DatabaseLoader.createCustomFee(sql, stmt, "EBay Standard", "0.09", "0.00");
        DatabaseLoader.createCustomFee(sql, stmt, "EBay TRS 20%", "0.072", "0.00");
        DatabaseLoader.createDistributor(sql, stmt, "Default");
        try {
            ArrayList<String> States = DatabaseLoader.fillStates();
            for (String state : States) {
                sql = "INSERT INTO SalesTax(Abbreviation) Values ('" + state + "')";
                stmt.executeUpdate(sql);
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private static void createIndexes(String sql, Statement stmt) {
        try {
            sql = "CREATE INDEX IF NOT EXISTS INDEX_TRANSACTIONIDIDX ON OrderDetails(TransactionID)";
            stmt.executeUpdate(sql);
            sql = "CREATE INDEX IF NOT EXISTS INDEX_EXPENSESIDX ON Expenses(ExpenseDate, ExpenseReasonID)";
            stmt.executeUpdate(sql);
            sql = "CREATE INDEX IF NOT EXISTS INDEX_EbayTransactionsIDX ON EbayTransactions(PaypalTransactionID)";
            stmt.executeUpdate(sql);
            sql = "CREATE INDEX IF NOT EXISTS INDEX_ORDERSIDX ON Orders(OrderStatusID, OrderDate)";
            stmt.executeUpdate(sql);
            sql = "CREATE INDEX IF NOT EXISTS INDEX_CUSTOMERSIDX ON Customers(CustomerEmail)";
            stmt.executeUpdate(sql);
            sql = "CREATE INDEX IF NOT EXISTS INDEX_DISTRIBUTORSIDX ON Distributors(DistributorName)";
            stmt.executeUpdate(sql);
            sql = "CREATE INDEX IF NOT EXISTS INDEX_INVENTORY_ITEMID_IDX ON Inventory(ItemID)";
            stmt.executeUpdate(sql);
            sql = "CREATE INDEX IF NOT EXISTS INDEX_INVENTORY_ITEMNAME_IDX ON Items(ItemName)";
            stmt.executeUpdate(sql);
            sql = "CREATE INDEX IF NOT EXISTS INDEX_INVENTORY_ITEMDESCRIPTION_IDX ON Items(ItemDescription)";
            stmt.executeUpdate(sql);
            sql = "CREATE INDEX IF NOT EXISTS INDEX_INVENTORY_ITEMLOCATION_IDX ON Items(Location)";
            stmt.executeUpdate(sql);
            sql = "CREATE INDEX IF NOT EXISTS INDEX_INVENTORY_ITEMDISTRIBUTOR_IDX ON Items(DistributorProductID)";
            stmt.executeUpdate(sql);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private static ArrayList<String> fillStates() {
        ArrayList<String> States = new ArrayList<String>();
        States.add("AL");
        States.add("AK");
        States.add("AZ");
        States.add("AR");
        States.add("CA");
        States.add("CO");
        States.add("CT");
        States.add("DE");
        States.add("FL");
        States.add("GA");
        States.add("HI");
        States.add("ID");
        States.add("IL");
        States.add("IN");
        States.add("IA");
        States.add("KS");
        States.add("KY");
        States.add("LA");
        States.add("ME");
        States.add("MD");
        States.add("MA");
        States.add("MI");
        States.add("MN");
        States.add("MS");
        States.add("MO");
        States.add("MT");
        States.add("NE");
        States.add("NV");
        States.add("NH");
        States.add("NJ");
        States.add("NM");
        States.add("NY");
        States.add("NC");
        States.add("ND");
        States.add("OH");
        States.add("OK");
        States.add("OR");
        States.add("PA");
        States.add("RI");
        States.add("SC");
        States.add("SD");
        States.add("TN");
        States.add("TX");
        States.add("UT");
        States.add("VT");
        States.add("VA");
        States.add("WA");
        States.add("WV");
        States.add("WI");
        States.add("WY");
        return States;
    }
}

