/*
 * Decompiled with CFR 0.152.
 */
package pnp.services.datatypes;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JOptionPane;
import pnp.services.datatypes.CompanyInfo;
import pnp.services.preferencemanager.Preferences;
import pnp.services.util.ErrorsUtil;

public class AccountPreferences {
    private List<String> genProfiles;
    private String genProfile;
    private boolean genNegativeNotification;
    private boolean genRefreshBehavior;
    private int genSalesPeriod;
    private int genStockNotification;
    private boolean genTrackingNotify;
    private boolean genUnmergeNotify;
    private String genBusinessName;
    private String genInvoiceComments;
    private String genWebsiteAddress;
    private int genVersion;
    private boolean genSyncNotification;
    private boolean genSplitRefresh;
    private boolean genInventoryRefresh;
    private boolean genBetaUpdates;
    private boolean subOfflineMode;
    private boolean subSaveCredentials;
    private String subLicense;
    private String subPassword;
    private String subUsername;
    private long ebayLastUpdate;
    private long paypalLastUpdate;
    private boolean paypalAutoLink;
    private Double paypalDomesticAddon;
    private Double paypalDomesticFee;
    private Double paypalInternationalAddon;
    private Double paypalInternationalFee;
    private ArrayList<String> paypalFilterList;
    private boolean stampsSaveCredentials;
    private boolean stampsSignatureConfirm;
    private String stampsAddress;
    private String stampsCity;
    private String stampsCountry;
    private String stampsFullName;
    private String stampsImageLocation;
    private String stampsPassword;
    private String stampsPhoneNumber;
    private String stampsPostalCode;
    private String stampsState;
    private String stampsUsername;
    private boolean stampsTracking;
    private boolean stampsSaveLabels;
    private boolean stampsPurchaseLabels;
    private boolean stampsPrintLabels;
    private String stampsLabelStatus;
    private String stampsPrintOptions;
    private String stampsPageOptions;
    private int stampsStorageDays;
    private boolean stampsHideNotification;
    private boolean stampsDateNotification;
    private boolean stampsPackedWeight;
    private float stampsAutoPurchaseLimit;
    private boolean stampsAutoPurchase;
    private boolean stampsAutoPurchaseWarning;
    private boolean stampsInvalidPackageNotification;
    private boolean stampsPurchaseDateNotification;
    private boolean stampsComments;
    private boolean stampsNIAFilter;
    private boolean stampsMixedInventoryNotification;
    private String stampsAccount;
    private String stampsEndiciaUserName;
    private String stampsEndiciaPassword;
    private String stampsUPSUserName;
    private String stampsUPSPassword;
    private String stampsUPSAccessKey;
    private String stampsUPSAccountNumber;
    private boolean stampsCommercialPlus;
    private boolean stampsInternationalWarning;
    private float stampsInternationalWarningPrice;
    private String stampsOOSWarning;
    private String stampsDiscoWarning;
    private String companyDefaultCompany;
    private HashMap<String, CompanyInfo> companyInformation;
    private ArrayList<String> paypalAccounts;
    public static String STAMPS = "Stamps";
    public static String ENDICIA = "Endicia";
    public static String UPS = "UPS";
    public static String COMPLETED = "Completed";
    public static String EXPORTLABELS = "Export Labels";
    public static String SINGLE = "SINGLE";
    public static String DUPLEX = "DUPLEX";
    public static String HALFPAGE = "HALF PAGE";
    public static String FULLPAGE = "FULL PAGE";
    public static int NEVER = -1;
    public static int FIRST = 0;
    public static int SIXTEENTH = 16;
    private HashMap<String, String> paypalMap;
    private ArrayList<String> companyMap;

    public AccountPreferences() {
        this.reset();
    }

    private void reset() {
        this.genProfiles = new ArrayList<String>();
        this.genProfiles.add("DEFAULT");
        this.genProfile = "DEFAULT";
        this.genNegativeNotification = true;
        this.genRefreshBehavior = true;
        this.genSalesPeriod = 1;
        this.genStockNotification = 1;
        this.genTrackingNotify = true;
        this.genUnmergeNotify = true;
        this.genBusinessName = "";
        this.genInvoiceComments = "";
        this.genWebsiteAddress = "";
        this.genVersion = 1;
        this.genSyncNotification = true;
        this.genSplitRefresh = false;
        this.genInventoryRefresh = false;
        this.genBetaUpdates = false;
        this.subOfflineMode = false;
        this.subSaveCredentials = true;
        this.subLicense = "";
        this.subPassword = "";
        this.subUsername = "";
        this.ebayLastUpdate = 0L;
        this.paypalLastUpdate = 0L;
        this.paypalAutoLink = false;
        this.paypalDomesticAddon = 0.3;
        this.paypalDomesticFee = 2.9;
        this.paypalInternationalAddon = 0.3;
        this.paypalInternationalFee = 3.9;
        this.paypalFilterList = new ArrayList();
        this.stampsSaveCredentials = true;
        this.stampsSignatureConfirm = true;
        this.stampsAddress = "";
        this.stampsCity = "";
        this.stampsCountry = "";
        this.stampsFullName = "";
        this.stampsImageLocation = "";
        this.stampsPassword = "";
        this.stampsPhoneNumber = "";
        this.stampsPostalCode = "";
        this.stampsState = "";
        this.stampsUsername = "";
        this.stampsTracking = false;
        this.stampsSaveLabels = false;
        this.stampsPurchaseLabels = false;
        this.stampsPrintLabels = false;
        this.stampsLabelStatus = EXPORTLABELS;
        this.stampsPrintOptions = SINGLE;
        this.stampsPageOptions = HALFPAGE;
        this.stampsHideNotification = true;
        this.stampsDateNotification = true;
        this.stampsPackedWeight = false;
        this.stampsAutoPurchaseLimit = 0.0f;
        this.stampsAutoPurchase = false;
        this.stampsAutoPurchaseWarning = true;
        this.stampsInvalidPackageNotification = true;
        this.stampsPurchaseDateNotification = true;
        this.stampsStorageDays = 30;
        this.stampsComments = false;
        this.stampsNIAFilter = true;
        this.stampsMixedInventoryNotification = true;
        this.stampsAccount = STAMPS;
        this.stampsEndiciaUserName = "";
        this.stampsEndiciaPassword = "";
        this.stampsUPSUserName = "";
        this.stampsUPSPassword = "";
        this.stampsUPSAccessKey = "";
        this.stampsUPSAccountNumber = "";
        this.stampsCommercialPlus = false;
        this.stampsInternationalWarning = true;
        this.stampsInternationalWarningPrice = 100.0f;
        this.stampsOOSWarning = "Out Of Stock - Confirm Quantity";
        this.stampsDiscoWarning = "Discontinued - Confirm & Remove";
        this.companyInformation = new HashMap();
        this.paypalAccounts = new ArrayList();
        this.paypalMap = new HashMap();
        this.companyMap = new ArrayList();
        this.companyDefaultCompany = "Default";
    }

    public ArrayList<String> getPaypalFilterList() {
        return this.paypalFilterList;
    }

    public void setPaypalFilterList(ArrayList<String> paypalFilterList) {
        this.paypalFilterList = paypalFilterList;
    }

    public String getStampsOOSWarning() {
        return this.stampsOOSWarning;
    }

    public void setStampsOOSWarning(String stampsOOSWarning) {
        this.stampsOOSWarning = stampsOOSWarning;
    }

    public String getStampsDiscoWarning() {
        return this.stampsDiscoWarning;
    }

    public void setStampsDiscoWarning(String stampsDiscoWarning) {
        this.stampsDiscoWarning = stampsDiscoWarning;
    }

    public float getStampsInternationalWarningPrice() {
        return this.stampsInternationalWarningPrice;
    }

    public void setStampsInternationalWarningPrice(float stampsInternationalWarningPrice) {
        this.stampsInternationalWarningPrice = stampsInternationalWarningPrice;
    }

    public boolean isStampsInternationalWarning() {
        return this.stampsInternationalWarning;
    }

    public void setStampsInternationalWarning(boolean stampsInternationalWarning) {
        this.stampsInternationalWarning = stampsInternationalWarning;
    }

    public ArrayList<String> getPaypalAccounts() {
        if (this.paypalAccounts == null) {
            this.paypalAccounts = new ArrayList();
        }
        return this.paypalAccounts;
    }

    public void setPaypalAccounts(ArrayList<String> paypalAccounts) {
        this.paypalAccounts = paypalAccounts;
    }

    public void setCompanyDefaultCompany(String company) {
        this.companyDefaultCompany = company;
    }

    public String getCompanyDefaultCompany() {
        return this.companyDefaultCompany;
    }

    public boolean isGenBetaUpdates() {
        return this.genBetaUpdates;
    }

    public void setGenBetaUpdates(boolean genBetaUpdates) {
        this.genBetaUpdates = genBetaUpdates;
    }

    public boolean isGenSplitRefresh() {
        return this.genSplitRefresh;
    }

    public void setGenSplitRefresh(boolean genSplitRefresh) {
        this.genSplitRefresh = genSplitRefresh;
    }

    public boolean isGenInventoryRefresh() {
        return this.genInventoryRefresh;
    }

    public void setGenInventoryRefresh(boolean genInventoryRefresh) {
        this.genInventoryRefresh = genInventoryRefresh;
    }

    public boolean isGenSyncNotification() {
        return this.genSyncNotification;
    }

    public void setGenSyncNotification(boolean genSyncNotification) {
        this.genSyncNotification = genSyncNotification;
    }

    public boolean isStampsCommercialPlus() {
        return this.stampsCommercialPlus;
    }

    public void setStampsCommercialPlus(boolean stampsCommercialPlus) {
        this.stampsCommercialPlus = stampsCommercialPlus;
    }

    public String getStampsAccount() {
        return this.stampsAccount;
    }

    public void setStampsAccount(String stampsAccount) {
        this.stampsAccount = stampsAccount;
    }

    public String getStampsEndiciaUserName() {
        return this.stampsEndiciaUserName;
    }

    public void setStampsEndiciaUserName(String stampsEndiciaUserName) {
        this.stampsEndiciaUserName = stampsEndiciaUserName;
    }

    public String getStampsEndiciaPassword() {
        return this.stampsEndiciaPassword;
    }

    public void setStampsEndiciaPassword(String stampsEndiciaPassword) {
        this.stampsEndiciaPassword = stampsEndiciaPassword;
    }

    public long getPaypalLastUpdate() {
        return this.paypalLastUpdate;
    }

    public void setPaypalLastUpdate(long paypalLastUpdate) {
        this.paypalLastUpdate = paypalLastUpdate;
    }

    public boolean isStampsMixedInventoryNotification() {
        return this.stampsMixedInventoryNotification;
    }

    public boolean isStampsNIAFilter() {
        return this.stampsNIAFilter;
    }

    public void setStampsNIAFilter(boolean stampsNIAFilter) {
        this.stampsNIAFilter = stampsNIAFilter;
    }

    public void setStampsMixedInventoryNotification(boolean stampsMixedInventoryNotification) {
        this.stampsMixedInventoryNotification = stampsMixedInventoryNotification;
    }

    public boolean isStampsComments() {
        return this.stampsComments;
    }

    public void setStampsComments(boolean stampsComments) {
        this.stampsComments = stampsComments;
    }

    public boolean isStampsPurchaseDateNotification() {
        return this.stampsPurchaseDateNotification;
    }

    public void setStampsPurchaseDateNotification(boolean stampsPurchaseDateNotification) {
        this.stampsPurchaseDateNotification = stampsPurchaseDateNotification;
    }

    public boolean isStampsInvalidPackageNotification() {
        return this.stampsInvalidPackageNotification;
    }

    public void setStampsInvalidPackageNotification(boolean stampsInvalidPackageNotification) {
        this.stampsInvalidPackageNotification = stampsInvalidPackageNotification;
    }

    public boolean isStampsAutoPurchase() {
        return this.stampsAutoPurchase;
    }

    public void setStampsAutoPurchase(boolean stampsAutoPurchase) {
        this.stampsAutoPurchase = stampsAutoPurchase;
    }

    public float getStampsAutoPurchaseLimit() {
        return this.stampsAutoPurchaseLimit;
    }

    public void setStampsAutoPurchaseLimit(float stampsAutoPurchaseLimit) {
        this.stampsAutoPurchaseLimit = stampsAutoPurchaseLimit;
    }

    public boolean isStampsPackedWeight() {
        return this.stampsPackedWeight;
    }

    public void setStampsPackedWeight(boolean stampsPackedWeight) {
        this.stampsPackedWeight = stampsPackedWeight;
    }

    public boolean isStampsDateNotification() {
        return this.stampsDateNotification;
    }

    public void setStampsDateNotification(boolean stampsDateNotification) {
        this.stampsDateNotification = stampsDateNotification;
    }

    public List<String> getGenProfiles() {
        return this.genProfiles;
    }

    public void setGenProfiles(List<String> genProfiles) {
        this.genProfiles = genProfiles;
    }

    public String getGenProfile() {
        return this.genProfile;
    }

    public void setGenProfile(String genProfile) {
        this.genProfile = genProfile;
    }

    public boolean isGenNegativeNotification() {
        return this.genNegativeNotification;
    }

    public void setGenNegativeNotification(boolean genNegativeNotification) {
        this.genNegativeNotification = genNegativeNotification;
    }

    public boolean isGenRefreshBehavior() {
        return this.genRefreshBehavior;
    }

    public void setGenRefreshBehavior(boolean genRefreshBehavior) {
        this.genRefreshBehavior = genRefreshBehavior;
    }

    public int getGenSalesPeriod() {
        return this.genSalesPeriod;
    }

    public void setGenSalesPeriod(int genSalesPeriod) {
        this.genSalesPeriod = genSalesPeriod;
    }

    public int getGenStockNotification() {
        return this.genStockNotification;
    }

    public void setGenStockNotification(int genStockNotification) {
        this.genStockNotification = genStockNotification;
    }

    public boolean isGenTrackingNotify() {
        return this.genTrackingNotify;
    }

    public void setGenTrackingNotify(boolean genTrackingNotify) {
        this.genTrackingNotify = genTrackingNotify;
    }

    public boolean isGenUnmergeNotify() {
        return this.genUnmergeNotify;
    }

    public void setGenUnmergeNotify(boolean genUnmergeNotify) {
        this.genUnmergeNotify = genUnmergeNotify;
    }

    public String getGenBusinessName() {
        return this.genBusinessName;
    }

    public void setGenBusinessName(String genBusinessName) {
        this.genBusinessName = genBusinessName;
    }

    public String getGenInvoiceComments() {
        return this.genInvoiceComments;
    }

    public void setGenInvoiceComments(String genInvoiceComments) {
        this.genInvoiceComments = genInvoiceComments;
    }

    public String getGenWebsiteAddress() {
        return this.genWebsiteAddress;
    }

    public void setGenWebsiteAddress(String genWebsiteAddress) {
        this.genWebsiteAddress = genWebsiteAddress;
    }

    public boolean isSubOfflineMode() {
        return this.subOfflineMode;
    }

    public void setSubOfflineMode(boolean subOfflineMode) {
        this.subOfflineMode = subOfflineMode;
    }

    public boolean isSubSaveCredentials() {
        return this.subSaveCredentials;
    }

    public void setSubSaveCredentials(boolean subSaveCredentials) {
        this.subSaveCredentials = subSaveCredentials;
    }

    public String getSubLicense() {
        return this.subLicense;
    }

    public void setSubLicense(String subLicense) {
        this.subLicense = subLicense;
    }

    public String getSubPassword() {
        return this.subPassword;
    }

    public void setSubPassword(String subPassword) {
        this.subPassword = subPassword;
    }

    public String getSubUsername() {
        return this.subUsername;
    }

    public void setSubUsername(String subUsername) {
        this.subUsername = subUsername;
    }

    public boolean isPaypalAutoLink() {
        return this.paypalAutoLink;
    }

    public void setPaypalAutoLink(boolean paypalAutoLink) {
        this.paypalAutoLink = paypalAutoLink;
    }

    public Double getPaypalDomesticAddon() {
        return this.paypalDomesticAddon;
    }

    public void setPaypalDomesticAddon(Double paypalDomesticAddon) {
        this.paypalDomesticAddon = paypalDomesticAddon;
    }

    public Double getPaypalDomesticFee() {
        return this.paypalDomesticFee;
    }

    public void setPaypalDomesticFee(Double paypalDomesticFee) {
        this.paypalDomesticFee = paypalDomesticFee;
    }

    public Double getPaypalInternationalAddon() {
        return this.paypalInternationalAddon;
    }

    public void setPaypalInternationalAddon(Double paypalInternationalAddon) {
        this.paypalInternationalAddon = paypalInternationalAddon;
    }

    public Double getPaypalInternationalFee() {
        return this.paypalInternationalFee;
    }

    public void setPaypalInternationalFee(Double paypalInternationalFee) {
        this.paypalInternationalFee = paypalInternationalFee;
    }

    public boolean isStampsSaveCredentials() {
        return this.stampsSaveCredentials;
    }

    public void setStampsSaveCredentials(boolean stampsSaveCredentials) {
        this.stampsSaveCredentials = stampsSaveCredentials;
    }

    public boolean isStampsSignatureConfirm() {
        return this.stampsSignatureConfirm;
    }

    public void setStampsSignatureConfirm(boolean stampsSignatureConfirm) {
        this.stampsSignatureConfirm = stampsSignatureConfirm;
    }

    public String getStampsAddress() {
        return this.stampsAddress;
    }

    public void setStampsAddress(String stampsAddress) {
        this.stampsAddress = stampsAddress;
    }

    public String getStampsCity() {
        return this.stampsCity;
    }

    public void setStampsCity(String stampsCity) {
        this.stampsCity = stampsCity;
    }

    public String getStampsCountry() {
        return this.stampsCountry;
    }

    public void setStampsCountry(String stampsCountry) {
        this.stampsCountry = stampsCountry;
    }

    public String getStampsFullName() {
        return this.stampsFullName;
    }

    public void setStampsFullName(String stampsFullName) {
        this.stampsFullName = stampsFullName;
    }

    public String getStampsImageLocation() {
        return this.stampsImageLocation;
    }

    public void setStampsImageLocation(String stampsImageLocation) {
        this.stampsImageLocation = stampsImageLocation;
    }

    public String getStampsPassword() {
        return this.stampsPassword;
    }

    public void setStampsPassword(String stampsPassword) {
        this.stampsPassword = stampsPassword;
    }

    public String getStampsPhoneNumber() {
        return this.stampsPhoneNumber;
    }

    public void setStampsPhoneNumber(String stampsPhoneNumber) {
        this.stampsPhoneNumber = stampsPhoneNumber;
    }

    public String getStampsPostalCode() {
        return this.stampsPostalCode;
    }

    public void setStampsPostalCode(String stampsPostalCode) {
        this.stampsPostalCode = stampsPostalCode;
    }

    public String getStampsState() {
        return this.stampsState;
    }

    public void setStampsState(String stampsState) {
        this.stampsState = stampsState;
    }

    public String getStampsUsername() {
        return this.stampsUsername;
    }

    public void setStampsUsername(String stampsUsername) {
        this.stampsUsername = stampsUsername;
    }

    public boolean isStampsTracking() {
        return this.stampsTracking;
    }

    public void setStampsTracking(boolean stampsTracking) {
        this.stampsTracking = stampsTracking;
    }

    public boolean isStampsSaveLabels() {
        return this.stampsSaveLabels;
    }

    public void setStampsSaveLabels(boolean stampsSaveLabels) {
        this.stampsSaveLabels = stampsSaveLabels;
    }

    public boolean isStampsPurchaseLabels() {
        return this.stampsPurchaseLabels;
    }

    public void setStampsPurchaseLabels(boolean stampsPurchaseLabels) {
        this.stampsPurchaseLabels = stampsPurchaseLabels;
    }

    public boolean isStampsPrintLabels() {
        return this.stampsPrintLabels;
    }

    public void setStampsPrintLabels(boolean stampsPrintLabels) {
        this.stampsPrintLabels = stampsPrintLabels;
    }

    public String getStampsLabelStatus() {
        return this.stampsLabelStatus;
    }

    public void setStampsLabelStatus(String stampsLabelStatus) {
        this.stampsLabelStatus = stampsLabelStatus;
    }

    public int getGenVersion() {
        return this.genVersion;
    }

    public void setGenVersion(int genVersion) {
        this.genVersion = genVersion;
    }

    public long getEbayLastUpdate() {
        return this.ebayLastUpdate;
    }

    public String getEbayLastUpdateString() {
        SimpleDateFormat formatter = new SimpleDateFormat("dd MMM yyyy HH:mm:ss");
        String lastUpdateString = 0L != this.ebayLastUpdate ? formatter.format(this.ebayLastUpdate) : "UNKNOWN";
        return lastUpdateString;
    }

    public void setEbayLastUpdate(long ebayLastUpdate) {
        this.ebayLastUpdate = ebayLastUpdate;
    }

    public String getStampsPrintOptions() {
        return this.stampsPrintOptions;
    }

    public void setStampsPrintOptions(String stampsPrintOptions) {
        this.stampsPrintOptions = stampsPrintOptions;
    }

    public String getStampsPageOptions() {
        return this.stampsPageOptions;
    }

    public void setStampsPageOptions(String stampsPageOptions) {
        if (stampsPageOptions == null) {
            stampsPageOptions = HALFPAGE;
        }
        this.stampsPageOptions = stampsPageOptions;
    }

    public int getStampsStorageDays() {
        return this.stampsStorageDays;
    }

    public void setStampsStorageDays(int stampsStorageDays) {
        this.stampsStorageDays = stampsStorageDays;
    }

    public boolean isStampsHideNotification() {
        return this.stampsHideNotification;
    }

    public void setStampsHideNotification(boolean stampsHideNotification) {
        this.stampsHideNotification = stampsHideNotification;
    }

    public boolean isStampsAutoPurchaseWarning() {
        return this.stampsAutoPurchaseWarning;
    }

    public void setStampsAutoPurchaseWarning(boolean stampsAutoPurchaseWarning) {
        this.stampsAutoPurchaseWarning = stampsAutoPurchaseWarning;
    }

    public HashMap<String, CompanyInfo> getCompanyInformation() {
        String defaultValue = CompanyInfo.sanitizeString("Default");
        if (this.companyInformation == null) {
            this.companyInformation = new HashMap();
        }
        if (defaultValue != null && !this.companyInformation.containsKey(defaultValue)) {
            this.companyInformation.put(defaultValue, new CompanyInfo());
        }
        return this.companyInformation;
    }

    public void setCompanyInformation(HashMap<String, CompanyInfo> companyInformation) {
        this.companyInformation = companyInformation;
    }

    public CompanyInfo getSpecificCompany(String company) {
        CompanyInfo specificCompany = null;
        try {
            if (company != null && !company.isEmpty()) {
                company = company.toLowerCase().replace(" ", "").trim();
                HashMap<String, CompanyInfo> companyInfo = this.getCompanyInformation();
                if (companyInfo != null && companyInfo.containsKey(company)) {
                    specificCompany = companyInfo.get(company);
                }
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        return specificCompany;
    }

    public boolean addCompany(String company, CompanyInfo suppliedInfo) {
        String sanitizedString = CompanyInfo.sanitizeString(company);
        if (!(sanitizedString == null || this.getCompanyInformation().containsKey(sanitizedString) || sanitizedString.equalsIgnoreCase("All") || sanitizedString.equalsIgnoreCase("Default"))) {
            this.getCompanyInformation().put(sanitizedString, suppliedInfo);
            this.createPaypalMap();
            return true;
        }
        JOptionPane.showMessageDialog(null, "Could not add company name : " + company + ". Either company already exists or attempting to add reserved company names.");
        return false;
    }

    public boolean addCompany(String company) {
        return this.addCompany(company, new CompanyInfo(company));
    }

    public void addPayPalAccount(String company, String paypalAccount) {
        String sanitizedCompanyName;
        if (this.getCompanyInformation() != null && (sanitizedCompanyName = CompanyInfo.sanitizeString(company)) != null) {
            for (String companyName : this.getCompanyInformation().keySet()) {
                if (!this.getCompanyInformation().containsKey(companyName)) continue;
                CompanyInfo specificCompany = this.getCompanyInformation().get(companyName);
                if (companyName.equalsIgnoreCase(CompanyInfo.sanitizeString("Default")) || companyName.equalsIgnoreCase(sanitizedCompanyName)) {
                    specificCompany.addPaypalLink(paypalAccount);
                    continue;
                }
                if (sanitizedCompanyName.equalsIgnoreCase(CompanyInfo.sanitizeString("Default"))) continue;
                specificCompany.removePaypalLink(paypalAccount);
            }
        }
        this.createPaypalMap();
    }

    public HashMap<String, String> getPaypalMap() {
        return this.paypalMap;
    }

    public void setPaypalMap(HashMap<String, String> paypalMap) {
        this.paypalMap = paypalMap;
    }

    public ArrayList<String> getCompanyMap() {
        return this.companyMap;
    }

    public void setCompanyMap(ArrayList<String> companyMap) {
        this.companyMap = companyMap;
    }

    public void createPaypalMap() {
        this.companyMap.clear();
        this.companyMap.add("Default");
        this.paypalMap.clear();
        HashMap<String, CompanyInfo> companyStuff = this.getCompanyInformation();
        for (String name : companyStuff.keySet()) {
            CompanyInfo specificCompany = companyStuff.get(name);
            String actualCompanyName = specificCompany.getCompanyName();
            if (!this.companyMap.contains(actualCompanyName)) {
                this.companyMap.add(actualCompanyName);
            }
            for (String paypalAccount : specificCompany.getCompanyPaypalLinks()) {
                if (this.paypalMap.containsKey(paypalAccount) && !this.paypalMap.get(paypalAccount).equalsIgnoreCase("default")) continue;
                this.paypalMap.put(paypalAccount, actualCompanyName);
            }
        }
    }

    public String getCompanyName(String paypalAccount) {
        String companyName = Preferences.getInstance().getAccountPreferences().getCompanyDefaultCompany();
        try {
            String paypalAccountSanitizied = paypalAccount;
            if (paypalAccountSanitizied != null && !paypalAccountSanitizied.isEmpty() && this.paypalMap != null && !this.paypalMap.isEmpty() && this.paypalMap.containsKey(paypalAccountSanitizied)) {
                companyName = this.paypalMap.get(paypalAccountSanitizied);
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        return companyName;
    }

    public void removePayPalAccount(String paypalAccount, boolean specialRemove) {
        if (this.getCompanyInformation() != null) {
            for (String companyName : this.getCompanyInformation().keySet()) {
                if (!this.getCompanyInformation().containsKey(companyName)) continue;
                CompanyInfo specificCompany = this.getCompanyInformation().get(companyName);
                if (companyName.equalsIgnoreCase(CompanyInfo.sanitizeString("Default")) && !specialRemove) {
                    specificCompany.addPaypalLink(paypalAccount);
                    continue;
                }
                specificCompany.removePaypalLink(paypalAccount);
            }
        }
        this.createPaypalMap();
    }

    public String getStampsUPSUserName() {
        return this.stampsUPSUserName;
    }

    public void setStampsUPSUserName(String stampsUPSUserName) {
        this.stampsUPSUserName = stampsUPSUserName;
    }

    public String getStampsUPSPassword() {
        return this.stampsUPSPassword;
    }

    public void setStampsUPSPassword(String stampsUPSPassword) {
        this.stampsUPSPassword = stampsUPSPassword;
    }

    public String getStampsUPSAccessKey() {
        return this.stampsUPSAccessKey;
    }

    public void setStampsUPSAccessKey(String stampsUPSAccessKey) {
        this.stampsUPSAccessKey = stampsUPSAccessKey;
    }

    public String getStampsUPSAccountNumber() {
        return this.stampsUPSAccountNumber;
    }

    public void setStampsUPSAccountNumber(String stampsUPSAccountNumber) {
        this.stampsUPSAccountNumber = stampsUPSAccountNumber;
    }
}

