/*
 * Decompiled with CFR 0.152.
 */
package pnp.services.datatypes;

import com.ebay.soap.eBLBaseComponents.CalculatedShippingRateType;
import com.ebay.soap.eBLBaseComponents.MeasureType;
import com.ebay.soap.eBLBaseComponents.MeasurementSystemCodeType;
import com.ebay.soap.eBLBaseComponents.ShippingPackageCodeType;
import java.math.BigDecimal;
import pnp.services.datatypes.Listing;

public class CalculatedShipping {
    private float internationalHandlingCost = 3.0f;
    private boolean shippingIrregular = false;
    private ShippingPackageCodeType shippingPackage = ShippingPackageCodeType.PACKAGE_THICK_ENVELOPE;
    private String standardizedUnit = "inches";
    private float packageDepth = 0.0f;
    private float packageLength = 0.0f;
    private float packageWidth = 0.0f;
    private float domesticHandlingCost = 0.0f;
    private float majorWeight = 0.0f;
    private float minorWeight = 0.0f;
    private MeasurementSystemCodeType measurement = MeasurementSystemCodeType.ENGLISH;
    private String standardizedMajor = "lbs";
    private String standardizedMinor = "oz";

    public void setInternationalHandlingCost(float internationalHandlingCost) {
        this.internationalHandlingCost = internationalHandlingCost;
    }

    public void setShippingIrregular(boolean shippingIrregular) {
        this.shippingIrregular = shippingIrregular;
    }

    public void setShippingPackage(ShippingPackageCodeType shippingPackage) {
        this.shippingPackage = shippingPackage;
    }

    public void setDomesticHandlingCost(float domesticHandlingCost) {
        this.domesticHandlingCost = domesticHandlingCost;
    }

    public void setWeight(float minorWeight) {
        this.minorWeight = minorWeight;
    }

    public CalculatedShippingRateType finalizeAndCreateRate(String originPostalCode) {
        CalculatedShippingRateType shippingRate = new CalculatedShippingRateType();
        shippingRate.setInternationalPackagingHandlingCosts(Listing.createAmountType(this.internationalHandlingCost));
        shippingRate.setOriginatingPostalCode(originPostalCode);
        shippingRate.setShippingIrregular(Boolean.valueOf(this.shippingIrregular));
        shippingRate.setShippingPackage(this.shippingPackage);
        shippingRate.setPackageDepth(this.creeateMeasureFromValue(this.packageDepth, this.standardizedUnit));
        shippingRate.setPackageLength(this.creeateMeasureFromValue(this.packageLength, this.standardizedUnit));
        shippingRate.setPackageWidth(this.creeateMeasureFromValue(this.packageWidth, this.standardizedUnit));
        shippingRate.setPackagingHandlingCosts(Listing.createAmountType(this.domesticHandlingCost));
        shippingRate.setWeightMajor(this.creeateMeasureFromValue(this.majorWeight, this.standardizedMajor));
        shippingRate.setWeightMinor(this.creeateMeasureFromValue(this.minorWeight, this.standardizedMinor));
        return shippingRate;
    }

    private MeasureType creeateMeasureFromValue(float value, String unit) {
        MeasureType measure = new MeasureType();
        measure.setMeasurementSystem(this.measurement);
        measure.setUnit(unit);
        measure.setValue(new BigDecimal(value));
        return measure;
    }
}

