/*
 * Decompiled with CFR 0.152.
 */
package pnp.services.datatypes;

import StampsSDK.Address;
import java.io.Serializable;
import java.util.ArrayList;

public class CompanyInfo
implements Serializable {
    private String companyName;
    private String companyWebsite;
    private String companyComments;
    private String companyAddress;
    private String companyCity;
    private String companyCountry;
    private String companyFullName;
    private String companyPhoneNumber;
    private String companyPostalCode;
    private String companyState;
    private ArrayList<String> companyPaypalLinks;
    private boolean addressValid;

    public CompanyInfo() {
        this.resetInformation("Default");
    }

    private void resetInformation(String name) {
        this.companyName = name;
        this.companyWebsite = "";
        this.companyComments = "";
        this.companyAddress = "";
        this.companyCity = "";
        this.companyCountry = "";
        this.companyFullName = "";
        this.companyPhoneNumber = "";
        this.companyPostalCode = "";
        this.companyState = "";
        this.companyPaypalLinks = new ArrayList();
        this.addressValid = false;
    }

    public CompanyInfo(String name) {
        this.resetInformation(name);
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getCompanyWebsite() {
        return this.companyWebsite;
    }

    public void setCompanyWebsite(String companyWebsite) {
        this.companyWebsite = companyWebsite;
    }

    public String getCompanyComments() {
        return this.companyComments;
    }

    public void setCompanyComments(String companyComments) {
        this.companyComments = companyComments;
    }

    public String getCompanyAddress() {
        return this.companyAddress;
    }

    public void setCompanyAddress(String companyAddress) {
        this.companyAddress = companyAddress;
    }

    public String getCompanyCity() {
        return this.companyCity;
    }

    public void setCompanyCity(String companyCity) {
        this.companyCity = companyCity;
    }

    public String getCompanyCountry() {
        return this.companyCountry;
    }

    public void setCompanyCountry(String companyCountry) {
        this.companyCountry = companyCountry;
    }

    public String getCompanyFullName() {
        return this.companyFullName;
    }

    public void setCompanyFullName(String companyFullName) {
        this.companyFullName = companyFullName;
    }

    public String getCompanyPhoneNumber() {
        return this.companyPhoneNumber;
    }

    public void setCompanyPhoneNumber(String companyPhoneNumber) {
        this.companyPhoneNumber = companyPhoneNumber;
    }

    public String getCompanyPostalCode() {
        return this.companyPostalCode;
    }

    public void setCompanyPostalCode(String companyPostalCode) {
        this.companyPostalCode = companyPostalCode;
    }

    public String getCompanyState() {
        return this.companyState;
    }

    public void setCompanyState(String companyState) {
        this.companyState = companyState;
    }

    public boolean isAddressValid() {
        return this.addressValid;
    }

    public void setAddressValid(boolean addressValid) {
        this.addressValid = addressValid;
    }

    public ArrayList<String> getCompanyPaypalLinks() {
        if (this.companyPaypalLinks == null) {
            this.companyPaypalLinks = new ArrayList();
        }
        return this.companyPaypalLinks;
    }

    public void setCompanyPaypalLinks(ArrayList<String> companyPaypalLinks) {
        this.companyPaypalLinks = companyPaypalLinks;
    }

    public void addPaypalLink(String paypalAccount) {
        String sanitizedAccount = CompanyInfo.sanitizeString(paypalAccount);
        if (sanitizedAccount != null && this.companyPaypalLinks != null && !this.companyPaypalLinks.contains(paypalAccount)) {
            this.companyPaypalLinks.add(sanitizedAccount);
        }
    }

    public static String sanitizeString(String sanitizedString) {
        if (sanitizedString != null && !sanitizedString.isEmpty() && !(sanitizedString = sanitizedString.replace(" ", "").toLowerCase().trim()).isEmpty()) {
            return sanitizedString;
        }
        return null;
    }

    public void removePaypalLink(String paypalAccount) {
        String sanitizedAccount = CompanyInfo.sanitizeString(paypalAccount);
        if (sanitizedAccount != null && this.companyPaypalLinks != null && this.companyPaypalLinks.contains(paypalAccount)) {
            this.companyPaypalLinks.remove(sanitizedAccount);
        }
    }

    public Address createAddressFromCompany() {
        Address fromAddress = new Address();
        fromAddress.setAddress1(this.companyAddress);
        fromAddress.setCity(this.companyCity);
        fromAddress.setCountry(this.companyCountry);
        fromAddress.setPhoneNumber(this.companyPhoneNumber);
        fromAddress.setFullName(this.companyFullName);
        if (fromAddress.getCountry() == null || fromAddress.getCountry().equalsIgnoreCase("US")) {
            if (this.companyPostalCode.split("-").length == 2) {
                fromAddress.setZIPCodeAddOn(this.companyPostalCode.split("-")[1]);
            }
            fromAddress.setZIPCode(this.companyPostalCode.split("-")[0]);
            fromAddress.setState(this.companyState);
        } else {
            fromAddress.setPostalCode(this.companyPostalCode);
            fromAddress.setProvince(this.companyState);
        }
        this.addressValid = this.companyAddress != null && !this.companyAddress.isEmpty() && this.companyCity != null && !this.companyCity.isEmpty() && this.companyCountry != null && !this.companyCountry.isEmpty() && this.companyFullName != null && !this.companyFullName.isEmpty() && this.companyPostalCode != null && !this.companyPostalCode.isEmpty() && this.companyState != null && !this.companyState.isEmpty() && this.companyPhoneNumber != null && !this.companyPhoneNumber.isEmpty();
        return fromAddress;
    }
}

