/*
 * Decompiled with CFR 0.152.
 */
package pnp.services.datatypes;

import pnp.services.util.GenericFunctions;

public class EbayTransactions {
    String ebayTransactionID;
    String auctionName;
    int quantity;
    Float cost;
    String referenceNumber;
    String paypalTransactionID;

    public EbayTransactions() {
    }

    public String getPaypalTransactionID() {
        return this.paypalTransactionID;
    }

    public void setPaypalTransactionID(String paypalTransactionID) {
        this.paypalTransactionID = paypalTransactionID;
    }

    public EbayTransactions(String ebayTransactionID, String auctionName, int quantity, Float cost, String referenceNumber) {
        this.ebayTransactionID = this.createSubstring(ebayTransactionID, 80);
        this.auctionName = this.createSubstring(auctionName, 256);
        this.quantity = quantity;
        this.cost = cost;
        this.referenceNumber = this.createSubstring(referenceNumber, 128);
    }

    private String createSubstring(String name, int length) {
        name = GenericFunctions.getInstance().prepareString(name);
        if (name.trim().length() > length) {
            name = name.trim().substring(0, length);
        }
        return name;
    }

    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    public String getEbayTransactionID() {
        return this.ebayTransactionID;
    }

    public void setEbayTransactionID(String ebayTransactionID) {
        this.ebayTransactionID = ebayTransactionID;
    }

    public String getAuctionName() {
        return this.auctionName;
    }

    public void setAuctionName(String auctionName) {
        this.auctionName = auctionName;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    public Float getCost() {
        return this.cost;
    }

    public void setCost(Float cost) {
        this.cost = cost;
    }
}

