/*
 * Decompiled with CFR 0.152.
 */
package pnp.services.datatypes;

import java.util.HashMap;
import java.util.HashSet;
import pnp.services.util.GenericFunctions;

public class FeedContainer {
    public static final String CATEGORY_ALL = "All";
    private String feedName;
    private HashMap<String, HashSet<String>> mainHash;
    private HashMap<String, HashSet<String>> subHash;
    private HashMap<String, HashSet<String>> tertHash;
    private HashMap<String, HashSet<String>> mainToSub;
    private HashMap<String, HashSet<String>> subToTert;

    public HashSet<String> getFeeds(String mainCategory, String subCategory, String tertCategory) {
        mainCategory = GenericFunctions.getInstance().prepareString(mainCategory);
        subCategory = GenericFunctions.getInstance().prepareString(subCategory);
        tertCategory = GenericFunctions.getInstance().prepareString(tertCategory);
        if (!(tertCategory.isEmpty() || mainCategory.equalsIgnoreCase(CATEGORY_ALL) || subCategory.equalsIgnoreCase(CATEGORY_ALL) || tertCategory.equalsIgnoreCase(CATEGORY_ALL) || !this.tertHash.containsKey(tertCategory))) {
            return this.tertHash.get(tertCategory);
        }
        if (!subCategory.isEmpty() && !mainCategory.equalsIgnoreCase(CATEGORY_ALL) && !subCategory.equalsIgnoreCase(CATEGORY_ALL) && this.subHash.containsKey(subCategory)) {
            return this.subHash.get(subCategory);
        }
        if (!mainCategory.isEmpty() && !mainCategory.equalsIgnoreCase(CATEGORY_ALL) && this.mainHash.containsKey(mainCategory)) {
            return this.mainHash.get(mainCategory);
        }
        return this.createMegaFeed();
    }

    private HashSet<String> createMegaFeed() {
        HashSet<String> megaFeed = new HashSet<String>();
        for (HashSet<String> feed : this.mainHash.values()) {
            megaFeed.addAll(feed);
        }
        return megaFeed;
    }

    public HashMap<String, HashSet<String>> getMainToSub() {
        return this.mainToSub;
    }

    public void setMainToSub(HashMap<String, HashSet<String>> mainToSub) {
        this.mainToSub = mainToSub;
    }

    public HashMap<String, HashSet<String>> getSubToTert() {
        return this.subToTert;
    }

    public void setSubToTert(HashMap<String, HashSet<String>> subToTert) {
        this.subToTert = subToTert;
    }

    public String getFeedName() {
        return this.feedName;
    }

    public void setFeedName(String feedName) {
        this.feedName = feedName;
    }

    public HashMap<String, HashSet<String>> getMainHash() {
        return this.mainHash;
    }

    public void setMainHash(HashMap<String, HashSet<String>> mainHash) {
        this.mainHash = mainHash;
    }

    public HashMap<String, HashSet<String>> getSubHash() {
        return this.subHash;
    }

    public void setSubHash(HashMap<String, HashSet<String>> subHash) {
        this.subHash = subHash;
    }

    public HashMap<String, HashSet<String>> getTertHash() {
        return this.tertHash;
    }

    public void setTertHash(HashMap<String, HashSet<String>> tertHash) {
        this.tertHash = tertHash;
    }
}

