/*
 * Decompiled with CFR 0.152.
 */
package pnp.services.datatypes;

import com.ebay.soap.eBLBaseComponents.AmountType;
import com.ebay.soap.eBLBaseComponents.BuyerPaymentMethodCodeType;
import com.ebay.soap.eBLBaseComponents.BuyerProtectionCodeType;
import com.ebay.soap.eBLBaseComponents.CategoryType;
import com.ebay.soap.eBLBaseComponents.CountryCodeType;
import com.ebay.soap.eBLBaseComponents.CurrencyCodeType;
import com.ebay.soap.eBLBaseComponents.HitCounterCodeType;
import com.ebay.soap.eBLBaseComponents.ItemType;
import com.ebay.soap.eBLBaseComponents.ListingDurationCodeType;
import com.ebay.soap.eBLBaseComponents.ListingTypeCodeType;
import com.ebay.soap.eBLBaseComponents.PictureDetailsType;
import com.ebay.soap.eBLBaseComponents.SiteCodeType;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import pnp.services.datatypes.BuyerRequirementDetails;
import pnp.services.datatypes.ReturnPolicy;
import pnp.services.datatypes.ShippingDetails;
import pnp.services.util.GenericFunctions;

public class Listing {
    private String accountName = "";
    private boolean autoPay = true;
    private String buyerProtection = BuyerProtectionCodeType.ITEM_ELIGIBLE.value();
    private String country = CountryCodeType.US.value();
    private static String currency;
    private String hitCounter;
    private String listingDuration;
    private String listingType;
    private String payPalEmail;
    private boolean privateListing;
    private int quantity;
    private String ebaySite;
    private String title;
    private String description;
    private boolean getItFast;
    private String itemSku;
    private String postalCode;
    private int dispatchTimeMax;
    private boolean proxyItem;
    private int condition;
    private List<String> pictures;
    private float buyItNow;
    private float reservePrice;
    private float startPrice;
    private float buyerGuaranteedPrice;
    private List<String> shipToLocations;
    private List<String> paymentMethods;
    private BuyerRequirementDetails buyerRequirementDetails;
    private ReturnPolicy returnPolicy;
    private String primaryCategoryID;
    private String secondaryCategoryID;
    private ShippingDetails shippingDetails;

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public void setAutoPay(boolean autoPay) {
        this.autoPay = autoPay;
    }

    public void setBuyerProtection(String buyerProtection) {
        this.buyerProtection = buyerProtection;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public static void setCurrency(String currency) {
        Listing.currency = currency;
    }

    public void setHitCounter(String hitCounter) {
        this.hitCounter = hitCounter;
    }

    public void setListingDuration(String listingDuration) {
        this.listingDuration = listingDuration;
    }

    public void setListingType(String listingType) {
        this.listingType = listingType;
    }

    public void setPayPalEmail(String payPalEmail) {
        this.payPalEmail = payPalEmail;
    }

    public void setPrivateListing(boolean privateListing) {
        this.privateListing = privateListing;
    }

    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    public void setEbaySite(String ebaySite) {
        this.ebaySite = ebaySite;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setGetItFast(boolean getItFast) {
        this.getItFast = getItFast;
    }

    public void setItemSku(String itemSku) {
        this.itemSku = itemSku;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public void setDispatchTimeMax(int dispatchTimeMax) {
        this.dispatchTimeMax = dispatchTimeMax;
    }

    public void setProxyItem(boolean proxyItem) {
        this.proxyItem = proxyItem;
    }

    public void setCondition(int condition) {
        this.condition = condition;
    }

    public void setBuyItNow(float buyItNow) {
        this.buyItNow = buyItNow;
    }

    public void setReservePrice(float reservePrice) {
        this.reservePrice = reservePrice;
    }

    public void setStartPrice(float startPrice) {
        this.startPrice = startPrice;
    }

    public void setBuyerGuaranteedPrice(float buyerGuaranteedPrice) {
        this.buyerGuaranteedPrice = buyerGuaranteedPrice;
    }

    public void setPrimaryCategoryID(String primaryCategoryID) {
        this.primaryCategoryID = primaryCategoryID;
    }

    public void setSecondaryCategoryID(String secondaryCategoryID) {
        this.secondaryCategoryID = secondaryCategoryID;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String addToList(List list, String item, int maxSize, String maxSizeError) {
        if (list == null) return "List was not instantiated. This should never happen.";
        if (maxSize <= 0) {
            maxSize = 999999;
        }
        if (list.contains(item = GenericFunctions.getInstance().prepareString(item))) return "Already Exists.";
        if (list.size() >= maxSize) {
            return maxSizeError;
        }
        list.add(item);
        return "";
    }

    public String addPicture(String picture) {
        return this.addToList(this.pictures, picture, 12, "Max Number of Pictures Reached (12)");
    }

    public String addShipToLocation(String location) {
        return this.addToList(this.shipToLocations, location, 0, "");
    }

    public String addPaymentMethod(String method) {
        return this.addToList(this.paymentMethods, method, 0, "");
    }

    public BuyerRequirementDetails getBuyerRequirementDetails() {
        return this.buyerRequirementDetails;
    }

    public ReturnPolicy getReturnPolicy() {
        return this.returnPolicy;
    }

    public ShippingDetails getShippingDetails() {
        return this.shippingDetails;
    }

    public Listing() {
        currency = CurrencyCodeType.USD.value();
        this.hitCounter = HitCounterCodeType.HIDDEN_STYLE.value();
        this.listingDuration = ListingDurationCodeType.GTC.value();
        this.listingType = ListingTypeCodeType.FIXED_PRICE_ITEM.value();
        this.payPalEmail = "";
        this.privateListing = true;
        this.quantity = 1;
        this.ebaySite = SiteCodeType.US.value();
        this.title = "";
        this.description = "";
        this.getItFast = false;
        this.itemSku = "";
        this.postalCode = "";
        this.dispatchTimeMax = 1;
        this.proxyItem = false;
        this.condition = 1000;
        this.pictures = new ArrayList<String>();
        this.buyItNow = 0.0f;
        this.reservePrice = 0.0f;
        this.startPrice = 0.0f;
        this.buyerGuaranteedPrice = 20000.0f;
        this.shipToLocations = new ArrayList<String>();
        this.paymentMethods = new ArrayList<String>();
        this.buyerRequirementDetails = new BuyerRequirementDetails();
        this.returnPolicy = new ReturnPolicy();
        this.primaryCategoryID = "";
        this.secondaryCategoryID = "";
        this.shippingDetails = new ShippingDetails();
    }

    public void useOurDefaults() {
        this.payPalEmail = "pnp.inc.ebay@gmail.com";
        this.postalCode = "33742";
        this.addShipToLocation("US");
        this.addShipToLocation("CA");
        this.addShipToLocation("AU");
        this.addPaymentMethod("PayPal");
        this.shippingDetails.addExcludedShipToLocations("Africa");
        this.shippingDetails.addExcludedShipToLocations("Middle East");
        this.shippingDetails.addExcludedShipToLocations("KH");
        this.shippingDetails.addExcludedShipToLocations("ID");
        this.shippingDetails.addExcludedShipToLocations("LA");
        this.shippingDetails.addExcludedShipToLocations("MO");
        this.shippingDetails.addExcludedShipToLocations("MY");
        this.shippingDetails.addExcludedShipToLocations("MX");
        this.shippingDetails.addInternationalShippingMethod(this.shipToLocations.toArray(new String[0]), "USPSFirstClassMailInternational");
        this.shippingDetails.addInternationalShippingMethod(this.shipToLocations.toArray(new String[0]), "USPSPriorityMailInternational");
        this.shippingDetails.addInternationalShippingMethod(this.shipToLocations.toArray(new String[0]), "USPSExpressMailInternational");
        this.shippingDetails.addDomesticShippingMethod(false, "USPSFirstClass", 2, 5, false);
        this.shippingDetails.addDomesticShippingMethod(false, "USPSPriority", 1, 3, false);
        this.shippingDetails.addDomesticShippingMethod(false, "USPSExpressMail", 1, 1, false);
    }

    private void ensureStrings() {
        this.accountName = GenericFunctions.getInstance().prepareString(this.accountName);
        this.title = GenericFunctions.getInstance().prepareString(this.title);
        this.description = GenericFunctions.getInstance().prepareString(this.description);
        this.itemSku = GenericFunctions.getInstance().prepareString(this.itemSku);
        this.postalCode = GenericFunctions.getInstance().prepareString(this.postalCode);
        this.primaryCategoryID = GenericFunctions.getInstance().prepareString(this.primaryCategoryID);
        this.secondaryCategoryID = GenericFunctions.getInstance().prepareString(this.secondaryCategoryID);
    }

    private boolean checkConstraints() {
        this.ensureStrings();
        String errorMessage = "";
        if (this.accountName.isEmpty()) {
            errorMessage = errorMessage + "Must supply an account name for this item to be elligible for listing.\r\n";
        }
        if (this.title.isEmpty()) {
            errorMessage = errorMessage + "Title cannot be empty.\r\n";
        }
        if (this.description.isEmpty()) {
            errorMessage = errorMessage + "Description cannot be empty.\r\n";
        }
        if (this.itemSku.isEmpty()) {
            errorMessage = errorMessage + "Item SKU cannot be empty.\r\n";
        }
        if (this.postalCode.isEmpty()) {
            errorMessage = errorMessage + "Postal Code cannot be empty.\r\n";
        }
        if (this.pictures.isEmpty()) {
            errorMessage = errorMessage + "Must include at least 1 picture.\r\n";
        }
        if (this.startPrice <= 0.0f) {
            errorMessage = errorMessage + "Start Price must be greater than 0.\r\n";
        }
        if (this.shipToLocations.isEmpty()) {
            errorMessage = errorMessage + "Ship To Locations cannot be empty.\r\n";
        }
        if (this.paymentMethods.isEmpty()) {
            errorMessage = errorMessage + "Payment Methods cannot be empty.\r\n";
        }
        if (this.primaryCategoryID.isEmpty()) {
            errorMessage = errorMessage + "You must supply a primary category.\r\n";
        }
        if (!(errorMessage = GenericFunctions.getInstance().prepareString(errorMessage)).isEmpty()) {
            JOptionPane.showMessageDialog(null, errorMessage);
        }
        return errorMessage.isEmpty();
    }

    public ItemType finalizeAndCreateListing() {
        ItemType listing = null;
        if (this.checkConstraints()) {
            listing = new ItemType();
            listing.setAutoPay(Boolean.valueOf(this.autoPay));
            listing.setBuyerProtection(BuyerProtectionCodeType.fromValue((String)this.buyerProtection));
            listing.setCountry(CountryCodeType.fromValue((String)this.country));
            listing.setCurrency(CurrencyCodeType.fromValue((String)currency));
            listing.setHitCounter(HitCounterCodeType.fromValue((String)this.hitCounter));
            listing.setListingDuration(this.listingDuration);
            listing.setListingType(ListingTypeCodeType.fromValue((String)this.listingType));
            listing.setPayPalEmailAddress(this.payPalEmail);
            listing.setPrivateListing(Boolean.valueOf(this.privateListing));
            listing.setQuantity(Integer.valueOf(this.quantity));
            listing.setSite(SiteCodeType.fromValue((String)this.ebaySite));
            listing.setTitle(this.title);
            listing.setDescription(this.description);
            listing.setGetItFast(Boolean.valueOf(this.getItFast));
            listing.setSKU(this.itemSku);
            listing.setPostalCode(this.postalCode);
            listing.setDispatchTimeMax(Integer.valueOf(this.dispatchTimeMax));
            listing.setProxyItem(Boolean.valueOf(this.proxyItem));
            listing.setConditionID(Integer.valueOf(this.condition));
            listing.setPictureDetails(this.createPictures());
            listing.setBuyItNowPrice(Listing.createAmountType(this.buyItNow));
            listing.setReservePrice(Listing.createAmountType(this.reservePrice));
            listing.setStartPrice(Listing.createAmountType(this.startPrice));
            listing.setBuyerGuaranteePrice(Listing.createAmountType(this.buyerGuaranteedPrice));
            listing.setShipToLocations(this.shipToLocations.toArray(new String[0]));
            listing.setPaymentMethods(this.createPaymentMethods());
            listing.setBuyerRequirementDetails(this.buyerRequirementDetails.finalizeAndCreateBuyerRequirements());
            listing.setReturnPolicy(this.returnPolicy.finalizeAndCreateReturnPolicy());
            listing.setPrimaryCategory(this.createCategory(this.primaryCategoryID));
            listing.setSecondaryCategory(this.createCategory(this.secondaryCategoryID));
            listing.setShippingDetails(this.shippingDetails.finalizeAndCreateShippingDetails(this.postalCode));
        }
        return listing;
    }

    private CategoryType createCategory(String categoryID) {
        CategoryType type = new CategoryType();
        type.setCategoryID(categoryID);
        if (categoryID == null || categoryID.isEmpty()) {
            return null;
        }
        return type;
    }

    private PictureDetailsType createPictures() {
        PictureDetailsType pictureDetails = new PictureDetailsType();
        pictureDetails.setPictureURL(this.pictures.toArray(new String[0]));
        return pictureDetails;
    }

    private BuyerPaymentMethodCodeType[] createPaymentMethods() {
        BuyerPaymentMethodCodeType[] actualPaymentMethods = new BuyerPaymentMethodCodeType[this.paymentMethods.size()];
        int counter = 0;
        for (String method : this.paymentMethods) {
            actualPaymentMethods[counter++] = BuyerPaymentMethodCodeType.fromValue((String)method);
        }
        return actualPaymentMethods;
    }

    public static CurrencyCodeType getCurrency() {
        return CurrencyCodeType.fromValue((String)currency);
    }

    public static AmountType createAmountType(float value) {
        AmountType amount = new AmountType();
        amount.setCurrencyID(Listing.getCurrency());
        amount.setValue((double)value);
        return amount;
    }
}

