/*
 * Decompiled with CFR 0.152.
 */
package pnp.services.datatypes;

import java.sql.Date;
import pnp.services.datatypes.Customer;
import pnp.services.datatypes.OrderStatus;
import pnp.services.preferencemanager.Preferences;

public class Order {
    private int orderID = 0;
    private Customer customer = null;
    private Date orderDate = new Date(System.currentTimeMillis());
    private float orderTotal = 0.0f;
    private String shippingMethodName = "";
    private float shippingCost = 0.0f;
    private float shippingPaid = 0.0f;
    private int orderStatusID = 0;
    private String orderComments = "";
    private OrderStatus orderStatus = null;
    private String paypalAccount = Preferences.getInstance().getAccountPreferences().getCompanyDefaultCompany();
    private String customerUserName;

    public String getCustomerUserName() {
        return this.customerUserName;
    }

    public void setCustomerUserName(String customerUserName) {
        this.customerUserName = customerUserName;
    }

    public Order copy() {
        Order copy = new Order();
        copy.setCustomer(this.customer);
        copy.setOrderComments(this.orderComments);
        copy.setOrderDate(this.orderDate);
        copy.setOrderID(this.orderID);
        copy.setOrderTotal(this.orderTotal);
        copy.setShippingCost(this.shippingCost);
        copy.setShippingMethodName(this.shippingMethodName);
        copy.setShippingPaid(this.shippingPaid);
        copy.setOrderStatus(this.orderStatus);
        copy.setPaypalAccount(this.paypalAccount);
        return copy;
    }

    public void setOrderStatusID(int orderStatusID) {
        this.orderStatusID = orderStatusID;
    }

    public String getPaypalAccount() {
        return this.paypalAccount;
    }

    public void setPaypalAccount(String paypalAccount) {
        this.paypalAccount = paypalAccount;
    }

    public Customer getCustomer() {
        return this.customer;
    }

    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    public String getOrderComments() {
        return this.orderComments;
    }

    public void setOrderComments(String orderComments) {
        this.orderComments = null != orderComments ? orderComments : "";
    }

    public Date getOrderDate() {
        return this.orderDate;
    }

    public void setOrderDate(Date orderDate) {
        if (null != orderDate) {
            this.orderDate = orderDate;
        } else {
            orderDate = new Date(System.currentTimeMillis());
        }
    }

    public int getOrderID() {
        return this.orderID;
    }

    public void setOrderID(int orderID) {
        this.orderID = orderID;
    }

    public OrderStatus getOrderStatus() {
        return this.orderStatus;
    }

    public int getOrderStatusID() {
        return this.orderStatusID;
    }

    public float getOrderTotal() {
        return this.orderTotal;
    }

    public void setOrderTotal(float orderTotal) {
        this.orderTotal = orderTotal;
    }

    public float getShippingCost() {
        return this.shippingCost;
    }

    public void setShippingCost(float shippingCost) {
        this.shippingCost = shippingCost;
    }

    public String getShippingMethodName() {
        return this.shippingMethodName;
    }

    public void setShippingMethodName(String shippingMethodName) {
        this.shippingMethodName = null != shippingMethodName ? shippingMethodName : "";
    }

    public float getShippingPaid() {
        return this.shippingPaid;
    }

    public void setShippingPaid(float shippingPaid) {
        this.shippingPaid = shippingPaid;
    }

    public void setOrderStatus(OrderStatus orderStatus) {
        this.orderStatus = orderStatus;
        this.orderStatusID = orderStatus.getOrderStatusID();
    }

    public int hashCode() {
        int hash = 5;
        hash = 43 * hash + this.orderID;
        hash = 43 * hash + (this.customer != null ? this.customer.hashCode() : 0);
        hash = 43 * hash + (this.orderDate != null ? this.orderDate.hashCode() : 0);
        hash = 43 * hash + Float.floatToIntBits(this.orderTotal);
        hash = 43 * hash + (this.shippingMethodName != null ? this.shippingMethodName.hashCode() : 0);
        hash = 43 * hash + Float.floatToIntBits(this.shippingCost);
        hash = 43 * hash + Float.floatToIntBits(this.shippingPaid);
        hash = 43 * hash + this.orderStatusID;
        hash = 43 * hash + (this.orderComments != null ? this.orderComments.hashCode() : 0);
        hash = 43 * hash + (this.orderStatus != null ? this.orderStatus.hashCode() : 0);
        hash = 43 * hash + (this.paypalAccount != null ? this.paypalAccount.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Order other = (Order)obj;
        if (this.orderID != other.orderID) {
            return false;
        }
        if (!(this.customer == other.customer || this.customer != null && this.customer.equals(other.customer))) {
            return false;
        }
        if (!(this.orderDate == other.orderDate || this.orderDate != null && this.orderDate.equals(other.orderDate))) {
            return false;
        }
        if (Float.floatToIntBits(this.orderTotal) != Float.floatToIntBits(other.orderTotal)) {
            return false;
        }
        if (this.shippingMethodName == null ? other.shippingMethodName != null : !this.shippingMethodName.equals(other.shippingMethodName)) {
            return false;
        }
        if (Float.floatToIntBits(this.shippingCost) != Float.floatToIntBits(other.shippingCost)) {
            return false;
        }
        if (Float.floatToIntBits(this.shippingPaid) != Float.floatToIntBits(other.shippingPaid)) {
            return false;
        }
        if (this.orderStatusID != other.orderStatusID) {
            return false;
        }
        if (this.orderComments == null ? other.orderComments != null : !this.orderComments.equals(other.orderComments)) {
            return false;
        }
        if (!(this.orderStatus == other.orderStatus || this.orderStatus != null && this.orderStatus.equals(other.orderStatus))) {
            return false;
        }
        return !(this.paypalAccount == null ? other.paypalAccount != null : !this.paypalAccount.equals(other.paypalAccount));
    }
}

