/*
 * Decompiled with CFR 0.152.
 */
package pnp.services.datatypes;

import java.util.ArrayList;
import java.util.List;
import pnp.services.datatypes.EbayTransactions;
import pnp.services.util.CurrencyConverter;
import pnp.services.util.ErrorsUtil;
import pnp.services.util.GenericFunctions;
import urn.ebay.apis.CoreComponentTypes.BasicAmountType;
import urn.ebay.apis.eBLBaseComponents.AddressType;
import urn.ebay.apis.eBLBaseComponents.AuctionInfoType;
import urn.ebay.apis.eBLBaseComponents.CountryCodeType;
import urn.ebay.apis.eBLBaseComponents.CurrencyCodeType;
import urn.ebay.apis.eBLBaseComponents.PayerInfoType;
import urn.ebay.apis.eBLBaseComponents.PaymentCodeType;
import urn.ebay.apis.eBLBaseComponents.PaymentInfoType;
import urn.ebay.apis.eBLBaseComponents.PaymentItemInfoType;
import urn.ebay.apis.eBLBaseComponents.PaymentItemType;
import urn.ebay.apis.eBLBaseComponents.PaymentStatusCodeType;
import urn.ebay.apis.eBLBaseComponents.PaymentTransactionCodeType;

public class PaypalDetails {
    String email;
    String firstName;
    String lastName;
    String countryCode;
    String street1;
    String street2;
    String cityName;
    String stateOrProvince;
    String countryName;
    String postalCode;
    String paypalTransactionID;
    String transactionType;
    String paymentType;
    String paymentDate;
    String paymentStatus;
    String shippingMethod;
    String custom;
    String memo;
    String buyerID;
    String closingDate;
    String multiItem;
    List<EbayTransactions> ebayItems;
    Float grossAmount;
    boolean linked;
    Float tax;
    String currencyCode;
    Float shippingAmount;
    String paypalAccount;

    private String createSubstring(String name, int length) {
        name = GenericFunctions.getInstance().prepareString(name);
        if (name.trim().length() > length) {
            name = name.trim().substring(0, length);
        }
        return name;
    }

    private void condenseStrings() {
        this.email = this.createSubstring(this.email, 80);
        this.firstName = this.createSubstring(this.firstName, 80);
        this.lastName = this.createSubstring(this.lastName, 80);
        this.countryCode = this.createSubstring(this.countryCode, 3);
        this.countryName = this.createSubstring(this.countryName, 80);
        this.street1 = this.createSubstring(this.street1, 150);
        this.street2 = this.createSubstring(this.street2, 150);
        this.cityName = this.createSubstring(this.cityName, 80);
        this.stateOrProvince = this.createSubstring(this.stateOrProvince, 128);
        this.postalCode = this.createSubstring(this.postalCode, 20);
        this.transactionType = this.createSubstring(this.transactionType, 80);
        this.paymentType = this.createSubstring(this.paymentType, 80);
        this.paymentDate = this.createSubstring(this.paymentDate, 80);
        this.paymentStatus = this.createSubstring(this.paymentStatus, 80);
        this.shippingMethod = this.createSubstring(this.shippingMethod, 80);
        this.custom = this.createSubstring(this.custom, 128);
        this.buyerID = this.createSubstring(this.buyerID, 80);
        this.closingDate = this.createSubstring(this.closingDate, 80);
        this.currencyCode = this.createSubstring(this.currencyCode, 10);
        this.paypalAccount = this.createSubstring(this.paypalAccount, 150);
    }

    private void protectExceptions(PayerInfoType payerInfo, PaymentInfoType paymentInfo, PaymentItemInfoType paymentItemInfo) {
        if (payerInfo.getAddress() == null) {
            payerInfo.setAddress(new AddressType());
        }
        if (payerInfo.getAddress().getCountry() == null) {
            payerInfo.getAddress().setCountry(CountryCodeType.US);
        }
        if (paymentInfo.getTransactionType() == null) {
            paymentInfo.setTransactionType(PaymentTransactionCodeType.CART);
        }
        if (paymentInfo.getPaymentType() == null) {
            paymentInfo.setPaymentType(PaymentCodeType.INSTANT);
        }
        if (paymentInfo.getPaymentStatus() == null) {
            paymentInfo.setPaymentStatus(PaymentStatusCodeType.PENDING);
        }
        if (paymentItemInfo.getAuction() == null) {
            paymentItemInfo.setAuction(new AuctionInfoType());
        }
        if (paymentInfo.getGrossAmount() == null) {
            paymentInfo.setGrossAmount(new BasicAmountType());
        }
        if (paymentInfo.getTaxAmount() == null) {
            paymentInfo.setTaxAmount(new BasicAmountType());
        }
        if (paymentInfo.getGrossAmount().getCurrencyID() == null) {
            paymentInfo.getGrossAmount().setCurrencyID(CurrencyCodeType.USD);
        }
        if (paymentItemInfo.getPaymentItem() == null) {
            paymentItemInfo.setPaymentItem(new ArrayList());
        }
    }

    public PaypalDetails(PayerInfoType payerInfo, PaymentInfoType paymentInfo, PaymentItemInfoType paymentItemInfo, String paypalAccount) {
        this.reset();
        this.paypalAccount = GenericFunctions.getInstance().prepareString(paypalAccount);
        try {
            this.protectExceptions(payerInfo, paymentInfo, paymentItemInfo);
            String fullName = GenericFunctions.getInstance().prepareString(payerInfo.getAddress().getName());
            if (!fullName.isEmpty()) {
                String[] nameArray = fullName.split(" ");
                if (nameArray != null) {
                    for (int i = 0; i < nameArray.length; ++i) {
                        if (i != 0 && i == nameArray.length - 1) {
                            this.lastName = GenericFunctions.getInstance().prepareString(nameArray[i]);
                            continue;
                        }
                        this.firstName = this.firstName + GenericFunctions.getInstance().prepareString(nameArray[i]);
                    }
                } else {
                    this.firstName = fullName;
                }
            }
            this.email = GenericFunctions.getInstance().prepareString(payerInfo.getPayer());
            this.countryCode = GenericFunctions.getInstance().prepareString(payerInfo.getAddress().getCountry().getValue());
            this.street1 = GenericFunctions.getInstance().prepareString(payerInfo.getAddress().getStreet1());
            this.street2 = GenericFunctions.getInstance().prepareString(payerInfo.getAddress().getStreet2());
            this.cityName = GenericFunctions.getInstance().prepareString(payerInfo.getAddress().getCityName());
            this.stateOrProvince = GenericFunctions.getInstance().prepareString(payerInfo.getAddress().getStateOrProvince());
            this.countryName = GenericFunctions.getInstance().prepareString(payerInfo.getAddress().getCountryName());
            this.postalCode = GenericFunctions.getInstance().prepareString(payerInfo.getAddress().getPostalCode());
            this.paypalTransactionID = GenericFunctions.getInstance().prepareString(paymentInfo.getTransactionID());
            this.transactionType = GenericFunctions.getInstance().prepareString(paymentInfo.getTransactionType().getValue());
            this.paymentType = GenericFunctions.getInstance().prepareString(paymentInfo.getPaymentType().getValue());
            this.paymentDate = GenericFunctions.getInstance().prepareString(paymentInfo.getPaymentDate());
            this.paymentStatus = GenericFunctions.getInstance().prepareString(paymentInfo.getPaymentStatus().getValue());
            this.shippingMethod = GenericFunctions.getInstance().prepareString(paymentInfo.getShippingMethod());
            this.custom = GenericFunctions.getInstance().prepareString(paymentItemInfo.getCustom());
            this.memo = GenericFunctions.getInstance().prepareString(paymentItemInfo.getMemo());
            this.buyerID = GenericFunctions.getInstance().prepareString(paymentItemInfo.getAuction().getBuyerID());
            this.closingDate = GenericFunctions.getInstance().prepareString(paymentItemInfo.getAuction().getClosingDate());
            this.multiItem = GenericFunctions.getInstance().prepareString(paymentItemInfo.getAuction().getMultiItem());
            this.currencyCode = GenericFunctions.getInstance().prepareString(paymentInfo.getGrossAmount().getCurrencyID().getValue());
            this.grossAmount = GenericFunctions.getInstance().prepareFloat(paymentInfo.getGrossAmount().getValue());
            this.tax = GenericFunctions.getInstance().prepareFloat(paymentInfo.getTaxAmount().getValue());
            this.shippingAmount = GenericFunctions.getInstance().prepareFloat(paymentInfo.getShipAmount());
            this.linked = false;
            this.ebayItems = new ArrayList<EbayTransactions>();
            this.addEbayItems(paymentItemInfo);
            this.convertCurrency();
            this.condenseStrings();
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    public PaypalDetails() {
        this.reset();
    }

    private void reset() {
        this.email = "";
        this.firstName = "";
        this.lastName = "";
        this.countryCode = "";
        this.street1 = "";
        this.street2 = "";
        this.cityName = "";
        this.stateOrProvince = "";
        this.countryName = "";
        this.postalCode = "";
        this.paypalTransactionID = "EMPTY";
        this.transactionType = "";
        this.paymentType = "";
        this.paymentDate = "";
        this.paymentStatus = "";
        this.shippingMethod = "";
        this.custom = "";
        this.memo = "";
        this.buyerID = "";
        this.closingDate = "";
        this.multiItem = "";
        this.ebayItems = new ArrayList<EbayTransactions>();
        this.grossAmount = Float.valueOf(0.0f);
        this.linked = false;
        this.tax = Float.valueOf(0.0f);
        this.currencyCode = "";
        this.shippingAmount = Float.valueOf(0.0f);
        this.paypalAccount = "";
    }

    public String getPaypalAccount() {
        return this.paypalAccount;
    }

    public void setPaypalAccount(String paypalAccount) {
        this.paypalAccount = paypalAccount;
    }

    public Float getShippingAmount() {
        return this.shippingAmount;
    }

    public void setShippingAmount(Float shippingAmount) {
        this.shippingAmount = shippingAmount;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public Float getTax() {
        return this.tax;
    }

    public void setTax(Float tax) {
        this.tax = tax;
    }

    public boolean isLinked() {
        return this.linked;
    }

    public void setLinked(boolean linked) {
        this.linked = linked;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public String getStreet1() {
        return this.street1;
    }

    public void setStreet1(String street1) {
        this.street1 = street1;
    }

    public String getStreet2() {
        return this.street2;
    }

    public void setStreet2(String street2) {
        this.street2 = street2;
    }

    public String getCityName() {
        return this.cityName;
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public String getStateOrProvince() {
        return this.stateOrProvince;
    }

    public void setStateOrProvince(String stateOrProvince) {
        this.stateOrProvince = stateOrProvince;
    }

    public String getCountryName() {
        return this.countryName;
    }

    public void setCountryName(String countryName) {
        this.countryName = countryName;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public String getPaypalTransactionID() {
        return this.paypalTransactionID;
    }

    public void setPaypalTransactionID(String paypalTransactionID) {
        this.paypalTransactionID = paypalTransactionID;
    }

    public String getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(String transactionType) {
        this.transactionType = transactionType;
    }

    public String getPaymentType() {
        return this.paymentType;
    }

    public void setPaymentType(String paymentType) {
        this.paymentType = paymentType;
    }

    public String getPaymentDate() {
        return this.paymentDate;
    }

    public void setPaymentDate(String paymentDate) {
        this.paymentDate = paymentDate;
    }

    public String getPaymentStatus() {
        return this.paymentStatus;
    }

    public void setPaymentStatus(String paymentStatus) {
        this.paymentStatus = paymentStatus;
    }

    public String getShippingMethod() {
        return this.shippingMethod;
    }

    public void setShippingMethod(String shippingMethod) {
        this.shippingMethod = shippingMethod;
    }

    public String getCustom() {
        return this.custom;
    }

    public void setCustom(String custom) {
        this.custom = custom;
    }

    public String getMemo() {
        return this.memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getBuyerID() {
        return this.buyerID;
    }

    public void setBuyerID(String buyerID) {
        this.buyerID = buyerID;
    }

    public String getClosingDate() {
        return this.closingDate;
    }

    public void setClosingDate(String closingDate) {
        this.closingDate = closingDate;
    }

    public String getMultiItem() {
        return this.multiItem;
    }

    public void setMultiItem(String multiItem) {
        this.multiItem = multiItem;
    }

    public Float getGrossAmount() {
        return this.grossAmount;
    }

    public void setGrossAmount(Float grossAmount) {
        this.grossAmount = grossAmount;
    }

    public List<EbayTransactions> getEbayItems() {
        return this.ebayItems;
    }

    public void setEbayItems(List<EbayTransactions> ebayItems) {
        this.ebayItems = ebayItems;
    }

    private void addEbayItems(PaymentItemInfoType paymentItemInfo) {
        try {
            for (PaymentItemType newPayment : paymentItemInfo.getPaymentItem()) {
                if (null == newPayment) continue;
                if ((null == newPayment.getEbayItemTxnId() || newPayment.getEbayItemTxnId().equalsIgnoreCase("0")) && null != newPayment.getNumber()) {
                    newPayment.setEbayItemTxnId(newPayment.getNumber());
                }
                if (null == newPayment.getEbayItemTxnId()) continue;
                if (null == newPayment.getName()) {
                    newPayment.setName("");
                }
                if (null == newPayment.getQuantity()) {
                    newPayment.setQuantity("0");
                }
                if (null == newPayment.getAmount()) {
                    BasicAmountType newAmount = new BasicAmountType();
                    newAmount.setCurrencyID(CurrencyCodeType.USD);
                    newAmount.setValue("0");
                    newPayment.setAmount(newAmount);
                }
                this.ebayItems.add(new EbayTransactions(newPayment.getEbayItemTxnId(), newPayment.getName(), Integer.parseInt(newPayment.getQuantity()), Float.valueOf(Float.parseFloat(newPayment.getAmount().getValue())), newPayment.getNumber()));
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private void convertCurrency() {
        try {
            if (!this.currencyCode.equalsIgnoreCase("USD") && !this.currencyCode.isEmpty()) {
                this.grossAmount = Float.valueOf(CurrencyConverter.convertCurrency(this.currencyCode, this.grossAmount.floatValue()));
                this.tax = Float.valueOf(CurrencyConverter.convertCurrency(this.currencyCode, this.tax.floatValue()));
                this.shippingAmount = Float.valueOf(CurrencyConverter.convertCurrency(this.currencyCode, this.shippingAmount.floatValue()));
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }
}

