/*
 * Decompiled with CFR 0.152.
 */
package pnp.services.datatypes;

import com.ebay.soap.eBLBaseComponents.InternationalShippingServiceOptionsType;
import com.ebay.soap.eBLBaseComponents.SalesTaxType;
import com.ebay.soap.eBLBaseComponents.ShippingDetailsType;
import com.ebay.soap.eBLBaseComponents.ShippingServiceOptionsType;
import com.ebay.soap.eBLBaseComponents.ShippingTypeCodeType;
import java.util.ArrayList;
import java.util.List;
import pnp.services.datatypes.CalculatedShipping;
import pnp.services.util.GenericFunctions;

public class ShippingDetails {
    private boolean applyShippingDiscount = false;
    private List<String> excludeShipToLocations = new ArrayList<String>();
    private String internationalShippingDiscount = "0";
    private List<InternationalShippingServiceOptionsType> internationalShippingMethods = new ArrayList<InternationalShippingServiceOptionsType>();
    private List<ShippingServiceOptionsType> domesticShippingMethods = new ArrayList<ShippingServiceOptionsType>();
    private float salesTaxPercentage = 7.0f;
    private String salesTaxStateAbbreviation = "FL";
    private boolean salesTaxIncludeShipping = false;
    private String shippingDiscountProfileID = "0";
    private ShippingTypeCodeType shippingType = ShippingTypeCodeType.CALCULATED;
    private CalculatedShipping calculatedShipping = new CalculatedShipping();

    public void setSalesTaxPercentage(float salesTaxPercentage) {
        this.salesTaxPercentage = salesTaxPercentage;
    }

    public void setSalesTaxStateAbbreviation(String salesTaxStateAbbreviation) {
        this.salesTaxStateAbbreviation = salesTaxStateAbbreviation;
    }

    public void setSalesTaxIncludeShipping(boolean salesTaxIncludeShipping) {
        this.salesTaxIncludeShipping = salesTaxIncludeShipping;
    }

    public CalculatedShipping getCalculatedShipping() {
        return this.calculatedShipping;
    }

    public void addDomesticShippingMethod(boolean expeditedService, String serviceName, int shippingMin, int shippingMax, boolean freeShipping) {
        serviceName = GenericFunctions.getInstance().prepareString(serviceName);
        if (this.domesticShippingMethods != null && shippingMin > 0 && shippingMax > 0 && !serviceName.isEmpty()) {
            ShippingServiceOptionsType serviceType = new ShippingServiceOptionsType();
            serviceType.setExpeditedService(Boolean.valueOf(expeditedService));
            serviceType.setFreeShipping(Boolean.valueOf(freeShipping));
            serviceType.setShippingService(serviceName);
            serviceType.setShippingServicePriority(Integer.valueOf(this.domesticShippingMethods.size() + 1));
            serviceType.setShippingTimeMax(Integer.valueOf(shippingMax));
            serviceType.setShippingTimeMin(Integer.valueOf(shippingMin));
            if (!this.domesticShippingMethods.contains(serviceType)) {
                this.domesticShippingMethods.add(serviceType);
            }
        }
    }

    public void addInternationalShippingMethod(String[] shipToLocations, String serviceName) {
        serviceName = GenericFunctions.getInstance().prepareString(serviceName);
        if (this.internationalShippingMethods != null && shipToLocations != null && shipToLocations.length > 0 && !serviceName.isEmpty()) {
            InternationalShippingServiceOptionsType serviceType = new InternationalShippingServiceOptionsType();
            serviceType.setShipToLocation(shipToLocations);
            serviceType.setShippingService(serviceName);
            serviceType.setShippingServicePriority(Integer.valueOf(this.internationalShippingMethods.size() + 1));
            if (!this.internationalShippingMethods.contains(serviceType)) {
                this.internationalShippingMethods.add(serviceType);
            }
        }
    }

    public void addExcludedShipToLocations(String location) {
        location = GenericFunctions.getInstance().prepareString(location);
        if (this.excludeShipToLocations != null && !location.isEmpty() && !this.excludeShipToLocations.contains(location)) {
            this.excludeShipToLocations.add(location);
        }
    }

    public ShippingDetailsType finalizeAndCreateShippingDetails(String originPostalCode) {
        ShippingDetailsType shippingDetails = new ShippingDetailsType();
        shippingDetails.setApplyShippingDiscount(Boolean.valueOf(this.applyShippingDiscount));
        shippingDetails.setExcludeShipToLocation(this.excludeShipToLocations.toArray(new String[0]));
        shippingDetails.setSellerExcludeShipToLocationsPreference(Boolean.valueOf(!this.excludeShipToLocations.isEmpty()));
        shippingDetails.setInternationalShippingDiscountProfileID(this.internationalShippingDiscount);
        shippingDetails.setInternationalShippingServiceOption(this.internationalShippingMethods.toArray(new InternationalShippingServiceOptionsType[0]));
        shippingDetails.setSalesTax(this.getSalesTax());
        shippingDetails.setShippingDiscountProfileID(this.shippingDiscountProfileID);
        shippingDetails.setShippingType(this.shippingType);
        shippingDetails.setShippingServiceOptions(this.domesticShippingMethods.toArray(new ShippingServiceOptionsType[0]));
        shippingDetails.setCalculatedShippingRate(this.calculatedShipping.finalizeAndCreateRate(originPostalCode));
        return shippingDetails;
    }

    private SalesTaxType getSalesTax() {
        SalesTaxType salesTax = new SalesTaxType();
        salesTax.setSalesTaxPercent(Float.valueOf(this.salesTaxPercentage));
        salesTax.setSalesTaxState(this.salesTaxStateAbbreviation);
        salesTax.setShippingIncludedInTax(Boolean.valueOf(this.salesTaxIncludeShipping));
        return salesTax;
    }
}

