/*
 * Decompiled with CFR 0.152.
 */
package pnp.services.datatypes;

import StampsSDK.Address;
import pnp.services.datatypes.webservices.DBPassword;

public class StampsAccount {
    private String userName;
    private String password;
    private String address;
    private String city;
    private String zip;
    private String state;
    private String country;
    private String number;
    private String name;
    private String secretKey;
    private Address from;

    private void defaultValues() {
        this.userName = "";
        this.password = "";
        this.address = "";
        this.city = "";
        this.zip = "";
        this.state = "";
        this.country = "";
        this.number = "";
        this.name = "";
        this.secretKey = "StampsAccount";
        this.from = new Address();
    }

    public StampsAccount() {
        this.defaultValues();
    }

    public StampsAccount(String userName, String password, String address, String city, String zip, String state, String country, String number, String name) {
        this.defaultValues();
        this.userName = userName;
        this.password = password;
        this.address = address;
        this.city = city;
        this.zip = zip;
        this.state = state;
        this.country = country;
        this.number = number;
        this.name = name;
    }

    public Address createAddress() {
        if (this.country == null) {
            this.country = "US";
        }
        if (this.country.equalsIgnoreCase("US")) {
            if (this.zip.split("-").length == 2) {
                this.from.setZIPCodeAddOn(this.zip.split("-")[1]);
            }
            this.from.setZIPCode(this.zip.split("-")[0]);
            this.from.setState(this.state);
        } else {
            this.from.setPostalCode(this.zip);
            this.from.setProvince(this.state);
        }
        this.from.setAddress1(this.address);
        this.from.setCity(this.city);
        this.from.setCountry(this.country);
        this.from.setPhoneNumber(this.number);
        this.from.setFullName(this.name);
        return this.from;
    }

    public Address getFrom() {
        return this.from;
    }

    public void setFrom(Address from) {
        this.from = from;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUnalteredPassword() {
        return this.password;
    }

    public String getPassword() {
        return DBPassword.getInstance().decryptPassword(this.password, this.secretKey);
    }

    public void setUnalteredPassword(String password) {
        this.password = password;
    }

    public void setPassword(String password) {
        this.password = DBPassword.getInstance().encryptPassword(password, this.secretKey);
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getZip() {
        return this.zip;
    }

    public void setZip(String zip) {
        this.zip = zip;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

