/*
 * Decompiled with CFR 0.152.
 */
package pnp.services.db;

import com.ebay.soap.eBLBaseComponents.TransactionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import pnp.services.datatypes.AccountPreferences;
import pnp.services.datatypes.AmazonAccount;
import pnp.services.datatypes.Category;
import pnp.services.datatypes.CategoryAssociation;
import pnp.services.datatypes.CheckDetails;
import pnp.services.datatypes.CompleteOrder;
import pnp.services.datatypes.CustomFee;
import pnp.services.datatypes.Customer;
import pnp.services.datatypes.Distributor;
import pnp.services.datatypes.EtsyAccount;
import pnp.services.datatypes.EtsyOrder;
import pnp.services.datatypes.Expense;
import pnp.services.datatypes.ExpenseReason;
import pnp.services.datatypes.InventoryElement;
import pnp.services.datatypes.Item;
import pnp.services.datatypes.OrderDetails;
import pnp.services.datatypes.OrderStatus;
import pnp.services.datatypes.PaypalDetails;
import pnp.services.datatypes.PrintDetails;
import pnp.services.datatypes.RESTData;
import pnp.services.datatypes.RMADetails;
import pnp.services.datatypes.RMAReason;
import pnp.services.datatypes.RMAStatus;
import pnp.services.datatypes.SalesTax;
import pnp.services.datatypes.ShippingMethod;
import pnp.services.datatypes.webservices.Website;
import pnp.services.datatypes.webservices.WebsiteCategories;
import pnp.services.datatypes.webservices.WebsiteElement;
import pnp.services.datatypes.webservices.WebsiteProduct;

public interface DBServices {
    public ArrayList<InventoryElement> findFromFullInventory(String var1);

    public float getMaxWholesaleCost(String var1);

    public void removeCategory(int var1);

    public void mergeCategory(int var1, int var2);

    public void addEtsyOrders(HashMap<String, EtsyOrder> var1);

    public void addAmazonOrders(Collection<CompleteOrder> var1);

    public void updateAmazonAccount(AmazonAccount var1);

    public AmazonAccount getAmazonAccountAccount();

    public void updateEtsyAccount(EtsyAccount var1);

    public void deleteEtsyAccount(String var1, String var2);

    public ArrayList<EtsyAccount> getEtsyAccounts();

    public HashMap<String, Integer> getAllItemsQuantity();

    public boolean startup();

    public void updateRESTData(RESTData var1);

    public RESTData getRESTData(String var1);

    public String getLicense();

    public void setLicense(String var1);

    public String combineComments(String var1, String var2);

    public HashMap<Integer, CheckDetails> getCheckDetails(String var1);

    public void deleteCheckDetails(String var1);

    public void insertCheckDetails(CheckDetails var1);

    public AccountPreferences getAccountPreferences(String var1);

    public AccountPreferences getAccountPreferences();

    public void updateAccountPreferences(AccountPreferences var1);

    public void setPaypalLinked(PaypalDetails var1);

    public void deletePrintDetails(String var1);

    public HashMap<String, PrintDetails> getPrintDetails();

    public int getLastPrintID();

    public PrintDetails getPrintDetails(String var1);

    public HashMap<String, PrintDetails> searchPrintDetails(String var1);

    public void refreshExpenseReasonList(boolean var1);

    public void refreshDistributorList(boolean var1);

    public void refreshWebsiteList(boolean var1);

    public void setNoInventory(boolean var1);

    public void setOrderComments(boolean var1);

    public void insertPrintDetails(PrintDetails var1);

    public boolean renameCompany(String var1, String var2);

    public boolean massChangeCompany(String var1, String var2);

    public void deletePaypalTransaction(String var1);

    public ArrayList<PaypalDetails> searchPaypalOrders(String var1);

    public ArrayList<PaypalDetails> getPaypalDetails(String var1);

    public void setPaypalDetails(PaypalDetails var1);

    public void processTransactionUpdate(TransactionType[] var1);

    public HashMap<Integer, CompleteOrder> getOrderList(boolean var1);

    public void setRefresh(boolean var1);

    public HashMap<Integer, CompleteOrder> getCompletedOrders(long var1, long var3);

    public HashMap<Integer, CompleteOrder> getOrdersForTracking();

    public HashMap<Integer, CompleteOrder> getBaseOrders();

    public HashMap<Integer, CompleteOrder> getOrders(Integer[] var1);

    public HashMap<Integer, CompleteOrder> getOrders(String var1, OrderStatus[] var2, long var3, long var5, String var7);

    public CompleteOrder[] getOosOrderList();

    public HashMap<Integer, CompleteOrder> getCompletedOrders();

    public Expense[] getExpenses();

    public Expense[] getSnapshotExpenses(long var1, long var3, String var5);

    public CompleteOrder[] getSnapshotOrders(long var1, long var3, String var5);

    public void refreshCompletedOrders(long var1, long var3);

    public void refreshExpenses(long var1, long var3, ArrayList<Integer> var5, String var6);

    public void searchOrders(String var1, OrderStatus[] var2, long var3, long var5, String var7);

    public void refreshInventory(String var1, boolean var2, boolean var3, boolean var4, boolean var5, String[] var6, boolean var7);

    public void setOrderFilters(Integer[] var1);

    public HashMap<OrderStatus, Integer> getFilterQuantities();

    public void setFilterQuantities(HashMap<OrderStatus, Integer> var1);

    public HashMap<String, OrderStatus> getAvailableFilters();

    public void deleteRMA(RMADetails var1);

    public RMADetails updateRMA(RMADetails var1);

    public RMAReason getRMAReason(int var1);

    public RMAStatus getRMAStatus(int var1);

    public HashMap<String, RMAReason> getAvailableRMAReasons();

    public void searchRMADetails(String var1, long var2, long var4);

    public RMADetails[] getRMAList();

    public HashMap<String, RMAStatus> getAvailableRMAStatuses();

    public void setTrackingOverride(boolean var1);

    public void setMultiOrders(boolean var1);

    public CompleteOrder mergeOrders(ArrayList<CompleteOrder> var1);

    public void updateOrder(CompleteOrder var1);

    public void updateExpense(Expense var1);

    public void updateDistributor(Distributor var1);

    public void deleteOrderDetail(CompleteOrder var1, OrderDetails var2);

    public void deleteExpense(Expense var1);

    public Customer getCustomerByUsername(String var1);

    public Customer getCustomerByEmail(String var1);

    public ArrayList<ShippingMethod> getAvaliableShippingMethods();

    public Item getItem(String var1);

    public void setItem(Item var1);

    public ArrayList<CustomFee> getCustomFeeList();

    public void updateCustomFee(CustomFee var1);

    public void refreshCachedOrderList();

    public void removeCustomFee(CustomFee var1);

    public Collection<ArrayList<InventoryElement>> getInventoryList();

    public Collection<ArrayList<InventoryElement>> getInventoryList(String var1, boolean var2, boolean var3, boolean var4, String[] var5, boolean var6);

    public void updateWebsiteElement(WebsiteElement var1);

    public HashMap<String, WebsiteProduct> getWebsiteProductList();

    public void refreshWebsiteProductList(String var1, boolean var2, boolean var3);

    public void refreshWebsiteProductList();

    public Distributor[] getDistributors();

    public OrderDetails[] getOosOrderDetails();

    public void updateOosOrder(OrderDetails var1);

    public InventoryElement[] getOosInventory();

    public void setInventoryElementChain(ArrayList<InventoryElement> var1);

    public void setInventoryElement(InventoryElement var1);

    public float getAverageWholesaleCost(String var1);

    public void deleteInventoryElement(InventoryElement var1);

    public int getItemQuantity(String var1, boolean var2);

    public HashMap<String, Integer> getReorderList(long var1, long var3);

    public ArrayList<OrderStatus> getOrderStatusList();

    public void updateCategory(Category var1);

    public Category[] getCategories();

    public void updateWebsite(Website var1);

    public Website[] getWebsites();

    public void updateWebsiteCategories(WebsiteCategories var1);

    public WebsiteCategories[] getWebsiteCategories();

    public void updateExpenseReason(ExpenseReason var1);

    public void setRmaFilters(Integer[] var1, Integer[] var2);

    public ExpenseReason[] getExpenseReasons();

    public void splitOrders(HashMap<CompleteOrder, ArrayList<OrderDetails>> var1);

    public ArrayList<OrderDetails> splitOrders(OrderDetails var1);

    public void unmergeOrders(HashMap<CompleteOrder, ArrayList<OrderDetails>> var1);

    public ArrayList<SalesTax> getSalesTax();

    public void setSalesTax(String var1, String var2, Float var3);

    public HashMap<Integer, CategoryAssociation> getCategoryAssociations();

    public void updateCategoryAssociations(CategoryAssociation var1);
}

