/*
 * Decompiled with CFR 0.152.
 */
package pnp.services.localsettings;

import java.awt.print.PrinterJob;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Properties;
import pnp.services.util.ErrorsUtil;
import pnp.services.util.LookupServicesUtil;

public class LocalSettings {
    private Properties keys;
    private static LocalSettings _instance;
    public static final String CONFIGFILE = "config.properties";
    public static final String DATABASE = "database";
    public static final String DEFAULTDB = "pnpdb";
    public static final String PROFILE = "profile";
    public static final String DEFAULTPROFILE = "DEFAULT";
    public static final String DBPREFIX = "jdbc:h2:";
    public static final String OMCOLUMNWIDTHS = "OrderManagerColumnWidths";
    public static final String OMHIDDENCOLUMNS = "OrderManagerColumns";
    public static String DIRECTORY;
    public static final String APPENDMV = ";MV_STORE=FALSE";
    public static final String APPENDDONTTRACK = "?dontTrackOpenResources=true";
    public static String FULL_DB_DIRECTORY;
    private PrinterJob printer;
    public static final String SQLDB = "SQLDB";
    public static final String SQLSERVER = "SQLServer";
    public static final String SQLUSER = "SQLUser";
    public static final String SQLPASSWORD = "SQL";
    public static final String DEFAULTSQLDB = "GamutDB";
    public static final String DEFAULTSQLSERVER = "localhost";
    public static final String DEFAULTSQLUSER = "root";
    public static final String DEFAULTSQLPASSWORD = "GamutSQLDB";
    public static final String USINGMYSQL = "SQLDatabaseExists";

    private LocalSettings() {
        DIRECTORY = System.getProperty("user.dir") + "\\";
        FULL_DB_DIRECTORY = "jdbc:h2:C:\\Users\\Travis\\Desktop\\Gamut Repo\\trunk\\Gamut\\pnpdb;MV_STORE=FALSE";
        this.keys = new Properties();
        try {
            this.keys.load(new FileInputStream(CONFIGFILE));
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex, false);
            this.writeProperties(DATABASE, DEFAULTDB);
            this.writeProperties(PROFILE, DEFAULTPROFILE);
            this.writeProperties(SQLDB, DEFAULTSQLDB);
            this.writeProperties(SQLSERVER, DEFAULTSQLSERVER);
            this.writeProperties(SQLUSER, DEFAULTSQLUSER);
            this.writeProperties(SQLPASSWORD, DEFAULTSQLPASSWORD);
            LookupServicesUtil.getManagerServices().firstStart();
        }
        this.printer = PrinterJob.getPrinterJob();
    }

    public static LocalSettings getInstance() {
        if (null == _instance) {
            _instance = new LocalSettings();
        }
        return _instance;
    }

    public PrinterJob getPrinter() {
        return this.printer;
    }

    public void setPrinter(PrinterJob printer) {
        this.printer = printer;
    }

    public void removeProperty(String property) {
        try {
            this.keys.remove(property);
            this.keys.store(new FileOutputStream(CONFIGFILE), null);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    public void writeProperties(String property, String value) {
        try {
            this.keys.setProperty(property, value);
            this.keys.store(new FileOutputStream(CONFIGFILE), null);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    public String getPropertyValue(String property) {
        String value = this.keys.getProperty(property);
        return value;
    }

    public void setHiddenField(String property, ArrayList<String> columnList) {
        String hiddenColumnString = "";
        Iterator<String> columnIter = columnList.iterator();
        while (columnIter.hasNext()) {
            if (hiddenColumnString.isEmpty()) {
                hiddenColumnString = columnIter.next();
                continue;
            }
            hiddenColumnString = hiddenColumnString + "," + columnIter.next();
        }
        this.writeProperties(property, hiddenColumnString);
    }

    public ArrayList<String> getHiddenField(String property) {
        String hiddenColumnsString = this.getPropertyValue(property);
        ArrayList<String> columnList = new ArrayList<String>();
        if (null != hiddenColumnsString && !hiddenColumnsString.isEmpty()) {
            columnList.addAll(Arrays.asList(hiddenColumnsString.split(",")));
        }
        return columnList;
    }
}

