/*
 * Decompiled with CFR 0.152.
 */
package pnp.services.preferencemanager;

import pnp.services.datatypes.AmazonAccount;
import pnp.services.listenermanager.ListenerManager;
import pnp.services.preferencemanager.Preferences;
import pnp.services.preferencemanager.ifc.PreferenceExt;
import pnp.services.util.LookupServicesUtil;

public class AmazonTab
extends PreferenceExt {
    public AmazonTab(Preferences pref) {
        super(pref);
    }

    @Override
    public void populate() {
        AmazonAccount amazonAccount = LookupServicesUtil.getDBServices().getAmazonAccountAccount();
        this.pref.amazonAccountName.setText(amazonAccount.getAccountName());
        this.pref.amazonMarketPlaceID.setText(amazonAccount.getMarketPlaceID());
        this.pref.amazonSellerID.setText(amazonAccount.getSellerID());
        this.pref.mwsAuthToken.setText(amazonAccount.getMwsAuthToken());
    }

    @Override
    public boolean apply() {
        AmazonAccount amazonAccount = LookupServicesUtil.getDBServices().getAmazonAccountAccount();
        if (!(this.pref.amazonAccountName.getText() == null || this.pref.amazonAccountName.getText().trim().isEmpty() || this.pref.amazonMarketPlaceID.getText() == null || this.pref.amazonMarketPlaceID.getText().trim().isEmpty() || this.pref.amazonSellerID.getText() == null || this.pref.amazonSellerID.getText().trim().isEmpty() || this.pref.mwsAuthToken.getText() == null || this.pref.mwsAuthToken.getText().trim().isEmpty())) {
            amazonAccount.setAccountName(this.pref.amazonAccountName.getText().trim());
            amazonAccount.setMarketPlaceID(this.pref.amazonMarketPlaceID.getText().trim());
            amazonAccount.setSellerID(this.pref.amazonSellerID.getText().trim());
            amazonAccount.setMwsAuthToken(this.pref.mwsAuthToken.getText().trim());
            LookupServicesUtil.getDBServices().updateAmazonAccount(amazonAccount);
            ListenerManager.getInstance().notify(ListenerManager.AMAZON_ACCOUNT_LISTENER);
        }
        return true;
    }

    @Override
    public void clear() {
        AmazonAccount amazonAccount = LookupServicesUtil.getDBServices().getAmazonAccountAccount();
        this.pref.amazonAccountName.setText(amazonAccount.getAccountName());
        this.pref.amazonMarketPlaceID.setText(amazonAccount.getMarketPlaceID());
        this.pref.amazonSellerID.setText(amazonAccount.getSellerID());
        this.pref.mwsAuthToken.setText(amazonAccount.getMwsAuthToken());
    }
}

