/*
 * Decompiled with CFR 0.152.
 */
package pnp.services.preferencemanager;

import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JOptionPane;
import pnp.services.datatypes.AccountPreferences;
import pnp.services.datatypes.CompanyInfo;
import pnp.services.preferencemanager.Preferences;
import pnp.services.preferencemanager.ifc.PreferenceExt;
import pnp.services.util.LookupServicesUtil;

public class CompanyTab
extends PreferenceExt {
    public CompanyTab(Preferences pref) {
        super(pref);
    }

    @Override
    public void clear() {
        super.clear();
    }

    @Override
    public boolean apply() {
        this.applyHelper(this.getSelectedCompany());
        return true;
    }

    public void applyHelper(CompanyInfo specificCompany) {
        specificCompany.setCompanyAddress(this.pref.companyAddress.getText());
        specificCompany.setCompanyCity(this.pref.companyCity.getText());
        specificCompany.setCompanyComments(this.pref.companyInvoiceComments.getText());
        specificCompany.setCompanyCountry(this.pref.companyCountry.getText());
        specificCompany.setCompanyFullName(this.pref.companyFullName.getText());
        specificCompany.setCompanyPaypalLinks((ArrayList)this.listBuilder(this.pref.companyAssociatedAccountsList.getModel()));
        specificCompany.setCompanyPhoneNumber(this.pref.companyPhoneNumber.getText());
        specificCompany.setCompanyPostalCode(this.pref.companyPostalCode.getText());
        specificCompany.setCompanyState(this.pref.companyState.getText());
        specificCompany.setCompanyWebsite(this.pref.companyWebsiteAddress.getText());
        if (this.pref.companySetDefault.isSelected()) {
            this._preferences.setCompanyDefaultCompany(specificCompany.getCompanyName());
        }
    }

    @Override
    public void populate() {
        AccountPreferences test = this._preferences;
        HashMap<String, CompanyInfo> test2 = test.getCompanyInformation();
        this.pref.pauseCompanyBox = true;
        CompanyInfo specificCompany = this.getSelectedCompany();
        this.createComboBox(null);
        this.pref.companyAddress.setText(specificCompany.getCompanyAddress().trim());
        this.pref.companyCity.setText(specificCompany.getCompanyCity().trim());
        this.pref.companyCountry.setText(specificCompany.getCompanyCountry().trim());
        this.pref.companyFullName.setText(specificCompany.getCompanyFullName().trim());
        this.pref.companyInvoiceComments.setText(specificCompany.getCompanyComments().trim());
        this.pref.companyPhoneNumber.setText(specificCompany.getCompanyPhoneNumber().trim());
        this.pref.companyPostalCode.setText(specificCompany.getCompanyPostalCode().trim());
        this.pref.companyState.setText(specificCompany.getCompanyState().trim());
        this.pref.companyWebsiteAddress.setText(specificCompany.getCompanyWebsite().trim());
        CompanyInfo defaultCompany = this._preferences.getSpecificCompany(this._preferences.getCompanyDefaultCompany());
        if (defaultCompany == null) {
            this._preferences.setCompanyDefaultCompany("Default");
        }
        this.pref.companySetDefault.setSelected(specificCompany.getCompanyName().equalsIgnoreCase(this._preferences.getCompanyDefaultCompany()));
        this.enableButtons(null);
        this.refreshLists();
        this.pref.pauseCompanyBox = false;
    }

    public void enableButtons(String textAddition) {
        if (textAddition == null) {
            textAddition = "";
        }
        String comboBox = "";
        String textField = "";
        if (this.pref.companyName.getText() != null) {
            textField = this.pref.companyName.getText().trim();
        }
        if (this.pref.companyComboBox.getSelectedItem() != null) {
            comboBox = this.pref.companyComboBox.getSelectedItem().toString().trim();
        }
        textField = textField + textAddition.trim();
        CompanyInfo company = this._preferences.getSpecificCompany(textField);
        this.pref.companyRenameButton.setEnabled(!comboBox.isEmpty() && !textField.isEmpty() && company == null && !comboBox.equalsIgnoreCase("Default"));
        this.pref.companyAddButton.setEnabled(!textField.isEmpty() && company == null);
    }

    private void createComboBox(String preferredSelection) {
        boolean currentStatus = this.pref.pauseCompanyBox;
        this.pref.pauseCompanyBox = true;
        String specificCompanySelected = this.getSelectedCompanyName();
        this.pref.companyComboBox.removeAllItems();
        this.pref.companyFromComboBox.removeAllItems();
        this.pref.companyToComboBox.removeAllItems();
        this.pref.companyComboBox.addItem("Default");
        this.pref.companyFromComboBox.addItem("Default");
        this.pref.companyToComboBox.addItem("Default");
        for (String companyName : this._preferences.getCompanyInformation().keySet()) {
            if (companyName.equalsIgnoreCase("Default")) continue;
            this.pref.companyComboBox.addItem(this._preferences.getSpecificCompany(companyName).getCompanyName());
            this.pref.companyFromComboBox.addItem(this._preferences.getSpecificCompany(companyName).getCompanyName());
            this.pref.companyToComboBox.addItem(this._preferences.getSpecificCompany(companyName).getCompanyName());
        }
        this.pref.companyFromComboBox.setSelectedItem("Default");
        this.pref.companyToComboBox.setSelectedItem("Default");
        this.pref.companyComboBox.setSelectedItem(specificCompanySelected);
        if (preferredSelection != null) {
            this.pref.companyComboBox.setSelectedItem(preferredSelection);
        }
        this.pref.pauseCompanyBox = currentStatus;
    }

    public CompanyInfo getSelectedCompany() {
        String selectedCompany = "Default";
        if (this.pref.companyComboBox != null & this.pref.companyComboBox.getSelectedItem() != null & !this.pref.companyComboBox.getSelectedItem().toString().isEmpty()) {
            selectedCompany = this.pref.companyComboBox.getSelectedItem().toString();
        }
        return this._preferences.getSpecificCompany(selectedCompany);
    }

    public String getSelectedCompanyName() {
        String selectedCompany = "Default";
        if (this.pref.companyComboBox.getSelectedItem() != null && !this.pref.companyComboBox.getSelectedItem().toString().isEmpty()) {
            selectedCompany = this.pref.companyComboBox.getSelectedItem().toString();
        }
        return selectedCompany;
    }

    public void refreshLists() {
        CompanyInfo specificCompany = this.getSelectedCompany();
        ArrayList<String> accountList = new ArrayList<String>(this._preferences.getPaypalAccounts());
        accountList.removeAll(specificCompany.getCompanyPaypalLinks());
        this.pref.companyAvailableAccountsList.setListData(accountList.toArray(new String[0]));
        this.pref.companyAssociatedAccountsList.setListData(specificCompany.getCompanyPaypalLinks().toArray(new String[0]));
    }

    @Override
    public void valueChanged() {
        this.pref.companyAddAccountButton.setEnabled(this.pref.companyAvailableAccountsList.getSelectedIndex() != -1 && !this.getSelectedCompanyName().equalsIgnoreCase("Default"));
        this.pref.companyRemoveAccountButton.setEnabled(this.pref.companyAssociatedAccountsList.getSelectedIndex() != -1 && !this.getSelectedCompanyName().equalsIgnoreCase("Default"));
    }

    @Override
    public void validate() {
        super.validate();
    }

    public boolean massChangeCompany(String companySelected, String companyRenamed) {
        boolean success = LookupServicesUtil.getDBServices().massChangeCompany(companySelected, companyRenamed);
        LookupServicesUtil.getManagerServices().recreateComboBox();
        return success;
    }

    public boolean renameCompany(String companySelected, String companyRenamed) {
        boolean success = false;
        CompanyInfo selectedCompany = this._preferences.getSpecificCompany(companySelected);
        CompanyInfo renamedCompany = this._preferences.getSpecificCompany(companyRenamed);
        if (selectedCompany != null) {
            if (renamedCompany == null) {
                success = LookupServicesUtil.getDBServices().renameCompany(companySelected, companyRenamed);
                selectedCompany.setCompanyName(companyRenamed);
                this._preferences.getCompanyInformation().remove(CompanyInfo.sanitizeString(companySelected));
                this._preferences.addCompany(CompanyInfo.sanitizeString(companyRenamed), selectedCompany);
                this.createComboBox(companyRenamed);
                if (this._preferences.getCompanyDefaultCompany().equalsIgnoreCase(companySelected)) {
                    this._preferences.setCompanyDefaultCompany(companyRenamed);
                }
                JOptionPane.showMessageDialog(null, companySelected + " successfully renamed to: " + companyRenamed + ".");
            } else {
                JOptionPane.showMessageDialog(null, "Cannot rename " + companySelected + " to " + companyRenamed + ". " + companyRenamed + " already exists.");
            }
        } else {
            JOptionPane.showMessageDialog(null, "Something went wrong. Selected company: " + companySelected + ", does not exist.");
        }
        if (success) {
            LookupServicesUtil.getManagerServices().recreateComboBox();
        }
        return success;
    }
}

