/*
 * Decompiled with CFR 0.152.
 */
package pnp.services.preferencemanager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import pnp.services.datatypes.Distributor;
import pnp.services.preferencemanager.Preferences;
import pnp.services.preferencemanager.ifc.PreferenceExt;
import pnp.services.util.LookupServicesUtil;

public class DistributorTab
extends PreferenceExt {
    private HashMap<String, Distributor> distHash;

    public HashMap<String, Distributor> getDistHash() {
        return this.distHash;
    }

    public DistributorTab(Preferences pref) {
        super(pref);
    }

    @Override
    public void valueChanged() {
        if (!this.pref.distList.isSelectionEmpty()) {
            String distributorName = (String)this.pref.distList.getSelectedValue();
            Distributor distributor = this.distHash.get(distributorName);
            this.pref.distCompanyName.setText(distributor.getDistributorName());
            this.pref.distContactName.setText(distributor.getDistributorContact());
            this.pref.distPhone.setText(distributor.getDistributorPhone());
            this.pref.distWebsite.setText(distributor.getDistributorWebsite());
            this.pref.distEmail.setText(distributor.getDistributorEmail());
            this.pref.distCompanyName.setEditable(false);
            this.pref.distCompanyName.setBackground(null);
        }
    }

    @Override
    public void populate() {
        this.distHash = new HashMap();
        ArrayList<String> distributorList = new ArrayList<String>();
        for (Distributor distributor : LookupServicesUtil.getDBServices().getDistributors()) {
            this.distHash.put(distributor.getDistributorName(), distributor);
            distributorList.add(distributor.getDistributorName());
        }
        Collections.sort(distributorList);
        this.pref.distList.setListData(distributorList.toArray(new String[0]));
        this.clear();
    }

    @Override
    public boolean apply() {
        String companyName = this.pref.distCompanyName.getText().trim();
        if (!companyName.isEmpty()) {
            Distributor distributor = this.distHash.get(this.pref.distCompanyName.getText().trim());
            if (distributor == null) {
                distributor = new Distributor();
                distributor.setDistributorName(this.pref.distCompanyName.getText().trim());
            }
            distributor.setDistributorContact(this.pref.distContactName.getText().trim());
            distributor.setDistributorEmail(this.pref.distEmail.getText().trim());
            distributor.setDistributorPhone(this.pref.distPhone.getText().trim());
            distributor.setDistributorWebsite(this.pref.distWebsite.getText().trim());
            LookupServicesUtil.getDBServices().updateDistributor(distributor);
        }
        this.populate();
        return true;
    }

    @Override
    public void clear() {
        this.pref.distCompanyName.setBackground(GOOD);
        this.pref.distList.clearSelection();
        this.pref.distCompanyName.setEditable(true);
        this.pref.distCompanyName.setText("");
        this.pref.distContactName.setText("");
        this.pref.distEmail.setText("");
        this.pref.distPhone.setText("");
        this.pref.distWebsite.setText("");
    }

    public void selectFromList() {
        if (this.pref.distCompanyName.getText() != null && !this.pref.distCompanyName.getText().isEmpty() && this.distHash.containsKey(this.pref.distCompanyName.getText())) {
            this.pref.distList.setSelectedValue(this.pref.distCompanyName.getText(), true);
            this.valueChanged();
        }
    }
}

