/*
 * Decompiled with CFR 0.152.
 */
package pnp.services.preferencemanager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import pnp.services.authenticationmanager.SubscriptionManager;
import pnp.services.datatypes.webservices.EbayAccountTemp;
import pnp.services.preferencemanager.Preferences;
import pnp.services.preferencemanager.ifc.PreferenceExt;
import pnp.services.util.LookupServicesUtil;

public class EbayTab
extends PreferenceExt {
    private HashMap<String, EbayAccountTemp> ebayHash;

    public EbayTab(Preferences pref) {
        super(pref);
    }

    public HashMap<String, EbayAccountTemp> getEbayHash() {
        return this.ebayHash;
    }

    public void setEbayHash(HashMap<String, EbayAccountTemp> ebayHash) {
        this.ebayHash = ebayHash;
    }

    @Override
    public void valueChanged() {
        if (!this.pref.ebayList.isSelectionEmpty()) {
            this.pref.ebayAccountName.setText((String)this.pref.ebayList.getSelectedValue());
        }
    }

    @Override
    public void populate() {
        this.ebayHash = new HashMap();
        ArrayList<String> listEbay = new ArrayList<String>();
        for (EbayAccountTemp newAccount : SubscriptionManager.getInstance().getEbayAccounts()) {
            listEbay.add(newAccount.getUsername());
            this.ebayHash.put(newAccount.getUsername(), newAccount);
        }
        Collections.sort(listEbay);
        this.pref.ebayList.setListData(listEbay.toArray(new String[0]));
        this.pref.ebayLastUpdate.setText(this._preferences.getEbayLastUpdateString());
        this.clear();
    }

    @Override
    public void clear() {
        this.pref.ebayList.clearSelection();
        this.pref.ebayAccountName.setText("");
    }

    public void lastUpdateHelper(long updateTime) {
        this._preferences.setEbayLastUpdate(updateTime);
        this.pref.updateAccountPreferences();
    }

    public boolean addAccount() {
        if (!(this.pref.ebayStatus.getText().equalsIgnoreCase("Offline") || this.pref.ebayAccountName.getText() == null || this.pref.ebayAccountName.getText().isEmpty() || this.ebayHash.containsKey(this.pref.ebayAccountName.getText()) || !SubscriptionManager.getInstance().getEbayAccounts().isEmpty() && !SubscriptionManager.getInstance().isMultiActive())) {
            boolean returnValue = LookupServicesUtil.getEbayServices().createUser(this.pref.ebayAccountName.getText());
            this.populate();
            return returnValue;
        }
        return false;
    }

    public boolean removeAccount() {
        if (!this.pref.ebayStatus.getText().equalsIgnoreCase("Offline") && this.pref.ebayAccountName.getText() != null && !this.pref.ebayAccountName.getText().isEmpty() && this.ebayHash.containsKey(this.pref.ebayAccountName.getText()) && SubscriptionManager.getInstance().removeEbayAccount(this.pref.ebayAccountName.getText())) {
            LookupServicesUtil.getAuthenticationManagerServices().communicate("removeEbayAccount", this.pref.ebayAccountName.getText(), null, null);
            this.populate();
            return true;
        }
        return false;
    }
}

