/*
 * Decompiled with CFR 0.152.
 */
package pnp.services.preferencemanager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import pnp.services.datatypes.ExpenseReason;
import pnp.services.preferencemanager.Preferences;
import pnp.services.preferencemanager.ifc.PreferenceExt;
import pnp.services.util.LookupServicesUtil;

public class ExpenseTab
extends PreferenceExt {
    private HashMap<String, ExpenseReason> expenseHash;

    public HashMap<String, ExpenseReason> getExpenseHash() {
        return this.expenseHash;
    }

    public ExpenseTab(Preferences pref) {
        super(pref);
    }

    @Override
    public void valueChanged() {
        if (!this.pref.expenseList.isSelectionEmpty()) {
            this.pref.expenseLabel.setText((String)this.pref.expenseList.getSelectedValue());
            this.pref.expenseEdit.setEditable(true);
            this.pref.expenseLabel.transferFocus();
        }
    }

    @Override
    public void populate() {
        this.expenseHash = new HashMap();
        ArrayList<String> expenseReasonList = new ArrayList<String>();
        for (ExpenseReason expense : LookupServicesUtil.getDBServices().getExpenseReasons()) {
            this.expenseHash.put(expense.getReason(), expense);
            expenseReasonList.add(expense.getReason());
        }
        Collections.sort(expenseReasonList);
        this.pref.expenseList.setListData(expenseReasonList.toArray(new String[0]));
        this.clear();
    }

    @Override
    public boolean apply() {
        if (this.pref.expenseLabel.getText() != null && !this.pref.expenseLabel.getText().trim().isEmpty()) {
            String expenseLabel = this.pref.expenseLabel.getText().trim();
            ExpenseReason expenseReason = null;
            if (this.expenseHash.containsKey(expenseLabel)) {
                expenseReason = this.expenseHash.get(expenseLabel);
                if (this.pref.expenseEdit.getText() != null && !this.pref.expenseEdit.getText().trim().isEmpty()) {
                    expenseReason.setReason(this.pref.expenseEdit.getText().trim());
                }
            } else {
                expenseReason = new ExpenseReason();
                expenseReason.setReason(expenseLabel);
            }
            LookupServicesUtil.getDBServices().updateExpenseReason(expenseReason);
            this.populate();
        }
        return true;
    }

    @Override
    public void clear() {
        this.pref.expenseList.clearSelection();
        this.pref.expenseEdit.setEditable(false);
        this.pref.expenseEdit.setText("");
        this.pref.expenseLabel.setText("");
    }
}

