/*
 * Decompiled with CFR 0.152.
 */
package pnp.services.preferencemanager;

import java.io.File;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import pnp.services.datatypes.AccountPreferences;
import pnp.services.localsettings.LocalSettings;
import pnp.services.preferencemanager.Preferences;
import pnp.services.preferencemanager.ifc.PreferenceExt;
import pnp.services.util.DatabaseConnector;
import pnp.services.util.GenericFunctions;

public class GeneralTab
extends PreferenceExt {
    public GeneralTab(Preferences pref) {
        super(pref);
    }

    @Override
    public void populate() {
        this.pref.profileListener = false;
        ((DefaultComboBoxModel)this.pref.genProfile.getModel()).removeAllElements();
        for (String element : this._preferences.getGenProfiles()) {
            ((DefaultComboBoxModel)this.pref.genProfile.getModel()).addElement(element);
        }
        this.pref.genProfile.setSelectedItem(this._preferences.getGenProfile());
        this.pref.genNegativeNotification.setSelected(this._preferences.isGenNegativeNotification());
        if (this._preferences.getGenSalesPeriod() == 1) {
            this.pref.genSalesPeriod.setSelectedIndex(0);
        } else {
            this.pref.genSalesPeriod.setSelectedIndex(1);
        }
        if (this._preferences.getGenStockNotification() == AccountPreferences.NEVER) {
            this.pref.genStockNotification.setSelectedItem("NEVER");
        } else if (this._preferences.getGenStockNotification() == 0 || this._preferences.getGenStockNotification() == 1 || this._preferences.getGenStockNotification() == 2 || this._preferences.getGenStockNotification() == 5) {
            this.pref.genStockNotification.setSelectedItem(String.valueOf(this._preferences.getGenStockNotification()));
        } else {
            this.pref.genStockNotification.setSelectedItem("Custom");
            this.pref.genCustomStockNotify.setText(String.valueOf(this._preferences.getGenStockNotification()));
        }
        this.pref.genTrackingNotify.setSelected(this._preferences.isGenTrackingNotify());
        this.pref.genUnmergeNotify.setSelected(this._preferences.isGenUnmergeNotify());
        this.pref.genVersion.setText(String.valueOf(this._preferences.getGenVersion()));
        this.pref.genDatabaseField.setText(LocalSettings.getInstance().getPropertyValue("database"));
        this.pref.genSyncNotification.setSelected(this._preferences.isGenSyncNotification());
        this.pref.genSplitRefresh.setSelected(this._preferences.isGenSplitRefresh());
        this.pref.genInventoryRefresh.setSelected(this._preferences.isGenInventoryRefresh());
        this.pref.genBetaUpdates.setSelected(this._preferences.isGenBetaUpdates());
        this.pref.sqlServerAddress.setText(LocalSettings.getInstance().getPropertyValue("SQLServer"));
        this.pref.sqlUserName.setText(LocalSettings.getInstance().getPropertyValue("SQLUser"));
        this.pref.sqlPassword.setText(LocalSettings.getInstance().getPropertyValue("SQL"));
        this.pref.profileListener = true;
    }

    @Override
    public boolean apply() {
        this.newDatabase();
        this._preferences.setGenProfile((String)this.pref.genProfile.getSelectedItem());
        this._preferences.setGenProfiles(this.listBuilder(this.pref.genProfile.getModel()));
        this._preferences.setGenNegativeNotification(this.pref.genNegativeNotification.isSelected());
        if (this.pref.genSalesPeriod.getSelectedIndex() == 1) {
            this._preferences.setGenSalesPeriod(16);
        } else {
            this._preferences.setGenSalesPeriod(1);
        }
        if (((String)this.pref.genStockNotification.getSelectedItem()).equalsIgnoreCase("NEVER")) {
            this._preferences.setGenStockNotification(AccountPreferences.NEVER);
        } else if (((String)this.pref.genStockNotification.getSelectedItem()).equalsIgnoreCase("Custom")) {
            String customText = this.pref.genCustomStockNotify.getText();
            if (customText == null || customText.trim().isEmpty() || !customText.matches("[0-9]+")) {
                customText = "0";
                this.pref.genCustomStockNotify.setText("0");
            }
            customText = customText.trim();
            this._preferences.setGenStockNotification(Integer.parseInt(customText));
        } else {
            this._preferences.setGenStockNotification(Integer.parseInt((String)this.pref.genStockNotification.getSelectedItem()));
        }
        this._preferences.setGenTrackingNotify(this.pref.genTrackingNotify.isSelected());
        this._preferences.setGenUnmergeNotify(this.pref.genUnmergeNotify.isSelected());
        this._preferences.setGenSyncNotification(this.pref.genSyncNotification.isSelected());
        this._preferences.setGenSplitRefresh(this.pref.genSplitRefresh.isSelected());
        this._preferences.setGenInventoryRefresh(this.pref.genInventoryRefresh.isSelected());
        this._preferences.setGenBetaUpdates(this.pref.genBetaUpdates.isSelected());
        this.tryMySQLLogin();
        return true;
    }

    private void tryMySQLLogin() {
        String serverName = GenericFunctions.getInstance().prepareString(LocalSettings.getInstance().getPropertyValue("SQLServer"));
        String userName = GenericFunctions.getInstance().prepareString(LocalSettings.getInstance().getPropertyValue("SQLUser"));
        String password = GenericFunctions.getInstance().prepareString(LocalSettings.getInstance().getPropertyValue("SQL"));
        String newServerName = GenericFunctions.getInstance().prepareString(this.pref.sqlServerAddress.getText());
        String newUserName = GenericFunctions.getInstance().prepareString(this.pref.sqlUserName.getText());
        String newPassword = GenericFunctions.getInstance().prepareString(new String(this.pref.sqlPassword.getPassword()));
        if (!(serverName.equals(newServerName) && userName.equals(newUserName) && password.equals(newPassword))) {
            LocalSettings.getInstance().writeProperties("SQLServer", newServerName);
            LocalSettings.getInstance().writeProperties("SQLUser", newUserName);
            LocalSettings.getInstance().writeProperties("SQL", newPassword);
        }
        LocalSettings.getInstance().removeProperty("SQLDatabaseExists");
        DatabaseConnector.selectDatabase();
        if (DatabaseConnector.usingSQLDB) {
            LocalSettings.getInstance().writeProperties("SQLDatabaseExists", "TRUE");
        }
    }

    public void genDatabaseLocation() {
        JFileChooser location = new JFileChooser();
        location.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String name = f.getName();
                return name.endsWith(".h2.db");
            }

            @Override
            public String getDescription() {
                return "*.h2.db";
            }
        });
        if (location.showSaveDialog(null) == 0) {
            this.pref.genDatabaseField.setText(location.getSelectedFile().getPath().trim().replace(".h2.db", ""));
        }
    }

    public void newDatabase() {
    }

    public void addAccount() {
        if (this.pref.genProfileAdd.getText() != null && !this.pref.genProfileAdd.getText().trim().isEmpty()) {
            String profile = this.pref.genProfileAdd.getText().trim().toUpperCase();
            if (!this._preferences.getGenProfiles().contains(profile)) {
                this._preferences.getGenProfiles().add(profile);
            }
            this.pref.genProfile.addItem(profile);
        }
    }

    public void removeAccount() {
        String profile;
        if (this.pref.genProfile.getSelectedItem() != null && !(profile = this.pref.genProfile.getSelectedItem().toString().toUpperCase()).equalsIgnoreCase("Default")) {
            this._preferences.getGenProfiles().remove(profile);
            this.pref.genProfile.setSelectedItem("DEFAULT");
        }
    }
}

