/*
 * Decompiled with CFR 0.152.
 */
package pnp.services.preferencemanager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import pnp.services.authenticationmanager.SubscriptionManager;
import pnp.services.datatypes.webservices.PaypalAccountTemp;
import pnp.services.listener.PaypalListener;
import pnp.services.listenermanager.ListenerManager;
import pnp.services.preferencemanager.Preferences;
import pnp.services.preferencemanager.ifc.PreferenceExt;
import pnp.services.util.LookupServicesUtil;

public class PaypalTab
extends PreferenceExt
implements PaypalListener {
    private HashMap<String, PaypalAccountTemp> paypalHash;

    public PaypalTab(Preferences pref) {
        super(pref);
        ListenerManager.getInstance().subscribe(this);
    }

    @Override
    public void valueChanged() {
        if (!this.pref.paypalList.isSelectionEmpty()) {
            this.pref.paypalAccountName.setText((String)this.pref.paypalList.getSelectedValue());
        }
    }

    public void populateList() {
        this.paypalHash = new HashMap();
        ArrayList<String> listPaypal = new ArrayList<String>();
        this._preferences.setPaypalAccounts(new ArrayList<String>());
        for (PaypalAccountTemp newAccount : SubscriptionManager.getInstance().getPaypalAccounts()) {
            listPaypal.add(newAccount.getAccountID());
            this.paypalHash.put(newAccount.getAccountID(), newAccount);
            if (newAccount.getAccountID() == null || this._preferences.getPaypalAccounts().contains(newAccount.getAccountID())) continue;
            this._preferences.getPaypalAccounts().add(newAccount.getAccountID());
            this._preferences.addPayPalAccount("default", newAccount.getAccountID());
        }
        Collections.sort(listPaypal);
        LookupServicesUtil.getManagerServices().recreateComboBox();
        this.pref.paypalList.setListData(listPaypal.toArray(new String[0]));
    }

    @Override
    public void populate() {
        this.clear();
        this.populateList();
        this.pref.paypalAutoLink.setSelected(this._preferences.isPaypalAutoLink());
        this.pref.paypalDomesticAddon.setValue(this._preferences.getPaypalDomesticAddon());
        this.pref.paypalDomesticFee.setValue(this._preferences.getPaypalDomesticFee());
        this.pref.paypalInternationalAddon.setValue(this._preferences.getPaypalInternationalAddon());
        this.pref.paypalInternationalFee.setValue(this._preferences.getPaypalInternationalFee());
        this.pref.paypalFilterList.setListData(this._preferences.getPaypalFilterList().toArray(new String[0]));
    }

    @Override
    public boolean apply() {
        this._preferences.setPaypalAutoLink(this.pref.paypalAutoLink.isSelected());
        this._preferences.setPaypalDomesticAddon(Double.parseDouble(this.pref.paypalDomesticAddon.getValue().toString()));
        this._preferences.setPaypalDomesticFee(Double.parseDouble(this.pref.paypalDomesticFee.getValue().toString()));
        this._preferences.setPaypalInternationalAddon(Double.parseDouble(this.pref.paypalInternationalAddon.getValue().toString()));
        this._preferences.setPaypalInternationalFee(Double.parseDouble(this.pref.paypalInternationalFee.getValue().toString()));
        this._preferences.setPaypalFilterList((ArrayList)this.listBuilder(this.pref.paypalFilterList.getModel()));
        this.populate();
        return true;
    }

    @Override
    public void clear() {
        this.pref.paypalList.clearSelection();
        this.pref.paypalAccountName.setText("");
        this.pref.paypalDomesticAddon.setValue(0.0);
        this.pref.paypalDomesticFee.setValue(0.0);
        this.pref.paypalInternationalAddon.setValue(0.0);
        this.pref.paypalInternationalFee.setValue(0.0);
    }

    public boolean addAccount() {
        if (!(this.pref.paypalStatus.getText().equalsIgnoreCase("Offline") || this.pref.paypalAccountName.getText() == null || this.pref.paypalAccountName.getText().isEmpty() || this.paypalHash.containsKey(this.pref.paypalAccountName.getText()) || !SubscriptionManager.getInstance().getPaypalAccounts().isEmpty() && !SubscriptionManager.getInstance().isMultiActive())) {
            LookupServicesUtil.getPaypalServices().getPermissions(this.pref.paypalAccountName.getText());
            this.populateList();
            return true;
        }
        return false;
    }

    public boolean removeAccount() {
        if (!this.pref.paypalStatus.getText().equalsIgnoreCase("Offline") && this.pref.paypalAccountName.getText() != null && !this.pref.paypalAccountName.getText().isEmpty() && this.paypalHash.containsKey(this.pref.paypalAccountName.getText()) && SubscriptionManager.getInstance().removePaypalAccount(this.pref.paypalAccountName.getText())) {
            LookupServicesUtil.getAuthenticationManagerServices().communicate("removePaypalAccount", this.pref.paypalAccountName.getText(), null, null);
            this.populateList();
            return true;
        }
        return false;
    }

    @Override
    public void newPaypalAccountAvailable() {
        this.populateList();
    }
}

