/*
 * Decompiled with CFR 0.152.
 */
package pnp.services.preferencemanager;

import StampsSDK.Address;
import javax.swing.JFileChooser;
import pnp.services.authenticationmanager.SubscriptionManager;
import pnp.services.datatypes.AccountPreferences;
import pnp.services.datatypes.StampsAccount;
import pnp.services.preferencemanager.Preferences;
import pnp.services.preferencemanager.ifc.PreferenceExt;
import pnp.services.util.ErrorsUtil;
import pnp.services.util.LookupServicesUtil;

public class StampsTab
extends PreferenceExt {
    public StampsTab(Preferences pref) {
        super(pref);
    }

    @Override
    public void populate() {
        this.pref.stampsSaveCredentials.setSelected(this._preferences.isStampsSaveCredentials());
        this.pref.stampsSignatureConfirm.setSelected(this._preferences.isStampsSignatureConfirm());
        this.pref.stampsImageLocation.setText(this._preferences.getStampsImageLocation());
        this.pref.stampsAccountComboBox.setSelectedItem(this._preferences.getStampsAccount());
        if (this._preferences.getStampsAccount() == null) {
            this._preferences.setStampsAccount(AccountPreferences.STAMPS);
        }
        this.pref.stampsEndiciaChangePassword.setVisible(this._preferences.getStampsAccount().equalsIgnoreCase(AccountPreferences.ENDICIA));
        this.pref.stampsAccountNumber.setVisible(this._preferences.getStampsAccount().equalsIgnoreCase(AccountPreferences.UPS));
        this.pref.accountNumberLabel.setVisible(this._preferences.getStampsAccount().equalsIgnoreCase(AccountPreferences.UPS));
        if (this.pref.stampsAccountComboBox.getSelectedItem().toString().equalsIgnoreCase(AccountPreferences.STAMPS)) {
            this.pref.stampsUsername.setText(this._preferences.getStampsUsername());
            this.pref.stampsPassword.setText(this._preferences.getStampsPassword());
        } else if (this.pref.stampsAccountComboBox.getSelectedItem().toString().equalsIgnoreCase(AccountPreferences.ENDICIA)) {
            this.pref.stampsUsername.setText(this._preferences.getStampsEndiciaUserName());
            this.pref.stampsPassword.setText(this._preferences.getStampsEndiciaPassword());
        } else if (this.pref.stampsAccountComboBox.getSelectedItem().toString().equalsIgnoreCase(AccountPreferences.UPS)) {
            this.pref.stampsUsername.setText(this._preferences.getStampsUPSUserName());
            this.pref.stampsPassword.setText(this._preferences.getStampsUPSPassword());
            this.pref.stampsAccountNumber.setText(this._preferences.getStampsUPSAccountNumber());
        }
        this.pref.stampsCommercialPlus.setSelected(this._preferences.isStampsCommercialPlus());
        this.pref.stampsPrintLabels.setSelected(this._preferences.isStampsPrintLabels());
        this.pref.stampsPurchaseLabels.setSelected(this._preferences.isStampsPurchaseLabels());
        this.pref.stampsSaveLabels.setSelected(this._preferences.isStampsSaveLabels());
        this.pref.stampsTracking.setSelected(this._preferences.isStampsTracking());
        this.pref.stampsLabelStatus.setSelectedItem(this._preferences.getStampsLabelStatus());
        this.pref.stampsPrintOptions.setSelectedItem(this._preferences.getStampsPrintOptions());
        this.pref.stampsPageOptions.setSelectedItem(this._preferences.getStampsPageOptions());
        this.pref.stampsHideNotification.setSelected(this._preferences.isStampsHideNotification());
        this.pref.stampsStorageDays.setSelectedItem(this._preferences.getStampsStorageDays());
        this.pref.stampsPackedWeight.setSelected(this._preferences.isStampsPackedWeight());
        this.pref.stampsAutoPurchase.setSelected(this._preferences.isStampsAutoPurchase());
        this.pref.stampsAutoPurchaseNotification.setSelected(this._preferences.isStampsAutoPurchaseWarning());
        this.pref.stampsInvalidPackageNotification.setSelected(this._preferences.isStampsInvalidPackageNotification());
        if (this._preferences.isStampsAutoPurchase()) {
            float autoPurchase = this._preferences.getStampsAutoPurchaseLimit();
            this.pref.stampsPurchaseAmountComboBox.setEnabled(true);
            if (autoPurchase < 0.0f) {
                this.pref.stampsPurchaseAmountComboBox.setSelectedItem("UNLIMITED");
            } else if (autoPurchase == 0.0f || autoPurchase == 25.0f || autoPurchase == 50.0f || autoPurchase == 100.0f || autoPurchase == 200.0f || autoPurchase == 500.0f) {
                int intAutoPurchase = (int)autoPurchase;
                this.pref.stampsPurchaseAmountComboBox.setSelectedItem(String.valueOf(intAutoPurchase));
            } else {
                this.pref.stampsPurchaseAmountComboBox.setSelectedItem("OTHER");
                this.pref.stampsAutoPurchaseAmount.setText(String.valueOf(this._preferences.getStampsAutoPurchaseLimit()));
                this.pref.stampsAutoPurchaseAmount.setEnabled(true);
            }
        } else {
            this.pref.stampsAutoPurchaseAmount.setEnabled(false);
            this.pref.stampsPurchaseAmountComboBox.setEnabled(false);
            this.pref.stampsPurchaseAmountComboBox.setSelectedItem("0");
            this.pref.stampsAutoPurchaseAmount.setText("0.0");
        }
        this.pref.stampsPurchaseDateNotification.setSelected(this._preferences.isStampsPurchaseDateNotification());
        this.pref.stampsComments.setSelected(this._preferences.isStampsComments());
        this.pref.stampsNIAFilter.setSelected(this._preferences.isStampsNIAFilter());
        this.pref.stampsMixedInventoryNotification.setSelected(this._preferences.isStampsMixedInventoryNotification());
        this.pref.stampsInternationalWarning.setSelected(this._preferences.isStampsInternationalWarning());
        this.pref.stampsInternationalWarningPrice.setText(String.valueOf(this._preferences.getStampsInternationalWarningPrice()));
        this.pref.stampsDiscoWarning.setText(this._preferences.getStampsDiscoWarning());
        this.pref.stampsOOSWarning.setText(this._preferences.getStampsOOSWarning());
    }

    @Override
    public boolean apply() {
        this._preferences.setStampsSaveCredentials(this.pref.stampsSaveCredentials.isSelected());
        this._preferences.setStampsSignatureConfirm(this.pref.stampsSignatureConfirm.isSelected());
        this._preferences.setStampsImageLocation(this.pref.stampsImageLocation.getText().trim());
        this._preferences.setStampsPrintLabels(this.pref.stampsPrintLabels.isSelected());
        this._preferences.setStampsPurchaseLabels(this.pref.stampsPurchaseLabels.isSelected());
        this._preferences.setStampsSaveLabels(this.pref.stampsSaveLabels.isSelected());
        this._preferences.setStampsTracking(this.pref.stampsTracking.isSelected());
        this._preferences.setStampsLabelStatus(this.pref.stampsLabelStatus.getSelectedItem().toString());
        this._preferences.setStampsPrintOptions(this.pref.stampsPrintOptions.getSelectedItem().toString());
        this._preferences.setStampsPageOptions(this.pref.stampsPageOptions.getSelectedItem().toString());
        this._preferences.setStampsHideNotification(this.pref.stampsHideNotification.isSelected());
        this._preferences.setStampsStorageDays(Integer.parseInt(this.pref.stampsStorageDays.getSelectedItem().toString()));
        if (this._preferences.isStampsPackedWeight() != this.pref.stampsPackedWeight.isSelected()) {
            this._preferences.setStampsPackedWeight(this.pref.stampsPackedWeight.isSelected());
            LookupServicesUtil.getManagerServices().printToggleWeight();
        }
        this._preferences.setStampsPackedWeight(this.pref.stampsPackedWeight.isSelected());
        this._preferences.setStampsAutoPurchase(this.pref.stampsAutoPurchase.isSelected());
        this._preferences.setStampsAutoPurchaseWarning(this.pref.stampsAutoPurchaseNotification.isSelected());
        this._preferences.setStampsInvalidPackageNotification(this.pref.stampsInvalidPackageNotification.isSelected());
        if (this.pref.stampsPurchaseAmountComboBox.getSelectedItem().toString().equalsIgnoreCase("OTHER")) {
            this._preferences.setStampsAutoPurchaseLimit(Float.parseFloat(this.pref.stampsAutoPurchaseAmount.getText()));
        } else if (this.pref.stampsPurchaseAmountComboBox.getSelectedItem().toString().equalsIgnoreCase("UNLIMITED")) {
            this._preferences.setStampsAutoPurchaseLimit(-1.0f);
        } else {
            this._preferences.setStampsAutoPurchaseLimit(Float.parseFloat(this.pref.stampsPurchaseAmountComboBox.getSelectedItem().toString()));
        }
        this._preferences.setStampsPurchaseDateNotification(this.pref.stampsPurchaseDateNotification.isSelected());
        this._preferences.setStampsComments(this.pref.stampsComments.isSelected());
        if (this._preferences.isStampsNIAFilter() != this.pref.stampsNIAFilter.isSelected()) {
            this._preferences.setStampsNIAFilter(this.pref.stampsNIAFilter.isSelected());
            LookupServicesUtil.getManagerServices().printToggleNIA();
        }
        this._preferences.setStampsNIAFilter(this.pref.stampsNIAFilter.isSelected());
        this._preferences.setStampsMixedInventoryNotification(this.pref.stampsMixedInventoryNotification.isSelected());
        this.pref.stampsEndiciaChangePassword.setVisible(this.pref.stampsAccountComboBox.getSelectedItem().toString().equalsIgnoreCase(AccountPreferences.ENDICIA));
        this.pref.stampsAccountNumber.setVisible(this.pref.stampsAccountComboBox.getSelectedItem().toString().equalsIgnoreCase(AccountPreferences.UPS));
        this.pref.accountNumberLabel.setVisible(this.pref.stampsAccountComboBox.getSelectedItem().toString().equalsIgnoreCase(AccountPreferences.UPS));
        this._preferences.setStampsAccount(this.pref.stampsAccountComboBox.getSelectedItem().toString());
        if (!this.pref.stampsUsername.getText().trim().isEmpty() && !new String(this.pref.stampsPassword.getPassword()).trim().isEmpty()) {
            if (this.pref.stampsAccountComboBox.getSelectedItem().toString().equalsIgnoreCase(AccountPreferences.STAMPS)) {
                if (!(this.pref.stampsLoginSuccess && this.pref.stampsUsername.getText().trim().equalsIgnoreCase(this._preferences.getStampsUsername()) && new String(this.pref.stampsPassword.getPassword()).trim().equalsIgnoreCase(this._preferences.getStampsPassword()))) {
                    SubscriptionManager.getInstance().removeStampsAccount();
                    this._preferences.setStampsUsername(this.pref.stampsUsername.getText().trim());
                    this._preferences.setStampsPassword(new String(this.pref.stampsPassword.getPassword()).trim());
                    this.pref.stampsLoginSuccess = this.stampsLogin(true);
                }
            } else if (this.pref.stampsAccountComboBox.getSelectedItem().toString().equalsIgnoreCase(AccountPreferences.ENDICIA)) {
                if (this.pref.endiciaLoginSuccess == -1.0f || !this.pref.stampsUsername.getText().trim().equalsIgnoreCase(this._preferences.getStampsEndiciaUserName()) || !new String(this.pref.stampsPassword.getPassword()).trim().equalsIgnoreCase(this._preferences.getStampsEndiciaPassword())) {
                    SubscriptionManager.getInstance().removeStampsAccount();
                    this._preferences.setStampsEndiciaUserName(this.pref.stampsUsername.getText().trim());
                    this._preferences.setStampsEndiciaPassword(new String(this.pref.stampsPassword.getPassword()).trim());
                    this.pref.endiciaLoginSuccess = this.endiciaLogin(true);
                }
            } else if (this.pref.stampsAccountComboBox.getSelectedItem().toString().equalsIgnoreCase(AccountPreferences.UPS) && !this.pref.stampsAccountNumber.getText().trim().isEmpty()) {
                SubscriptionManager.getInstance().removeStampsAccount();
                this._preferences.setStampsUPSUserName(this.pref.stampsUsername.getText().trim());
                this._preferences.setStampsUPSPassword(new String(this.pref.stampsPassword.getPassword()).trim());
                this._preferences.setStampsUPSAccountNumber(this.pref.stampsAccountNumber.getText().trim());
                this.pref.upsLoginSuccess = this.UPSLogin(true);
            }
        }
        this._preferences.setStampsCommercialPlus(this.pref.stampsCommercialPlus.isSelected());
        this._preferences.setStampsInternationalWarning(this.pref.stampsInternationalWarning.isSelected());
        float warningPrice = 100.0f;
        try {
            warningPrice = Float.parseFloat(this.pref.stampsInternationalWarningPrice.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._preferences.setStampsInternationalWarningPrice(warningPrice);
        this._preferences.setStampsDiscoWarning(this.pref.stampsDiscoWarning.getText());
        this._preferences.setStampsOOSWarning(this.pref.stampsOOSWarning.getText());
        LookupServicesUtil.getManagerServices().toggleAccounts();
        return this.pref.stampsLoginSuccess || this.pref.endiciaLoginSuccess != -1.0f || this.pref.upsLoginSuccess;
    }

    public boolean UPSLogin(boolean using) {
        try {
            boolean loginSuccess = LookupServicesUtil.getUPSServices().login(this._preferences.getStampsUPSUserName(), this._preferences.getStampsUPSPassword(), this._preferences.getStampsUPSAccountNumber());
            if (using) {
                if (loginSuccess) {
                    this.pref.stampsLoginStatus.setBackground(SUCCESS);
                    this.pref.stampsLoginStatus.setText("Success!");
                    SubscriptionManager.getInstance().getStampsAccount().setUserName(this._preferences.getStampsUPSUserName());
                    SubscriptionManager.getInstance().getStampsAccount().setPassword(this._preferences.getStampsUPSPassword());
                    SubscriptionManager.getInstance().getStampsAccount().setAddress(this.pref.companyAddress.getText());
                    SubscriptionManager.getInstance().getStampsAccount().setCity(this.pref.companyCity.getText());
                    SubscriptionManager.getInstance().getStampsAccount().setCountry(this.pref.companyCountry.getText());
                    SubscriptionManager.getInstance().getStampsAccount().setName(this.pref.companyFullName.getText());
                    SubscriptionManager.getInstance().getStampsAccount().setNumber(this.pref.companyPhoneNumber.getText());
                    SubscriptionManager.getInstance().getStampsAccount().setState(this.pref.companyState.getText());
                    SubscriptionManager.getInstance().getStampsAccount().setZip(this.pref.companyPostalCode.getText());
                } else {
                    this.pref.stampsLoginStatus.setBackground(BAD);
                    this.pref.stampsLoginStatus.setText("Invalid Login.");
                    SubscriptionManager.getInstance().setStampsAccount(new StampsAccount());
                }
            }
            return loginSuccess;
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
            return false;
        }
    }

    public float endiciaLogin(boolean usingAccount) {
        try {
            float postage = LookupServicesUtil.getEndiciaServices().getPostageBalance(this._preferences.getStampsEndiciaUserName(), this._preferences.getStampsEndiciaPassword(), usingAccount);
            if (usingAccount) {
                if (postage != -1.0f) {
                    this.pref.stampsLoginStatus.setBackground(SUCCESS);
                    this.pref.stampsLoginStatus.setText("Success!");
                    SubscriptionManager.getInstance().getStampsAccount().setUserName(this._preferences.getStampsUsername());
                    SubscriptionManager.getInstance().getStampsAccount().setPassword(this._preferences.getStampsPassword());
                    SubscriptionManager.getInstance().getStampsAccount().setAddress(this.pref.companyAddress.getText());
                    SubscriptionManager.getInstance().getStampsAccount().setCity(this.pref.companyCity.getText());
                    SubscriptionManager.getInstance().getStampsAccount().setCountry(this.pref.companyCountry.getText());
                    SubscriptionManager.getInstance().getStampsAccount().setName(this.pref.companyFullName.getText());
                    SubscriptionManager.getInstance().getStampsAccount().setNumber(this.pref.companyPhoneNumber.getText());
                    SubscriptionManager.getInstance().getStampsAccount().setState(this.pref.companyState.getText());
                    SubscriptionManager.getInstance().getStampsAccount().setZip(this.pref.companyPostalCode.getText());
                } else {
                    this.pref.stampsLoginStatus.setBackground(BAD);
                    this.pref.stampsLoginStatus.setText("Invalid Login.");
                    SubscriptionManager.getInstance().setStampsAccount(new StampsAccount());
                }
            }
            return postage;
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
            return -1.0f;
        }
    }

    @Override
    public void clear() {
        this.pref.stampsImageLocation.setBackground(GOOD);
        this.pref.stampsPassword.setBackground(GOOD);
        this.pref.stampsUsername.setBackground(GOOD);
        this.pref.stampsImageLocation.setText("");
        this.pref.stampsPassword.setText("");
        this.pref.stampsUsername.setText("");
    }

    public void stampsLocationAction() {
        JFileChooser location = new JFileChooser();
        location.setFileSelectionMode(1);
        if (location.showSaveDialog(null) == 0) {
            this._preferences.setStampsImageLocation(location.getSelectedFile().getPath().trim() + "\\");
            this.pref.stampsImageLocation.setText(this._preferences.getStampsImageLocation());
        }
    }

    public void stampsRegisterAction() {
        if (this.pref.stampsAccountComboBox.getSelectedItem().toString().equalsIgnoreCase(AccountPreferences.STAMPS)) {
            super.openWebsiteAction("http://www.stamps.com/registration/");
        } else if (this.pref.stampsAccountComboBox.getSelectedItem().toString().equalsIgnoreCase(AccountPreferences.ENDICIA)) {
            super.openWebsiteAction("https://account.endicia.com/");
        } else if (this.pref.stampsAccountComboBox.getSelectedItem().toString().equalsIgnoreCase(AccountPreferences.UPS)) {
            super.openWebsiteAction("https://google.com/");
        }
    }

    public boolean stampsLogin(boolean using) {
        try {
            boolean stampsLoginSuccess;
            boolean bl = stampsLoginSuccess = LookupServicesUtil.getStampsServices().authenticateUser(this._preferences.getStampsUsername(), this._preferences.getStampsPassword()) != null;
            if (stampsLoginSuccess) {
                SubscriptionManager.getInstance().getStampsAccount().setUserName(this._preferences.getStampsUsername());
                SubscriptionManager.getInstance().getStampsAccount().setPassword(this._preferences.getStampsPassword());
                if (using) {
                    this.pref.stampsLoginStatus.setBackground(SUCCESS);
                    this.pref.stampsLoginStatus.setText("Success!");
                }
            } else if (using) {
                this.pref.stampsLoginStatus.setBackground(BAD);
                this.pref.stampsLoginStatus.setText(LookupServicesUtil.getStampsServices().getAuthenticationError());
            }
            return stampsLoginSuccess;
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
            return false;
        }
    }

    public boolean stampsCleanse() {
        boolean stampsCleanseSuccess = true;
        Address newAddress = new Address();
        newAddress.setAddress1(this.pref.companyAddress.getText());
        newAddress.setCity(this.pref.companyCity.getText());
        newAddress.setCountry(this.pref.companyCountry.getText());
        newAddress.setPhoneNumber(this.pref.companyPhoneNumber.getText());
        newAddress.setFullName(this.pref.companyFullName.getText());
        if (this.pref.companyCountry.getText().equalsIgnoreCase("US")) {
            newAddress.setState(this.pref.companyState.getText());
            newAddress.setZIPCode(this.pref.companyPostalCode.getText());
        } else {
            newAddress.setProvince(this.pref.companyState.getText());
            newAddress.setPostalCode(this.pref.companyPostalCode.getText());
        }
        newAddress = LookupServicesUtil.getStampsServices().cleanseAddress(newAddress);
        if (newAddress != null) {
            if (newAddress.getCleanseHash().isEmpty() && newAddress.getOverrideHash().isEmpty()) {
                stampsCleanseSuccess = false;
            }
            SubscriptionManager.getInstance().getStampsAccount().setAddress(newAddress.getAddress1());
            SubscriptionManager.getInstance().getStampsAccount().setCity(newAddress.getCity());
            SubscriptionManager.getInstance().getStampsAccount().setCountry(newAddress.getCountry());
            SubscriptionManager.getInstance().getStampsAccount().setName(newAddress.getFullName());
            SubscriptionManager.getInstance().getStampsAccount().setNumber(newAddress.getPhoneNumber());
            SubscriptionManager.getInstance().getStampsAccount().setState(newAddress.getState());
            SubscriptionManager.getInstance().getStampsAccount().setZip(newAddress.getZIPCode());
        } else {
            stampsCleanseSuccess = false;
        }
        if (!stampsCleanseSuccess) {
            this.pref.preValidate = true;
            this.pref.openTab(Preferences.Index.Companies);
            this.pref.preValidate = false;
        }
        return stampsCleanseSuccess;
    }
}

