/*
 * Decompiled with CFR 0.152.
 */
package pnp.services.preferencemanager;

import java.util.ArrayList;
import javax.swing.JOptionPane;
import pnp.services.authenticationmanager.SubscriptionManager;
import pnp.services.datatypes.webservices.Permissions;
import pnp.services.datatypes.webservices.SubscriptionTemp;
import pnp.services.preferencemanager.Preferences;
import pnp.services.preferencemanager.ifc.PreferenceExt;
import pnp.services.util.ErrorsUtil;
import pnp.services.util.LookupServicesUtil;

public class SubscriptionTab
extends PreferenceExt {
    public SubscriptionTab(Preferences pref) {
        super(pref);
    }

    @Override
    public void populate() {
        ArrayList<String> subscriptionList = new ArrayList<String>();
        if (SubscriptionManager.getInstance().getSubscription() != null) {
            for (Permissions newPermission : SubscriptionManager.getInstance().getSubscription().getPermissionsCollection()) {
                if (!newPermission.getEnabled().booleanValue()) continue;
                subscriptionList.add(newPermission.getDatatypeID().getName());
            }
        }
        this.pref.subList.setListData(subscriptionList.toArray(new String[0]));
        this.pref.subOfflineMode.setSelected(this._preferences.isSubOfflineMode());
        this.pref.subSaveCredentials.setSelected(this._preferences.isSubSaveCredentials());
        this.pref.subPassword.setText(this._preferences.getSubPassword());
        this.pref.subUsername.setText(this._preferences.getSubUsername());
    }

    @Override
    public boolean apply() {
        this.pref.subscriptionLoginSuccess = this.pref.ebayStatus.getText().equalsIgnoreCase("Online") && this.pref.subUsername.getText().equalsIgnoreCase(this._preferences.getSubUsername()) && new String(this.pref.subPassword.getPassword()).equalsIgnoreCase(this._preferences.getSubPassword()) && !this.pref.subOfflineMode.isSelected();
        this._preferences.setSubOfflineMode(this.pref.subOfflineMode.isSelected());
        this._preferences.setSubSaveCredentials(this.pref.subSaveCredentials.isSelected());
        this._preferences.setSubPassword(new String(this.pref.subPassword.getPassword()));
        this._preferences.setSubUsername(this.pref.subUsername.getText());
        if (!this.pref.subscriptionLoginSuccess) {
            SubscriptionManager.getInstance().reset();
            this.pref.subscriptionLoginSuccess = this.subLogin();
        }
        if (!this.pref.subscriptionLoginSuccess) {
            SubscriptionManager.getInstance().reset();
            this.pref.subList.setListData(new String[0]);
        }
        if (!this.pref.subSaveCredentials.isSelected()) {
            this.clear();
        }
        return this.pref.subscriptionLoginSuccess;
    }

    @Override
    public void clear() {
        this.pref.subPassword.setBackground(GOOD);
        this.pref.subUsername.setBackground(GOOD);
        this.pref.subPassword.setText("");
        this.pref.subUsername.setText("");
    }

    public void subRegisterAction() {
        super.openWebsiteAction("http://www.handsupsolutions.com/gamut/register");
    }

    public boolean subLogin() {
        boolean loggedIn = false;
        this.pref.ebayStatus.setBackground(BAD);
        this.pref.paypalStatus.setBackground(BAD);
        this.pref.subStatus.setBackground(BAD);
        this.pref.ebayStatus.setText("Offline");
        this.pref.paypalStatus.setText("Offline");
        this.pref.subStatus.setText("Offline");
        SubscriptionManager.getInstance().setSubscription(null);
        if (!this.pref.subOfflineMode.isSelected()) {
            SubscriptionManager.getInstance().setUserName(this._preferences.getSubUsername());
            SubscriptionManager.getInstance().setPassword(this._preferences.getSubPassword());
            try {
                SubscriptionManager.getInstance().setSubscription((SubscriptionTemp)LookupServicesUtil.getAuthenticationManagerServices().communicate("validateSubscription", null, null, null));
                SubscriptionManager.getInstance().getRESTData();
                if (SubscriptionManager.getInstance().getSubscription() != null && SubscriptionManager.getInstance().getSubscription().getMessage() != null) {
                    this.pref.subMessage.setText(SubscriptionManager.getInstance().getSubscription().getMessage());
                } else {
                    this.pref.subMessage.setText("Could Not Validate");
                }
                this.pref.subLicense.setText("");
                if (SubscriptionManager.getInstance().getSubscription() != null && SubscriptionManager.getInstance().getLicense() != null && !SubscriptionManager.getInstance().getLicense().isEmpty() && SubscriptionManager.getInstance().isCurrent()) {
                    if (LookupServicesUtil.getDBServices().getLicense() == null || LookupServicesUtil.getDBServices().getLicense().isEmpty()) {
                        LookupServicesUtil.getDBServices().setLicense(SubscriptionManager.getInstance().getLicense());
                    }
                    if (SubscriptionManager.getInstance().getLicense().equalsIgnoreCase(LookupServicesUtil.getDBServices().getLicense())) {
                        loggedIn = true;
                        this.pref.subLicense.setText(SubscriptionManager.getInstance().getLicense());
                        this.pref.ebayStatus.setBackground(SUCCESS);
                        this.pref.paypalStatus.setBackground(SUCCESS);
                        this.pref.subStatus.setBackground(SUCCESS);
                        this.pref.ebayStatus.setText("Online");
                        this.pref.paypalStatus.setText("Online");
                        this.pref.subStatus.setText("Online");
                    } else {
                        SubscriptionManager.getInstance().setSubscription(null);
                        JOptionPane.showMessageDialog(null, "The license on your account does not match your database. Please contact support for more information.");
                    }
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return loggedIn;
    }
}

