/*
 * Decompiled with CFR 0.152.
 */
package pnp.services.preferencemanager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import pnp.services.datatypes.webservices.Website;
import pnp.services.preferencemanager.Preferences;
import pnp.services.preferencemanager.ifc.PreferenceExt;
import pnp.services.util.LookupServicesUtil;

public class WebsiteTab
extends PreferenceExt {
    private HashMap<String, Website> webHash;

    public HashMap<String, Website> getWebHash() {
        return this.webHash;
    }

    public WebsiteTab(Preferences pref) {
        super(pref);
    }

    @Override
    public void valueChanged() {
        if (!this.pref.webList.isSelectionEmpty()) {
            String websiteName = (String)this.pref.webList.getSelectedValue();
            Website website = this.webHash.get(websiteName);
            this.pref.webName.setText(website.getWebsiteName());
            this.pref.webURI.setText(website.getWebsiteURI());
            this.pref.webActive.setSelected(website.isWebsiteActive());
            this.pref.webName.setEditable(false);
            this.pref.webName.setBackground(null);
        }
    }

    @Override
    public void populate() {
        this.webHash = new HashMap();
        ArrayList<String> websiteList = new ArrayList<String>();
        for (Website website : LookupServicesUtil.getDBServices().getWebsites()) {
            this.webHash.put(website.getWebsiteName(), website);
            websiteList.add(website.getWebsiteName());
        }
        Collections.sort(websiteList);
        this.pref.webList.setListData(websiteList.toArray(new String[0]));
        this.clear();
    }

    @Override
    public void clear() {
        this.pref.webList.clearSelection();
        this.pref.webName.setEditable(true);
        this.pref.webName.setText("");
        this.pref.webURI.setText("");
        this.pref.webActive.setSelected(false);
    }

    @Override
    public boolean apply() {
        Website website = this.webHash.get(this.pref.webName.getText().trim());
        if (website == null) {
            website = new Website();
            website.setWebsiteName(this.pref.webName.getText().trim());
        }
        website.setWebsiteURI(this.pref.webURI.getText().trim());
        website.setWebsiteActive(this.pref.webActive.isSelected());
        LookupServicesUtil.getDBServices().updateWebsite(website);
        this.populate();
        return true;
    }

    public void focusHelper() {
        String websiteName;
        if (this.pref.webName.getText() != null && !this.pref.webName.getText().trim().isEmpty() && this.webHash.containsKey(websiteName = this.pref.webName.getText().trim())) {
            Website web = this.webHash.get(websiteName);
            this.pref.webName.setText(web.getWebsiteName());
            this.pref.webActive.setSelected(web.isWebsiteActive());
            this.pref.webURI.setText(web.getWebsiteURI());
            this.pref.webName.setEditable(false);
            this.pref.webName.setBackground(null);
        }
    }
}

