/*
 * Decompiled with CFR 0.152.
 */
package pnp.services.sqlconversion;

import java.io.File;
import java.io.FileWriter;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JOptionPane;
import pnp.services.database.DatabaseLoader;
import pnp.services.datatypes.AccountPreferences;
import pnp.services.datatypes.Category;
import pnp.services.datatypes.CheckDetails;
import pnp.services.datatypes.CompanyInfo;
import pnp.services.datatypes.CompanyLink;
import pnp.services.datatypes.CustomFee;
import pnp.services.datatypes.Customer;
import pnp.services.datatypes.Distributor;
import pnp.services.datatypes.EbayTransactions;
import pnp.services.datatypes.Expense;
import pnp.services.datatypes.ExpenseReason;
import pnp.services.datatypes.InventoryElement;
import pnp.services.datatypes.Item;
import pnp.services.datatypes.License;
import pnp.services.datatypes.Order;
import pnp.services.datatypes.OrderDetails;
import pnp.services.datatypes.OrderStatus;
import pnp.services.datatypes.PaypalDetails;
import pnp.services.datatypes.PreferencePayPalAccount;
import pnp.services.datatypes.PrintDetails;
import pnp.services.datatypes.Profile;
import pnp.services.datatypes.RESTData;
import pnp.services.datatypes.RMADetails;
import pnp.services.datatypes.RMAReason;
import pnp.services.datatypes.RMAStatus;
import pnp.services.datatypes.SalesTax;
import pnp.services.datatypes.ShippingMethod;
import pnp.services.datatypes.webservices.Amazonaccount;
import pnp.services.datatypes.webservices.Ebayaccount;
import pnp.services.datatypes.webservices.Paypalaccount;
import pnp.services.datatypes.webservices.Website;
import pnp.services.datatypes.webservices.WebsiteCategories;
import pnp.services.datatypes.webservices.WebsiteElement;
import pnp.services.localsettings.LocalSettings;
import pnp.services.sqlconversion.InsertIntoSQL;
import pnp.services.sqlconversion.SQLLoader;
import pnp.services.util.DatabaseConnector;
import pnp.services.util.ErrorsUtil;

public class CollectFromDatabase {
    public static boolean inProgress = false;
    private static String baseDir;
    private int totalProgress;
    private int currentProgress;
    private static boolean conversionSuccessful;
    private static String progressString;
    private static int percentageComplete;
    private HashMap<String, InventoryElement> itemsToBeAdded;
    private HashMap<String, Expense> expenseToBeAdded;
    private Connection archiveConnection;
    private Connection newConnection;
    private Connection h2ArchiveConnection;
    private HashMap<Integer, String> orderMapping;
    private HashSet<String> orderToCustomerMapping;
    private static final String doubleSlash = "\\";
    private static final String carriageReturn = "\r\n";

    private void announceProgress(String opener, int max) {
        this.totalProgress = max;
        this.currentProgress = 0;
    }

    private void denounceProgress() {
        this.totalProgress = 0;
        this.currentProgress = 0;
    }

    private void updateProgress(String tableName) {
        ++this.currentProgress;
        if (this.totalProgress == 0) {
            this.currentProgress = 1;
            this.totalProgress = 1;
        }
        double progressUpdate = (double)this.currentProgress / (double)this.totalProgress;
        percentageComplete = (int)(progressUpdate * 100.0);
        progressString = "Table: " + tableName + " - " + this.currentProgress + " / " + this.totalProgress;
    }

    private void doInventory() {
        try {
            this.itemsToBeAdded = new HashMap();
            ResultSet oldDB = this.collectResults(this.newConnection.createStatement(), "Inventory");
            while (oldDB != null && !oldDB.isClosed() && oldDB.next()) {
                InventoryElement element = new InventoryElement();
                String ID = this.getInventory(oldDB, element);
                if (this.itemsToBeAdded.containsKey(ID)) continue;
                this.itemsToBeAdded.put(ID, element);
            }
            ResultSet currDB = this.collectResults(this.h2ArchiveConnection.createStatement(), "Inventory");
            while (currDB != null && !currDB.isClosed() && currDB.next()) {
                InventoryElement element = new InventoryElement();
                String ID = this.getInventory(currDB, element);
                if (!this.itemsToBeAdded.containsKey(ID)) {
                    this.itemsToBeAdded.put(ID, element);
                    continue;
                }
                InventoryElement currElement = this.itemsToBeAdded.get(ID);
                if (!currElement.getItemID().equalsIgnoreCase(element.getItemID())) continue;
                currElement.setItemQuantity(element.getItemQuantity());
                this.itemsToBeAdded.put(ID, currElement);
            }
            if (this.itemsToBeAdded != null && !this.itemsToBeAdded.isEmpty()) {
                Statement stmt = this.h2ArchiveConnection.createStatement();
                stmt.executeUpdate("TRUNCATE TABLE Inventory");
                DatabaseConnector.removeObject(stmt);
                for (InventoryElement element : this.itemsToBeAdded.values()) {
                    this.doInsert(this.h2ArchiveConnection, "Inventory", element);
                }
            }
            DatabaseConnector.removeObject(oldDB);
            DatabaseConnector.removeObject(currDB);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private void doExpenses() {
        try {
            this.expenseToBeAdded = new HashMap();
            ResultSet oldDB = this.collectResults(this.newConnection.createStatement(), "Expenses");
            while (oldDB != null && !oldDB.isClosed() && oldDB.next()) {
                Expense element = new Expense();
                String ID = this.getExpenses(oldDB, element);
                if (this.expenseToBeAdded.containsKey(ID)) continue;
                this.expenseToBeAdded.put(ID, element);
            }
            ResultSet currDB = this.collectResults(this.h2ArchiveConnection.createStatement(), "Expenses");
            while (currDB != null && !currDB.isClosed() && currDB.next()) {
                Expense element = new Expense();
                String ID = this.getExpenses(currDB, element);
                if (this.expenseToBeAdded.containsKey(ID)) continue;
                this.expenseToBeAdded.put(ID, element);
            }
            if (this.expenseToBeAdded != null && !this.expenseToBeAdded.isEmpty()) {
                Statement stmt = this.h2ArchiveConnection.createStatement();
                stmt.executeUpdate("TRUNCATE TABLE Expenses");
                DatabaseConnector.removeObject(stmt);
                for (Expense element : this.expenseToBeAdded.values()) {
                    this.doInsert(this.h2ArchiveConnection, "Expenses", element);
                }
            }
            DatabaseConnector.removeObject(oldDB);
            DatabaseConnector.removeObject(currDB);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    public void fixInventoryAndExpenses() {
        try {
            this.newConnection = DatabaseConnector.getH2Connection("Test", "", "");
            this.h2ArchiveConnection = DatabaseConnector.getH2Connection();
            this.newConnection.setAutoCommit(true);
            this.h2ArchiveConnection.setAutoCommit(true);
            this.doInventory();
            this.doExpenses();
            this.h2ArchiveConnection.close();
            this.newConnection.close();
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    public static Connection getMYSQLConnection() {
        Connection sqlConnection = null;
        try {
            sqlConnection = DriverManager.getConnection("jdbc:mysql://" + LocalSettings.getInstance().getPropertyValue("SQLServer") + "/" + LocalSettings.getInstance().getPropertyValue("SQLDB") + "?dontTrackOpenResources=true", LocalSettings.getInstance().getPropertyValue("SQLUser"), LocalSettings.getInstance().getPropertyValue("SQL"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sqlConnection;
    }

    public boolean doArchive(Date dateSelected) {
        if (dateSelected != null) {
            this.orderMapping = new HashMap();
            this.orderToCustomerMapping = new HashSet();
            DatabaseLoader.createArchiveDatabases();
            this.archiveConnection = DatabaseConnector.getH2Connection("ArchiveDB");
            this.newConnection = DatabaseConnector.getH2Connection("NewDB");
            this.h2ArchiveConnection = DatabaseConnector.getH2Connection();
            if (this.archiveConnection != null && this.newConnection != null && this.h2ArchiveConnection != null) {
                try {
                    this.archiveConnection.setAutoCommit(true);
                    this.newConnection.setAutoCommit(true);
                    this.h2ArchiveConnection.setAutoCommit(true);
                    this.collectAll(this.h2ArchiveConnection, this.newConnection, true, dateSelected);
                }
                catch (Exception ex) {
                    ErrorsUtil.getInstance().logError(ex);
                    return false;
                }
            } else {
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean doConvert(boolean convertAll, String userName, String password, String serverName, String databaseName) {
        conversionSuccessful = false;
        inProgress = true;
        Connection sqlConnection = this.createMYSQLDatabase(userName, password, serverName, databaseName, convertAll);
        if (sqlConnection != null) {
            Connection h2Connection = DatabaseConnector.getH2Connection();
            if (h2Connection != null) {
                try {
                    sqlConnection.setAutoCommit(true);
                    h2Connection.setAutoCommit(true);
                    this.collectAll(h2Connection, sqlConnection, convertAll, null);
                    conversionSuccessful = true;
                }
                catch (Exception ex) {
                    ErrorsUtil.getInstance().logError(ex);
                    String logText = "ERROR\r\nGeneral\r\n" + ex.getMessage();
                    this.appendFileSpace(this.createFileSpace(baseDir + "General Run Log", "txt"), logText);
                }
                try {
                    if (sqlConnection != null && !sqlConnection.isClosed()) {
                        sqlConnection.close();
                    }
                }
                catch (Exception ex) {
                    ErrorsUtil.getInstance().logError(ex);
                }
                try {
                    if (h2Connection != null && !h2Connection.isClosed()) {
                        h2Connection.close();
                    }
                }
                catch (Exception ex) {
                    ErrorsUtil.getInstance().logError(ex);
                }
            } else {
                JOptionPane.showMessageDialog(null, "Could not connect to H2 database. Please validate your directory with the one referenced below:\n" + LocalSettings.DIRECTORY + LocalSettings.getInstance().getPropertyValue("database"));
            }
        }
        inProgress = false;
        return conversionSuccessful;
    }

    public static String getProgressString() {
        return progressString;
    }

    public static int getPercentageComplete() {
        return percentageComplete;
    }

    public CollectFromDatabase() {
        baseDir = this.getBaseDirectory() + doubleSlash + "SQL Conversion Logs" + doubleSlash + this.getYear() + doubleSlash + this.getMonthAndDay() + doubleSlash;
    }

    private File createFileSpace(String filePath, String fileType, boolean looped) {
        File targetFile = null;
        int number = 0;
        do {
            String newFilePath = number == 0 ? filePath : filePath + "-" + number;
            targetFile = this.createFileSpace(newFilePath, fileType);
            ++number;
        } while (targetFile == null || targetFile.exists());
        return targetFile;
    }

    private File createFileSpace(String filePath, String fileType) {
        File targetFile = new File(filePath + "." + fileType);
        File parent = targetFile.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            System.out.println("Could not create.");
        }
        return targetFile;
    }

    private String getBaseDirectory() {
        return System.getProperty("user.dir");
    }

    private String getYear() {
        java.util.Date today = new java.util.Date();
        SimpleDateFormat yearFormat = new SimpleDateFormat("YYYY");
        String year = yearFormat.format(today);
        return year;
    }

    private String getMonthAndDay() {
        java.util.Date today = new java.util.Date();
        SimpleDateFormat subFolderFormat = new SimpleDateFormat("MM-dd");
        String monthDay = subFolderFormat.format(today);
        return monthDay;
    }

    private void writeIndividualErrorLog(String table, Object item) {
        String individualFolder = "Specific ";
        if (table.equalsIgnoreCase("Items")) {
            Item specificItem = (Item)item;
            String individualFilePath = baseDir + individualFolder + table + doubleSlash + specificItem.getItemID();
            File targetFile = this.createFileSpace(individualFilePath, "txt", true);
            this.writeFileSpace(targetFile, "Specific Item Details:\r\nItem ID: " + specificItem.getItemID() + carriageReturn + "Item Name: " + specificItem.getItemName() + carriageReturn + "Item Location: " + specificItem.getLocation() + carriageReturn + "Item Description: " + specificItem.getItemDescription() + carriageReturn + "Item DistributorID " + specificItem.getDistributorID() + carriageReturn + "Item DistributorProductID: " + specificItem.getDistributorProductID() + carriageReturn + "Item Weight: " + specificItem.getItemWeight() + carriageReturn + "Item PackedWeight: " + specificItem.getPackedWeight() + carriageReturn + "Item Discontinued: " + specificItem.isDiscontinued() + carriageReturn + "Item Dropshipped: " + specificItem.isDropShipped() + carriageReturn);
        } else if (table.equalsIgnoreCase("Customers")) {
            Customer specificItem = (Customer)item;
            String fileName = specificItem.getCustomerUserName();
            if (fileName.contains("*")) {
                fileName = specificItem.getCustomerName();
            }
            String individualFilePath = baseDir + individualFolder + table + doubleSlash + fileName;
            File targetFile = this.createFileSpace(individualFilePath, "txt", true);
            this.writeFileSpace(targetFile, "Specific Customer Details:\r\nCustomer User Name: " + specificItem.getCustomerUserName() + carriageReturn + "Customer Name: " + specificItem.getCustomerName() + carriageReturn + "Customer Email: " + specificItem.getCustomerEmail() + carriageReturn + "Customer Address: " + specificItem.getCustomerAddress() + carriageReturn + "Customer City " + specificItem.getCustomerCity() + carriageReturn + "Customer Country: " + specificItem.getCustomerCountry() + carriageReturn + "Customer State: " + specificItem.getCustomerState() + carriageReturn + "Customer Zip Code: " + specificItem.getCustomerZipcode() + carriageReturn + "Customer Comments: " + specificItem.getCustomerComments() + carriageReturn);
        }
    }

    private String insertGenericItems(Connection sqlConnection, String table, Object item, Date selectedDate) {
        String errorText = "";
        try {
            if (selectedDate != null) {
                boolean useArchiveDB = false;
                boolean specialCategory = false;
                boolean duplicateCustomer = false;
                if (table.equalsIgnoreCase("Orders")) {
                    Order newOrder = (Order)item;
                    useArchiveDB = newOrder.getOrderDate().before(selectedDate);
                    if (useArchiveDB) {
                        this.orderMapping.put(newOrder.getOrderID(), newOrder.getCustomerUserName());
                    } else {
                        this.orderToCustomerMapping.add(newOrder.getCustomerUserName());
                    }
                    specialCategory = true;
                } else if (table.equalsIgnoreCase("Customers")) {
                    Customer newCustomer = (Customer)item;
                    useArchiveDB = newCustomer.getCustomerComments().isEmpty() && !this.orderToCustomerMapping.contains(newCustomer.getCustomerUserName());
                    duplicateCustomer = this.orderMapping.containsValue(newCustomer.getCustomerUserName());
                    specialCategory = true;
                } else if (table.equalsIgnoreCase("OrderDetails")) {
                    OrderDetails newOrderDetails = (OrderDetails)item;
                    useArchiveDB = this.orderMapping.containsKey(newOrderDetails.getOrderID());
                    specialCategory = true;
                }
                if (useArchiveDB) {
                    this.doInsert(this.archiveConnection, table, item);
                } else {
                    this.doInsert(this.newConnection, table, item);
                    if (!specialCategory || duplicateCustomer) {
                        this.doInsert(this.archiveConnection, table, item);
                    }
                }
            } else {
                this.doInsert(sqlConnection, table, item);
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
            this.writeIndividualErrorLog(table, item);
            errorText = ex.getMessage() + carriageReturn;
        }
        return errorText;
    }

    private void doTruncateTable(boolean wasFailure, boolean wasWarning, boolean convertAll, Connection sqlConnection, String table) {
        if (!convertAll && (wasWarning || wasFailure)) {
            Statement stmt = null;
            try {
                stmt = sqlConnection.createStatement();
                stmt.executeUpdate("TRUNCATE TABLE " + table);
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
            DatabaseConnector.removeObject(stmt);
        }
    }

    private void doGeneric(Connection h2Connection, Connection sqlConnection, String table, boolean convertAll, Date dateSelected) {
        String tableValue = LocalSettings.getInstance().getPropertyValue(table);
        if (tableValue == null || tableValue.trim().isEmpty()) {
            tableValue = "FAILURE";
        }
        boolean wasSuccess = tableValue.equalsIgnoreCase("SUCCESS");
        boolean wasWarning = tableValue.equalsIgnoreCase("WARNING");
        boolean wasFailure = tableValue.equalsIgnoreCase("FAILURE");
        if (!convertAll && (wasFailure || wasWarning) || convertAll) {
            this.doTruncateTable(wasFailure, wasWarning, convertAll, sqlConnection, table);
            this.announceProgress("Beginning collection from " + table, 100);
            this.collectGeneric(h2Connection, sqlConnection, table, dateSelected);
            this.denounceProgress();
        }
    }

    private ResultSet collectResults(Statement stmt, String table) throws Exception {
        String sql = "SELECT * FROM " + table;
        return DatabaseConnector.createStatementResultSet(stmt, sql, "collectResults");
    }

    private String prepareString(String word) {
        String preparedString = "";
        try {
            if (word == null) {
                word = "";
            }
            preparedString = word.trim();
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
            String logText = "ERROR\r\nString Error???\r\n" + ex.getMessage();
            this.appendFileSpace(this.createFileSpace(baseDir + "General Run Log", "txt"), logText);
        }
        return preparedString;
    }

    private Connection createMYSQLDatabase(String userName, String password, String serverName, String databaseName, boolean convertAll) {
        Connection databaseConnection = null;
        String errorMessage = "";
        userName = this.prepareString(userName);
        password = this.prepareString(password);
        databaseName = this.prepareString(databaseName);
        if (!(userName.isEmpty() || password.isEmpty() || databaseName.isEmpty())) {
            try {
                databaseConnection = DriverManager.getConnection("jdbc:mysql://" + serverName + "/", userName, password);
                Statement stmt = databaseConnection.createStatement();
                if (convertAll) {
                    try {
                        stmt.executeUpdate("DROP DATABASE " + databaseName);
                    }
                    catch (Exception ex) {
                        ErrorsUtil.getInstance().logError(ex);
                    }
                }
                stmt.executeUpdate("CREATE DATABASE " + databaseName);
                DatabaseConnector.removeObject(stmt);
                databaseConnection = DriverManager.getConnection("jdbc:mysql://" + serverName + "/" + databaseName, userName, password);
                SQLLoader.loadDatabase(databaseConnection);
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
                String receivedError = ex.getMessage();
                if (receivedError.contains("Communications link failure")) {
                    errorMessage = "Could not connect to the MYSQL server on localhost. Make sure XAMPP is running before trying again.";
                } else if (receivedError.contains("Access denied for user")) {
                    errorMessage = "Your User Name or Password was not valid when attempting connection to your MYSQL server.\nPlease validate your credentials and try again.";
                } else if (!receivedError.contains("Can't create database")) {
                    errorMessage = "This is an unexpected error, please forward this error to an admin if error persists: \n" + ex.getMessage();
                }
                String logText = "ERROR\r\nOpening MYSQL Connection\r\n" + ex.getMessage();
                this.appendFileSpace(this.createFileSpace(baseDir + "General Run Log", "txt"), logText);
            }
        } else {
            errorMessage = errorMessage + "Invalid Credentials: \n";
            if (userName.isEmpty()) {
                errorMessage = errorMessage + "UserName was empty.\n";
            }
            if (password.isEmpty()) {
                errorMessage = errorMessage + "Password was empty.\n";
            }
            if (databaseName.isEmpty()) {
                errorMessage = errorMessage + "Database was empty.\n";
            }
        }
        if (!errorMessage.isEmpty()) {
            JOptionPane.showMessageDialog(null, errorMessage);
        }
        return databaseConnection;
    }

    private void doInsert(Connection sqlConnection, String table, Object item) throws Exception {
        this.updateProgress(table);
        InsertIntoSQL sql = new InsertIntoSQL();
        if (table.equalsIgnoreCase("AccountPreferences")) {
            sql.insertAccountPreferences((AccountPreferences)item, sqlConnection, table);
        } else if (table.equalsIgnoreCase("AmazonAccount")) {
            sql.insertAmazonAccount((Amazonaccount)item, sqlConnection, table);
        } else if (table.equalsIgnoreCase("Categories")) {
            sql.insertCategories((Category)item, sqlConnection, table);
        } else if (table.equalsIgnoreCase("CheckDetails")) {
            sql.insertCheckDetails((CheckDetails)item, sqlConnection, table);
        } else if (table.equalsIgnoreCase("Companies")) {
            sql.insertCompanies((CompanyInfo)item, sqlConnection, table);
        } else if (table.equalsIgnoreCase("Customers")) {
            sql.insertCustomers((Customer)item, sqlConnection, table);
        } else if (table.equalsIgnoreCase("CustomFees")) {
            sql.insertCustomFees((CustomFee)item, sqlConnection, table);
        } else if (table.equalsIgnoreCase("Distributors")) {
            sql.insertDistributors((Distributor)item, sqlConnection, table);
        } else if (table.equalsIgnoreCase("EbayAccount")) {
            sql.insertEbayAccount((Ebayaccount)item, sqlConnection, table);
        } else if (table.equalsIgnoreCase("EbayTransactions")) {
            sql.insertEbayTransactions((EbayTransactions)item, sqlConnection, table);
        } else if (table.equalsIgnoreCase("ExpenseReasons")) {
            sql.insertExpenseReasons((ExpenseReason)item, sqlConnection, table);
        } else if (table.equalsIgnoreCase("Expenses")) {
            sql.insertExpenses((Expense)item, sqlConnection, table);
        } else if (table.equalsIgnoreCase("Inventory")) {
            sql.insertInventory((InventoryElement)item, sqlConnection, table);
        } else if (table.equalsIgnoreCase("Items")) {
            sql.insertItems((Item)item, sqlConnection, table);
        } else if (table.equalsIgnoreCase("License")) {
            sql.insertLicense((License)item, sqlConnection, table);
        } else if (table.equalsIgnoreCase("OrderDetails")) {
            sql.insertOrderDetails((OrderDetails)item, sqlConnection, table);
        } else if (table.equalsIgnoreCase("Orders")) {
            sql.insertOrders((Order)item, sqlConnection, table);
        } else if (table.equalsIgnoreCase("OrderStatus")) {
            sql.insertOrderStatus((OrderStatus)item, sqlConnection, table);
        } else if (table.equalsIgnoreCase("PaypalAccount")) {
            sql.insertPayPalAccount((Paypalaccount)item, sqlConnection, table);
        } else if (table.equalsIgnoreCase("PaypalTransactions")) {
            sql.insertPayPalTransactions((PaypalDetails)item, sqlConnection, table);
        } else if (table.equalsIgnoreCase("PrintDetails")) {
            sql.insertPrintDetails((PrintDetails)item, sqlConnection, table);
        } else if (table.equalsIgnoreCase("RMADetails")) {
            sql.insertRMADetails((RMADetails)item, sqlConnection, table);
        } else if (table.equalsIgnoreCase("RMAReason")) {
            sql.insertRMAReasons((RMAReason)item, sqlConnection, table);
        } else if (table.equalsIgnoreCase("RMAStatus")) {
            sql.insertRMAStatus((RMAStatus)item, sqlConnection, table);
        } else if (table.equalsIgnoreCase("SalesTax")) {
            sql.insertSalesTax((SalesTax)item, sqlConnection, table);
        } else if (table.equalsIgnoreCase("ShippingMethods")) {
            sql.insertShippingMethods((ShippingMethod)item, sqlConnection, table);
        } else if (table.equalsIgnoreCase("Subscription")) {
            sql.insertSubscription((RESTData)item, sqlConnection, table);
        } else if (table.equalsIgnoreCase("WebsiteCategories")) {
            sql.insertWebsiteCategories((WebsiteCategories)item, sqlConnection, table);
        } else if (table.equalsIgnoreCase("WebsiteProducts")) {
            sql.insertWebsiteProducts((WebsiteElement)item, sqlConnection, table);
        } else if (table.equalsIgnoreCase("Websites")) {
            sql.insertWebsites((Website)item, sqlConnection, table);
        } else if (table.equalsIgnoreCase("Profiles")) {
            sql.insertProfiles((Profile)item, sqlConnection, table);
        } else if (table.equalsIgnoreCase("PayPalAccounts")) {
            sql.insertPreferencePayPalAccounts((PreferencePayPalAccount)item, sqlConnection, table);
        } else if (table.equalsIgnoreCase("CompanyLinks")) {
            sql.insertCompanyLinks((CompanyLink)item, sqlConnection, table);
        }
    }

    private void appendFileSpace(File file, String text) {
        try {
            FileWriter writer = new FileWriter(file, true);
            writer.append(text + carriageReturn);
            writer.close();
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private void writeFileSpace(File file, String text) {
        try {
            FileWriter writer = new FileWriter(file);
            writer.write(text);
            writer.close();
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private void collectAll(Connection h2Connection, Connection sqlConnection, boolean convertAll, Date dateSelected) throws Exception {
        this.doGeneric(h2Connection, sqlConnection, "AccountPreferences", convertAll, dateSelected);
        this.doGeneric(h2Connection, sqlConnection, "AmazonAccount", convertAll, dateSelected);
        this.doGeneric(h2Connection, sqlConnection, "Categories", convertAll, dateSelected);
        this.doGeneric(h2Connection, sqlConnection, "Companies", convertAll, dateSelected);
        this.doGeneric(h2Connection, sqlConnection, "CustomFees", convertAll, dateSelected);
        this.doGeneric(h2Connection, sqlConnection, "Distributors", convertAll, dateSelected);
        this.doGeneric(h2Connection, sqlConnection, "EbayAccount", convertAll, dateSelected);
        this.doGeneric(h2Connection, sqlConnection, "ExpenseReasons", convertAll, dateSelected);
        this.doGeneric(h2Connection, sqlConnection, "Expenses", convertAll, dateSelected);
        this.doGeneric(h2Connection, sqlConnection, "Inventory", convertAll, dateSelected);
        this.doGeneric(h2Connection, sqlConnection, "Items", convertAll, dateSelected);
        this.doGeneric(h2Connection, sqlConnection, "License", convertAll, dateSelected);
        this.doGeneric(h2Connection, sqlConnection, "OrderStatus", convertAll, dateSelected);
        this.doGeneric(h2Connection, sqlConnection, "PaypalAccount", convertAll, dateSelected);
        this.doGeneric(h2Connection, sqlConnection, "PaypalTransactions", convertAll, dateSelected);
        this.doGeneric(h2Connection, sqlConnection, "PrintDetails", convertAll, dateSelected);
        this.doGeneric(h2Connection, sqlConnection, "RMADetails", convertAll, dateSelected);
        this.doGeneric(h2Connection, sqlConnection, "RMAReason", convertAll, dateSelected);
        this.doGeneric(h2Connection, sqlConnection, "RMAStatus", convertAll, dateSelected);
        this.doGeneric(h2Connection, sqlConnection, "SalesTax", convertAll, dateSelected);
        this.doGeneric(h2Connection, sqlConnection, "ShippingMethods", convertAll, dateSelected);
        this.doGeneric(h2Connection, sqlConnection, "Subscription", convertAll, dateSelected);
        this.doGeneric(h2Connection, sqlConnection, "WebsiteCategories", convertAll, dateSelected);
        this.doGeneric(h2Connection, sqlConnection, "WebsiteProducts", convertAll, dateSelected);
        this.doGeneric(h2Connection, sqlConnection, "Websites", convertAll, dateSelected);
        this.doGeneric(h2Connection, sqlConnection, "Profiles", convertAll, dateSelected);
        this.doGeneric(h2Connection, sqlConnection, "PayPalAccounts", convertAll, dateSelected);
        this.doGeneric(h2Connection, sqlConnection, "CompanyLinks", convertAll, dateSelected);
        this.doGeneric(h2Connection, sqlConnection, "Orders", convertAll, dateSelected);
        this.doGeneric(h2Connection, sqlConnection, "OrderDetails", convertAll, dateSelected);
        this.doGeneric(h2Connection, sqlConnection, "Customers", convertAll, dateSelected);
        this.doGeneric(h2Connection, sqlConnection, "EbayTransactions", convertAll, dateSelected);
        this.doGeneric(h2Connection, sqlConnection, "CheckDetails", convertAll, dateSelected);
    }

    private void collectGeneric(Connection h2Connection, Connection sqlConnection, String table, Date dateSelected) {
        String errorText;
        ResultSet rs;
        String logText;
        block8: {
            logText = "Begin collection and insert of table: " + table;
            this.appendFileSpace(this.createFileSpace(baseDir + "General Run Log", "txt"), logText);
            Statement stmt = null;
            rs = null;
            long currentTime = System.currentTimeMillis();
            errorText = "";
            int currentItem = 0;
            try {
                stmt = h2Connection.createStatement();
                rs = this.collectResults(stmt, table);
                if (rs == null) break block8;
                while (rs.next()) {
                    String idNumber = "";
                    Object specificItem = this.returnInstantiatedObject(rs, table);
                    try {
                        idNumber = this.genericCollect(rs, specificItem, table);
                    }
                    catch (Exception ex) {
                        ErrorsUtil.getInstance().logError(ex);
                        logText = "ERROR\r\n" + table + carriageReturn + ex.getMessage();
                        this.appendFileSpace(this.createFileSpace(baseDir + "General Run Log", "txt"), logText);
                    }
                    if (idNumber.isEmpty()) continue;
                    if (currentItem % 10000 == 0) {
                        logText = "Item Number: " + currentItem + " processed. Time elapsed: " + (System.currentTimeMillis() - currentTime) / 1000L + " seconds.";
                        this.appendFileSpace(this.createFileSpace(baseDir + "General Run Log", "txt"), logText);
                    }
                    errorText = errorText + this.insertGenericItems(sqlConnection, table, specificItem, dateSelected);
                    ++currentItem;
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
                logText = "ERROR\r\n" + table + carriageReturn + ex.getMessage();
                this.appendFileSpace(this.createFileSpace(baseDir + "General Run Log", "txt"), logText);
            }
        }
        DatabaseConnector.removeObject(rs);
        if (!errorText.isEmpty()) {
            String individualFilePath = baseDir + table;
            File targetFile = this.createFileSpace(individualFilePath, "txt", true);
            this.writeFileSpace(targetFile, "Error details for table: " + table + ": \n" + errorText);
            LocalSettings.getInstance().writeProperties(table, "WARNING");
        } else {
            LocalSettings.getInstance().writeProperties(table, "SUCCESS");
        }
        logText = "Finished collection and insert of table: " + table;
        this.appendFileSpace(this.createFileSpace(baseDir + "General Run Log", "txt"), logText);
    }

    private Object returnInstantiatedObject(ResultSet rs, String table) {
        Object listItem = new Object();
        if (table.equalsIgnoreCase("AccountPreferences")) {
            listItem = new AccountPreferences();
        } else if (table.equalsIgnoreCase("AmazonAccount")) {
            listItem = new Amazonaccount();
        } else if (table.equalsIgnoreCase("Categories")) {
            listItem = new Category();
        } else if (table.equalsIgnoreCase("CheckDetails")) {
            listItem = new CheckDetails();
        } else if (table.equalsIgnoreCase("Companies")) {
            listItem = new CompanyInfo();
        } else if (table.equalsIgnoreCase("Customers")) {
            listItem = new Customer();
        } else if (table.equalsIgnoreCase("CustomFees")) {
            listItem = new CustomFee();
        } else if (table.equalsIgnoreCase("Distributors")) {
            listItem = new Distributor();
        } else if (table.equalsIgnoreCase("EbayAccount")) {
            listItem = new Ebayaccount();
        } else if (table.equalsIgnoreCase("EbayTransactions")) {
            listItem = new EbayTransactions();
        } else if (table.equalsIgnoreCase("ExpenseReasons")) {
            listItem = new ExpenseReason();
        } else if (table.equalsIgnoreCase("Expenses")) {
            listItem = new Expense();
        } else if (table.equalsIgnoreCase("Inventory")) {
            listItem = new InventoryElement();
        } else if (table.equalsIgnoreCase("Items")) {
            listItem = new Item();
        } else if (table.equalsIgnoreCase("License")) {
            listItem = new License();
        } else if (table.equalsIgnoreCase("OrderDetails")) {
            listItem = new OrderDetails();
        } else if (table.equalsIgnoreCase("Orders")) {
            listItem = new Order();
        } else if (table.equalsIgnoreCase("OrderStatus")) {
            listItem = new OrderStatus();
        } else if (table.equalsIgnoreCase("PaypalAccount")) {
            listItem = new Paypalaccount();
        } else if (table.equalsIgnoreCase("PaypalTransactions")) {
            listItem = new PaypalDetails();
        } else if (table.equalsIgnoreCase("PrintDetails")) {
            listItem = new PrintDetails();
        } else if (table.equalsIgnoreCase("RMADetails")) {
            listItem = new RMADetails();
        } else if (table.equalsIgnoreCase("RMAReason")) {
            listItem = new RMAReason();
        } else if (table.equalsIgnoreCase("RMAStatus")) {
            listItem = new RMAStatus();
        } else if (table.equalsIgnoreCase("SalesTax")) {
            listItem = new SalesTax();
        } else if (table.equalsIgnoreCase("ShippingMethods")) {
            listItem = new ShippingMethod();
        } else if (table.equalsIgnoreCase("Subscription")) {
            listItem = new RESTData();
        } else if (table.equalsIgnoreCase("WebsiteCategories")) {
            listItem = new WebsiteCategories();
        } else if (table.equalsIgnoreCase("WebsiteProducts")) {
            listItem = new WebsiteElement();
        } else if (table.equalsIgnoreCase("Websites")) {
            listItem = new Website();
        } else if (table.equalsIgnoreCase("Profiles")) {
            listItem = new Profile();
        } else if (table.equalsIgnoreCase("PayPalAccounts")) {
            listItem = new PreferencePayPalAccount();
        } else if (table.equalsIgnoreCase("CompanyLinks")) {
            listItem = new CompanyLink();
        }
        return listItem;
    }

    private String genericCollect(ResultSet rs, Object listItem, String table) {
        String itemID = "";
        try {
            if (table.equalsIgnoreCase("AccountPreferences")) {
                itemID = this.getAccountPreferences(rs, (AccountPreferences)listItem);
            } else if (table.equalsIgnoreCase("AmazonAccount")) {
                itemID = this.getAmazonAccount(rs, (Amazonaccount)listItem);
            } else if (table.equalsIgnoreCase("Categories")) {
                itemID = this.getCategories(rs, (Category)listItem);
            } else if (table.equalsIgnoreCase("CheckDetails")) {
                itemID = this.getCheckDetails(rs, (CheckDetails)listItem);
            } else if (table.equalsIgnoreCase("Companies")) {
                itemID = this.getCompanies(rs, (CompanyInfo)listItem);
            } else if (table.equalsIgnoreCase("Customers")) {
                itemID = this.getCustomers(rs, (Customer)listItem);
            } else if (table.equalsIgnoreCase("CustomFees")) {
                itemID = this.getCustomFees(rs, (CustomFee)listItem);
            } else if (table.equalsIgnoreCase("Distributors")) {
                itemID = this.getDistributors(rs, (Distributor)listItem);
            } else if (table.equalsIgnoreCase("EbayAccount")) {
                itemID = this.getEbayAccount(rs, (Ebayaccount)listItem);
            } else if (table.equalsIgnoreCase("EbayTransactions")) {
                itemID = this.getEbayTransactions(rs, (EbayTransactions)listItem);
            } else if (table.equalsIgnoreCase("ExpenseReasons")) {
                itemID = this.getExpenseReasons(rs, (ExpenseReason)listItem);
            } else if (table.equalsIgnoreCase("Expenses")) {
                itemID = this.getExpenses(rs, (Expense)listItem);
            } else if (table.equalsIgnoreCase("Inventory")) {
                itemID = this.getInventory(rs, (InventoryElement)listItem);
            } else if (table.equalsIgnoreCase("Items")) {
                itemID = this.getItems(rs, (Item)listItem);
            } else if (table.equalsIgnoreCase("License")) {
                itemID = this.getLicense(rs, (License)listItem);
            } else if (table.equalsIgnoreCase("OrderDetails")) {
                itemID = this.getOrderDetails(rs, (OrderDetails)listItem);
            } else if (table.equalsIgnoreCase("Orders")) {
                itemID = this.getOrders(rs, (Order)listItem);
            } else if (table.equalsIgnoreCase("OrderStatus")) {
                itemID = this.getOrderStatus(rs, (OrderStatus)listItem);
            } else if (table.equalsIgnoreCase("PaypalAccount")) {
                itemID = this.getPaypalAccount(rs, (Paypalaccount)listItem);
            } else if (table.equalsIgnoreCase("PaypalTransactions")) {
                itemID = this.getPaypalTransactions(rs, (PaypalDetails)listItem);
            } else if (table.equalsIgnoreCase("PrintDetails")) {
                itemID = this.getPrintDetails(rs, (PrintDetails)listItem);
            } else if (table.equalsIgnoreCase("RMADetails")) {
                itemID = this.getRMADetails(rs, (RMADetails)listItem);
            } else if (table.equalsIgnoreCase("RMAReason")) {
                itemID = this.getRMAReason(rs, (RMAReason)listItem);
            } else if (table.equalsIgnoreCase("RMAStatus")) {
                itemID = this.getRMAStatus(rs, (RMAStatus)listItem);
            } else if (table.equalsIgnoreCase("SalesTax")) {
                itemID = this.getSalesTax(rs, (SalesTax)listItem);
            } else if (table.equalsIgnoreCase("ShippingMethods")) {
                itemID = this.getShippingMethods(rs, (ShippingMethod)listItem);
            } else if (table.equalsIgnoreCase("Subscription")) {
                itemID = this.getSubscription(rs, (RESTData)listItem);
            } else if (table.equalsIgnoreCase("WebsiteCategories")) {
                itemID = this.getWebsiteCategories(rs, (WebsiteCategories)listItem);
            } else if (table.equalsIgnoreCase("WebsiteProducts")) {
                itemID = this.getWebisteProducts(rs, (WebsiteElement)listItem);
            } else if (table.equalsIgnoreCase("Websites")) {
                itemID = this.getWebsites(rs, (Website)listItem);
            } else if (table.equalsIgnoreCase("Profiles")) {
                itemID = this.getProfiles(rs, (Profile)listItem);
            } else if (table.equalsIgnoreCase("PayPalAccounts")) {
                itemID = this.getPreferencePaypalAccounts(rs, (PreferencePayPalAccount)listItem);
            } else if (table.equalsIgnoreCase("CompanyLinks")) {
                itemID = this.getCompanyLinks(rs, (CompanyLink)listItem);
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
            String logText = "ERROR\r\n" + table + carriageReturn + ex.getMessage();
            this.appendFileSpace(this.createFileSpace(baseDir + "General Run Log", "txt"), logText);
        }
        return itemID;
    }

    private String getAccountPreferences(ResultSet rs, AccountPreferences preferences) throws Exception {
        String identifier = String.valueOf(rs.getString("GenProfile"));
        preferences.setGenProfile(rs.getString("GenProfile"));
        preferences.setGenNegativeNotification(rs.getBoolean("GenNegativeNotification"));
        preferences.setGenRefreshBehavior(rs.getBoolean("GenRefreshBehavior"));
        preferences.setGenSalesPeriod(rs.getInt("GenSalesPeriod"));
        preferences.setGenStockNotification(rs.getInt("GenStockNotification"));
        preferences.setGenTrackingNotify(rs.getBoolean("GenTrackingNotify"));
        preferences.setGenUnmergeNotify(rs.getBoolean("GenUnmergeNotify"));
        preferences.setGenBusinessName(rs.getString("GenBusinessName"));
        try {
            preferences.setGenInvoiceComments(rs.getString("GenInvoiceComments"));
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex, false);
        }
        preferences.setGenWebsiteAddress(rs.getString("GenWebsiteAddress"));
        preferences.setGenVersion(rs.getInt("GenVersion"));
        preferences.setGenSyncNotification(rs.getBoolean("GenSyncNotification"));
        preferences.setGenSplitRefresh(rs.getBoolean("GenSplitRefresh"));
        preferences.setGenInventoryRefresh(rs.getBoolean("GenInventoryRefresh"));
        preferences.setGenBetaUpdates(rs.getBoolean("GenBetaUpdates"));
        preferences.setSubOfflineMode(rs.getBoolean("SubOfflineMode"));
        preferences.setSubSaveCredentials(rs.getBoolean("SubSaveCredentials"));
        preferences.setSubLicense(rs.getString("SubLicense"));
        preferences.setSubPassword(rs.getString("SubPassword"));
        preferences.setSubUsername(rs.getString("SubUsername"));
        preferences.setEbayLastUpdate(rs.getLong("EbayLastUpdate"));
        preferences.setPaypalLastUpdate(rs.getLong("PaypalLastUpdate"));
        if (preferences.getEbayLastUpdate() != 0L && preferences.getPaypalLastUpdate() == 0L) {
            preferences.setPaypalLastUpdate(preferences.getEbayLastUpdate());
        }
        preferences.setPaypalAutoLink(rs.getBoolean("PaypalAutoLink"));
        preferences.setPaypalDomesticAddon(rs.getDouble("PaypalDomesticAddon"));
        preferences.setPaypalDomesticFee(rs.getDouble("PaypalDomesticFee"));
        preferences.setPaypalInternationalAddon(rs.getDouble("PaypalInternationalAddon"));
        preferences.setPaypalInternationalFee(rs.getDouble("PaypalInternationalFee"));
        preferences.setStampsSaveCredentials(rs.getBoolean("StampsSaveCredentials"));
        preferences.setStampsSignatureConfirm(rs.getBoolean("StampsSignatureConfirm"));
        preferences.setStampsAddress(rs.getString("StampsAddress"));
        preferences.setStampsCity(rs.getString("StampsCity"));
        preferences.setStampsCountry(rs.getString("StampsCountry"));
        preferences.setStampsFullName(rs.getString("StampsFullName"));
        preferences.setStampsImageLocation(rs.getString("StampsImageLocation"));
        preferences.setStampsPassword(rs.getString("StampsPassword"));
        preferences.setStampsPhoneNumber(rs.getString("StampsPhoneNumber"));
        preferences.setStampsPostalCode(rs.getString("StampsPostalCode"));
        preferences.setStampsState(rs.getString("StampsState"));
        preferences.setStampsUsername(rs.getString("StampsUsername"));
        preferences.setStampsLabelStatus(rs.getString("StampsLabelStatus"));
        preferences.setStampsPrintLabels(rs.getBoolean("StampsPrintLabels"));
        preferences.setStampsPurchaseLabels(rs.getBoolean("StampsPurchaseLabels"));
        preferences.setStampsSaveLabels(rs.getBoolean("StampsSaveLabels"));
        preferences.setStampsTracking(rs.getBoolean("StampsTracking"));
        preferences.setStampsPrintOptions(rs.getString("StampsPrintOptions"));
        preferences.setStampsPageOptions(rs.getString("StampsPageOptions"));
        preferences.setStampsHideNotification(rs.getBoolean("StampsHideNotification"));
        preferences.setStampsStorageDays(rs.getInt("StampsStorageDays"));
        preferences.setStampsDateNotification(rs.getBoolean("StampsDateNotification"));
        preferences.setStampsPackedWeight(rs.getBoolean("StampsPackedWeight"));
        preferences.setStampsAutoPurchase(rs.getBoolean("StampsAutoPurchase"));
        preferences.setStampsAutoPurchaseLimit(rs.getFloat("StampsAutoPurchaseLimit"));
        preferences.setStampsAutoPurchaseWarning(rs.getBoolean("StampsAutoPurchaseWarning"));
        preferences.setStampsInvalidPackageNotification(rs.getBoolean("StampsInvalidPackageNotification"));
        preferences.setStampsPurchaseDateNotification(rs.getBoolean("StampsPurchaseDateNotification"));
        preferences.setStampsComments(rs.getBoolean("StampsComments"));
        preferences.setStampsMixedInventoryNotification(rs.getBoolean("StampsMixedInventoryNotification"));
        preferences.setStampsNIAFilter(rs.getBoolean("StampsNIAFilter"));
        preferences.setStampsAccount(rs.getString("StampsAccount"));
        preferences.setStampsEndiciaUserName(rs.getString("StampsEndiciaUsername"));
        preferences.setStampsEndiciaPassword(rs.getString("StampsEndiciaPassword"));
        preferences.setStampsCommercialPlus(rs.getBoolean("StampsCommercialPlus"));
        preferences.setStampsUPSUserName(rs.getString("StampsUPSUsername"));
        preferences.setStampsUPSPassword(rs.getString("StampsUPSPassword"));
        preferences.setStampsUPSAccessKey(rs.getString("StampsUPSAccessKey"));
        preferences.setStampsUPSAccountNumber(rs.getString("StampsUPSAccountNumber"));
        preferences.setCompanyDefaultCompany(rs.getString("CompanyDefaultCompany"));
        return identifier;
    }

    private String getAmazonAccount(ResultSet rs, Amazonaccount amazonaccount) throws Exception {
        String identifier = String.valueOf(rs.getString("AmazonAccountNumber"));
        amazonaccount.setAmazonAccountID(rs.getString("AmazonAccountID"));
        amazonaccount.setAmazonAccountNumber(rs.getInt("AmazonAccountNumber"));
        try {
            amazonaccount.setUserToken(rs.getString("UserToken"));
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex, false);
        }
        amazonaccount.setUserName(rs.getString("UserName"));
        return identifier;
    }

    private String getCategories(ResultSet rs, Category category) throws Exception {
        String identifier = String.valueOf(rs.getInt("CategoryID"));
        category.setCategoryID(rs.getInt("CategoryID"));
        category.setCategoryName(rs.getString("CategoryName"));
        return identifier;
    }

    private String getCheckDetails(ResultSet rs, CheckDetails checkDetails) throws Exception {
        String identifier = String.valueOf(rs.getInt("CheckID"));
        checkDetails.setCheckID(rs.getInt("CheckID"));
        checkDetails.setOrderDetailsID(rs.getInt("OrderDetailsID"));
        checkDetails.setOrderID(rs.getString("OrderID"));
        checkDetails.setPackedWeight(rs.getFloat("PackedWeight"));
        checkDetails.setPaypalAccount(rs.getString("PaypalAccount"));
        checkDetails.setWeight(rs.getFloat("Weight"));
        return identifier;
    }

    private String getCompanies(ResultSet rs, CompanyInfo companyInfo) throws Exception {
        String identifier = String.valueOf(rs.getString("CompanyName"));
        companyInfo.setCompanyAddress(rs.getString("CompanyAddress"));
        companyInfo.setCompanyCity(rs.getString("CompanyCity"));
        companyInfo.setCompanyComments(rs.getString("CompanyComments"));
        companyInfo.setCompanyCountry(rs.getString("CompanyCountry"));
        companyInfo.setCompanyFullName(rs.getString("CompanyFullName"));
        companyInfo.setCompanyName(rs.getString("CompanyName"));
        companyInfo.setCompanyPhoneNumber(rs.getString("CompanyPhoneNumber"));
        companyInfo.setCompanyPostalCode(rs.getString("CompanyPostalCode"));
        companyInfo.setCompanyState(rs.getString("CompanyState"));
        companyInfo.setCompanyWebsite(rs.getString("CompanyWebsite"));
        return identifier;
    }

    private String getCustomers(ResultSet rs, Customer customer) throws Exception {
        String identifier = String.valueOf(rs.getString("CustomerUserName"));
        customer.setCustomerAddress(rs.getString("CustomerAddress"));
        customer.setCustomerCity(rs.getString("CustomerCity"));
        customer.setCustomerComments(rs.getString("CustomerComments"));
        try {
            customer.setCustomerComments(rs.getString("CustomerComments"));
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex, false);
        }
        customer.setCustomerCountry(rs.getString("CustomerCountry"));
        customer.setCustomerEmail(rs.getString("CustomerEmail"));
        customer.setCustomerName(rs.getString("CustomerName"));
        customer.setCustomerState(rs.getString("CustomerState"));
        customer.setCustomerUserName(rs.getString("CustomerUserName"));
        customer.setCustomerZipcode(rs.getString("CustomerZipCode"));
        return identifier;
    }

    private String getCustomFees(ResultSet rs, CustomFee customFee) throws Exception {
        String identifier = String.valueOf(rs.getInt("CustomFeeID"));
        customFee.setCustomFeeID(rs.getInt("CustomFeeID"));
        customFee.setFeeFlatCost(rs.getDouble("CustomFeeFlatCost"));
        customFee.setFeeName(rs.getString("CustomFeeName"));
        customFee.setFeePercentage(rs.getDouble("CustomFeePercentage"));
        return identifier;
    }

    private String getDistributors(ResultSet rs, Distributor distributor) throws Exception {
        String identifier = String.valueOf(rs.getInt("DistributorID"));
        distributor.setDistributorContact(rs.getString("DistributorContact"));
        distributor.setDistributorEmail(rs.getString("DistributorEmail"));
        distributor.setDistributorID(rs.getInt("DistributorID"));
        distributor.setDistributorName(rs.getString("DistributorName"));
        distributor.setDistributorPhone(rs.getString("DistributorPhone"));
        distributor.setDistributorWebsite(rs.getString("DistributorWebsite"));
        return identifier;
    }

    private String getEbayAccount(ResultSet rs, Ebayaccount ebayaccount) throws Exception {
        String identifier = String.valueOf(rs.getInt("EbayAccountNumber"));
        ebayaccount.setUserName(rs.getString("UserName"));
        ebayaccount.setEbayAccountID(rs.getString("EbayAccountID"));
        ebayaccount.setEbayAccountNumber(rs.getInt("EbayAccountNumber"));
        try {
            ebayaccount.setUserToken(rs.getString("UserToken"));
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex, false);
        }
        return identifier;
    }

    private String getEbayTransactions(ResultSet rs, EbayTransactions ebayTransactions) throws Exception {
        String identifier = String.valueOf(rs.getString("EbayTransactionID"));
        ebayTransactions.setAuctionName(rs.getString("AuctionName"));
        ebayTransactions.setCost(Float.valueOf(rs.getFloat("Cost")));
        ebayTransactions.setEbayTransactionID(rs.getString("EbayTransactionID"));
        ebayTransactions.setQuantity(rs.getInt("Quantity"));
        ebayTransactions.setReferenceNumber(rs.getString("ReferenceNumber"));
        ebayTransactions.setPaypalTransactionID(rs.getString("PayPalTransactionID"));
        return identifier;
    }

    private String getExpenseReasons(ResultSet rs, ExpenseReason expenseReason) throws Exception {
        String identifier = String.valueOf(rs.getInt("ExpenseReasonID"));
        expenseReason.setExpenseReasonID(rs.getInt("ExpenseReasonID"));
        expenseReason.setReason(rs.getString("Reason"));
        return identifier;
    }

    private String getExpenses(ResultSet rs, Expense expense) throws Exception {
        String identifier = String.valueOf(rs.getString("ExpenseID"));
        expense.setCompanyName(rs.getString("CompanyName"));
        expense.setExpenseComment(rs.getString("ExpenseComment"));
        expense.setExpenseCost(rs.getFloat("ExpenseCost"));
        expense.setExpenseDate(rs.getDate("ExpenseDate"));
        expense.setExpenseID(rs.getInt("ExpenseID"));
        expense.setExpenseReason(rs.getString("ExpenseReason"));
        expense.setExpenseReasonID(rs.getInt("ExpenseReasonID"));
        return identifier;
    }

    private String getInventory(ResultSet rs, InventoryElement inventoryElement) throws Exception {
        String identifier = String.valueOf(rs.getInt("InventoryID"));
        inventoryElement.setInventoryID(rs.getInt("InventoryID"));
        inventoryElement.setItemCost(rs.getFloat("ItemCost"));
        inventoryElement.setItemID(rs.getString("ItemID"));
        inventoryElement.setItemQuantity(rs.getInt("ItemQuantity"));
        inventoryElement.setOosItem(rs.getBoolean("OOSItem"));
        inventoryElement.setStockDate(rs.getDate("StockDate"));
        return identifier;
    }

    private String getItems(ResultSet rs, Item item) throws Exception {
        String identifier = String.valueOf(rs.getString("ItemID"));
        item.setDiscontinued(rs.getBoolean("Discontinued"));
        item.setDistributorID(rs.getInt("DistributorID"));
        item.setDistributorProductID(rs.getString("DistributorProductID"));
        item.setDropShipped(rs.getBoolean("DropShipped"));
        item.setItemDescription(rs.getString("ItemDescription"));
        item.setItemID(rs.getString("ItemID"));
        item.setItemName(rs.getString("ItemName"));
        item.setItemWeight(rs.getFloat("ItemWeight"));
        item.setLocation(rs.getString("Location"));
        item.setPackedWeight(rs.getFloat("PackedWeight"));
        return identifier;
    }

    private String getOrderDetails(ResultSet rs, OrderDetails orderDetails) throws Exception {
        String identifier = String.valueOf(rs.getInt("OrderDetailsID"));
        orderDetails.setItemID(rs.getString("ItemID"));
        orderDetails.setAccountName(rs.getString("AccountName"));
        orderDetails.setEbaySite(rs.getString("EbaySite"));
        orderDetails.setTrackingNumber(rs.getString("TrackingNumber"));
        orderDetails.setCarrier(rs.getString("Carrier"));
        orderDetails.setOrderDetailsID(rs.getInt("OrderDetailsID"));
        orderDetails.setOrderID(rs.getInt("OrderID"));
        orderDetails.setBackordered(rs.getBoolean("Backordered"));
        orderDetails.setOrderNumber(rs.getString("OrderNumber"));
        orderDetails.setSalesPrice(rs.getFloat("Salesprice"));
        orderDetails.setItemCost(rs.getFloat("ItemCost"));
        orderDetails.setTransactionID(rs.getString("TransactionID"));
        orderDetails.setInhouse(rs.getBoolean("Inhouse"));
        orderDetails.setOrderDescription(rs.getString("OrderDescription"));
        orderDetails.setEbayWeight(rs.getFloat("EbayWeight"));
        orderDetails.setDeleted(rs.getBoolean("Deleted"));
        Date date = rs.getDate("ShipDate");
        if (null != date) {
            orderDetails.setShipDate(date);
        }
        return identifier;
    }

    private String getOrders(ResultSet rs, Order order) throws Exception {
        String identifier = String.valueOf(rs.getInt("OrderID"));
        try {
            order.setOrderComments(rs.getString("OrderComments"));
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex, false);
        }
        order.setOrderDate(rs.getDate("OrderDate"));
        order.setOrderID(rs.getInt("OrderID"));
        order.setOrderStatusID(rs.getInt("OrderStatusID"));
        order.setOrderTotal(rs.getFloat("OrderTotal"));
        order.setShippingCost(rs.getFloat("ShippingCost"));
        order.setShippingMethodName(rs.getString("ShippingMethodID"));
        order.setShippingPaid(rs.getFloat("ShippingPaid"));
        order.setPaypalAccount(rs.getString("OrderPaypal"));
        order.setCustomerUserName(rs.getString("CustomerUserName"));
        return identifier;
    }

    private String getOrderStatus(ResultSet rs, OrderStatus orderStatus) throws Exception {
        String identifier = String.valueOf(rs.getInt("OrderStatusID"));
        orderStatus.setOrderStatusID(rs.getInt("OrderStatusID"));
        orderStatus.setOrderStatusType(rs.getString("OrderStatusType"));
        return identifier;
    }

    private String getPaypalAccount(ResultSet rs, Paypalaccount paypalaccount) throws Exception {
        String identifier = String.valueOf(rs.getInt("PaypalAccountNumber"));
        paypalaccount.setUserName(rs.getString("UserName"));
        paypalaccount.setPaypalAccountID(rs.getString("PaypalAccountID"));
        paypalaccount.setPaypalAccountNumber(rs.getInt("PaypalAccountNumber"));
        try {
            paypalaccount.setAccessToken(rs.getString("AccessToken"));
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex, false);
        }
        try {
            paypalaccount.setTokenSecret(rs.getString("TokenSecret"));
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex, false);
        }
        return identifier;
    }

    private String getPaypalTransactions(ResultSet rs, PaypalDetails paypalDetails) throws Exception {
        String identifier = String.valueOf(rs.getString("PaypalTransactionID"));
        paypalDetails.setPaypalTransactionID(rs.getString("PaypalTransactionID"));
        paypalDetails.setEmail(rs.getString("EmailAddress"));
        paypalDetails.setFirstName(rs.getString("FirstName"));
        paypalDetails.setLastName(rs.getString("LastName"));
        paypalDetails.setCountryCode(rs.getString("CountryCode"));
        paypalDetails.setCountryName(rs.getString("CountryName"));
        paypalDetails.setStreet1(rs.getString("Street1"));
        paypalDetails.setStreet2(rs.getString("Street2"));
        paypalDetails.setCityName(rs.getString("CityName"));
        paypalDetails.setStateOrProvince(rs.getString("StateOrProvince"));
        paypalDetails.setPostalCode(rs.getString("PostalCode"));
        paypalDetails.setTransactionType(rs.getString("TransactionType"));
        paypalDetails.setPaymentType(rs.getString("PaymentType"));
        paypalDetails.setPaymentDate(rs.getString("PaymentDate"));
        paypalDetails.setGrossAmount(Float.valueOf(rs.getFloat("GrossAmount")));
        paypalDetails.setPaymentStatus(rs.getString("PaymentStatus"));
        paypalDetails.setShippingMethod(rs.getString("ShippingMethod"));
        paypalDetails.setCustom(rs.getString("Custom"));
        try {
            paypalDetails.setMemo(rs.getString("Memo"));
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex, false);
        }
        paypalDetails.setBuyerID(rs.getString("BuyerID"));
        paypalDetails.setClosingDate(rs.getString("ClosingDate"));
        paypalDetails.setMultiItem(rs.getString("MultiItem"));
        paypalDetails.setLinked(rs.getBoolean("Linked"));
        paypalDetails.setTax(Float.valueOf(rs.getFloat("Tax")));
        paypalDetails.setCurrencyCode(rs.getString("CurrencyCode"));
        paypalDetails.setShippingAmount(Float.valueOf(rs.getFloat("ShippingAmount")));
        paypalDetails.setPaypalAccount(rs.getString("PayPalAccount"));
        return identifier;
    }

    private String getPrintDetails(ResultSet rs, PrintDetails printDetails) throws Exception {
        String identifier = String.valueOf(rs.getString("OrderID"));
        printDetails.setCity(rs.getString("City"));
        printDetails.setCost(rs.getDouble("Cost"));
        printDetails.setCountryCode(rs.getString("CountryCode"));
        printDetails.setCustomer(rs.getString("Customer"));
        printDetails.setEmail(rs.getString("Email"));
        printDetails.setFirstName(rs.getString("FirstName"));
        printDetails.setLastName(rs.getString("LastName"));
        printDetails.setPostalCode(rs.getString("PostalCode"));
        printDetails.setPackageType(rs.getString("PackageType"));
        printDetails.setShipping(rs.getString("ShippingType"));
        printDetails.setState(rs.getString("State"));
        printDetails.setStreet1(rs.getString("Street1"));
        printDetails.setStreet2(rs.getString("Street2"));
        printDetails.setOrderID(rs.getString("OrderID"));
        printDetails.setWeight(rs.getDouble("Weight"));
        printDetails.setPackedWeight(rs.getDouble("PackedWeight"));
        try {
            printDetails.setErrorDetails(rs.getString("IndiciumID"));
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex, false);
        }
        try {
            printDetails.setActualErrorDetails(rs.getString("ActualErrorDetails"));
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex, false);
        }
        printDetails.setTracking(rs.getString("Tracking"));
        printDetails.setUrl(rs.getString("URL"));
        printDetails.setStampsID(rs.getString("StampsID"));
        printDetails.setScan(rs.getBoolean("Scan"));
        printDetails.setError(rs.getBoolean("Error"));
        printDetails.setCanceled(rs.getBoolean("Canceled"));
        printDetails.setPrinted(rs.getBoolean("Printed"));
        try {
            printDetails.setLabelInstructions(rs.getString("LabelInstructions"));
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex, false);
        }
        printDetails.setDateEntered(rs.getDate("DateEntered"));
        printDetails.setCopies(rs.getInt("Copies"));
        printDetails.setParentOrderID(rs.getString("ParentOrderID"));
        printDetails.setOrderTotal(rs.getDouble("OrderTotal"));
        printDetails.setShipDate(rs.getDate("ShipDate"));
        printDetails.setDeclaredWeight(rs.getDouble("DeclaredValue"));
        printDetails.setPrintDate(rs.getTimestamp("PrintDate"));
        printDetails.setPaypalAccount(rs.getString("PayPalAccount"));
        printDetails.setPrintID(rs.getInt("PrintID"));
        printDetails.setPrintPage(rs.getInt("PrintPage"));
        return identifier;
    }

    private String getRMADetails(ResultSet rs, RMADetails rmaDetails) throws Exception {
        String identifier = String.valueOf(rs.getInt("RmaNumberID"));
        try {
            rmaDetails.setRmaComments(rs.getString("RMAComments"));
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex, false);
        }
        rmaDetails.setRmaDate(rs.getDate("RMADate"));
        rmaDetails.setCustomerUsername(rs.getString("CustomerUserName"));
        rmaDetails.setOrderDetailsID(rs.getInt("OrderDetailsID"));
        rmaDetails.setReplacementTracking(rs.getString("ReplacementTracking"));
        rmaDetails.setReturnTracking(rs.getString("ReturnTracking"));
        rmaDetails.setRmaNumberID(rs.getInt("RmaNumberID"));
        rmaDetails.setRmaReasonID(rs.getInt("RmaReasonID"));
        rmaDetails.setRmaStatusID(rs.getInt("RmaStatusID"));
        return identifier;
    }

    private String getRMAReason(ResultSet rs, RMAReason rmaReason) throws Exception {
        String identifier = String.valueOf(rs.getInt("RMAReasonID"));
        rmaReason.setRmaReasonType(rs.getString("RMAReasonType"));
        rmaReason.setRmarReasonID(rs.getInt("RMAReasonID"));
        return identifier;
    }

    private String getRMAStatus(ResultSet rs, RMAStatus rmaStatus) throws Exception {
        String identifier = String.valueOf(rs.getInt("RMAStatusID"));
        rmaStatus.setRmaStatusID(rs.getInt("RMAStatusID"));
        rmaStatus.setRmaStatusType(rs.getString("RMAStatusType"));
        return identifier;
    }

    private String getSalesTax(ResultSet rs, SalesTax salesTax) throws Exception {
        String identifier = String.valueOf(rs.getString("Abbreviation"));
        salesTax.setAbbreviation(rs.getString("Abbreviation"));
        salesTax.setCost(Float.valueOf(rs.getFloat("Cost")));
        salesTax.setEnabled(rs.getBoolean("Enabled"));
        salesTax.setIdentifier(rs.getString("Identifier"));
        return identifier;
    }

    private String getShippingMethods(ResultSet rs, ShippingMethod shippingMethod) throws Exception {
        String identifier = String.valueOf(rs.getString("ShippingMethodName"));
        shippingMethod.setDeliveryTimeMax(rs.getInt("DeliveryTimeMax"));
        shippingMethod.setDeliveryTimeMin(rs.getInt("DeliveryTimeMin"));
        shippingMethod.setShippingMethodName(rs.getString("ShippingMethodName"));
        return identifier;
    }

    private String getSubscription(ResultSet rs, RESTData restData) throws Exception {
        String identifier = String.valueOf(rs.getString("UserName"));
        restData.setUserName(rs.getString("UserName"));
        restData.setFinance(rs.getBoolean("Finance"));
        restData.setInventory(rs.getBoolean("Inventory"));
        restData.setWebsite(rs.getBoolean("Website"));
        restData.setMulti(rs.getBoolean("Multi"));
        restData.setPaypal(rs.getBoolean("Paypal"));
        restData.setPrint(rs.getBoolean("Print"));
        restData.setCurrent(rs.getBoolean("Current"));
        restData.setExpire(rs.getDate("Expire"));
        restData.setOffline(rs.getBoolean("Offline"));
        restData.setTimer(rs.getDate("Timer"));
        restData.setPassword(rs.getString("Password"));
        restData.setLicense(rs.getString("License"));
        return identifier;
    }

    private String getWebsiteCategories(ResultSet rs, WebsiteCategories websiteCategories) throws Exception {
        String identifier = String.valueOf(rs.getInt("WebsiteID"));
        websiteCategories.setWebsiteID(rs.getInt("WebsiteID"));
        websiteCategories.setWebsiteCategoriesID(rs.getInt("WebsiteCategoriesID"));
        websiteCategories.setCategoryID(rs.getInt("CategoryID"));
        return identifier;
    }

    private String getWebisteProducts(ResultSet rs, WebsiteElement websiteElement) throws Exception {
        String identifier = String.valueOf(rs.getString("ItemID"));
        websiteElement.setItemID(rs.getString("ItemID"));
        websiteElement.setOem(rs.getString("Oem"));
        websiteElement.setPrice(rs.getFloat("Price"));
        websiteElement.setPriceRetail(rs.getFloat("PriceRetail"));
        try {
            websiteElement.setBriefDescription(rs.getString("BriefDescription"));
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex, false);
        }
        websiteElement.setThumbnail(rs.getString("Thumbnail"));
        websiteElement.setPhoto1(rs.getString("Photo1"));
        websiteElement.setPhoto2(rs.getString("Photo2"));
        websiteElement.setPhoto3(rs.getString("Photo3"));
        websiteElement.setCategoryID(rs.getInt("CategoryID"));
        websiteElement.setEnabled(rs.getBoolean("Enabled"));
        websiteElement.setFeatured(rs.getBoolean("Featured"));
        try {
            websiteElement.setDescription(rs.getString("Description"));
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex, false);
        }
        try {
            websiteElement.setKeywords(rs.getString("Keywords"));
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex, false);
        }
        return identifier;
    }

    private String getWebsites(ResultSet rs, Website website) throws Exception {
        String identifier = String.valueOf(rs.getInt("WebsiteID"));
        website.setLastUpdate(rs.getLong("LastUpdate"));
        website.setWebsiteActive(rs.getBoolean("WebsiteActive"));
        website.setWebsiteID(rs.getInt("WebsiteID"));
        website.setWebsiteName(rs.getString("WebsiteName"));
        website.setWebsiteURI(rs.getString("WebsiteURI"));
        return identifier;
    }

    private String getLicense(ResultSet rs, License license) throws Exception {
        String identifier = String.valueOf(rs.getString("License"));
        license.setLicense(rs.getString("License"));
        return identifier;
    }

    private String getProfiles(ResultSet rs, Profile profile) throws Exception {
        String identifier = String.valueOf(rs.getString("Profile"));
        profile.setProfile(rs.getString("Profile"));
        return identifier;
    }

    private String getCompanyLinks(ResultSet rs, CompanyLink companyLink) throws Exception {
        String identifier = String.valueOf(rs.getString("PayPalLink"));
        companyLink.setCompanyName(rs.getString("CompanyName"));
        companyLink.setPaypalLink(rs.getString("PayPalLink"));
        return identifier;
    }

    private String getPreferencePaypalAccounts(ResultSet rs, PreferencePayPalAccount preferencePayPalAccount) throws Exception {
        String identifier = String.valueOf(rs.getString("PayPalAccount"));
        preferencePayPalAccount.setPaypalAccount(rs.getString("PayPalAccount"));
        return identifier;
    }

    static {
        progressString = "";
        percentageComplete = 0;
    }
}

