/*
 * Decompiled with CFR 0.152.
 */
package pnp.services.sqlconversion;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import pnp.services.datatypes.AccountPreferences;
import pnp.services.datatypes.Category;
import pnp.services.datatypes.CheckDetails;
import pnp.services.datatypes.CompanyInfo;
import pnp.services.datatypes.CompanyLink;
import pnp.services.datatypes.CustomFee;
import pnp.services.datatypes.Customer;
import pnp.services.datatypes.Distributor;
import pnp.services.datatypes.EbayTransactions;
import pnp.services.datatypes.Expense;
import pnp.services.datatypes.ExpenseReason;
import pnp.services.datatypes.InventoryElement;
import pnp.services.datatypes.Item;
import pnp.services.datatypes.License;
import pnp.services.datatypes.Order;
import pnp.services.datatypes.OrderDetails;
import pnp.services.datatypes.OrderStatus;
import pnp.services.datatypes.PaypalDetails;
import pnp.services.datatypes.PreferencePayPalAccount;
import pnp.services.datatypes.PrintDetails;
import pnp.services.datatypes.Profile;
import pnp.services.datatypes.RESTData;
import pnp.services.datatypes.RMADetails;
import pnp.services.datatypes.RMAReason;
import pnp.services.datatypes.RMAStatus;
import pnp.services.datatypes.SalesTax;
import pnp.services.datatypes.ShippingMethod;
import pnp.services.datatypes.webservices.Amazonaccount;
import pnp.services.datatypes.webservices.Ebayaccount;
import pnp.services.datatypes.webservices.Paypalaccount;
import pnp.services.datatypes.webservices.Website;
import pnp.services.datatypes.webservices.WebsiteCategories;
import pnp.services.datatypes.webservices.WebsiteElement;

public class InsertIntoSQL {
    private static final Object _lock = new Object();

    private String createInsertSQL(String table, String[] fields) throws Exception {
        String fieldSQL = "";
        String valueSQL = "";
        boolean first = true;
        for (String field : fields) {
            if (!first) {
                fieldSQL = fieldSQL + ",";
                valueSQL = valueSQL + ",";
            }
            fieldSQL = fieldSQL + field;
            valueSQL = valueSQL + "?";
            first = false;
        }
        return "INSERT INTO " + table + "(" + fieldSQL + ")Values(" + valueSQL + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertAccountPreferences(AccountPreferences item, Connection dbConnection, String table) throws Exception {
        Object object = _lock;
        synchronized (object) {
            if (!item.getGenProfile().equals("Default")) {
                String[] fields = new String[]{"GenProfile", "GenNegativeNotification", "GenRefreshBehavior", "GenSalesPeriod", "GenStockNotification", "GenTrackingNotify", "GenUnmergeNotify", "GenBusinessName", "GenInvoiceComments", "GenWebsiteAddress", "GenVersion", "GenSyncNotification", "GenSplitRefresh", "GenInventoryRefresh", "GenBetaUpdates", "SubOfflineMode", "SubSaveCredentials", "SubLicense", "SubPassword", "SubUsername", "EbayLastUpdate", "PaypalLastUpdate", "PaypalAutoLink", "PaypalDomesticAddon", "PaypalDomesticFee", "PaypalInternationalAddon", "PaypalInternationalFee", "StampsSaveCredentials", "StampsSignatureConfirm", "StampsAddress", "StampsCity", "StampsCountry", "StampsFullName", "StampsImageLocation", "StampsPassword", "StampsPhoneNumber", "StampsPostalCode", "StampsState", "StampsUsername", "StampsLabelStatus", "StampsPrintLabels", "StampsPurchaseLabels ", "StampsSaveLabels", "StampsTracking", "StampsPrintOptions", "StampsPageOptions", "StampsHideNotification", "StampsStorageDays", "StampsDateNotification", "StampsPackedWeight", "StampsAutoPurchase", "StampsAutoPurchaseLimit", "StampsAutoPurchaseWarning", "StampsInvalidPackageNotification", "StampsPurchaseDateNotification", "StampsComments", "StampsNIAFilter", "StampsMixedInventoryNotification", "StampsAccount", "StampsEndiciaUsername", "StampsEndiciaPassword", "StampsCommercialPlus", "CompanyDefaultCompany", "StampsUPSUsername", "StampsUPSPassword", "StampsUPSAccessKey", "StampsUPSAccountNumber"};
                String sql = this.createInsertSQL(table, fields);
                PreparedStatement stmt = dbConnection.prepareStatement(sql);
                int itemCounter = 1;
                stmt.setString(itemCounter++, item.getGenProfile());
                stmt.setBoolean(itemCounter++, item.isGenNegativeNotification());
                stmt.setBoolean(itemCounter++, item.isGenRefreshBehavior());
                stmt.setInt(itemCounter++, item.getGenSalesPeriod());
                stmt.setInt(itemCounter++, item.getGenStockNotification());
                stmt.setBoolean(itemCounter++, item.isGenTrackingNotify());
                stmt.setBoolean(itemCounter++, item.isGenUnmergeNotify());
                stmt.setString(itemCounter++, item.getGenBusinessName());
                stmt.setString(itemCounter++, item.getGenInvoiceComments());
                stmt.setString(itemCounter++, item.getGenWebsiteAddress());
                stmt.setInt(itemCounter++, item.getGenVersion());
                stmt.setBoolean(itemCounter++, item.isGenSyncNotification());
                stmt.setBoolean(itemCounter++, item.isGenSplitRefresh());
                stmt.setBoolean(itemCounter++, item.isGenInventoryRefresh());
                stmt.setBoolean(itemCounter++, item.isGenBetaUpdates());
                stmt.setBoolean(itemCounter++, item.isSubOfflineMode());
                stmt.setBoolean(itemCounter++, item.isSubSaveCredentials());
                stmt.setString(itemCounter++, item.getSubLicense());
                stmt.setString(itemCounter++, item.getSubPassword());
                stmt.setString(itemCounter++, item.getSubUsername());
                stmt.setLong(itemCounter++, item.getEbayLastUpdate());
                stmt.setLong(itemCounter++, item.getPaypalLastUpdate());
                stmt.setBoolean(itemCounter++, item.isPaypalAutoLink());
                stmt.setDouble(itemCounter++, item.getPaypalDomesticAddon());
                stmt.setDouble(itemCounter++, item.getPaypalDomesticFee());
                stmt.setDouble(itemCounter++, item.getPaypalInternationalAddon());
                stmt.setDouble(itemCounter++, item.getPaypalInternationalFee());
                stmt.setBoolean(itemCounter++, item.isStampsSaveCredentials());
                stmt.setBoolean(itemCounter++, item.isStampsSignatureConfirm());
                stmt.setString(itemCounter++, item.getStampsAddress());
                stmt.setString(itemCounter++, item.getStampsCity());
                stmt.setString(itemCounter++, item.getStampsCountry());
                stmt.setString(itemCounter++, item.getStampsFullName());
                stmt.setString(itemCounter++, item.getStampsImageLocation());
                stmt.setString(itemCounter++, item.getStampsPassword());
                stmt.setString(itemCounter++, item.getStampsPhoneNumber());
                stmt.setString(itemCounter++, item.getStampsPostalCode());
                stmt.setString(itemCounter++, item.getStampsState());
                stmt.setString(itemCounter++, item.getStampsUsername());
                stmt.setString(itemCounter++, item.getStampsLabelStatus());
                stmt.setBoolean(itemCounter++, item.isStampsPrintLabels());
                stmt.setBoolean(itemCounter++, item.isStampsPurchaseLabels());
                stmt.setBoolean(itemCounter++, item.isStampsSaveLabels());
                stmt.setBoolean(itemCounter++, item.isStampsTracking());
                stmt.setString(itemCounter++, item.getStampsPrintOptions());
                stmt.setString(itemCounter++, item.getStampsPageOptions());
                stmt.setBoolean(itemCounter++, item.isStampsHideNotification());
                stmt.setInt(itemCounter++, item.getStampsStorageDays());
                stmt.setBoolean(itemCounter++, item.isStampsDateNotification());
                stmt.setBoolean(itemCounter++, item.isStampsPackedWeight());
                stmt.setBoolean(itemCounter++, item.isStampsAutoPurchase());
                stmt.setFloat(itemCounter++, item.getStampsAutoPurchaseLimit());
                stmt.setBoolean(itemCounter++, item.isStampsAutoPurchaseWarning());
                stmt.setBoolean(itemCounter++, item.isStampsInvalidPackageNotification());
                stmt.setBoolean(itemCounter++, item.isStampsPurchaseDateNotification());
                stmt.setBoolean(itemCounter++, item.isStampsComments());
                stmt.setBoolean(itemCounter++, item.isStampsMixedInventoryNotification());
                stmt.setBoolean(itemCounter++, item.isStampsNIAFilter());
                stmt.setString(itemCounter++, item.getStampsAccount());
                stmt.setString(itemCounter++, item.getStampsEndiciaUserName());
                stmt.setString(itemCounter++, item.getStampsEndiciaPassword());
                stmt.setBoolean(itemCounter++, item.isStampsCommercialPlus());
                stmt.setString(itemCounter++, item.getCompanyDefaultCompany());
                stmt.setString(itemCounter++, item.getStampsUPSUserName());
                stmt.setString(itemCounter++, item.getStampsUPSPassword());
                stmt.setString(itemCounter++, item.getStampsUPSAccessKey());
                stmt.setString(itemCounter++, item.getStampsUPSAccountNumber());
                stmt.executeUpdate();
                if (stmt != null && !stmt.isClosed()) {
                    stmt.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertAmazonAccount(Amazonaccount item, Connection sqlConnection, String table) throws Exception {
        Object object = _lock;
        synchronized (object) {
            int itemCounter = 1;
            String[] fields = new String[]{"AmazonAccountID", "AmazonAccountNumber", "UserToken", "UserName"};
            String sql = this.createInsertSQL(table, fields);
            PreparedStatement stmt = sqlConnection.prepareStatement(sql);
            stmt.setString(itemCounter++, item.getAmazonAccountID());
            stmt.setInt(itemCounter++, item.getAmazonAccountNumber());
            stmt.setString(itemCounter++, item.getUserToken());
            stmt.setString(itemCounter++, item.getUserName());
            stmt.executeUpdate();
            if (stmt != null && !stmt.isClosed()) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertCategories(Category item, Connection sqlConnection, String table) throws Exception {
        Object object = _lock;
        synchronized (object) {
            int itemCounter = 1;
            String[] fields = new String[]{"CategoryID", "CategoryName"};
            String sql = this.createInsertSQL(table, fields);
            PreparedStatement stmt = sqlConnection.prepareStatement(sql);
            stmt.setInt(itemCounter++, item.getCategoryID());
            stmt.setString(itemCounter++, item.getCategoryName());
            stmt.executeUpdate();
            if (stmt != null && !stmt.isClosed()) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertCheckDetails(CheckDetails item, Connection sqlConnection, String table) throws Exception {
        Object object = _lock;
        synchronized (object) {
            int itemCounter = 1;
            String[] fields = new String[]{"CheckID", "OrderDetailsID", "OrderID", "PackedWeight", "PaypalAccount", "Weight"};
            String sql = this.createInsertSQL(table, fields);
            PreparedStatement stmt = sqlConnection.prepareStatement(sql);
            stmt.setInt(itemCounter++, item.getCheckID());
            stmt.setInt(itemCounter++, item.getOrderDetailsID());
            stmt.setString(itemCounter++, item.getOrderID());
            stmt.setFloat(itemCounter++, item.getPackedWeight());
            stmt.setString(itemCounter++, item.getPaypalAccount());
            stmt.setFloat(itemCounter++, item.getWeight());
            stmt.executeUpdate();
            if (stmt != null && !stmt.isClosed()) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertCompanies(CompanyInfo item, Connection sqlConnection, String table) throws Exception {
        Object object = _lock;
        synchronized (object) {
            int itemCounter = 1;
            String[] fields = new String[]{"CompanyAddress", "CompanyCity", "CompanyComments", "CompanyCountry", "CompanyFullName", "CompanyName", "CompanyPhoneNumber", "CompanyPostalCode", "CompanyState", "CompanyWebsite"};
            String sql = this.createInsertSQL(table, fields);
            PreparedStatement stmt = sqlConnection.prepareStatement(sql);
            stmt.setString(itemCounter++, item.getCompanyAddress());
            stmt.setString(itemCounter++, item.getCompanyCity());
            stmt.setString(itemCounter++, item.getCompanyComments());
            stmt.setString(itemCounter++, item.getCompanyCountry());
            stmt.setString(itemCounter++, item.getCompanyFullName());
            stmt.setString(itemCounter++, item.getCompanyName());
            stmt.setString(itemCounter++, item.getCompanyPhoneNumber());
            stmt.setString(itemCounter++, item.getCompanyPostalCode());
            stmt.setString(itemCounter++, item.getCompanyState());
            stmt.setString(itemCounter++, item.getCompanyWebsite());
            stmt.executeUpdate();
            if (stmt != null && !stmt.isClosed()) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertCustomers(Customer item, Connection sqlConnection, String table) throws Exception {
        Object object = _lock;
        synchronized (object) {
            int itemCounter = 1;
            String[] fields = new String[]{"CustomerAddress", "CustomerCity", "CustomerComments", "CustomerCountry", "CustomerEmail", "CustomerName", "CustomerState", "CustomerUserName", "CustomerZipCode"};
            String sql = this.createInsertSQL(table, fields);
            PreparedStatement stmt = sqlConnection.prepareStatement(sql);
            stmt.setString(itemCounter++, item.getCustomerAddress());
            stmt.setString(itemCounter++, item.getCustomerCity());
            stmt.setString(itemCounter++, item.getCustomerComments());
            stmt.setString(itemCounter++, item.getCustomerCountry());
            stmt.setString(itemCounter++, item.getCustomerEmail());
            stmt.setString(itemCounter++, item.getCustomerName());
            stmt.setString(itemCounter++, item.getCustomerState());
            stmt.setString(itemCounter++, item.getCustomerUserName());
            stmt.setString(itemCounter++, item.getCustomerZipcode());
            stmt.executeUpdate();
            if (stmt != null && !stmt.isClosed()) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertCustomFees(CustomFee item, Connection sqlConnection, String table) throws Exception {
        Object object = _lock;
        synchronized (object) {
            int itemCounter = 1;
            String[] fields = new String[]{"CustomFeeID", "CustomFeeFlatCost", "CustomFeeName", "CustomFeePercentage"};
            String sql = this.createInsertSQL(table, fields);
            PreparedStatement stmt = sqlConnection.prepareStatement(sql);
            stmt.setInt(itemCounter++, item.getCustomFeeID());
            stmt.setDouble(itemCounter++, item.getFeeFlatCost());
            stmt.setString(itemCounter++, item.getFeeName());
            stmt.setDouble(itemCounter++, item.getFeePercentage());
            stmt.executeUpdate();
            if (stmt != null && !stmt.isClosed()) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertDistributors(Distributor item, Connection sqlConnection, String table) throws Exception {
        Object object = _lock;
        synchronized (object) {
            int itemCounter = 1;
            String[] fields = new String[]{"DistributorContact", "DistributorEmail", "DistributorID", "DistributorName", "DistributorPhone", "DistributorWebsite"};
            String sql = this.createInsertSQL(table, fields);
            PreparedStatement stmt = sqlConnection.prepareStatement(sql);
            stmt.setString(itemCounter++, item.getDistributorContact());
            stmt.setString(itemCounter++, item.getDistributorEmail());
            stmt.setInt(itemCounter++, item.getDistributorID());
            stmt.setString(itemCounter++, item.getDistributorName());
            stmt.setString(itemCounter++, item.getDistributorPhone());
            stmt.setString(itemCounter++, item.getDistributorWebsite());
            stmt.executeUpdate();
            if (stmt != null && !stmt.isClosed()) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertEbayAccount(Ebayaccount item, Connection sqlConnection, String table) throws Exception {
        Object object = _lock;
        synchronized (object) {
            int itemCounter = 1;
            String[] fields = new String[]{"UserName", "EbayAccountID", "EbayAccountNumber", "UserToken"};
            String sql = this.createInsertSQL(table, fields);
            PreparedStatement stmt = sqlConnection.prepareStatement(sql);
            stmt.setString(itemCounter++, item.getUserName());
            stmt.setString(itemCounter++, item.getEbayAccountID());
            stmt.setInt(itemCounter++, item.getEbayAccountNumber());
            stmt.setString(itemCounter++, item.getUserToken());
            stmt.executeUpdate();
            if (stmt != null && !stmt.isClosed()) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertEbayTransactions(EbayTransactions item, Connection sqlConnection, String table) throws Exception {
        Object object = _lock;
        synchronized (object) {
            int itemCounter = 1;
            String[] fields = new String[]{"AuctionName", "Cost", "EbayTransactionID", "Quantity", "ReferenceNumber", "PayPalTransactionID"};
            String sql = this.createInsertSQL(table, fields);
            PreparedStatement stmt = sqlConnection.prepareStatement(sql);
            stmt.setString(itemCounter++, item.getAuctionName());
            stmt.setFloat(itemCounter++, item.getCost().floatValue());
            stmt.setString(itemCounter++, item.getEbayTransactionID());
            stmt.setInt(itemCounter++, item.getQuantity());
            stmt.setString(itemCounter++, item.getReferenceNumber());
            stmt.setString(itemCounter++, item.getPaypalTransactionID());
            stmt.executeUpdate();
            if (stmt != null && !stmt.isClosed()) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertExpenseReasons(ExpenseReason item, Connection sqlConnection, String table) throws Exception {
        Object object = _lock;
        synchronized (object) {
            int itemCounter = 1;
            String[] fields = new String[]{"ExpenseReasonID", "Reason"};
            String sql = this.createInsertSQL(table, fields);
            PreparedStatement stmt = sqlConnection.prepareStatement(sql);
            stmt.setInt(itemCounter++, item.getExpenseReasonID());
            stmt.setString(itemCounter++, item.getReason());
            stmt.executeUpdate();
            if (stmt != null && !stmt.isClosed()) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertExpenses(Expense item, Connection sqlConnection, String table) throws Exception {
        Object object = _lock;
        synchronized (object) {
            int itemCounter = 1;
            String[] fields = new String[]{"CompanyName", "ExpenseComment", "ExpenseCost", "ExpenseDate", "ExpenseID", "ExpenseReason", "ExpenseReasonID"};
            String sql = this.createInsertSQL(table, fields);
            PreparedStatement stmt = sqlConnection.prepareStatement(sql);
            stmt.setString(itemCounter++, item.getCompanyName());
            stmt.setString(itemCounter++, item.getExpenseComment());
            stmt.setFloat(itemCounter++, item.getExpenseCost());
            stmt.setDate(itemCounter++, item.getExpenseDate());
            stmt.setInt(itemCounter++, item.getExpenseID());
            stmt.setString(itemCounter++, item.getExpenseReason());
            stmt.setInt(itemCounter++, item.getExpenseReasonID());
            stmt.executeUpdate();
            if (stmt != null && !stmt.isClosed()) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertInventory(InventoryElement item, Connection sqlConnection, String table) throws Exception {
        Object object = _lock;
        synchronized (object) {
            int itemCounter = 1;
            String[] fields = new String[]{"InventoryID", "ItemCost", "ItemID", "ItemQuantity", "OOSItem", "StockDate"};
            String sql = this.createInsertSQL(table, fields);
            PreparedStatement stmt = sqlConnection.prepareStatement(sql);
            stmt.setInt(itemCounter++, item.getInventoryID());
            stmt.setFloat(itemCounter++, item.getItemCost());
            stmt.setString(itemCounter++, item.getItemID());
            stmt.setInt(itemCounter++, item.getItemQuantity());
            stmt.setBoolean(itemCounter++, item.isOosItem());
            stmt.setDate(itemCounter++, item.getStockDate());
            stmt.executeUpdate();
            if (stmt != null && !stmt.isClosed()) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertItems(Item item, Connection sqlConnection, String table) throws Exception {
        Object object = _lock;
        synchronized (object) {
            int itemCounter = 1;
            String[] fields = new String[]{"Discontinued", "DistributorID", "DistributorProductID", "DropShipped", "ItemDescription", "ItemID", "ItemName", "ItemWeight", "Location", "PackedWeight"};
            String sql = this.createInsertSQL(table, fields);
            PreparedStatement stmt = sqlConnection.prepareStatement(sql);
            stmt.setBoolean(itemCounter++, item.isDiscontinued());
            stmt.setInt(itemCounter++, item.getDistributorID());
            stmt.setString(itemCounter++, item.getDistributorProductID());
            stmt.setBoolean(itemCounter++, item.isDropShipped());
            stmt.setString(itemCounter++, item.getItemDescription());
            stmt.setString(itemCounter++, item.getItemID());
            stmt.setString(itemCounter++, item.getItemName());
            stmt.setFloat(itemCounter++, item.getItemWeight());
            stmt.setString(itemCounter++, item.getLocation());
            stmt.setFloat(itemCounter++, item.getPackedWeight());
            stmt.executeUpdate();
            if (stmt != null && !stmt.isClosed()) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertLicense(License item, Connection sqlConnection, String table) throws Exception {
        Object object = _lock;
        synchronized (object) {
            int itemCounter = 1;
            String[] fields = new String[]{"License"};
            String sql = this.createInsertSQL(table, fields);
            PreparedStatement stmt = sqlConnection.prepareStatement(sql);
            stmt.setString(itemCounter++, item.getLicense());
            stmt.executeUpdate();
            if (stmt != null && !stmt.isClosed()) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertOrderDetails(OrderDetails item, Connection sqlConnection, String table) throws Exception {
        Object object = _lock;
        synchronized (object) {
            int itemCounter = 1;
            String[] fields = new String[]{"ItemID", "AccountName", "EbaySite", "TrackingNumber", "Carrier", "OrderDetailsID", "OrderID", "Backordered", "OrderNumber", "Salesprice", "ItemCost", "TransactionID", "Inhouse", "OrderDescription", "EbayWeight", "ShipDate", "Deleted"};
            String sql = this.createInsertSQL(table, fields);
            PreparedStatement stmt = sqlConnection.prepareStatement(sql);
            stmt.setString(itemCounter++, item.getItemID());
            stmt.setString(itemCounter++, item.getAccountName());
            stmt.setString(itemCounter++, item.getEbaySite());
            stmt.setString(itemCounter++, item.getTrackingNumber());
            stmt.setString(itemCounter++, item.getCarrier());
            stmt.setInt(itemCounter++, item.getOrderDetailsID());
            stmt.setInt(itemCounter++, item.getOrderID());
            stmt.setBoolean(itemCounter++, item.isBackordered());
            stmt.setString(itemCounter++, item.getOrderNumber());
            stmt.setFloat(itemCounter++, item.getSalesPrice());
            stmt.setFloat(itemCounter++, item.getItemCost());
            stmt.setString(itemCounter++, item.getTransactionID());
            stmt.setBoolean(itemCounter++, item.isInhouse());
            stmt.setString(itemCounter++, item.getOrderDescription());
            stmt.setFloat(itemCounter++, item.getEbayWeight());
            stmt.setDate(itemCounter++, item.getShipDate());
            stmt.setBoolean(itemCounter++, item.isDeleted());
            stmt.executeUpdate();
            if (stmt != null && !stmt.isClosed()) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertOrders(Order item, Connection sqlConnection, String table) throws Exception {
        Object object = _lock;
        synchronized (object) {
            int itemCounter = 1;
            String[] fields = new String[]{"OrderComments", "OrderDate", "OrderID", "OrderStatusID", "OrderTotal", "ShippingCost", "ShippingMethodID", "ShippingPaid", "OrderPaypal", "CustomerUserName"};
            String sql = this.createInsertSQL(table, fields);
            PreparedStatement stmt = sqlConnection.prepareStatement(sql);
            stmt.setString(itemCounter++, item.getOrderComments());
            stmt.setDate(itemCounter++, item.getOrderDate());
            stmt.setInt(itemCounter++, item.getOrderID());
            stmt.setInt(itemCounter++, item.getOrderStatusID());
            stmt.setFloat(itemCounter++, item.getOrderTotal());
            stmt.setFloat(itemCounter++, item.getShippingCost());
            stmt.setString(itemCounter++, item.getShippingMethodName());
            stmt.setFloat(itemCounter++, item.getShippingPaid());
            stmt.setString(itemCounter++, item.getPaypalAccount());
            stmt.setString(itemCounter++, item.getCustomerUserName());
            stmt.executeUpdate();
            if (stmt != null && !stmt.isClosed()) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertOrderStatus(OrderStatus item, Connection sqlConnection, String table) throws Exception {
        Object object = _lock;
        synchronized (object) {
            int itemCounter = 1;
            String[] fields = new String[]{"OrderStatusID", "OrderStatusType"};
            String sql = this.createInsertSQL(table, fields);
            PreparedStatement stmt = sqlConnection.prepareStatement(sql);
            stmt.setInt(itemCounter++, item.getOrderStatusID());
            stmt.setString(itemCounter++, item.getOrderStatusType());
            stmt.executeUpdate();
            if (stmt != null && !stmt.isClosed()) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertPayPalAccount(Paypalaccount item, Connection sqlConnection, String table) throws Exception {
        Object object = _lock;
        synchronized (object) {
            int itemCounter = 1;
            String[] fields = new String[]{"AccessToken", "UserName", "PaypalAccountID", "PaypalAccountNumber", "TokenSecret"};
            String sql = this.createInsertSQL(table, fields);
            PreparedStatement stmt = sqlConnection.prepareStatement(sql);
            stmt.setString(itemCounter++, item.getAccessToken());
            stmt.setString(itemCounter++, item.getUserName());
            stmt.setString(itemCounter++, item.getPaypalAccountID());
            stmt.setInt(itemCounter++, item.getPaypalAccountNumber());
            stmt.setString(itemCounter++, item.getTokenSecret());
            stmt.executeUpdate();
            if (stmt != null && !stmt.isClosed()) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertPayPalTransactions(PaypalDetails item, Connection sqlConnection, String table) throws Exception {
        Object object = _lock;
        synchronized (object) {
            int itemCounter = 1;
            String[] fields = new String[]{"PaypalTransactionID", "EmailAddress", "FirstName", "LastName", "CountryCode", "CountryName", "Street1", "Street2", "CityName", "StateOrProvince", "PostalCode", "TransactionType", "PaymentType", "PaymentDate", "GrossAmount", "PaymentStatus", "ShippingMethod", "Custom", "Memo", "BuyerID", "ClosingDate", "MultiItem", "Linked", "Tax", "CurrencyCode", "ShippingAmount", "PayPalAccount"};
            String sql = this.createInsertSQL(table, fields);
            PreparedStatement stmt = sqlConnection.prepareStatement(sql);
            stmt.setString(itemCounter++, item.getPaypalTransactionID());
            stmt.setString(itemCounter++, item.getEmail());
            stmt.setString(itemCounter++, item.getFirstName());
            stmt.setString(itemCounter++, item.getLastName());
            stmt.setString(itemCounter++, item.getCountryCode());
            stmt.setString(itemCounter++, item.getCountryName());
            stmt.setString(itemCounter++, item.getStreet1());
            stmt.setString(itemCounter++, item.getStreet2());
            stmt.setString(itemCounter++, item.getCityName());
            stmt.setString(itemCounter++, item.getStateOrProvince());
            stmt.setString(itemCounter++, item.getPostalCode());
            stmt.setString(itemCounter++, item.getTransactionType());
            stmt.setString(itemCounter++, item.getPaymentType());
            stmt.setString(itemCounter++, item.getPaymentDate());
            stmt.setFloat(itemCounter++, item.getGrossAmount().floatValue());
            stmt.setString(itemCounter++, item.getPaymentStatus());
            stmt.setString(itemCounter++, item.getShippingMethod());
            stmt.setString(itemCounter++, item.getCustom());
            stmt.setString(itemCounter++, item.getMemo());
            stmt.setString(itemCounter++, item.getBuyerID());
            stmt.setString(itemCounter++, item.getClosingDate());
            stmt.setString(itemCounter++, item.getMultiItem());
            stmt.setBoolean(itemCounter++, item.isLinked());
            stmt.setFloat(itemCounter++, item.getTax().floatValue());
            stmt.setString(itemCounter++, item.getCurrencyCode());
            stmt.setFloat(itemCounter++, item.getShippingAmount().floatValue());
            stmt.setString(itemCounter++, item.getPaypalAccount());
            stmt.executeUpdate();
            if (stmt != null && !stmt.isClosed()) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertPrintDetails(PrintDetails item, Connection sqlConnection, String table) throws Exception {
        Object object = _lock;
        synchronized (object) {
            int itemCounter = 1;
            String[] fields = new String[]{"City", "Cost", "CountryCode", "Customer", "Email", "FirstName", "LastName", "PostalCode", "PackageType", "ShippingType", "State", "Street1", "Street2", "OrderID", "Weight", "PackedWeight", "IndiciumID", "ActualErrorDetails", "Tracking", "URL", "StampsID", "Scan", "Error", "Canceled", "Printed", "LabelInstructions", "DateEntered", "Copies", "ParentOrderID", "OrderTotal", "ShipDate", "DeclaredValue", "PrintDate", "PayPalAccount", "PrintID", "PrintPage"};
            String sql = this.createInsertSQL(table, fields);
            PreparedStatement stmt = sqlConnection.prepareStatement(sql);
            Date shipDate = null;
            Date dateEntered = null;
            Timestamp printDate = null;
            if (item.getShipDate() != null) {
                shipDate = new Date(item.getShipDate().getTime());
            }
            if (item.getDateEntered() != null) {
                dateEntered = new Date(item.getDateEntered().getTime());
            }
            if (item.getPrintDate() != null) {
                printDate = new Timestamp(item.getPrintDate().getTime());
            }
            stmt.setString(itemCounter++, item.getCity());
            stmt.setDouble(itemCounter++, item.getCost());
            stmt.setString(itemCounter++, item.getCountryCode());
            stmt.setString(itemCounter++, item.getCustomer());
            stmt.setString(itemCounter++, item.getEmail());
            stmt.setString(itemCounter++, item.getFirstName());
            stmt.setString(itemCounter++, item.getLastName());
            stmt.setString(itemCounter++, item.getPostalCode());
            stmt.setString(itemCounter++, item.getPackageType());
            stmt.setString(itemCounter++, item.getShipping());
            stmt.setString(itemCounter++, item.getState());
            stmt.setString(itemCounter++, item.getStreet1());
            stmt.setString(itemCounter++, item.getStreet2());
            stmt.setString(itemCounter++, item.getOrderID());
            stmt.setDouble(itemCounter++, item.getWeight());
            stmt.setDouble(itemCounter++, item.getPackedWeight());
            stmt.setString(itemCounter++, item.getErrorDetails());
            stmt.setString(itemCounter++, item.getActualErrorDetails());
            stmt.setString(itemCounter++, item.getTracking());
            stmt.setString(itemCounter++, item.getUrl());
            stmt.setString(itemCounter++, item.getStampsID());
            stmt.setBoolean(itemCounter++, item.isScan());
            stmt.setBoolean(itemCounter++, item.isError());
            stmt.setBoolean(itemCounter++, item.isCanceled());
            stmt.setBoolean(itemCounter++, item.isPrinted());
            stmt.setString(itemCounter++, item.getLabelInstructions());
            stmt.setDate(itemCounter++, dateEntered);
            stmt.setInt(itemCounter++, item.getCopies());
            stmt.setString(itemCounter++, item.getParentOrderID());
            stmt.setDouble(itemCounter++, item.getOrderTotal());
            stmt.setDate(itemCounter++, shipDate);
            stmt.setDouble(itemCounter++, item.getDeclaredWeight());
            stmt.setTimestamp(itemCounter++, printDate);
            stmt.setString(itemCounter++, item.getPaypalAccount());
            stmt.setInt(itemCounter++, item.getPrintID());
            stmt.setInt(itemCounter++, item.getPrintPage());
            stmt.executeUpdate();
            if (stmt != null && !stmt.isClosed()) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertRMADetails(RMADetails item, Connection sqlConnection, String table) throws Exception {
        Object object = _lock;
        synchronized (object) {
            int itemCounter = 1;
            String[] fields = new String[]{"RMAComments", "RMADate", "CustomerUserName", "OrderDetailsID", "ReplacementTracking", "ReturnTracking", "RmaNumberID", "RmaReasonID", "RmaStatusID"};
            String sql = this.createInsertSQL(table, fields);
            PreparedStatement stmt = sqlConnection.prepareStatement(sql);
            stmt.setString(itemCounter++, item.getRmaComments());
            stmt.setDate(itemCounter++, item.getRmaDate());
            stmt.setString(itemCounter++, item.getCustomerUsername());
            stmt.setInt(itemCounter++, item.getOrderDetailsID());
            stmt.setString(itemCounter++, item.getReplacementTracking());
            stmt.setString(itemCounter++, item.getReturnTracking());
            stmt.setInt(itemCounter++, item.getRmaNumberID());
            stmt.setInt(itemCounter++, item.getRmaReasonID());
            stmt.setInt(itemCounter++, item.getRmaStatusID());
            stmt.executeUpdate();
            if (stmt != null && !stmt.isClosed()) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertRMAReasons(RMAReason item, Connection sqlConnection, String table) throws Exception {
        Object object = _lock;
        synchronized (object) {
            int itemCounter = 1;
            String[] fields = new String[]{"RMAReasonType", "RMAReasonID"};
            String sql = this.createInsertSQL(table, fields);
            PreparedStatement stmt = sqlConnection.prepareStatement(sql);
            stmt.setString(itemCounter++, item.getRmaReasonType());
            stmt.setInt(itemCounter++, item.getRmaReasonID());
            stmt.executeUpdate();
            if (stmt != null && !stmt.isClosed()) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertRMAStatus(RMAStatus item, Connection sqlConnection, String table) throws Exception {
        Object object = _lock;
        synchronized (object) {
            int itemCounter = 1;
            String[] fields = new String[]{"RMAStatusID", "RMAStatusType"};
            String sql = this.createInsertSQL(table, fields);
            PreparedStatement stmt = sqlConnection.prepareStatement(sql);
            stmt.setInt(itemCounter++, item.getRmaStatusID());
            stmt.setString(itemCounter++, item.getRmaStatusType());
            stmt.executeUpdate();
            if (stmt != null && !stmt.isClosed()) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertSalesTax(SalesTax item, Connection sqlConnection, String table) throws Exception {
        Object object = _lock;
        synchronized (object) {
            int itemCounter = 1;
            String[] fields = new String[]{"Abbreviation", "Cost", "Enabled", "Identifier"};
            String sql = this.createInsertSQL(table, fields);
            PreparedStatement stmt = sqlConnection.prepareStatement(sql);
            stmt.setString(itemCounter++, item.getAbbreviation());
            stmt.setFloat(itemCounter++, item.getCost().floatValue());
            stmt.setBoolean(itemCounter++, item.isEnabled());
            stmt.setString(itemCounter++, item.getIdentifier());
            stmt.executeUpdate();
            if (stmt != null && !stmt.isClosed()) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertShippingMethods(ShippingMethod item, Connection sqlConnection, String table) throws Exception {
        Object object = _lock;
        synchronized (object) {
            int itemCounter = 1;
            String[] fields = new String[]{"DeliveryTimeMax", "DeliveryTimeMin", "ShippingMethodName"};
            String sql = this.createInsertSQL(table, fields);
            PreparedStatement stmt = sqlConnection.prepareStatement(sql);
            stmt.setInt(itemCounter++, item.getDeliveryTimeMax());
            stmt.setInt(itemCounter++, item.getDeliveryTimeMin());
            stmt.setString(itemCounter++, item.getShippingMethodName());
            stmt.executeUpdate();
            if (stmt != null && !stmt.isClosed()) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertSubscription(RESTData item, Connection sqlConnection, String table) throws Exception {
        Object object = _lock;
        synchronized (object) {
            int itemCounter = 1;
            String[] fields = new String[]{"UserName", "Finance", "Inventory", "Website", "Multi", "Paypal", "Print", "Current", "Expire", "Offline", "Timer", "Password", "License"};
            String sql = this.createInsertSQL(table, fields);
            PreparedStatement stmt = sqlConnection.prepareStatement(sql);
            stmt.setString(itemCounter++, item.getUserName());
            stmt.setBoolean(itemCounter++, item.isFinance());
            stmt.setBoolean(itemCounter++, item.isInventory());
            stmt.setBoolean(itemCounter++, item.isWebsite());
            stmt.setBoolean(itemCounter++, item.isMulti());
            stmt.setBoolean(itemCounter++, item.isPaypal());
            stmt.setBoolean(itemCounter++, item.isPrint());
            stmt.setBoolean(itemCounter++, item.isCurrent());
            stmt.setDate(itemCounter++, item.getExpire());
            stmt.setBoolean(itemCounter++, item.isOffline());
            stmt.setDate(itemCounter++, item.getTimer());
            stmt.setString(itemCounter++, item.getPassword());
            stmt.setString(itemCounter++, item.getLicense());
            stmt.executeUpdate();
            if (stmt != null && !stmt.isClosed()) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertWebsiteCategories(WebsiteCategories item, Connection sqlConnection, String table) throws Exception {
        Object object = _lock;
        synchronized (object) {
            int itemCounter = 1;
            String[] fields = new String[]{"WebsiteID", "WebsiteCategoriesID", "CategoryID"};
            String sql = this.createInsertSQL(table, fields);
            PreparedStatement stmt = sqlConnection.prepareStatement(sql);
            stmt.setInt(itemCounter++, item.getWebsiteID());
            stmt.setInt(itemCounter++, item.getWebsiteCategoriesID());
            stmt.setInt(itemCounter++, item.getCategoryID());
            stmt.executeUpdate();
            if (stmt != null && !stmt.isClosed()) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertWebsiteProducts(WebsiteElement item, Connection sqlConnection, String table) throws Exception {
        Object object = _lock;
        synchronized (object) {
            int itemCounter = 1;
            String[] fields = new String[]{"ItemID", "Oem", "Price", "PriceRetail", "BriefDescription", "Description", "Thumbnail", "Photo1", "Photo2", "Photo3", "CategoryID", "Keywords", "Enabled", "Featured"};
            String sql = this.createInsertSQL(table, fields);
            PreparedStatement stmt = sqlConnection.prepareStatement(sql);
            stmt.setString(itemCounter++, item.getItemID());
            stmt.setString(itemCounter++, item.getOem());
            stmt.setFloat(itemCounter++, item.getPrice());
            stmt.setFloat(itemCounter++, item.getPriceRetail());
            stmt.setString(itemCounter++, item.getBriefDescription());
            stmt.setString(itemCounter++, item.getDescription());
            stmt.setString(itemCounter++, item.getThumbnail());
            stmt.setString(itemCounter++, item.getPhoto1());
            stmt.setString(itemCounter++, item.getPhoto2());
            stmt.setString(itemCounter++, item.getPhoto3());
            stmt.setInt(itemCounter++, item.getCategoryID());
            stmt.setString(itemCounter++, item.getKeywords());
            stmt.setBoolean(itemCounter++, item.isEnabled());
            stmt.setBoolean(itemCounter++, item.isFeatured());
            stmt.executeUpdate();
            if (stmt != null && !stmt.isClosed()) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertWebsites(Website item, Connection sqlConnection, String table) throws Exception {
        Object object = _lock;
        synchronized (object) {
            int itemCounter = 1;
            String[] fields = new String[]{"LastUpdate", "WebsiteActive", "WebsiteID", "WebsiteName", "WebsiteURI"};
            String sql = this.createInsertSQL(table, fields);
            PreparedStatement stmt = sqlConnection.prepareStatement(sql);
            stmt.setLong(itemCounter++, item.getLastUpdate());
            stmt.setBoolean(itemCounter++, item.isWebsiteActive());
            stmt.setInt(itemCounter++, item.getWebsiteID());
            stmt.setString(itemCounter++, item.getWebsiteName());
            stmt.setString(itemCounter++, item.getWebsiteURI());
            stmt.executeUpdate();
            if (stmt != null && !stmt.isClosed()) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertProfiles(Profile item, Connection sqlConnection, String table) throws Exception {
        Object object = _lock;
        synchronized (object) {
            int itemCounter = 1;
            String[] fields = new String[]{"Profile"};
            String sql = this.createInsertSQL(table, fields);
            PreparedStatement stmt = sqlConnection.prepareStatement(sql);
            stmt.setString(itemCounter++, item.getProfile());
            stmt.executeUpdate();
            if (stmt != null && !stmt.isClosed()) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertPreferencePayPalAccounts(PreferencePayPalAccount item, Connection sqlConnection, String table) throws Exception {
        Object object = _lock;
        synchronized (object) {
            int itemCounter = 1;
            String[] fields = new String[]{"PayPalAccount"};
            String sql = this.createInsertSQL(table, fields);
            PreparedStatement stmt = sqlConnection.prepareStatement(sql);
            stmt.setString(itemCounter++, item.getPaypalAccount());
            stmt.executeUpdate();
            if (stmt != null && !stmt.isClosed()) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertCompanyLinks(CompanyLink item, Connection sqlConnection, String table) throws Exception {
        Object object = _lock;
        synchronized (object) {
            int itemCounter = 1;
            String[] fields = new String[]{"CompanyName", "PayPalLink"};
            String sql = this.createInsertSQL(table, fields);
            PreparedStatement stmt = sqlConnection.prepareStatement(sql);
            stmt.setString(itemCounter++, item.getCompanyName());
            stmt.setString(itemCounter++, item.getPaypalLink());
            stmt.executeUpdate();
            if (stmt != null && !stmt.isClosed()) {
                stmt.close();
            }
        }
    }
}

