/*
 * Decompiled with CFR 0.152.
 */
package pnp.services.sqlconversion;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import pnp.services.util.DatabaseConnector;
import pnp.services.util.ErrorsUtil;

public class SQLLoader {
    private static int VERSION = 1;

    public static void loadDatabase(Connection connection) {
        try {
            Statement stmt = connection.createStatement();
            SQLLoader.createTable(stmt, "Customers", "CustomerUserName", "VARCHAR(80)", "NOT NULL");
            SQLLoader.addColumn(stmt, "Customers", "CustomerEmail", "VARCHAR(80)");
            SQLLoader.addColumn(stmt, "Customers", "CustomerName", "VARCHAR(255)");
            SQLLoader.addColumn(stmt, "Customers", "CustomerCountry", "VARCHAR(32)");
            SQLLoader.addColumn(stmt, "Customers", "CustomerAddress", "VARCHAR(255)");
            SQLLoader.addColumn(stmt, "Customers", "CustomerCity", "VARCHAR(80)");
            SQLLoader.addColumn(stmt, "Customers", "CustomerState", "VARCHAR(32)");
            SQLLoader.addColumn(stmt, "Customers", "CustomerZipCode", "VARCHAR(12)");
            SQLLoader.addColumn(stmt, "Customers", "CustomerComments", "TEXT");
            SQLLoader.createTable(stmt, "Orders", "OrderID", "INTEGER", "NOT NULL AUTO_INCREMENT");
            SQLLoader.addColumn(stmt, "Orders", "CustomerUserName", "VARCHAR(80)");
            SQLLoader.addColumn(stmt, "Orders", "OrderDate", "DATE");
            SQLLoader.addColumn(stmt, "Orders", "OrderTotal", "FLOAT");
            SQLLoader.addColumn(stmt, "Orders", "ShippingMethodID", "VARCHAR(50)");
            SQLLoader.addColumn(stmt, "Orders", "ShippingCost", "FLOAT");
            SQLLoader.addColumn(stmt, "Orders", "ShippingPaid", "FLOAT");
            SQLLoader.addColumn(stmt, "Orders", "OrderStatusID", "INTEGER");
            SQLLoader.addColumn(stmt, "Orders", "OrderComments", "MEDIUMTEXT");
            SQLLoader.createTable(stmt, "ShippingMethods", "ShippingMethodName", "VARCHAR(32)", "NOT NULL");
            SQLLoader.addColumn(stmt, "ShippingMethods", "DeliveryTimeMin", "INTEGER");
            SQLLoader.addColumn(stmt, "ShippingMethods", "DeliveryTimeMax", "INTEGER");
            SQLLoader.createTable(stmt, "OrderDetails", "OrderDetailsID", "INTEGER", "NOT NULL AUTO_INCREMENT");
            SQLLoader.addColumn(stmt, "OrderDetails", "TransactionID", "VARCHAR(80)");
            SQLLoader.addColumn(stmt, "OrderDetails", "OrderID", "INTEGER");
            SQLLoader.addColumn(stmt, "OrderDetails", "OrderNumber", "VARCHAR(32)");
            SQLLoader.addColumn(stmt, "OrderDetails", "AccountName", "VARCHAR(32)");
            SQLLoader.addColumn(stmt, "OrderDetails", "Backordered", "BOOLEAN");
            SQLLoader.addColumn(stmt, "OrderDetails", "EbaySite", "VARCHAR(32)");
            SQLLoader.addColumn(stmt, "OrderDetails", "ItemCost", "FLOAT");
            SQLLoader.addColumn(stmt, "OrderDetails", "ShipDate", "DATE");
            SQLLoader.addColumn(stmt, "OrderDetails", "ItemID", "VARCHAR(80)");
            SQLLoader.addColumn(stmt, "OrderDetails", "OrderDescription", "VARCHAR(255)");
            SQLLoader.addColumn(stmt, "OrderDetails", "SalesPrice", "FLOAT");
            SQLLoader.addColumn(stmt, "OrderDetails", "Inhouse", "BOOLEAN");
            SQLLoader.addColumn(stmt, "OrderDetails", "Deleted", "BOOLEAN");
            SQLLoader.addColumn(stmt, "OrderDetails", "TrackingNumber", "VARCHAR(32) DEFAULT ''");
            SQLLoader.addColumn(stmt, "OrderDetails", "Carrier", "VARCHAR(32) DEFAULT ''");
            SQLLoader.addColumn(stmt, "OrderDetails", "EbayWeight", "FLOAT");
            SQLLoader.createTable(stmt, "OrderStatus", "OrderStatusID", "INTEGER", "NOT NULL AUTO_INCREMENT");
            SQLLoader.addColumn(stmt, "OrderStatus", "OrderStatusType", "VARCHAR(32)");
            SQLLoader.createTable(stmt, "Inventory", "InventoryID", "INTEGER", "NOT NULL AUTO_INCREMENT");
            SQLLoader.addColumn(stmt, "Inventory", "ItemID", "VARCHAR(80)");
            SQLLoader.addColumn(stmt, "Inventory", "ItemCost", "FLOAT");
            SQLLoader.addColumn(stmt, "Inventory", "ItemQuantity", "INTEGER");
            SQLLoader.addColumn(stmt, "Inventory", "OOSItem", "BOOLEAN");
            SQLLoader.addColumn(stmt, "Inventory", "StockDate", "DATE");
            SQLLoader.createTable(stmt, "Expenses", "ExpenseID", "INTEGER", "NOT NULL AUTO_INCREMENT");
            SQLLoader.addColumn(stmt, "Expenses", "ExpenseComment", "VARCHAR(255)");
            SQLLoader.addColumn(stmt, "Expenses", "ExpenseCost", "FLOAT");
            SQLLoader.addColumn(stmt, "Expenses", "ExpenseDate", "DATE");
            SQLLoader.addColumn(stmt, "Expenses", "ExpenseReasonID", "INTEGER");
            SQLLoader.addColumn(stmt, "Expenses", "ExpenseReason", "VARCHAR(32)");
            SQLLoader.addColumn(stmt, "Expenses", "CompanyName", "VARCHAR(150) DEFAULT 'Default'");
            SQLLoader.createTable(stmt, "Items", "ItemID", "VARCHAR(80)", "NOT NULL");
            SQLLoader.addColumn(stmt, "Items", "ItemName", "VARCHAR(255)");
            SQLLoader.addColumn(stmt, "Items", "ItemWeight", "FLOAT");
            SQLLoader.addColumn(stmt, "Items", "ItemDescription", "VARCHAR(255)");
            SQLLoader.addColumn(stmt, "Items", "DistributorID", "INTEGER");
            SQLLoader.addColumn(stmt, "Items", "DropShipped", "BOOLEAN");
            SQLLoader.addColumn(stmt, "Items", "Discontinued", "BOOLEAN");
            SQLLoader.addColumn(stmt, "Items", "Location", "VARCHAR(20)");
            SQLLoader.addColumn(stmt, "Items", "DistributorProductID", "VARCHAR(80)");
            SQLLoader.addColumn(stmt, "Items", "PackedWeight", "FLOAT DEFAULT '0.0'");
            SQLLoader.createTable(stmt, "Distributors", "DistributorID", "INTEGER", "NOT NULL AUTO_INCREMENT");
            SQLLoader.addColumn(stmt, "Distributors", "DistributorName", "VARCHAR(80)");
            SQLLoader.addColumn(stmt, "Distributors", "DistributorContact", "VARCHAR(80)");
            SQLLoader.addColumn(stmt, "Distributors", "DistributorPhone", "VARCHAR(32)");
            SQLLoader.addColumn(stmt, "Distributors", "DistributorEmail", "VARCHAR(80)");
            SQLLoader.addColumn(stmt, "Distributors", "DistributorWebsite", "VARCHAR(80)");
            SQLLoader.createTable(stmt, "WebsiteProducts", "ItemID", "VARCHAR(80)", "NOT NULL");
            SQLLoader.addColumn(stmt, "WebsiteProducts", "Oem", "VARCHAR(80)");
            SQLLoader.addColumn(stmt, "WebsiteProducts", "Price", "FLOAT");
            SQLLoader.addColumn(stmt, "WebsiteProducts", "PriceRetail", "FLOAT");
            SQLLoader.addColumn(stmt, "WebsiteProducts", "BriefDescription", "TEXT");
            SQLLoader.addColumn(stmt, "WebsiteProducts", "Description", "TEXT");
            SQLLoader.addColumn(stmt, "WebsiteProducts", "Thumbnail", "VARCHAR(80)");
            SQLLoader.addColumn(stmt, "WebsiteProducts", "Photo1", "VARCHAR(80)");
            SQLLoader.addColumn(stmt, "WebsiteProducts", "Photo2", "VARCHAR(80)");
            SQLLoader.addColumn(stmt, "WebsiteProducts", "Photo3", "VARCHAR(80)");
            SQLLoader.addColumn(stmt, "WebsiteProducts", "CategoryID", "INTEGER");
            SQLLoader.addColumn(stmt, "WebsiteProducts", "KeyWords", "TEXT");
            SQLLoader.addColumn(stmt, "WebsiteProducts", "Enabled", "BOOLEAN");
            SQLLoader.addColumn(stmt, "WebsiteProducts", "Featured", "BOOLEAN");
            SQLLoader.createTable(stmt, "WebsiteCategories", "WebsiteCategoriesID", "INTEGER", "NOT NULL AUTO_INCREMENT");
            SQLLoader.addColumn(stmt, "WebsiteCategories", "WebsiteID", "INTEGER");
            SQLLoader.addColumn(stmt, "WebsiteCategories", "CategoryID", "INTEGER");
            SQLLoader.createTable(stmt, "Categories", "CategoryID", "INTEGER", "NOT NULL AUTO_INCREMENT");
            SQLLoader.addColumn(stmt, "Categories", "CategoryName", "VARCHAR(80)");
            SQLLoader.createTable(stmt, "Websites", "WebsiteID", "INTEGER", "NOT NULL AUTO_INCREMENT");
            SQLLoader.addColumn(stmt, "Websites", "WebsiteName", "VARCHAR(80)");
            SQLLoader.addColumn(stmt, "Websites", "WebsiteURI", "VARCHAR(255)");
            SQLLoader.addColumn(stmt, "Websites", "WebsiteActive", "BOOLEAN");
            SQLLoader.addColumn(stmt, "Websites", "LastUpdate", "LONG");
            SQLLoader.createTable(stmt, "ExpenseReasons", "ExpenseReasonID", "INTEGER", "NOT NULL AUTO_INCREMENT");
            SQLLoader.addColumn(stmt, "ExpenseReasons", "Reason", "VARCHAR(80)");
            SQLLoader.createTable(stmt, "SalesTax", "Abbreviation", "VARCHAR(2)", "NOT NULL");
            SQLLoader.addColumn(stmt, "SalesTax", "Identifier", "VARCHAR(32)");
            SQLLoader.addColumn(stmt, "SalesTax", "Cost", "FLOAT DEFAULT '0.0'");
            SQLLoader.addColumn(stmt, "SalesTax", "Enabled", "BOOLEAN DEFAULT '0'");
            SQLLoader.createTable(stmt, "CustomFees", "CustomFeeID", "INTEGER", "NOT NULL AUTO_INCREMENT");
            SQLLoader.addColumn(stmt, "CustomFees", "CustomFeeName", "VARCHAR(32)");
            SQLLoader.addColumn(stmt, "CustomFees", "CustomFeePercentage", "DOUBLE");
            SQLLoader.addColumn(stmt, "CustomFees", "CustomFeeFlatCost", "DOUBLE");
            SQLLoader.createTable(stmt, "RMADetails", "RmaNumberID", "INTEGER", "NOT NULL AUTO_INCREMENT");
            SQLLoader.addColumn(stmt, "RMADetails", "RMAComments", "TEXT");
            SQLLoader.addColumn(stmt, "RMADetails", "RMADate", "DATE");
            SQLLoader.addColumn(stmt, "RMADetails", "CustomerUserName", "VARCHAR(80)");
            SQLLoader.addColumn(stmt, "RMADetails", "OrderDetailsID", "INTEGER");
            SQLLoader.addColumn(stmt, "RMADetails", "ReplacementTracking", "VARCHAR(32)");
            SQLLoader.addColumn(stmt, "RMADetails", "ReturnTracking", "VARCHAR(32)");
            SQLLoader.addColumn(stmt, "RMADetails", "RmaReasonID", "INTEGER");
            SQLLoader.addColumn(stmt, "RMADetails", "RmaStatusID", "INTEGER");
            SQLLoader.createTable(stmt, "RMAReason", "RMAReasonID", "INTEGER", "NOT NULL AUTO_INCREMENT");
            SQLLoader.addColumn(stmt, "RMAReason", "RMAReasonType", "VARCHAR(32)");
            SQLLoader.createTable(stmt, "RMAStatus", "RMAStatusID", "INTEGER", "NOT NULL AUTO_INCREMENT");
            SQLLoader.addColumn(stmt, "RMAStatus", "RMAStatusType", "VARCHAR(32)");
            SQLLoader.createTable(stmt, "PaypalTransactions", "PayPalTransactionID", "VARCHAR(80)", "NOT NULL");
            SQLLoader.addColumn(stmt, "PaypalTransactions", "EmailAddress", "VARCHAR(80)");
            SQLLoader.addColumn(stmt, "PaypalTransactions", "FirstName", "VARCHAR(80)");
            SQLLoader.addColumn(stmt, "PaypalTransactions", "LastName", "VARCHAR(80)");
            SQLLoader.addColumn(stmt, "PaypalTransactions", "CountryCode", "VARCHAR(3)");
            SQLLoader.addColumn(stmt, "PaypalTransactions", "CountryName", "VARCHAR(80)");
            SQLLoader.addColumn(stmt, "PaypalTransactions", "Street1", "VARCHAR(150)");
            SQLLoader.addColumn(stmt, "PaypalTransactions", "Street2", "VARCHAR(150)");
            SQLLoader.addColumn(stmt, "PaypalTransactions", "CityName", "VARCHAR(80)");
            SQLLoader.addColumn(stmt, "PaypalTransactions", "StateOrProvince", "VARCHAR(128)");
            SQLLoader.addColumn(stmt, "PaypalTransactions", "PostalCode", "VARCHAR(20)");
            SQLLoader.addColumn(stmt, "PaypalTransactions", "TransactionType", "VARCHAR(80)");
            SQLLoader.addColumn(stmt, "PaypalTransactions", "PaymentType", "VARCHAR(80)");
            SQLLoader.addColumn(stmt, "PaypalTransactions", "PaymentDate", "VARCHAR(80)");
            SQLLoader.addColumn(stmt, "PaypalTransactions", "GrossAmount", "FLOAT");
            SQLLoader.addColumn(stmt, "PaypalTransactions", "PaymentStatus", "VARCHAR(80)");
            SQLLoader.addColumn(stmt, "PaypalTransactions", "ShippingMethod", "VARCHAR(80)");
            SQLLoader.addColumn(stmt, "PaypalTransactions", "Custom", "VARCHAR(128)");
            SQLLoader.addColumn(stmt, "PaypalTransactions", "Memo", "TEXT");
            SQLLoader.addColumn(stmt, "PaypalTransactions", "BuyerID", "VARCHAR(80)");
            SQLLoader.addColumn(stmt, "PaypalTransactions", "ClosingDate", "VARCHAR(80)");
            SQLLoader.addColumn(stmt, "PaypalTransactions", "MultiItem", "VARCHAR(80)");
            SQLLoader.addColumn(stmt, "PaypalTransactions", "Linked", "BOOLEAN");
            SQLLoader.addColumn(stmt, "PaypalTransactions", "Tax", "FLOAT");
            SQLLoader.addColumn(stmt, "PaypalTransactions", "CurrencyCode", "VARCHAR(10)");
            SQLLoader.addColumn(stmt, "PaypalTransactions", "ShippingAmount", "FLOAT");
            SQLLoader.addColumn(stmt, "PaypalTransactions", "PayPalAccount", "VARCHAR(150)");
            SQLLoader.createTable(stmt, "EbayTransactions", "EbayTransactionID", "VARCHAR(80)", "NOT NULL", "PaypalTransactions", "PayPalTransactionID", "VARCHAR(80)");
            SQLLoader.addColumn(stmt, "EbayTransactions", "AuctionName", "VARCHAR(256)");
            SQLLoader.addColumn(stmt, "EbayTransactions", "Quantity", "INTEGER");
            SQLLoader.addColumn(stmt, "EbayTransactions", "Cost", "FLOAT");
            SQLLoader.addColumn(stmt, "EbayTransactions", "ReferenceNumber", "VARCHAR(32)");
            SQLLoader.createTable(stmt, "PrintDetails", "OrderID", "VARCHAR(32)", "NOT NULL");
            SQLLoader.addColumn(stmt, "PrintDetails", "Customer", "VARCHAR(128)");
            SQLLoader.addColumn(stmt, "PrintDetails", "Email", "VARCHAR(256)");
            SQLLoader.addColumn(stmt, "PrintDetails", "FirstName", "VARCHAR(50)");
            SQLLoader.addColumn(stmt, "PrintDetails", "LastName", "VARCHAR(50)");
            SQLLoader.addColumn(stmt, "PrintDetails", "Street1", "VARCHAR(150)");
            SQLLoader.addColumn(stmt, "PrintDetails", "Street2", "VARCHAR(150)");
            SQLLoader.addColumn(stmt, "PrintDetails", "CountryCode", "VARCHAR(2)");
            SQLLoader.addColumn(stmt, "PrintDetails", "City", "VARCHAR(32)");
            SQLLoader.addColumn(stmt, "PrintDetails", "State", "VARCHAR(40)");
            SQLLoader.addColumn(stmt, "PrintDetails", "PostalCode", "VARCHAR(20)");
            SQLLoader.addColumn(stmt, "PrintDetails", "Weight", "DOUBLE");
            SQLLoader.addColumn(stmt, "PrintDetails", "ShippingType", "VARCHAR(150)");
            SQLLoader.addColumn(stmt, "PrintDetails", "PackageType", "VARCHAR(150)");
            SQLLoader.addColumn(stmt, "PrintDetails", "IndiciumID", "TEXT");
            SQLLoader.addColumn(stmt, "PrintDetails", "StampsID", "VARCHAR(80)");
            SQLLoader.addColumn(stmt, "PrintDetails", "Tracking", "VARCHAR(80)");
            SQLLoader.addColumn(stmt, "PrintDetails", "URL", "MEDIUMTEXT");
            SQLLoader.addColumn(stmt, "PrintDetails", "Cost", "DOUBLE");
            SQLLoader.addColumn(stmt, "PrintDetails", "Scan", "BOOLEAN");
            SQLLoader.addColumn(stmt, "PrintDetails", "Error", "BOOLEAN");
            SQLLoader.addColumn(stmt, "PrintDetails", "Canceled", "BOOLEAN");
            SQLLoader.addColumn(stmt, "PrintDetails", "Printed", "BOOLEAN");
            SQLLoader.addColumn(stmt, "PrintDetails", "LabelInstructions", "TEXT");
            SQLLoader.addColumn(stmt, "PrintDetails", "DateEntered", "DATE");
            SQLLoader.addColumn(stmt, "PrintDetails", "Copies", "INTEGER");
            SQLLoader.addColumn(stmt, "PrintDetails", "ParentOrderID", "VARCHAR(32)");
            SQLLoader.addColumn(stmt, "PrintDetails", "OrderTotal", "DOUBLE");
            SQLLoader.addColumn(stmt, "PrintDetails", "ShipDate", "DATE");
            SQLLoader.addColumn(stmt, "PrintDetails", "PackedWeight", "DOUBLE");
            SQLLoader.addColumn(stmt, "PrintDetails", "ActualErrorDetails", "TEXT");
            SQLLoader.addColumn(stmt, "PrintDetails", "DeclaredValue", "DOUBLE");
            SQLLoader.addColumn(stmt, "PrintDetails", "PrintDate", "TIMESTAMP");
            SQLLoader.addColumn(stmt, "PrintDetails", "PrintID", "INTEGER");
            SQLLoader.addColumn(stmt, "PrintDetails", "PrintPage", "INTEGER");
            SQLLoader.addColumn(stmt, "PrintDetails", "PayPalAccount", "VARCHAR(150)");
            SQLLoader.createTable(stmt, "CheckDetails", "CheckID", "INTEGER", "NOT NULL AUTO_INCREMENT", "PrintDetails", "OrderID", "VARCHAR(32)");
            SQLLoader.addColumn(stmt, "CheckDetails", "OrderDetailsID", "INTEGER");
            SQLLoader.addColumn(stmt, "CheckDetails", "Weight", "FLOAT");
            SQLLoader.addColumn(stmt, "CheckDetails", "PackedWeight", "FLOAT");
            SQLLoader.addColumn(stmt, "CheckDetails", "PayPalAccount", "VARCHAR(150)");
            SQLLoader.createTable(stmt, "AccountPreferences", "GenProfile", "VARCHAR(128)", "NOT NULL");
            SQLLoader.createTable(stmt, "Profiles", "Profile", "VARCHAR(128)", "NOT NULL");
            SQLLoader.addColumn(stmt, "AccountPreferences", "GenNegativeNotification", "BOOLEAN");
            SQLLoader.addColumn(stmt, "AccountPreferences", "GenRefreshBehavior", "BOOLEAN");
            SQLLoader.addColumn(stmt, "AccountPreferences", "GenSalesPeriod", "INTEGER");
            SQLLoader.addColumn(stmt, "AccountPreferences", "GenStockNotification", "INTEGER");
            SQLLoader.addColumn(stmt, "AccountPreferences", "GenTrackingNotify", "BOOLEAN");
            SQLLoader.addColumn(stmt, "AccountPreferences", "GenUnmergeNotify", "BOOLEAN");
            SQLLoader.addColumn(stmt, "AccountPreferences", "GenBusinessName", "VARCHAR(128)");
            SQLLoader.addColumn(stmt, "AccountPreferences", "GenInvoiceComments", "TEXT");
            SQLLoader.addColumn(stmt, "AccountPreferences", "GenWebsiteAddress", "VARCHAR(128)");
            SQLLoader.addColumn(stmt, "AccountPreferences", "GenVersion", "INTEGER");
            SQLLoader.addColumn(stmt, "AccountPreferences", "GenSyncNotification", "BOOLEAN DEFAULT '1'");
            SQLLoader.addColumn(stmt, "AccountPreferences", "GenSplitRefresh", "BOOLEAN");
            SQLLoader.addColumn(stmt, "AccountPreferences", "GenInventoryRefresh", "BOOLEAN");
            SQLLoader.addColumn(stmt, "AccountPreferences", "GenBetaUpdates", "BOOLEAN");
            SQLLoader.addColumn(stmt, "AccountPreferences", "SubOfflineMode", "BOOLEAN");
            SQLLoader.addColumn(stmt, "AccountPreferences", "SubSaveCredentials", "BOOLEAN");
            SQLLoader.addColumn(stmt, "AccountPreferences", "SubLicense", "VARCHAR(128)");
            SQLLoader.addColumn(stmt, "AccountPreferences", "SubMessage", "TEXT");
            SQLLoader.addColumn(stmt, "AccountPreferences", "SubPassword", "VARCHAR(128)");
            SQLLoader.addColumn(stmt, "AccountPreferences", "SubUsername", "VARCHAR(128)");
            SQLLoader.addColumn(stmt, "AccountPreferences", "EbayLastUpdate", "LONG");
            SQLLoader.addColumn(stmt, "AccountPreferences", "PaypalAutoLink", "BOOLEAN");
            SQLLoader.addColumn(stmt, "AccountPreferences", "PaypalDomesticAddon", "DOUBLE");
            SQLLoader.addColumn(stmt, "AccountPreferences", "PaypalDomesticFee", "DOUBLE");
            SQLLoader.addColumn(stmt, "AccountPreferences", "PaypalInternationalAddon", "DOUBLE");
            SQLLoader.addColumn(stmt, "AccountPreferences", "PaypalInternationalFee", "DOUBLE");
            SQLLoader.addColumn(stmt, "AccountPreferences", "PaypalLastUpdate", "LONG");
            SQLLoader.addColumn(stmt, "AccountPreferences", "StampsSaveCredentials", "BOOLEAN");
            SQLLoader.addColumn(stmt, "AccountPreferences", "StampsSignatureConfirm", "BOOLEAN");
            SQLLoader.addColumn(stmt, "AccountPreferences", "StampsAddress", "VARCHAR(128)");
            SQLLoader.addColumn(stmt, "AccountPreferences", "StampsCity", "VARCHAR(128)");
            SQLLoader.addColumn(stmt, "AccountPreferences", "StampsCountry", "VARCHAR(2)");
            SQLLoader.addColumn(stmt, "AccountPreferences", "StampsFullName", "VARCHAR(128)");
            SQLLoader.addColumn(stmt, "AccountPreferences", "StampsImageLocation", "VARCHAR(128)");
            SQLLoader.addColumn(stmt, "AccountPreferences", "StampsPassword", "VARCHAR(128)");
            SQLLoader.addColumn(stmt, "AccountPreferences", "StampsPhoneNumber", "VARCHAR(128)");
            SQLLoader.addColumn(stmt, "AccountPreferences", "StampsPostalCode", "VARCHAR(5)");
            SQLLoader.addColumn(stmt, "AccountPreferences", "StampsState", "VARCHAR(2)");
            SQLLoader.addColumn(stmt, "AccountPreferences", "StampsUsername", "VARCHAR(128)");
            SQLLoader.addColumn(stmt, "AccountPreferences", "StampsLabelStatus", "VARCHAR(128)");
            SQLLoader.addColumn(stmt, "AccountPreferences", "StampsPrintLabels", "BOOLEAN");
            SQLLoader.addColumn(stmt, "AccountPreferences", "StampsPurchaseLabels", "BOOLEAN");
            SQLLoader.addColumn(stmt, "AccountPreferences", "StampsSaveLabels", "BOOLEAN");
            SQLLoader.addColumn(stmt, "AccountPreferences", "StampsTracking", "BOOLEAN");
            SQLLoader.addColumn(stmt, "AccountPreferences", "StampsPrintOptions", "VARCHAR(20)");
            SQLLoader.addColumn(stmt, "AccountPreferences", "StampsPageOptions", "VARCHAR(20)");
            SQLLoader.addColumn(stmt, "AccountPreferences", "StampsHideNotification", "BOOLEAN");
            SQLLoader.addColumn(stmt, "AccountPreferences", "StampsStorageDays", "INTEGER");
            SQLLoader.addColumn(stmt, "AccountPreferences", "StampsDateNotification", "BOOLEAN");
            SQLLoader.addColumn(stmt, "AccountPreferences", "StampsPackedWeight", "BOOLEAN");
            SQLLoader.addColumn(stmt, "AccountPreferences", "StampsAutoPurchase", "BOOLEAN");
            SQLLoader.addColumn(stmt, "AccountPreferences", "StampsAutoPurchaseLimit", "FLOAT");
            SQLLoader.addColumn(stmt, "AccountPreferences", "StampsAutoPurchaseWarning", "BOOLEAN");
            SQLLoader.addColumn(stmt, "AccountPreferences", "StampsInvalidPackageNotification", "BOOLEAN");
            SQLLoader.addColumn(stmt, "AccountPreferences", "StampsPurchaseDateNotification", "BOOLEAN");
            SQLLoader.addColumn(stmt, "AccountPreferences", "StampsComments", "BOOLEAN");
            SQLLoader.addColumn(stmt, "AccountPreferences", "StampsNIAFilter", "BOOLEAN");
            SQLLoader.addColumn(stmt, "AccountPreferences", "StampsMixedInventoryNotification", "BOOLEAN");
            SQLLoader.addColumn(stmt, "AccountPreferences", "StampsAccount", "VARCHAR(80)");
            SQLLoader.addColumn(stmt, "AccountPreferences", "StampsEndiciaUsername", "VARCHAR(80)");
            SQLLoader.addColumn(stmt, "AccountPreferences", "StampsEndiciaPassword", "VARCHAR(80)");
            SQLLoader.addColumn(stmt, "AccountPreferences", "StampsUPSUsername", "VARCHAR(80)");
            SQLLoader.addColumn(stmt, "AccountPreferences", "StampsUPSPassword", "VARCHAR(80)");
            SQLLoader.addColumn(stmt, "AccountPreferences", "StampsUPSAccessKey", "VARCHAR(80)");
            SQLLoader.addColumn(stmt, "AccountPreferences", "StampsUPSAccountNumber", "VARCHAR(80)");
            SQLLoader.addColumn(stmt, "AccountPreferences", "StampsCommercialPlus", "BOOLEAN");
            SQLLoader.addColumn(stmt, "AccountPreferences", "CompanyDefaultCompany", "VARCHAR(150) DEFAULT 'Default'");
            SQLLoader.createTable(stmt, "PayPalAccounts", "PayPalAccount", "VARCHAR(128)", "NOT NULL");
            SQLLoader.addColumn(stmt, "Orders", "OrderPaypal", "VARCHAR(128) DEFAULT 'Default'");
            SQLLoader.createTable(stmt, "Companies", "CompanyName", "VARCHAR(128)", "NOT NULL");
            SQLLoader.addColumn(stmt, "Companies", "CompanyWebsite", "VARCHAR(128)");
            SQLLoader.addColumn(stmt, "Companies", "CompanyComments", "VARCHAR(128)");
            SQLLoader.addColumn(stmt, "Companies", "CompanyAddress", "VARCHAR(128)");
            SQLLoader.addColumn(stmt, "Companies", "CompanyCity", "VARCHAR(128)");
            SQLLoader.addColumn(stmt, "Companies", "CompanyCountry", "VARCHAR(2)");
            SQLLoader.addColumn(stmt, "Companies", "CompanyFullName", "VARCHAR(128)");
            SQLLoader.addColumn(stmt, "Companies", "CompanyPhoneNumber", "VARCHAR(128)");
            SQLLoader.addColumn(stmt, "Companies", "CompanyPostalCode", "VARCHAR(5)");
            SQLLoader.addColumn(stmt, "Companies", "CompanyState", "VARCHAR(2)");
            SQLLoader.createTable(stmt, "CompanyLinks", "PayPalLink", "VARCHAR(128)", "NOT NULL");
            SQLLoader.addColumn(stmt, "CompanyLinks", "CompanyName", "VARCHAR(128)");
            SQLLoader.createTable(stmt, "License", "License", "VARCHAR(80)", "NOT NULL");
            SQLLoader.createTable(stmt, "EbayAccount", "EbayAccountNumber", "INTEGER", "NOT NULL AUTO_INCREMENT");
            SQLLoader.addColumn(stmt, "EbayAccount", "EbayAccountID", "VARCHAR(80)");
            SQLLoader.addColumn(stmt, "EbayAccount", "UserToken", "TEXT");
            SQLLoader.addColumn(stmt, "EbayAccount", "UserName", "VARCHAR(80) NOT NULL");
            SQLLoader.createTable(stmt, "PaypalAccount", "PaypalAccountNumber", "INTEGER", "NOT NULL AUTO_INCREMENT");
            SQLLoader.addColumn(stmt, "PaypalAccount", "PaypalAccountID", "VARCHAR(80)");
            SQLLoader.addColumn(stmt, "PaypalAccount", "AccessToken", "TEXT");
            SQLLoader.addColumn(stmt, "PaypalAccount", "TokenSecret", "TEXT");
            SQLLoader.addColumn(stmt, "PaypalAccount", "UserName", "VARCHAR(80) NOT NULL");
            SQLLoader.createTable(stmt, "AmazonAccount", "AmazonAccountNumber", "INTEGER", "NOT NULL AUTO_INCREMENT");
            SQLLoader.addColumn(stmt, "AmazonAccount", "AmazonAccountID", "VARCHAR(80)");
            SQLLoader.addColumn(stmt, "AmazonAccount", "UserToken", "TEXT");
            SQLLoader.addColumn(stmt, "AmazonAccount", "UserName", "VARCHAR(80) NOT NULL");
            SQLLoader.createTable(stmt, "Subscription", "UserName", "VARCHAR(80)", "NOT NULL");
            SQLLoader.addColumn(stmt, "Subscription", "Password", "VARCHAR(80)");
            SQLLoader.addColumn(stmt, "Subscription", "Finance", "BOOLEAN");
            SQLLoader.addColumn(stmt, "Subscription", "Inventory", "BOOLEAN");
            SQLLoader.addColumn(stmt, "Subscription", "Website", "BOOLEAN");
            SQLLoader.addColumn(stmt, "Subscription", "Multi", "BOOLEAN");
            SQLLoader.addColumn(stmt, "Subscription", "Paypal", "BOOLEAN");
            SQLLoader.addColumn(stmt, "Subscription", "Print", "BOOLEAN");
            SQLLoader.addColumn(stmt, "Subscription", "Current", "BOOLEAN");
            SQLLoader.addColumn(stmt, "Subscription", "Offline", "BOOLEAN");
            SQLLoader.addColumn(stmt, "Subscription", "Expire", "DATE");
            SQLLoader.addColumn(stmt, "Subscription", "Timer", "DATE");
            SQLLoader.addColumn(stmt, "Subscription", "License", "VARCHAR(128)");
            SQLLoader.createTable(stmt, "ETSYACCOUNTS", "EtsyStore", "VARCHAR(128)", "NOT NULL");
            SQLLoader.addColumn(stmt, "ETSYACCOUNTS", "Token", "VARCHAR(128)");
            SQLLoader.addColumn(stmt, "ETSYACCOUNTS", "TokenSecret", "VARCHAR(128)");
            SQLLoader.createIndexes("", stmt);
            SQLLoader.updateDatabase(stmt);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private static ResultSet executeQuery(String sql, Statement stmt) {
        return DatabaseConnector.createStatementResultSet(stmt, sql, "DBLoaderExecuteQuery");
    }

    private static void executeUpdate(String sql, Statement stmt) {
        try {
            stmt.executeUpdate(sql);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private static void alterTable(String sql, Statement stmt, String table, String column, String type) {
        sql = "ALTER TABLE " + table + " ALTER COLUMN " + column + " " + type;
        SQLLoader.executeUpdate(sql, stmt);
    }

    private static void updateDatabase(Statement stmt) {
        try {
            int Version = 0;
            String sql = "SELECT GenVersion FROM AccountPreferences";
            ResultSet rs = SQLLoader.executeQuery(sql, stmt);
            if (rs != null && rs.next()) {
                Version = rs.getInt("GenVersion");
            }
            if (Version <= 0) {
                // empty if block
            }
            Version = 1;
            sql = "UPDATE AccountPreferences SET GenVersion = " + Version;
            SQLLoader.executeUpdate(sql, stmt);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private static void addColumn(Statement stmt, String table, String column, String type) {
        try {
            String sql = "ALTER TABLE " + table + " ADD " + column + " " + type;
            stmt.executeUpdate(sql);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private static void createTable(Statement stmt, String table, String column, String type, String addon) {
        try {
            String sql = "CREATE TABLE IF NOT EXISTS " + table + "(" + column + " " + type + " " + addon + ", " + "PRIMARY KEY(" + column + "))";
            stmt.executeUpdate(sql);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private static void createTable(Statement stmt, String table, String primaryKey, String primaryKeyType, String addon, String foreignTable, String foreignKey, String foreignType) {
        try {
            String sql = "CREATE TABLE IF NOT EXISTS " + table + " (" + primaryKey + " " + primaryKeyType + " " + addon + ", " + foreignKey + " " + foreignType + ", " + "foreign key(" + foreignKey + ") references " + foreignTable + "(" + foreignKey + "), " + "Primary key(" + primaryKey + "))";
            stmt.executeUpdate(sql);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private static void createShipping(String sql, Statement stmt, String name, String min, String max) {
        try {
            sql = "UPDATE ShippingMethods SET ShippingMethodName='" + name + "', " + "DeliveryTimeMin=" + min + ", DeliveryTimeMax=" + max + " " + " WHERE ShippingMethodName='" + name + "'";
            stmt.executeUpdate(sql);
            if (0 == stmt.getUpdateCount()) {
                sql = "INSERT INTO ShippingMethods  (ShippingMethodName, DeliveryTimeMin, DeliveryTimeMax) Values ('" + name + "', " + min + ", " + max + ")";
                stmt.executeUpdate(sql);
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private static void createOrder(String sql, Statement stmt, String name) {
        try {
            sql = "UPDATE OrderStatus SET OrderStatusType='" + name + "' " + " WHERE OrderStatusType='" + name + "'";
            stmt.executeUpdate(sql);
            if (0 == stmt.getUpdateCount()) {
                sql = "INSERT INTO OrderStatus  (OrderStatusType) Values ('" + name + "')";
                stmt.executeUpdate(sql);
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private static void createRMAReason(String sql, Statement stmt, String name) {
        try {
            sql = "UPDATE RMAReason SET RMAReasonType='" + name + "' " + " WHERE RMAReasonType='" + name + "'";
            stmt.executeUpdate(sql);
            if (0 == stmt.getUpdateCount()) {
                sql = "INSERT INTO RMAReason (RMAReasonType) Values ('" + name + "')";
                stmt.executeUpdate(sql);
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private static void createRMAStatus(String sql, Statement stmt, String name) {
        try {
            sql = "UPDATE RMAStatus SET RMAStatusType='" + name + "' " + " WHERE RMAStatusType='" + name + "'";
            stmt.executeUpdate(sql);
            if (0 == stmt.getUpdateCount()) {
                sql = "INSERT INTO RMAStatus (RMAStatusType) Values ('" + name + "')";
                stmt.executeUpdate(sql);
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private static void createDistributor(String sql, Statement stmt, String name) {
        try {
            sql = "INSERT INTO Distributors (DistributorName) Values ('" + name + "')";
            stmt.executeUpdate(sql);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private static void createCustomFee(String sql, Statement stmt, String name, String percent, String flatCost) {
        try {
            sql = "INSERT INTO CustomFees (CustomFeeName, CustomFeePercentage, CustomFeeFlatCost) Values ('" + name + "', " + percent + ", " + flatCost + ")";
            stmt.executeUpdate(sql);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private static void defaultValues(String sql, Statement stmt) {
        SQLLoader.createShipping(sql, stmt, "Standard", "5", "12");
        SQLLoader.createShipping(sql, stmt, "Expedited", "3", "6");
        SQLLoader.createShipping(sql, stmt, "2-Day", "1", "3");
        SQLLoader.createOrder(sql, stmt, "New");
        SQLLoader.createOrder(sql, stmt, "Pending");
        SQLLoader.createOrder(sql, stmt, "Pending Print");
        SQLLoader.createOrder(sql, stmt, "Print");
        SQLLoader.createOrder(sql, stmt, "Export Labels");
        SQLLoader.createOrder(sql, stmt, "Pending MO");
        SQLLoader.createOrder(sql, stmt, "Pending E-Check");
        SQLLoader.createOrder(sql, stmt, "OOS");
        SQLLoader.createOrder(sql, stmt, "NPB");
        SQLLoader.createOrder(sql, stmt, "Canceled");
        SQLLoader.createOrder(sql, stmt, "Complete");
        SQLLoader.createOrder(sql, stmt, "Admin Hold");
        SQLLoader.createRMAReason(sql, stmt, "");
        SQLLoader.createRMAReason(sql, stmt, "Defective");
        SQLLoader.createRMAReason(sql, stmt, "Wrong Item");
        SQLLoader.createRMAReason(sql, stmt, "Changed Mind");
        SQLLoader.createRMAReason(sql, stmt, "Wrong Size");
        SQLLoader.createRMAStatus(sql, stmt, "New RMA");
        SQLLoader.createRMAStatus(sql, stmt, "Pending Response");
        SQLLoader.createRMAStatus(sql, stmt, "Exchanging");
        SQLLoader.createRMAStatus(sql, stmt, "Return Label Issued");
        SQLLoader.createRMAStatus(sql, stmt, "Returning");
        SQLLoader.createRMAStatus(sql, stmt, "Return Processed");
        SQLLoader.createRMAStatus(sql, stmt, "Reshipped");
        SQLLoader.createRMAStatus(sql, stmt, "Refunded");
        SQLLoader.createCustomFee(sql, stmt, "EBay Standard", "0.09", "0.00");
        SQLLoader.createCustomFee(sql, stmt, "EBay TRS 20%", "0.072", "0.00");
        SQLLoader.createDistributor(sql, stmt, "Default");
        SQLLoader.createIndexes(sql, stmt);
        try {
            ArrayList<String> States = SQLLoader.fillStates();
            for (String state : States) {
                sql = "INSERT INTO SalesTax(Abbreviation) Values ('" + state + "')";
                stmt.executeUpdate(sql);
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private static void createIndexes(String sql, Statement stmt) {
        try {
            sql = "CREATE INDEX INDEX_TRANSACTIONIDIDX ON OrderDetails(TransactionID)";
            stmt.executeUpdate(sql);
            sql = "CREATE INDEX INDEX_EXPENSESIDX ON Expenses(ExpenseDate, ExpenseReasonID)";
            stmt.executeUpdate(sql);
            sql = "CREATE INDEX  INDEX_EbayTransactionsIDX ON EbayTransactions(PaypalTransactionID)";
            stmt.executeUpdate(sql);
            sql = "CREATE INDEX  INDEX_ORDERSIDX ON Orders(OrderStatusID, OrderDate)";
            stmt.executeUpdate(sql);
            sql = "CREATE INDEX  INDEX_CUSTOMERSIDX ON Customers(CustomerEmail)";
            stmt.executeUpdate(sql);
            sql = "CREATE INDEX  INDEX_DISTRIBUTORSIDX ON Distributors(DistributorName)";
            stmt.executeUpdate(sql);
            sql = "CREATE INDEX  INDEX_INVENTORY_ITEMID_IDX ON Inventory(ItemID)";
            stmt.executeUpdate(sql);
            sql = "CREATE INDEX  INDEX_INVENTORY_ITEMNAME_IDX ON Items(ItemName)";
            stmt.executeUpdate(sql);
            sql = "CREATE INDEX  INDEX_INVENTORY_ITEMDESCRIPTION_IDX ON Items(ItemDescription)";
            stmt.executeUpdate(sql);
            sql = "CREATE INDEX  INDEX_INVENTORY_ITEMLOCATION_IDX ON Items(Location)";
            stmt.executeUpdate(sql);
            sql = "CREATE INDEX  INDEX_INVENTORY_ITEMDISTRIBUTOR_IDX ON Items(DistributorProductID)";
            stmt.executeUpdate(sql);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private static ArrayList<String> fillStates() {
        ArrayList<String> States = new ArrayList<String>();
        States.add("AL");
        States.add("AK");
        States.add("AZ");
        States.add("AR");
        States.add("CA");
        States.add("CO");
        States.add("CT");
        States.add("DE");
        States.add("FL");
        States.add("GA");
        States.add("HI");
        States.add("ID");
        States.add("IL");
        States.add("IN");
        States.add("IA");
        States.add("KS");
        States.add("KY");
        States.add("LA");
        States.add("ME");
        States.add("MD");
        States.add("MA");
        States.add("MI");
        States.add("MN");
        States.add("MS");
        States.add("MO");
        States.add("MT");
        States.add("NE");
        States.add("NV");
        States.add("NH");
        States.add("NJ");
        States.add("NM");
        States.add("NY");
        States.add("NC");
        States.add("ND");
        States.add("OH");
        States.add("OK");
        States.add("OR");
        States.add("PA");
        States.add("RI");
        States.add("SC");
        States.add("SD");
        States.add("TN");
        States.add("TX");
        States.add("UT");
        States.add("VT");
        States.add("VA");
        States.add("WA");
        States.add("WV");
        States.add("WI");
        States.add("WY");
        return States;
    }
}

