/*
 * Decompiled with CFR 0.152.
 */
package pnp.services.table;

import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import pnp.services.constants.FrameConstants;
import pnp.services.datatypes.ChangedCell;
import pnp.services.datatypes.CompleteOrder;
import pnp.services.preferencemanager.Preferences;
import pnp.services.table.FormattedXTable;
import pnp.services.util.ErrorsUtil;
import pnp.services.util.MathParser;

public class CellColorRenderer
extends DefaultTableCellRenderer {
    private boolean verified;
    private Set<CompleteOrder> _savedOrders;
    private HashMap<Integer, CompleteOrder> tableRows;
    private FormattedXTable formattedTable;
    private boolean completeImportPressed;
    private HashMap<String, ChangedCell> _validCellChanges;
    private HashMap<String, ChangedCell> _invalidCellChanges;

    private void reset() {
        this.verified = true;
        this.completeImportPressed = false;
        this._savedOrders = null;
        this.tableRows = null;
        this.formattedTable = null;
        this._validCellChanges = new HashMap();
        this._invalidCellChanges = new HashMap();
    }

    public CellColorRenderer(FormattedXTable parent) {
        this.reset();
        this.formattedTable = parent;
    }

    private void genericColoring(boolean hasFocus, boolean isSelected, int row) {
        this.setForeground(Color.black);
        if (hasFocus) {
            this.setBackground(new Color(FrameConstants.ROW_COLOR_1));
        } else if (isSelected) {
            this.setBackground(new Color(FrameConstants.SELECTED_ROW));
        } else if (row % 2 == 0) {
            this.setBackground(new Color(FrameConstants.ROW_COLOR_1));
        } else {
            this.setBackground(new Color(FrameConstants.ROW_COLOR_2));
        }
    }

    private void genericChangedCellColoring(int row, int columnChanged) {
        ChangedCell cell = this.checkInvalidCell(row, columnChanged);
        if (null != cell) {
            this.setForeground(Color.red);
        } else {
            cell = this.checkValidCell(this.formattedTable.convertRow(row), columnChanged);
            if (null != cell) {
                this.setForeground(new Color(FrameConstants.CHANGED_CELL));
            }
        }
    }

    private void specificColoring(boolean hasFocus, int row, int column) {
        int columnChanged = this.formattedTable.convertColumn(column);
        String columnName = this.formattedTable.getColumnMap().get(columnChanged);
        if (this.formattedTable.getLocalSettingsID().equalsIgnoreCase("CreateOrder")) {
            if ((columnName.equalsIgnoreCase("Wholesale $") || columnName.equalsIgnoreCase("Retail $")) && !this.checkDollarAmount(row, columnName)) {
                this.setBackground(Color.red);
            }
        } else if (!this.formattedTable.getLocalSettingsID().equalsIgnoreCase("CustomsSkuTable")) {
            if (this.formattedTable.getLocalSettingsID().equalsIgnoreCase("CustomsTable")) {
                if (columnChanged == this.formattedTable.getReverseColumnMap().get("Description") && this.formattedTable.getValue(row, "Description").isEmpty() && !this.verified) {
                    this.setBackground(Color.RED);
                }
            } else if (this.formattedTable.getLocalSettingsID().equalsIgnoreCase("InventoryImport")) {
                if (this.completeImportPressed && !this.validateRow(row, column)) {
                    this.setBackground(Color.RED);
                }
            } else if (!this.formattedTable.getLocalSettingsID().equalsIgnoreCase("InventoryManager") && !this.formattedTable.getLocalSettingsID().equalsIgnoreCase("InventoryOOS")) {
                if (this.formattedTable.getLocalSettingsID().equalsIgnoreCase("OrderSelection")) {
                    if (this._savedOrders != null && !this._savedOrders.isEmpty() && this.tableRows != null && !this.tableRows.isEmpty() && this._savedOrders.contains(this.tableRows.get(row))) {
                        this.setBackground(Color.GREEN);
                    }
                } else if (!this.formattedTable.getLocalSettingsID().equalsIgnoreCase("PaypalManager") && !this.formattedTable.getLocalSettingsID().equalsIgnoreCase("PaypalSelection")) {
                    if (this.formattedTable.getLocalSettingsID().equalsIgnoreCase("PrintManager")) {
                        if (!hasFocus && (columnName.equalsIgnoreCase("Weight") && !Preferences.getInstance().getAccountPreferences().isStampsPackedWeight() || columnName.equalsIgnoreCase("Packed Weight") && Preferences.getInstance().getAccountPreferences().isStampsPackedWeight())) {
                            this.setBackground(new Color(FrameConstants.SELECTED_ROW));
                        }
                    } else if (!this.formattedTable.getLocalSettingsID().equalsIgnoreCase("PrintManagerSKU")) {
                        if (this.formattedTable.getLocalSettingsID().equalsIgnoreCase("RMAManager")) {
                            if (columnName.equalsIgnoreCase("RMA Date") || columnName.equalsIgnoreCase("RMA Reason") || columnName.equalsIgnoreCase("RMA Status")) {
                                this.genericChangedCellColoring(row, columnChanged);
                            }
                        } else if (this.formattedTable.getLocalSettingsID().equalsIgnoreCase("ReorderForm")) {
                            if (!hasFocus && columnName.equalsIgnoreCase("Restock Amount")) {
                                this.setBackground(new Color(FrameConstants.SELECTED_ROW));
                            }
                        } else if (this.formattedTable.getLocalSettingsID().equalsIgnoreCase("WebsiteManager")) {
                            this.genericChangedCellColoring(row, columnChanged);
                        }
                    }
                }
            }
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.genericColoring(hasFocus, isSelected, row);
        this.specificColoring(hasFocus, row, column);
        return c;
    }

    private boolean validateRow(int row, int column) {
        String value = this.formattedTable.getValue(row, column);
        column = this.formattedTable.convertColumn(column);
        boolean valid = false;
        if (value.toString() != null && !value.toString().isEmpty()) {
            valid = true;
            if (column != this.formattedTable.getReverseColumnMap().get("Item ID") && column != this.formattedTable.getReverseColumnMap().get("Item Name") && column != this.formattedTable.getReverseColumnMap().get("Location") && column != this.formattedTable.getReverseColumnMap().get("Reference ID") && column != this.formattedTable.getReverseColumnMap().get("Distributor") && column != this.formattedTable.getReverseColumnMap().get("Inventory")) {
                try {
                    valid = Float.parseFloat(value.toString()) >= 0.0f;
                }
                catch (Exception ex) {
                    ErrorsUtil.getInstance().logError(ex);
                    valid = false;
                }
            }
        }
        if (valid && value.toString().length() > 20) {
            if (column == this.formattedTable.getReverseColumnMap().get("Location")) {
                valid = false;
            } else if (value.toString().length() > 80) {
                if (column == this.formattedTable.getReverseColumnMap().get("Reference ID") || column == this.formattedTable.getReverseColumnMap().get("Item ID")) {
                    valid = false;
                } else if (value.toString().length() > 255 && column == this.formattedTable.getReverseColumnMap().get("Item Name")) {
                    valid = false;
                }
            }
        }
        return valid;
    }

    private boolean checkDollarAmount(int row, String column) {
        String amount = this.formattedTable.getValue(row, column);
        if (null != amount) {
            if (amount.isEmpty()) {
                amount = "0.00";
            }
            amount = this.isDollarAmount(amount);
        }
        return amount != null;
    }

    private String isDollarAmount(String input) {
        try {
            input = input.replace("$", "");
            input = input.trim();
            input = String.valueOf((float)MathParser.processEquation(input));
            Double.parseDouble(input);
            input = input.trim();
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
            input = null;
        }
        return input;
    }

    public boolean isVerified() {
        return this.verified;
    }

    public void setVerified(boolean verified) {
        this.verified = verified;
    }

    public Set<CompleteOrder> getSavedOrders() {
        return this._savedOrders;
    }

    public void setSavedOrders(Set<CompleteOrder> _savedOrders) {
        this._savedOrders = _savedOrders;
    }

    public HashMap<Integer, CompleteOrder> getTableRows() {
        return this.tableRows;
    }

    public void setTableRows(HashMap<Integer, CompleteOrder> tableRows) {
        this.tableRows = tableRows;
    }

    public boolean isCompleteImportPressed() {
        return this.completeImportPressed;
    }

    public void setCompleteImportPressed(boolean completeImportPressed) {
        this.completeImportPressed = completeImportPressed;
    }

    private String getUpdatedCellKey(int row, int column) {
        return "Row" + row + "Column" + column;
    }

    private ChangedCell checkValidCell(int row, int column) {
        return this._validCellChanges.get(this.getUpdatedCellKey(row, column));
    }

    private ChangedCell checkInvalidCell(int row, int column) {
        return this._invalidCellChanges.get(this.getUpdatedCellKey(row, column));
    }

    public void setValidCellChanges(HashMap<String, ChangedCell> _validCellChanges) {
        this._validCellChanges = _validCellChanges;
    }

    public void setInvalidCellChanges(HashMap<String, ChangedCell> _invalidCellChanges) {
        this._invalidCellChanges = _invalidCellChanges;
    }
}

