/*
 * Decompiled with CFR 0.152.
 */
package pnp.services.table;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import pnp.services.constants.FrameConstants;
import pnp.services.preferencemanager.Preferences;
import pnp.services.util.ErrorsUtil;

public class CheckBoxRenderer
extends JCheckBox
implements TableCellRenderer {
    private boolean useMasterColumn;
    private int masterColumn;
    private int alternateColumn;
    private boolean alternate;
    private boolean isStamps;
    private boolean isCustoms;
    private DefaultTableModel tableModel;
    private boolean verified;

    private void reset() {
        this.alternate = false;
        this.useMasterColumn = false;
        this.isStamps = false;
        this.isCustoms = false;
        this.tableModel = null;
        this.masterColumn = -1;
        this.alternateColumn = -1;
        this.verified = true;
    }

    public CheckBoxRenderer(boolean value) {
        super("", value);
        this.reset();
    }

    public CheckBoxRenderer(boolean value, int weight, int packedWeight) {
        super("", value);
        this.reset();
        this.useMasterColumn = true;
        this.isStamps = true;
        this.masterColumn = weight;
        this.alternateColumn = packedWeight;
    }

    public CheckBoxRenderer(boolean value, int masterRow) {
        super("", value);
        this.reset();
        this.useMasterColumn = true;
        this.isStamps = true;
        this.masterColumn = masterRow;
    }

    public CheckBoxRenderer(boolean value, DefaultTableModel tableModel, int errorRow) {
        super("", value);
        this.reset();
        this.isCustoms = true;
        this.tableModel = tableModel;
        this.masterColumn = errorRow;
    }

    @Override
    public void updateUI() {
        super.updateUI();
    }

    @Override
    public void revalidate() {
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        boolean selected = false;
        try {
            selected = value != null && (Boolean)value != false;
        }
        catch (Exception ex) {
            selected = false;
            ErrorsUtil.getInstance().logError(ex);
        }
        this.setSelected(selected);
        this.setHorizontalAlignment(0);
        if (this.isStamps) {
            this.selectMasterRow();
        }
        int columnChanged = table.convertColumnIndexToModel(column);
        this.setForeground(Color.black);
        if (hasFocus) {
            this.setBackground(new Color(FrameConstants.ROW_COLOR_1));
        } else if (isSelected || this.useMasterColumn && columnChanged == this.masterColumn) {
            this.setBackground(new Color(FrameConstants.SELECTED_ROW));
        } else if (row % 2 == 0) {
            this.setBackground(new Color(FrameConstants.ROW_COLOR_1));
        } else {
            this.setBackground(new Color(FrameConstants.ROW_COLOR_2));
        }
        if (this.isCustoms && columnChanged == this.masterColumn && this.tableModel.getValueAt(row, this.masterColumn).toString().isEmpty() && !this.verified) {
            this.setBackground(Color.red);
        }
        return this;
    }

    private void selectMasterRow() {
        if (!this.alternate && Preferences.getInstance().getAccountPreferences().isStampsPackedWeight() || this.alternate && !Preferences.getInstance().getAccountPreferences().isStampsPackedWeight()) {
            int temp = this.masterColumn;
            this.masterColumn = this.alternateColumn;
            this.alternateColumn = temp;
            this.alternate = !this.alternate;
        }
    }

    public boolean isVerified() {
        return this.verified;
    }

    public void setVerified(boolean verified) {
        this.verified = verified;
    }
}

