/*
 * Decompiled with CFR 0.152.
 */
package pnp.services.table;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import pnp.services.table.FormattedXTable;
import pnp.services.util.ErrorsUtil;

public class CopyPastaCell
implements KeyListener {
    FormattedXTable xTable;
    private boolean ctrlPressed;

    public CopyPastaCell(FormattedXTable xTable) {
        this.xTable = xTable;
        this.ctrlPressed = false;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        try {
            if (e.isControlDown() || e.getKeyCode() == 17) {
                this.ctrlPressed = true;
            }
            if (this.ctrlPressed && e.getKeyCode() == 67 && this.xTable.getFormattedTable().getSelectedRows().length == 1 && this.xTable.getFormattedTable().getSelectedColumns().length == 1) {
                String copyString = this.xTable.getValue(this.xTable.getFormattedTable().getSelectedRow(), this.xTable.getFormattedTable().getSelectedColumn());
                StringSelection stringSelection = new StringSelection(copyString);
                Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
                clpbrd.setContents(stringSelection, null);
                e.consume();
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        try {
            if (e.isControlDown() || e.getKeyCode() == 17) {
                this.ctrlPressed = false;
                e.consume();
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }
}

