/*
 * Decompiled with CFR 0.152.
 */
package pnp.services.table;

import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SortOrder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnExt;
import pnp.services.datatypes.PrintDetails;
import pnp.services.db.DBServices;
import pnp.services.listener.ClosingListener;
import pnp.services.listenermanager.ListenerManager;
import pnp.services.localsettings.LocalSettings;
import pnp.services.table.CellColorRenderer;
import pnp.services.table.CheckBoxRenderer;
import pnp.services.table.CopyPastaCell;
import pnp.services.table.FormattedTableCellEditor;
import pnp.services.table.HiddenColumnModelListener;
import pnp.services.table.StatusComboBoxEditor;
import pnp.services.table.StatusComboBoxRenderer;
import pnp.services.table.XTable;
import pnp.services.util.ErrorsUtil;

public class FormattedXTable
extends JPanel
implements ClosingListener {
    public static final String PRINTMANAGER = "PrintManager";
    public static final String INVENTORYIMPORT = "InventoryImport";
    public static final String INVENTORYMANAGER = "InventoryManager";
    public static final String INVENTORYOOS = "InventoryOOS";
    public static final String CREATEORDER = "CreateOrder";
    public static final String PAYPALSELECTION = "PaypalSelection";
    public static final String ORDERSELECTION = "OrderSelection";
    public static final String PAYPALMANAGER = "PaypalManager";
    public static final String PAYPALDETAILSMANAGER = "PaypalDetailsManager";
    public static final String CUSTOMSTABLE = "CustomsTable";
    public static final String CUSTOMSSKUTABLE = "CustomsSkuTable";
    public static final String PRINTMANAGERSKU = "PrintManagerSKU";
    public static final String ORDERMANAGER = "OrderManager";
    public static final String ITEMFINDER = "ITEMFINDER";
    public static final String MASSEDIT = "MASSEDIT";
    public static final String RMAMANAGER = "RMAManager";
    public static final String REORDERFORM = "ReorderForm";
    public static final String WEBSITEMANAGER = "WebsiteManager";
    public static final String SALESHISTORYFORM = "SalesHistoryForm";
    public static final String RETURNFORM = "ReturnForm";
    private HashMap<String, PrintDetails> printList;
    private DefaultTableModel tableModel;
    private TableColumnModel columnModel;
    private HashMap<Integer, String> columnMap;
    private HashMap<String, Integer> reverseColumnMap;
    private String localSettingsID;
    private CellColorRenderer renderer;
    private DBServices dbServices;
    private String[] hiddenColumns;
    private XTable formattedTable;
    private JScrollPane jScrollPane1;

    public FormattedXTable() {
        this.initComponents();
        this.basicInit();
    }

    private void basicInit() {
        ListenerManager.getInstance().subscribe(this);
        this.tableModel = (DefaultTableModel)this.formattedTable.getModel();
        this.columnModel = this.formattedTable.getColumnModel();
        this.columnMap = new HashMap();
        this.reverseColumnMap = new HashMap();
        this.renderer = new CellColorRenderer(this);
        this.formattedTable.setDefaultRenderer(Object.class, this.renderer);
        this.formattedTable.putClientProperty("useDTCRColorMemoryHack", null);
        this.formattedTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.formattedTable.setShowGrid(false);
        this.formattedTable.setSortsOnUpdates(false);
    }

    public void init(String[] columns, String localSettingsID, String[] hiddenColumns) {
        this.localSettingsID = localSettingsID;
        this.createTable(columns);
        this.formattedTable.getColumnModel().addColumnModelListener(new HiddenColumnModelListener(this.columnMap, this.formattedTable, localSettingsID));
        for (int column : this.reverseColumnMap.values()) {
            this.columnModel.getColumn(column).setCellEditor(new FormattedTableCellEditor());
        }
        this.hiddenColumns = hiddenColumns;
        this.formattedTable.addKeyListener(new CopyPastaCell(this));
    }

    public DBServices getDbServices() {
        return this.dbServices;
    }

    public HashMap<String, PrintDetails> getPrintList() {
        return this.printList;
    }

    public void setPrintList(HashMap<String, PrintDetails> printList) {
        this.printList = printList;
    }

    public CellColorRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(CellColorRenderer renderer) {
        this.renderer = renderer;
        this.formattedTable.setDefaultRenderer(Object.class, renderer);
    }

    public void removeColumn(String column) {
        this.columnMap.remove(this.reverseColumnMap.get(column));
        this.reverseColumnMap.remove(column);
        TableColumn col = this.columnModel.getColumn(this.columnModel.getColumnIndex(column));
        this.columnModel.removeColumn(col);
    }

    public DefaultTableModel getTableModel() {
        return this.tableModel;
    }

    public TableColumnModel getColumnModel() {
        return this.columnModel;
    }

    public HashMap<Integer, String> getColumnMap() {
        return this.columnMap;
    }

    public HashMap<String, Integer> getReverseColumnMap() {
        return this.reverseColumnMap;
    }

    public String getLocalSettingsID() {
        return this.localSettingsID;
    }

    public JXTable getFormattedTable() {
        return this.formattedTable;
    }

    public void createTable(String[] columns) {
        boolean first = true;
        for (String column : columns) {
            this.addColumn(column);
            if (first) {
                this.formattedTable.setSortOrder(column, SortOrder.DESCENDING);
            }
            first = false;
        }
    }

    private String getValue(Object value) {
        if (value != null) {
            return value.toString().trim();
        }
        return null;
    }

    public String getValue(int row, String column) {
        if (row == -1 || column == null || !this.reverseColumnMap.containsKey(column)) {
            return null;
        }
        try {
            return this.getValue(this.tableModel.getValueAt(this.convertRow(row), this.reverseColumnMap.get(column)));
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
            return null;
        }
    }

    public String getValue(int row, int column) {
        if (row == -1 || column == -1) {
            return null;
        }
        try {
            return this.getValue(this.tableModel.getValueAt(this.convertRow(row), this.convertColumn(column)));
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
            return null;
        }
    }

    public void setValue(Object value, int row, String column) {
        if (row != -1) {
            this.tableModel.setValueAt(value, this.convertRow(row), this.reverseColumnMap.get(column));
        }
    }

    public void setValue(Object value, int row, int column) {
        if (row != -1) {
            this.tableModel.setValueAt(value, this.convertRow(row), this.convertColumn(column));
        }
    }

    public int convertRow(int row) {
        if (row == -1) {
            return -1;
        }
        int convertedRow = this.formattedTable.convertRowIndexToModel(row);
        return convertedRow;
    }

    public int convertColumn(int column) {
        int convertedColumn = this.formattedTable.convertColumnIndexToModel(column);
        return convertedColumn;
    }

    public void createCheckBox(String column) {
        JCheckBox checkBox = new JCheckBox();
        checkBox.setHorizontalAlignment(0);
        TableColumn col = this.columnModel.getColumn(this.columnModel.getColumnIndex(column));
        col.setCellEditor(new DefaultCellEditor(checkBox));
        col.setCellRenderer(new CheckBoxRenderer(false));
    }

    public void overwriteCellEditor(String column, TableCellEditor cellEditor) {
        TableColumn col = this.columnModel.getColumn(this.columnModel.getColumnIndex(column));
        col.setCellEditor(cellEditor);
    }

    public void overwriteCellRenderer(String column, TableCellRenderer cellRenderer) {
        TableColumn col = this.columnModel.getColumn(this.columnModel.getColumnIndex(column));
        col.setCellRenderer(cellRenderer);
    }

    public void overwriteCellDefault(String column, String[] items) {
        TableColumn col = this.columnModel.getColumn(this.columnModel.getColumnIndex(column));
        col.setCellEditor(new StatusComboBoxEditor(items));
        col.setCellRenderer(new StatusComboBoxRenderer(items));
    }

    private void addColumn(String columnName) {
        int size = this.columnMap.size();
        this.tableModel.addColumn(columnName);
        this.columnMap.put(size, columnName);
        this.reverseColumnMap.put(columnName, size);
    }

    public void loadSavedSettings() {
        if (LocalSettings.getInstance().getPropertyValue(this.localSettingsID + "Columns") == null) {
            this.hideCells(this.hiddenColumns);
            this.formattedTable.packAll();
        }
        for (String hiddenColumn : LocalSettings.getInstance().getHiddenField(this.localSettingsID + "Columns")) {
            TableColumnExt tableColumn = this.formattedTable.getColumnExt(hiddenColumn);
            if (null == tableColumn) continue;
            tableColumn.setVisible(false);
        }
        for (String columnWidth : LocalSettings.getInstance().getHiddenField(this.localSettingsID + "ColumnWidths")) {
            try {
                String[] columnWidthPairing = columnWidth.split(":");
                this.columnModel.getColumn(this.columnModel.getColumnIndex(columnWidthPairing[0])).setPreferredWidth(Integer.valueOf(columnWidthPairing[1]));
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
    }

    public void showCells(String[] hiddenColumns) {
        if (hiddenColumns != null) {
            for (String hiddenColumn : hiddenColumns) {
                TableColumnExt tableColumn = this.formattedTable.getColumnExt(hiddenColumn);
                if (null == tableColumn) continue;
                tableColumn.setVisible(true);
            }
        }
    }

    public void hideCells(String[] hiddenColumns) {
        if (hiddenColumns != null) {
            for (String hiddenColumn : hiddenColumns) {
                TableColumnExt tableColumn = this.formattedTable.getColumnExt(hiddenColumn);
                if (null == tableColumn) continue;
                tableColumn.setVisible(false);
            }
        }
    }

    @Override
    public void programClosed() {
        ArrayList<String> columnWidthList = new ArrayList<String>();
        for (String column : this.columnMap.values()) {
            try {
                columnWidthList.add(column + ":" + this.columnModel.getColumn(this.columnModel.getColumnIndex(column)).getPreferredWidth());
            }
            catch (Exception ex) {}
        }
        LocalSettings.getInstance().setHiddenField(this.localSettingsID + "ColumnWidths", columnWidthList);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.formattedTable = new XTable(this);
        this.formattedTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.formattedTable.setColumnControlVisible(true);
        this.jScrollPane1.setViewportView((Component)((Object)this.formattedTable));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 300, Short.MAX_VALUE));
    }
}

