/*
 * Decompiled with CFR 0.152.
 */
package pnp.services.table;

import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnExt;
import pnp.services.localsettings.LocalSettings;

public class HiddenColumnModelListener
implements TableColumnModelListener {
    private HashMap<Integer, String> columnMap;
    private JXTable formattedTable;
    private String localSettingsID;

    public HiddenColumnModelListener(HashMap<Integer, String> columnMap, JXTable formattedTable, String localSettingsID) {
        this.columnMap = columnMap;
        this.formattedTable = formattedTable;
        this.localSettingsID = localSettingsID;
    }

    @Override
    public void columnAdded(TableColumnModelEvent e) {
        ArrayList<String> hiddenColumns = new ArrayList<String>();
        for (int i = 0; i < this.formattedTable.getColumnCount(true); ++i) {
            TableColumn column = (TableColumn)this.formattedTable.getColumns(true).get(i);
            if (((TableColumnExt)column).isVisible()) continue;
            hiddenColumns.add(this.columnMap.get(i));
        }
        LocalSettings.getInstance().setHiddenField(this.localSettingsID + "Columns", hiddenColumns);
    }

    @Override
    public void columnRemoved(TableColumnModelEvent e) {
        ArrayList<String> hiddenColumns = new ArrayList<String>();
        for (int i = 0; i < this.formattedTable.getColumnCount(true); ++i) {
            TableColumn column = (TableColumn)this.formattedTable.getColumns(true).get(i);
            if (((TableColumnExt)column).isVisible()) continue;
            hiddenColumns.add(this.columnMap.get(i));
        }
        LocalSettings.getInstance().setHiddenField(this.localSettingsID + "Columns", hiddenColumns);
    }

    @Override
    public void columnMoved(TableColumnModelEvent e) {
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent e) {
    }
}

