/*
 * Decompiled with CFR 0.152.
 */
package pnp.services.table;

import org.jdesktop.swingx.JXTable;
import pnp.services.datatypes.PrintDetails;
import pnp.services.table.FormattedXTable;

public class XTable
extends JXTable {
    private FormattedXTable child;

    public XTable(FormattedXTable child) {
        this.child = child;
    }

    public boolean isCellEditable(int row, int column) {
        if (this.isEditable()) {
            if (row != -1 && column != -1) {
                column = this.child.convertColumn(column);
                if (this.child.getLocalSettingsID().equalsIgnoreCase("PrintManager")) {
                    if (this.child.getValue(row, "City").equalsIgnoreCase("APO")) {
                        String value = this.child.getValue(row, "OrderID");
                        PrintDetails detail = this.child.getPrintList().get(value.toString());
                        String street1 = this.child.getValue(row, "Street1");
                        String street2 = this.child.getValue(row, "Street2");
                        if (!street2.isEmpty()) {
                            street1 = street1 + " " + street2;
                            street2 = "";
                            this.child.setValue((Object)street1, row, "Street1");
                            this.child.setValue((Object)street2, row, "Street2");
                            detail.setStreet1(street1);
                            detail.setStreet2(street2);
                            this.child.getDbServices().insertPrintDetails(detail);
                        }
                        if (column == this.child.getReverseColumnMap().get("Street2")) {
                            return false;
                        }
                    }
                } else if (this.child.getLocalSettingsID().equalsIgnoreCase("RMAManager")) {
                    return column == this.child.getReverseColumnMap().get("RMA Status") || column == this.child.getReverseColumnMap().get("RMA Reason") || column == this.child.getReverseColumnMap().get("RMA Date");
                }
            }
            return true;
        }
        return false;
    }
}

