/*
 * Decompiled with CFR 0.152.
 */
package pnp.services.util;

import java.awt.Desktop;
import java.io.File;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import pnp.services.util.ErrorsUtil;

public class CreationTools {
    private static final String doubleSlash = "\\";
    public static final String carriageReturn = "\r\n";

    public static File createFileSpace(String originLocation, String mainFolder, String fileName, String filetype) {
        File parent;
        if (originLocation == null || originLocation.trim().isEmpty()) {
            originLocation = System.getProperty("user.dir");
        }
        originLocation = originLocation + doubleSlash;
        File targetFile = null;
        Date today = new Date();
        SimpleDateFormat subFolderFormat = new SimpleDateFormat("MM-dd");
        SimpleDateFormat yearFormat = new SimpleDateFormat("YYYY");
        String year = yearFormat.format(today);
        String subFolder = doubleSlash + subFolderFormat.format(today) + doubleSlash;
        if (!mainFolder.trim().isEmpty()) {
            mainFolder = mainFolder + doubleSlash;
        }
        if (!(parent = (targetFile = new File(originLocation + mainFolder + year + subFolder + fileName + "." + filetype)).getParentFile()).exists() && !parent.mkdirs()) {
            System.out.println("Could not create.");
        }
        return targetFile;
    }

    public static void openWebsiteAction(String website) {
        try {
            URI uri = new URI(website);
            Desktop.getDesktop().browse(uri);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private static String getBaseDirectory() {
        return System.getProperty("user.dir") + doubleSlash;
    }

    private static String getYear() {
        Date today = new Date();
        SimpleDateFormat yearFormat = new SimpleDateFormat("YYYY");
        String year = yearFormat.format(today);
        return year + doubleSlash;
    }

    private static String getMonth() {
        Date today = new Date();
        SimpleDateFormat subFolderFormat = new SimpleDateFormat("MM");
        String month = subFolderFormat.format(today);
        return month + doubleSlash;
    }

    private static String getDay() {
        Date today = new Date();
        SimpleDateFormat subFolderFormat = new SimpleDateFormat("dd");
        String day = subFolderFormat.format(today);
        return day + doubleSlash;
    }

    private static String getMonthDay() {
        Date today = new Date();
        SimpleDateFormat subFolderFormat = new SimpleDateFormat("MM-dd");
        String monthDay = subFolderFormat.format(today);
        return monthDay + doubleSlash;
    }

    public static File createFileSpace(String outputFolder, String outputFile, String fileType, boolean useMainFolder, boolean useYear, boolean useMonth, boolean useDay, boolean looped) {
        String directory = "";
        if (useMainFolder) {
            directory = directory + CreationTools.getBaseDirectory();
        }
        directory = directory + outputFolder + doubleSlash;
        if (useYear) {
            directory = directory + CreationTools.getYear();
        }
        if (useMonth && useDay) {
            directory = directory + CreationTools.getMonthDay();
        }
        if (useMonth && !useDay) {
            directory = directory + CreationTools.getMonth();
        }
        if (useDay && !useMonth) {
            directory = directory + CreationTools.getDay();
        }
        directory = directory + outputFile;
        return CreationTools.createFileSpace(directory, fileType, looped);
    }

    private static File createFileSpace(String filePath, String fileType, boolean looped) {
        if (looped) {
            return CreationTools.createFileSpace(filePath, fileType, looped, false);
        }
        return CreationTools.createFileSpace(filePath, fileType);
    }

    private static File createFileSpace(String filePath, String fileType, boolean looped, boolean difference) {
        File targetFile = null;
        int number = 0;
        do {
            String newFilePath = number == 0 ? filePath : filePath + "-" + number;
            targetFile = CreationTools.createFileSpace(newFilePath, fileType);
            ++number;
        } while (targetFile == null || targetFile.exists());
        return targetFile;
    }

    private static File createFileSpace(String filePath, String fileType) {
        File targetFile = new File(filePath + "." + fileType);
        File parent = targetFile.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            System.out.println("Could not create.");
        }
        return targetFile;
    }
}

