/*
 * Decompiled with CFR 0.152.
 */
package pnp.services.util;

import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Stack;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import pnp.services.localsettings.LocalSettings;
import pnp.services.sqlconversion.CollectFromDatabase;
import pnp.services.util.ErrorsUtil;

public class DatabaseConnector {
    public static boolean usingSQLDB = false;
    public static Connection dbConnection = null;
    private static boolean initiatedShutdown = false;
    private static Stack stack = new Stack();
    private static boolean holdStack = false;

    public static Connection selectDatabase() {
        if (!initiatedShutdown) {
            String usingMYSQL = LocalSettings.getInstance().getPropertyValue("SQLDatabaseExists");
            try {
                if (dbConnection == null || dbConnection.isClosed()) {
                    if (usingMYSQL == null || usingMYSQL.equalsIgnoreCase("true") || usingMYSQL.trim().isEmpty()) {
                        dbConnection = CollectFromDatabase.getMYSQLConnection();
                    }
                    if (dbConnection == null) {
                        if (usingMYSQL == null || usingMYSQL.equalsIgnoreCase("false") || usingMYSQL.trim().isEmpty()) {
                            dbConnection = DatabaseConnector.getH2Connection();
                            usingSQLDB = false;
                        }
                    } else {
                        LocalSettings.getInstance().writeProperties("SQLDatabaseExists", "TRUE");
                        usingSQLDB = true;
                    }
                    if (dbConnection != null) {
                        dbConnection.setAutoCommit(true);
                    }
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (dbConnection == null) {
                String databaseError = "Could not connect to a database. Please restart Gamut and try again.\n";
                if (usingMYSQL != null) {
                    databaseError = usingMYSQL.equalsIgnoreCase("TRUE") ? databaseError + "Make sure your SQL server is running before trying again.\n" : databaseError + "Make sure the H2 database is not open in another program.\n";
                } else {
                    databaseError = databaseError + "If using SQL Server: Make sure your SQL server is running before trying again.\n";
                    databaseError = databaseError + "If using H2 Embedded: Make sure the H2 database is not open in another program.\n";
                }
                JOptionPane.showMessageDialog(null, databaseError);
                initiatedShutdown = true;
                Runtime.getRuntime().exit(0);
            }
        }
        return dbConnection;
    }

    public static synchronized ResultSet createGeneratedKeys(Statement stmt, String origin) {
        ResultSet rs = null;
        try {
            if (stmt != null && !stmt.isClosed()) {
                rs = stmt.getGeneratedKeys();
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        if (rs != null) {
            stack.push("Create Generated Keys - " + origin);
        }
        return rs;
    }

    public static synchronized Statement createStatement(String origin) {
        Statement stmt = null;
        try {
            DatabaseConnector.selectDatabase();
            if (dbConnection != null) {
                stmt = dbConnection.createStatement();
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        if (stmt != null) {
            stack.push("Create Statement - " + origin);
        }
        return stmt;
    }

    public static synchronized PreparedStatement createPreparedStatement(String sql, String origin) {
        PreparedStatement stmt = null;
        try {
            DatabaseConnector.selectDatabase();
            if (dbConnection != null) {
                stmt = dbConnection.prepareStatement(sql);
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        if (stmt != null) {
            stack.push("Create Prepared Statement - " + origin);
        }
        return stmt;
    }

    public static synchronized int executeUpdate(Statement stmt, String sql) throws Exception {
        if (stmt != null && !stmt.isClosed() && sql != null && !sql.isEmpty()) {
            return stmt.executeUpdate(sql);
        }
        return 0;
    }

    public static synchronized int executeUpdate(PreparedStatement stmt) throws Exception {
        if (stmt != null && !stmt.isClosed()) {
            return stmt.executeUpdate();
        }
        return 0;
    }

    public static synchronized PreparedStatement createPreparedStatement(String sql, int generatedKeys, String origin) {
        PreparedStatement stmt = null;
        try {
            DatabaseConnector.selectDatabase();
            if (dbConnection != null) {
                stmt = dbConnection.prepareStatement(sql, generatedKeys);
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        if (stmt != null) {
            stack.push("Create Prepared Statement w/Keys - " + origin);
        }
        return stmt;
    }

    public static synchronized ResultSet createStatementResultSet(Statement stmt, String sql, String origin) {
        ResultSet rs = null;
        try {
            if (stmt != null && !stmt.isClosed()) {
                rs = stmt.executeQuery(sql);
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        if (rs != null) {
            stack.push("Create Result Set From Statement - " + origin);
        }
        return rs;
    }

    public static synchronized ResultSet createPreparedStatementResultSet(PreparedStatement stmt, String origin) {
        ResultSet rs = null;
        try {
            if (stmt != null && !stmt.isClosed()) {
                rs = stmt.executeQuery();
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        if (rs != null) {
            stack.push("Create Result Set From Prepared Statement - " + origin);
        }
        return rs;
    }

    public static void removeObject(Statement stmt) {
        DatabaseConnector.removeObject(stmt, null, null);
    }

    public static void removeObject(PreparedStatement stmt) {
        DatabaseConnector.removeObject(null, stmt, null);
    }

    public static void removeObject(ResultSet stmt) {
        DatabaseConnector.removeObject(null, null, stmt);
    }

    public static synchronized void removeObject(Statement stmt, PreparedStatement pstmt, ResultSet rs) {
        DatabaseConnector.closeStatement(stmt);
        DatabaseConnector.closePreparedStatement(pstmt);
        DatabaseConnector.closeResultSet(rs);
    }

    private static synchronized void closeStatement(Statement stmt) {
        try {
            if (stmt != null && !stmt.isClosed()) {
                stmt.close();
                stack.pop();
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private static synchronized void closePreparedStatement(PreparedStatement stmt) {
        try {
            if (stmt != null && !stmt.isClosed()) {
                stmt.close();
                stack.pop();
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private static synchronized void closeResultSet(ResultSet rs) {
        try {
            if (rs != null && !rs.isClosed()) {
                DatabaseConnector.closeStatement(rs.getStatement());
                rs.close();
                stack.pop();
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    public static synchronized void closeDatabase() {
        try {
            if (dbConnection != null && !dbConnection.isClosed()) {
                DatabaseConnector.printStack();
                dbConnection.close();
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    public static Connection getMYSQLConnection() {
        return CollectFromDatabase.getMYSQLConnection();
    }

    public static Connection getH2Connection() {
        Connection dbConnection = null;
        try {
            Class.forName("org.h2.Driver");
            dbConnection = DriverManager.getConnection("jdbc:h2:" + LocalSettings.DIRECTORY + LocalSettings.getInstance().getPropertyValue("database") + ";MV_STORE=FALSE" + "?dontTrackOpenResources=true", "admin", "ripcord");
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
            try {
                dbConnection = DriverManager.getConnection("jdbc:h2:" + LocalSettings.DIRECTORY + LocalSettings.getInstance().getPropertyValue("database") + ";MV_STORE=FALSE" + "?dontTrackOpenResources=true");
            }
            catch (Exception ex1) {
                ErrorsUtil.getInstance().logError(ex1);
            }
        }
        return dbConnection;
    }

    public static Connection getH2Connection(String dbName) {
        Connection newConnection = null;
        try {
            Class.forName("org.h2.Driver");
            newConnection = DriverManager.getConnection("jdbc:h2:" + LocalSettings.DIRECTORY + dbName + ";MV_STORE=FALSE" + "?dontTrackOpenResources=true", "admin", "ripcord");
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        return newConnection;
    }

    public static Connection getH2Connection(String dbName, String userName, String password) {
        Connection newConnection = null;
        try {
            Class.forName("org.h2.Driver");
            newConnection = DriverManager.getConnection("jdbc:h2:" + LocalSettings.DIRECTORY + dbName + ";MV_STORE=FALSE" + "?dontTrackOpenResources=true", userName, password);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        return newConnection;
    }

    public static boolean archiveDatabase(Date dateSelected) {
        CollectFromDatabase sqlDb = new CollectFromDatabase();
        return sqlDb.doArchive(dateSelected);
    }

    public static boolean convertH2ToSQL(JProgressBar progressBar, boolean convertAll, String userName, String password, String serverName) {
        boolean conversionSuccessful = false;
        CollectFromDatabase sqlDb = new CollectFromDatabase();
        String databaseName = "GamutDB";
        LocalSettings.getInstance().writeProperties("SQLDB", databaseName);
        LocalSettings.getInstance().writeProperties("SQLServer", serverName);
        LocalSettings.getInstance().writeProperties("SQLUser", userName);
        LocalSettings.getInstance().writeProperties("SQL", password);
        conversionSuccessful = sqlDb.doConvert(convertAll, userName, password, serverName, databaseName);
        if (conversionSuccessful) {
            try {
                dbConnection.close();
                LocalSettings.getInstance().writeProperties("SQLDatabaseExists", "TRUE");
                DatabaseConnector.selectDatabase();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, "Could not connect to a database. Please restart Gamut and try again.");
                ErrorsUtil.getInstance().logError(ex);
                return false;
            }
        }
        return conversionSuccessful;
    }

    public static boolean isInProgress() {
        return CollectFromDatabase.inProgress;
    }

    public static int getPercentageComplete() {
        return CollectFromDatabase.getPercentageComplete();
    }

    public static String getProgressString() {
        return CollectFromDatabase.getProgressString();
    }

    public static boolean isInitiatedShutdown() {
        return initiatedShutdown;
    }

    public static void fixInventory() {
        CollectFromDatabase sqlDb = new CollectFromDatabase();
        sqlDb.fixInventoryAndExpenses();
    }

    public static void push() {
        holdStack = true;
    }

    public static void pop() {
        holdStack = false;
    }

    public static void stackClose() {
        if (stack.empty() && !holdStack) {
            DatabaseConnector.closeDatabase();
        }
    }

    public static void printStack() {
        System.out.println(stack.toString());
    }
}

