/*
 * Decompiled with CFR 0.152.
 */
package pnp.services.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import pnp.services.util.CreationTools;
import pnp.services.util.GenericFunctions;

public class ErrorsUtil {
    private static ErrorsUtil _instance;
    public static final String ETSY_MODIFIER = "ETSY:";
    public static final String PAYPAL_MODIFIER = "PAYPAL:";
    public static final String EBAY_MODIFIER = "EBAY:";
    public static final String ENDICIA_MODIFIER = "ENDICIA:";
    public static final String STAMPS_MODIFIER = "STAMPS:";
    public static final String NO_MODIFER = "";

    public static ErrorsUtil getInstance() {
        if (null == _instance) {
            _instance = new ErrorsUtil();
        }
        return _instance;
    }

    private String checkModifier(String modifier) {
        if (!(modifier.equalsIgnoreCase(ETSY_MODIFIER) || modifier.equalsIgnoreCase(PAYPAL_MODIFIER) || modifier.equalsIgnoreCase(EBAY_MODIFIER) || modifier.equalsIgnoreCase(ENDICIA_MODIFIER) || modifier.equalsIgnoreCase(STAMPS_MODIFIER) || modifier.equalsIgnoreCase(NO_MODIFER))) {
            return NO_MODIFER;
        }
        return modifier;
    }

    public String createErrorResponse(String modifier, String errorNumber) {
        modifier = this.checkModifier(GenericFunctions.getInstance().prepareString(modifier).replace(" ", NO_MODIFER).toUpperCase());
        errorNumber = GenericFunctions.getInstance().prepareString(modifier).replace(" ", NO_MODIFER).toUpperCase();
        int actualErrorNumber = -1;
        try {
            actualErrorNumber = Integer.parseInt(errorNumber);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        if (actualErrorNumber == -1) {
            errorNumber = "0";
        }
        return modifier + errorNumber;
    }

    public String printErrorMessage(String errorID) {
        errorID = GenericFunctions.getInstance().prepareString(errorID).replace(" ", NO_MODIFER).toUpperCase();
        String errorMessage = NO_MODIFER;
        if (!errorID.isEmpty()) {
            errorMessage = errorID.contains(ETSY_MODIFIER) ? this.getEtsyErrorMessage(this.splitStringToInt(errorID, ETSY_MODIFIER)) : (errorID.contains(EBAY_MODIFIER) ? this.getEbayErrorMessage(this.splitStringToInt(errorID, EBAY_MODIFIER)) : (errorID.contains(ENDICIA_MODIFIER) ? this.getEndiciaErrorMessage(this.splitStringToInt(errorID, ENDICIA_MODIFIER)) : (errorID.contains(PAYPAL_MODIFIER) ? this.getPaypalErrorMessage(this.splitStringToInt(errorID, PAYPAL_MODIFIER)) : (errorID.contains(STAMPS_MODIFIER) ? this.getStampsErrorMessage(this.splitStringToInt(errorID, STAMPS_MODIFIER)) : (!errorID.contains(":") ? this.getGeneralErrorMessage(this.splitStringToInt(errorID, NO_MODIFER)) : "Unknown Error Thrown. Please try again or contact support if problem persists.")))));
        }
        return errorMessage;
    }

    private int splitStringToInt(String errorID, String splitCriteria) {
        String[] splitString = errorID.split(splitCriteria);
        int actualErrorID = 0;
        if (splitString != null && splitString.length == 2) {
            try {
                actualErrorID = Integer.parseInt(splitString[1]);
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return actualErrorID;
    }

    private String getGeneralErrorMessage(int errorID) {
        switch (errorID) {
            case 0: {
                return NO_MODIFER;
            }
        }
        return NO_MODIFER;
    }

    private String getStampsErrorMessage(int errorID) {
        switch (errorID) {
            case 0: {
                return NO_MODIFER;
            }
        }
        return NO_MODIFER;
    }

    private String getPaypalErrorMessage(int errorID) {
        switch (errorID) {
            case 0: {
                return NO_MODIFER;
            }
        }
        return NO_MODIFER;
    }

    private String getEndiciaErrorMessage(int errorID) {
        switch (errorID) {
            case 0: {
                return NO_MODIFER;
            }
        }
        return NO_MODIFER;
    }

    private String getEbayErrorMessage(int errorID) {
        switch (errorID) {
            case 0: {
                return NO_MODIFER;
            }
        }
        return NO_MODIFER;
    }

    private String getEtsyErrorMessage(int errorID) {
        switch (errorID) {
            case 0: {
                return NO_MODIFER;
            }
        }
        return NO_MODIFER;
    }

    private boolean checkExcepted(String message) {
        boolean logError = true;
        if (message != null) {
            if (message.contains("Invalid conversation token")) {
                logError = false;
            } else if (message.contains("Connection timed out")) {
                logError = false;
            }
        }
        return logError;
    }

    public void logError(Exception ex, boolean logError) {
        ex.printStackTrace();
    }

    public void logError(Exception ex) {
        try {
            ex.printStackTrace();
            if (this.checkExcepted(ex.getMessage())) {
                File targetFile = CreationTools.createFileSpace("Error Logs", "Error", "txt", true, true, true, true, false);
                PrintWriter pw = new PrintWriter(new FileOutputStream(targetFile, true));
                StringWriter errors = new StringWriter();
                ex.printStackTrace(new PrintWriter(errors));
                pw.append("Error Occurred: " + new Date(System.currentTimeMillis()).toString());
                pw.append("\r\n");
                pw.append(errors.toString());
                pw.append("\r\n");
                pw.append("\r\n");
                pw.flush();
                pw.close();
            }
        }
        catch (Exception ex1) {
            ex1.printStackTrace(System.out);
        }
    }

    public void writeLog(String message) {
        try {
            System.out.println(message);
            File targetFile = CreationTools.createFileSpace("Logs//Updates", "UpdateLog", "txt", true, false, false, false, false);
            PrintWriter pw = new PrintWriter(new FileOutputStream(targetFile, true));
            pw.append("Update Message: " + new Date(System.currentTimeMillis()).toString());
            pw.append("\r\n");
            pw.append(message);
            pw.append("\r\n");
            pw.append("\r\n");
            pw.flush();
            pw.close();
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }
}

