/*
 * Decompiled with CFR 0.152.
 */
package pnp.services.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.commons.codec.binary.Base64;
import pnp.services.util.ErrorsUtil;

public class GenericFunctions {
    private static GenericFunctions _instance;

    public static GenericFunctions getInstance() {
        if (null == _instance) {
            _instance = new GenericFunctions();
        }
        return _instance;
    }

    public String prepareString(String word) {
        String preparedString = "";
        try {
            if (word == null) {
                word = "";
            }
            preparedString = word.trim();
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        return preparedString;
    }

    public Float prepareFloat(String number) {
        float newFloat = 0.0f;
        number = this.prepareString(number);
        try {
            newFloat = Float.parseFloat(number);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Float.valueOf(newFloat);
    }

    public void viewImage(String base64Image) {
        this.viewImage(base64Image, 762, 1200);
    }

    public void viewImage(String base64Image, int width, int height) {
        try {
            if (base64Image.contains("UPS: ")) {
                base64Image = base64Image.replace("UPS: ", "");
            }
            Base64 imageBase = new Base64();
            byte[] btDataFile = imageBase.decode(base64Image);
            BufferedImage image = ImageIO.read(new ByteArrayInputStream(btDataFile));
            ImageIcon icon = new ImageIcon(image);
            JLabel label = new JLabel("View Image", icon, 0);
            JPanel imagePanel = new JPanel(new BorderLayout());
            JFrame frame = new JFrame();
            label.setPreferredSize(new Dimension(width, height));
            imagePanel.add((Component)label, "Center");
            imagePanel.setPreferredSize(new Dimension(width, height));
            frame.add(imagePanel);
            frame.setSize(width, height);
            frame.setVisible(true);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    public boolean createAcceptDialog(String title, String message) {
        return JOptionPane.showOptionDialog(null, message, title, 0, 3, null, null, null) == 0;
    }

    public String fixWebsitePath(String path) {
        if (path == null) {
            path = "";
        }
        path = path.replace(",", "").trim();
        return path;
    }
}

