/*
 * Decompiled with CFR 0.152.
 */
package pnp.services.util;

import java.text.DecimalFormat;
import pnp.services.util.ErrorsUtil;

public class MathParser {
    private static final char[] validOperators = new char[]{'/', '*', '+', '-'};

    private MathParser() {
    }

    private static Double evaluate(String leftSide, char oper, String rightSide) throws IllegalArgumentException {
        double total = 0.0;
        double leftResult = 0.0;
        double rightResult = 0.0;
        int operatorLoc = MathParser.findOperatorLocation(leftSide);
        if (operatorLoc > 0 && operatorLoc < leftSide.length() - 1) {
            leftResult = MathParser.evaluate(leftSide.substring(0, operatorLoc), leftSide.charAt(operatorLoc), leftSide.substring(operatorLoc + 1, leftSide.length()));
        } else {
            try {
                leftResult = Double.parseDouble(leftSide);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Invalid value found in portion of equation: " + leftSide);
            }
        }
        operatorLoc = MathParser.findOperatorLocation(rightSide);
        if (operatorLoc > 0 && operatorLoc < rightSide.length() - 1) {
            rightResult = MathParser.evaluate(rightSide.substring(0, operatorLoc), rightSide.charAt(operatorLoc), rightSide.substring(operatorLoc + 1, rightSide.length()));
        } else {
            try {
                rightResult = Double.parseDouble(rightSide);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Invalid value found in portion of equation: " + rightSide);
            }
        }
        switch (oper) {
            case '/': {
                total = leftResult / rightResult;
                break;
            }
            case '*': {
                total = leftResult * rightResult;
                break;
            }
            case '+': {
                total = leftResult + rightResult;
                break;
            }
            case '-': {
                total = leftResult - rightResult;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown operator.");
            }
        }
        return total;
    }

    private static int findOperatorLocation(String string) {
        int index = -1;
        for (int i = validOperators.length - 1; i >= 0; --i) {
            index = string.indexOf(validOperators[i]);
            if (index < 0) continue;
            return index;
        }
        return index;
    }

    public static double processEquation(String equation) throws IllegalArgumentException {
        return MathParser.evaluate(equation, '+', "0");
    }

    public static String isDollarAmount(String input) {
        if (input != null) {
            try {
                DecimalFormat df = new DecimalFormat("#.##");
                input = input.replace("(", "-");
                input = input.replace(")", "");
                input = input.replace("$", "");
                input = input.replace(",", "");
                input = input.trim();
                input = df.format(MathParser.processEquation(input));
                Double.parseDouble(input);
            }
            catch (Exception ex) {
                input = null;
            }
        }
        return input;
    }

    public static boolean isInteger(String input) {
        try {
            Integer.parseInt(input);
            return true;
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
            return false;
        }
    }

    public static boolean isDouble(String input) {
        try {
            Double.parseDouble(input);
            return true;
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
            return false;
        }
    }
}

