/*
 * Decompiled with CFR 0.152.
 */
package pnp.ups;

import StampsSDK.Address;
import StampsSDK.ContentTypeV2;
import StampsSDK.CustomsLine;
import StampsSDK.PostageBalance;
import StampsSDK.RateV11;
import com.ups.wsdl.xoltws._void.v1.VoidPortType;
import com.ups.wsdl.xoltws._void.v1.VoidService;
import com.ups.wsdl.xoltws.ship.v1.ShipConfirmErrorMessage;
import com.ups.wsdl.xoltws.ship.v1.ShipPortType;
import com.ups.wsdl.xoltws.ship.v1.ShipService;
import com.ups.wsdl.xoltws.ship.v1.ShipmentErrorMessage;
import com.ups.xmlschema.xoltws._if.v1.CN22ContentType;
import com.ups.xmlschema.xoltws._if.v1.CN22FormType;
import com.ups.xmlschema.xoltws._if.v1.InternationalFormType;
import com.ups.xmlschema.xoltws._if.v1.ProductWeightType;
import com.ups.xmlschema.xoltws._if.v1.UnitOfMeasurementType;
import com.ups.xmlschema.xoltws._void.v1.VoidShipmentRequest;
import com.ups.xmlschema.xoltws._void.v1.VoidShipmentResponse;
import com.ups.xmlschema.xoltws.common.v1.RequestType;
import com.ups.xmlschema.xoltws.common.v1.TransactionReferenceType;
import com.ups.xmlschema.xoltws.ship.v1.BillShipperType;
import com.ups.xmlschema.xoltws.ship.v1.DeliveryConfirmationType;
import com.ups.xmlschema.xoltws.ship.v1.LabelImageFormatType;
import com.ups.xmlschema.xoltws.ship.v1.LabelSpecificationType;
import com.ups.xmlschema.xoltws.ship.v1.PackageResultsType;
import com.ups.xmlschema.xoltws.ship.v1.PackageServiceOptionsType;
import com.ups.xmlschema.xoltws.ship.v1.PackageType;
import com.ups.xmlschema.xoltws.ship.v1.PackageWeightType;
import com.ups.xmlschema.xoltws.ship.v1.PackagingType;
import com.ups.xmlschema.xoltws.ship.v1.PaymentInfoType;
import com.ups.xmlschema.xoltws.ship.v1.ServiceType;
import com.ups.xmlschema.xoltws.ship.v1.ShipAcceptRequest;
import com.ups.xmlschema.xoltws.ship.v1.ShipAcceptResponse;
import com.ups.xmlschema.xoltws.ship.v1.ShipAddressType;
import com.ups.xmlschema.xoltws.ship.v1.ShipConfirmRequest;
import com.ups.xmlschema.xoltws.ship.v1.ShipConfirmResponse;
import com.ups.xmlschema.xoltws.ship.v1.ShipFromType;
import com.ups.xmlschema.xoltws.ship.v1.ShipPhoneType;
import com.ups.xmlschema.xoltws.ship.v1.ShipToAddressType;
import com.ups.xmlschema.xoltws.ship.v1.ShipToType;
import com.ups.xmlschema.xoltws.ship.v1.ShipUnitOfMeasurementType;
import com.ups.xmlschema.xoltws.ship.v1.ShipmentChargeType;
import com.ups.xmlschema.xoltws.ship.v1.ShipmentType;
import com.ups.xmlschema.xoltws.ship.v1.ShipperType;
import com.ups.xmlschema.xoltws.upss.v1.UPSSecurity;
import java.math.BigDecimal;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Holder;
import pnp.services.datatypes.MailClass;
import pnp.services.datatypes.Packaging;
import pnp.services.datatypes.PreparedIndicium;
import pnp.services.datatypes.UPSRate;
import pnp.services.util.ErrorsUtil;
import pnp.services.util.GenericFunctions;

public class UPSConnectionManager {
    private final boolean isLive = true;
    private static UPSConnectionManager _instance;
    private final String voidWSDL = "http://www.handsupsolutions.com/wsdl/Void.wsdl";
    private final String testVoidURL = "https://wwwcie.ups.com/webservices/Void";
    private final String liveVoidURL = "https://onlinetools.ups.com/webservices/Void";
    private final String shipWSDL = "http://www.handsupsolutions.com/wsdl/Ship.wsdl";
    private final String testShipURL = "https://wwwcie.ups.com/webservices/Ship";
    private final String liveShipURL = "https://onlinetools.ups.com/webservices/Ship";
    private final String accessKey = "CCC9AA929CB26CD3";
    private ShipService shipService;
    private ShipPortType shipPort;
    private boolean shipWSDLActive;
    private VoidService voidService;
    private VoidPortType voidPort;
    private boolean voidWSDLActive;
    private UPSSecurity upsSecurity;
    private boolean loggedIn;
    private ShipToType toAddress;
    private boolean toAddressAccepted;
    private ShipFromType fromAddress;
    private boolean fromAddressAccepted;
    private ShipperType shipperAddress;
    private boolean shipperAddressAccepted;
    private ServiceType service;
    private boolean serviceAccepted;
    private ShipmentType shipment;
    private ShipConfirmRequest shipConfirmRequest;
    private ShipAcceptRequest shipAcceptRequest;
    private boolean shipAccepted;
    private RequestType requestType;
    private boolean requestAccepted;
    private List<String> options;
    private PaymentInfoType paymentInformation;
    private boolean paymentInformationAccepted;
    private LabelSpecificationType labelSpecType;
    private VoidShipmentRequest voidLabel;
    private boolean voidLabelAccepted;
    private PackageType packageType;
    private boolean packageTypeAccepted;
    private String actualError;
    private String accountNumber;

    public static UPSConnectionManager getInstance() {
        if (null == _instance) {
            _instance = new UPSConnectionManager();
        }
        return _instance;
    }

    public synchronized boolean login(String userName, String password, String accountNum) {
        this.checkDefaults();
        this.resetUPSSecurity();
        userName = GenericFunctions.getInstance().prepareString(userName);
        password = GenericFunctions.getInstance().prepareString(password);
        accountNum = GenericFunctions.getInstance().prepareString(accountNum);
        if (!userName.isEmpty() && !password.isEmpty()) {
            this.upsSecurity.getUsernameToken().setPassword(password);
            this.upsSecurity.getUsernameToken().setUsername(userName);
            this.upsSecurity.getServiceAccessToken().setAccessLicenseNumber("CCC9AA929CB26CD3");
            this.accountNumber = accountNum;
            this.loggedIn = true;
        }
        return this.loggedIn;
    }

    public synchronized boolean voidLabel(String trackingNumber, String shipmentIDNumber) {
        this.checkDefaults();
        this.setVoidLabelRequest(shipmentIDNumber, trackingNumber);
        if (this.checkAccepted("Void")) {
            try {
                VoidShipmentResponse response = this.voidPort.processVoid(this.voidLabel, this.upsSecurity);
                if (response != null && response.getResponse() != null && response.getResponse().getResponseStatus() != null && response.getResponse().getResponseStatus().getDescription() != null) {
                    return response.getResponse().getResponseStatus().getDescription().equalsIgnoreCase("Success");
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return false;
    }

    public synchronized Holder<String> acceptShipment(PreparedIndicium indicium) {
        String errorCode;
        String tracking;
        String image;
        String uniqueID;
        Double amount;
        block17: {
            String shipmentDigest = (String)indicium.getIntegratorTxID().value;
            amount = 0.0;
            uniqueID = "UPS:" + UUID.randomUUID().toString();
            if (uniqueID.length() > 70) {
                uniqueID = uniqueID.substring(0, 70);
            }
            image = "";
            tracking = "";
            errorCode = "";
            this.checkDefaults();
            this.setShipAccept(shipmentDigest);
            if (this.checkAccepted("Accept")) {
                try {
                    ShipAcceptResponse shipAcceptResponse = this.shipPort.processShipAccept(this.shipAcceptRequest, this.upsSecurity);
                    if (shipAcceptResponse != null && shipAcceptResponse.getResponse() != null && shipAcceptResponse.getResponse().getResponseStatus() != null && shipAcceptResponse.getResponse().getResponseStatus().getDescription() != null) {
                        if (!shipAcceptResponse.getResponse().getResponseStatus().getDescription().equalsIgnoreCase("Success")) {
                            errorCode = "UPS Returned failure, please try again.";
                            break block17;
                        }
                        if (shipAcceptResponse.getShipmentResults() == null) break block17;
                        if (shipAcceptResponse.getShipmentResults().getPackageResults() != null && !shipAcceptResponse.getShipmentResults().getPackageResults().isEmpty() && shipAcceptResponse.getShipmentResults().getPackageResults().get(0) != null) {
                            PackageResultsType packageResults = shipAcceptResponse.getShipmentResults().getPackageResults().get(0);
                            if (packageResults.getShippingLabel() != null && packageResults.getShippingLabel().getGraphicImage() != null) {
                                image = packageResults.getShippingLabel().getGraphicImage().trim();
                            }
                            if (packageResults.getUSPSPICNumber() != null && !packageResults.getUSPSPICNumber().trim().isEmpty()) {
                                tracking = packageResults.getUSPSPICNumber().trim();
                            } else if (packageResults.getTrackingNumber() != null && !packageResults.getTrackingNumber().trim().isEmpty()) {
                                tracking = packageResults.getTrackingNumber().trim();
                            }
                        }
                        if (shipAcceptResponse.getShipmentResults().getShipmentCharges() != null && shipAcceptResponse.getShipmentResults().getShipmentCharges().getTotalCharges() != null && shipAcceptResponse.getShipmentResults().getShipmentCharges().getTotalCharges().getMonetaryValue() != null) {
                            try {
                                amount = Double.valueOf(shipAcceptResponse.getShipmentResults().getShipmentCharges().getTotalCharges().getMonetaryValue());
                            }
                            catch (Exception ex) {
                                ErrorsUtil.getInstance().logError(ex);
                            }
                        }
                        if (shipAcceptResponse.getShipmentResults().getShipmentIdentificationNumber() != null && !shipAcceptResponse.getShipmentResults().getShipmentIdentificationNumber().trim().isEmpty()) {
                            uniqueID = shipAcceptResponse.getShipmentResults().getShipmentIdentificationNumber().trim();
                        }
                        break block17;
                    }
                    errorCode = "No Response from UPS, please try again.";
                }
                catch (Exception ex) {
                    if (ex instanceof ShipmentErrorMessage) {
                        ShipConfirmErrorMessage errorMessage = (ShipConfirmErrorMessage)ex;
                        errorCode = errorMessage.getFaultInfo().getErrorDetail().get(0).getPrimaryErrorCode().getDescription();
                    }
                    ErrorsUtil.getInstance().logError(ex);
                }
            }
        }
        indicium.setTrackingNumber(new Holder());
        indicium.getTrackingNumber().value = tracking;
        indicium.setUrl(new Holder());
        indicium.getUrl().value = "UPS: " + image;
        indicium.setStampsTxID(new Holder());
        indicium.getStampsTxID().value = uniqueID;
        indicium.setRate(new Holder());
        indicium.getRate().value = new RateV11();
        ((RateV11)indicium.getRate().value).setAmount(new BigDecimal(amount));
        indicium.setPostageBalance(new Holder());
        indicium.getPostageBalance().value = new PostageBalance();
        ((PostageBalance)indicium.getPostageBalance().value).setAvailablePostage(BigDecimal.ZERO);
        indicium.getUpsIndicium().setErrorCode(errorCode);
        if (tracking != null && !tracking.trim().isEmpty()) {
            return new Holder();
        }
        return null;
    }

    private String checkWeightConstraints(PreparedIndicium indicium) {
        Packaging packagingType = indicium.getUpsIndicium().getPackageType();
        Double weight = Double.parseDouble(indicium.getUpsIndicium().getWeight());
        String code = "OZS";
        String description = "Ounces";
        String errorMessage = "";
        if (packagingType.equals((Object)Packaging.Irregulars)) {
            if (weight < 1.0 || weight >= 15.99) {
                errorMessage = "Weight must be between 1 oz and 15.99 ozs for package type: " + packagingType.actualName;
            }
        } else if (packagingType.equals((Object)Packaging.MediaMail) || packagingType.equals((Object)Packaging.ParcelPost)) {
            if (weight < 16.0 || weight >= 1120.0) {
                errorMessage = "Weight must be between 1 LB and 70 LBs for package type: " + packagingType.actualName;
            }
            code = "LBS";
            description = "Pounds";
            weight = weight / 16.0;
        } else if (packagingType.equals((Object)Packaging.Machinables) && (weight < 6.0 || weight >= 15.99)) {
            errorMessage = "Weight must be between 6 oz and 15.99 oz for package type: " + packagingType.actualName;
        }
        this.setPackage(packagingType, String.valueOf(weight), code, description);
        return errorMessage;
    }

    private void resetCustoms() {
        this.shipConfirmRequest.getShipment().setMILabelCN22Indicator(null);
        this.shipConfirmRequest.getShipment().setShipmentServiceOptions(null);
    }

    private void setCustoms(PreparedIndicium indicium) {
        this.resetCustoms();
        if (indicium.getCustoms() != null) {
            String countryOfOrigin = ((CustomsLine)indicium.getCustoms().getCustomsLines().getCustomsLine().get(0)).getCountryOfOrigin();
            String description = ((CustomsLine)indicium.getCustoms().getCustomsLines().getCustomsLine().get(0)).getDescription();
            String tariff = ((CustomsLine)indicium.getCustoms().getCustomsLines().getCustomsLine().get(0)).getHSTariffNumber();
            int quantity = 0;
            double value = 0.0;
            double weightOz = 0.0;
            for (CustomsLine indyLine : indicium.getCustoms().getCustomsLines().getCustomsLine()) {
                quantity = (int)((double)quantity + indyLine.getQuantity());
                value += indyLine.getValue().doubleValue();
                weightOz += indyLine.getWeightOz().doubleValue();
            }
            String stringQuantity = String.valueOf(quantity);
            String stringValue = String.valueOf(value);
            if (this.packageType.getPackageWeight().getUnitOfMeasurement().getCode().equalsIgnoreCase("LBS")) {
                weightOz /= 16.0;
            }
            String stringWeight = String.valueOf(weightOz);
            this.shipConfirmRequest.getShipment().setMILabelCN22Indicator("");
            this.shipConfirmRequest.getShipment().setShipmentServiceOptions(new ShipmentType.ShipmentServiceOptions());
            this.shipConfirmRequest.getShipment().getShipmentServiceOptions().setInternationalForms(new InternationalFormType());
            this.shipConfirmRequest.getShipment().getShipmentServiceOptions().getInternationalForms().setCN22Form(new CN22FormType());
            this.shipConfirmRequest.getShipment().getShipmentServiceOptions().getInternationalForms().getCN22Form().getCN22Content().add(new CN22ContentType());
            this.shipConfirmRequest.getShipment().getShipmentServiceOptions().getInternationalForms().getCN22Form().getCN22Content().get(0).setCN22ContentWeight(new ProductWeightType());
            this.shipConfirmRequest.getShipment().getShipmentServiceOptions().getInternationalForms().getCN22Form().getCN22Content().get(0).getCN22ContentWeight().setUnitOfMeasurement(new UnitOfMeasurementType());
            this.shipConfirmRequest.getShipment().getShipmentServiceOptions().getInternationalForms().getFormType().add("10");
            this.shipConfirmRequest.getShipment().getShipmentServiceOptions().getInternationalForms().getCN22Form().getCN22Content().get(0).getCN22ContentWeight().getUnitOfMeasurement().setCode(this.packageType.getPackageWeight().getUnitOfMeasurement().getCode());
            this.shipConfirmRequest.getShipment().getShipmentServiceOptions().getInternationalForms().getCN22Form().getCN22Content().get(0).getCN22ContentWeight().getUnitOfMeasurement().setDescription(this.packageType.getPackageWeight().getUnitOfMeasurement().getDescription());
            this.shipConfirmRequest.getShipment().getShipmentServiceOptions().getInternationalForms().getCN22Form().getCN22Content().get(0).setCN22ContentCountryOfOrigin(countryOfOrigin);
            this.shipConfirmRequest.getShipment().getShipmentServiceOptions().getInternationalForms().getCN22Form().getCN22Content().get(0).setCN22ContentCurrencyCode("USD");
            this.shipConfirmRequest.getShipment().getShipmentServiceOptions().getInternationalForms().getCN22Form().getCN22Content().get(0).setCN22ContentDescription(description);
            this.shipConfirmRequest.getShipment().getShipmentServiceOptions().getInternationalForms().getCN22Form().getCN22Content().get(0).setCN22ContentQuantity(stringQuantity);
            this.shipConfirmRequest.getShipment().getShipmentServiceOptions().getInternationalForms().getCN22Form().getCN22Content().get(0).setCN22ContentTariffNumber(tariff);
            this.shipConfirmRequest.getShipment().getShipmentServiceOptions().getInternationalForms().getCN22Form().getCN22Content().get(0).setCN22ContentTotalValue(stringValue);
            this.shipConfirmRequest.getShipment().getShipmentServiceOptions().getInternationalForms().getCN22Form().getCN22Content().get(0).getCN22ContentWeight().setWeight(stringWeight);
            String CN22Type = "4";
            if (indicium.getCustoms().getContentType().equals((Object)ContentTypeV2.GIFT)) {
                CN22Type = "1";
            } else if (indicium.getCustoms().getContentType().equals((Object)ContentTypeV2.DOCUMENT)) {
                CN22Type = "2";
            } else if (indicium.getCustoms().getContentType().equals((Object)ContentTypeV2.COMMERCIAL_SAMPLE)) {
                CN22Type = "3";
            }
            this.shipConfirmRequest.getShipment().getShipmentServiceOptions().getInternationalForms().getCN22Form().setCN22Type(CN22Type);
            if (CN22Type.equalsIgnoreCase("4")) {
                String otherText = indicium.getCustoms().getOtherDescribe();
                if (otherText == null || otherText.trim().isEmpty()) {
                    if (indicium.getCustoms().getContentType().equals((Object)ContentTypeV2.DANGEROUS_GOODS)) {
                        otherText = "Dangerous Goods";
                    } else if (indicium.getCustoms().getContentType().equals((Object)ContentTypeV2.HUMANITARIAN_DONATION)) {
                        otherText = "Humanitarian Donation";
                    } else if (indicium.getCustoms().getContentType().equals((Object)ContentTypeV2.MERCHANDISE)) {
                        otherText = "Retail Merchandise";
                    } else if (indicium.getCustoms().getContentType().equals((Object)ContentTypeV2.RETURNED_GOODS)) {
                        otherText = "Returned Goods";
                    }
                }
                this.shipConfirmRequest.getShipment().getShipmentServiceOptions().getInternationalForms().getCN22Form().setCN22OtherDescription(otherText);
            }
            this.shipConfirmRequest.getShipment().getShipmentServiceOptions().getInternationalForms().getCN22Form().setLabelPrintType("gif");
            this.shipConfirmRequest.getShipment().getShipmentServiceOptions().getInternationalForms().getCN22Form().setLabelSize("6");
            this.shipConfirmRequest.getShipment().getShipmentServiceOptions().getInternationalForms().getCN22Form().setPrintsPerPage("1");
        }
    }

    public synchronized UPSRate confirmShipment(PreparedIndicium indicium) {
        this.checkDefaults();
        UPSRate rate = new UPSRate();
        try {
            this.setRequestType(this.upsSecurity.getUsernameToken().getUsername(), UUID.randomUUID().toString());
            this.setPaymentInformation(this.accountNumber);
            this.setShipper(indicium.getFrom(), this.accountNumber);
            this.setTo(indicium.getTo());
            this.setFrom(indicium.getFrom());
            this.setService(indicium.getUpsIndicium().getMailClass());
            String weightErrorMessage = this.checkWeightConstraints(indicium);
            if (weightErrorMessage.trim().isEmpty()) {
                if (this.checkAccepted("Confirm")) {
                    ShipConfirmResponse shipConfirmResponse = this.shipPort.processShipConfirm(this.shipConfirmRequest, this.upsSecurity);
                    if (shipConfirmResponse != null) {
                        if (shipConfirmResponse.getResponse().getResponseStatus() != null && shipConfirmResponse.getResponse().getResponseStatus().getDescription() != null) {
                            if (!shipConfirmResponse.getResponse().getResponseStatus().getDescription().equalsIgnoreCase("Success")) {
                                rate.setErrorMessage("Failure returned. Please try again.");
                            } else if (shipConfirmResponse.getShipmentResults().getShipmentDigest() != null && !shipConfirmResponse.getShipmentResults().getShipmentDigest().trim().isEmpty()) {
                                rate.setShipmentDigest(shipConfirmResponse.getShipmentResults().getShipmentDigest().trim());
                                rate.setActualCost(Double.valueOf(0.0));
                                rate.setErrorMessage("");
                                if (shipConfirmResponse.getShipmentResults().getShipmentCharges() != null && shipConfirmResponse.getShipmentResults().getShipmentCharges().getTotalCharges() != null && shipConfirmResponse.getShipmentResults().getShipmentCharges().getTotalCharges().getMonetaryValue() != null && !shipConfirmResponse.getShipmentResults().getShipmentCharges().getTotalCharges().getMonetaryValue().trim().isEmpty()) {
                                    try {
                                        rate.setActualCost(Double.valueOf(shipConfirmResponse.getShipmentResults().getShipmentCharges().getTotalCharges().getMonetaryValue().trim()));
                                    }
                                    catch (Exception ex) {
                                        ErrorsUtil.getInstance().logError(ex);
                                    }
                                }
                            }
                        } else {
                            rate.setErrorMessage("No response from UPS. Please try again.");
                        }
                    }
                } else {
                    rate.setErrorMessage(this.actualError);
                }
            } else {
                rate.setErrorMessage(weightErrorMessage);
            }
        }
        catch (Exception ex) {
            if (ex instanceof ShipConfirmErrorMessage) {
                ShipConfirmErrorMessage errorMessage = (ShipConfirmErrorMessage)ex;
                String errorCode = errorMessage.getFaultInfo().getErrorDetail().get(0).getPrimaryErrorCode().getDescription();
                rate.defaultValues();
                rate.setErrorMessage(errorCode);
            }
            ErrorsUtil.getInstance().logError(ex);
        }
        return rate;
    }

    private void generateDefaults() {
        this.resetRequestType();
        this.resetLabel();
        this.resetUPSSecurity();
        this.resetToAddress();
        this.resetFromAddress();
        this.resetShipperAddress();
        this.resetService();
        this.resetPaymentInformation();
        this.resetPackage();
        this.resetVoidLabelRequest();
        this.resetShipAccept();
        this.resetShipment();
        this.resetShipConfirm();
    }

    private void instantiateVoidWSDL() {
        try {
            this.voidService = new VoidService(new URL("http://www.handsupsolutions.com/wsdl/Void.wsdl"));
            this.voidPort = this.voidService.getVoidPort();
            BindingProvider bp = (BindingProvider)this.voidPort;
            bp.getRequestContext().put("javax.xml.ws.service.endpoint.address", "https://onlinetools.ups.com/webservices/Void");
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        this.voidWSDLActive = this.voidService != null && this.voidPort != null;
    }

    private void instantiateShipWSDL() {
        try {
            this.shipService = new ShipService(new URL("http://www.handsupsolutions.com/wsdl/Ship.wsdl"));
            this.shipPort = this.shipService.getShipPort();
            BindingProvider bp = (BindingProvider)this.shipPort;
            bp.getRequestContext().put("javax.xml.ws.service.endpoint.address", "https://onlinetools.ups.com/webservices/Ship");
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        this.shipWSDLActive = this.shipService != null && this.shipPort != null;
    }

    private void resetUPSSecurity() {
        if (this.upsSecurity == null) {
            this.upsSecurity = new UPSSecurity();
            this.upsSecurity.setUsernameToken(new UPSSecurity.UsernameToken());
            this.upsSecurity.setServiceAccessToken(new UPSSecurity.ServiceAccessToken());
        }
        this.upsSecurity.getUsernameToken().setPassword("");
        this.upsSecurity.getUsernameToken().setUsername("");
        this.upsSecurity.getServiceAccessToken().setAccessLicenseNumber("");
        this.loggedIn = false;
    }

    private void splitAddress(List<String> addressList, String address) {
        if (addressList != null) {
            while (address.length() > 0 && addressList.size() < 3) {
                if (address.length() > 35) {
                    addressList.add(address.substring(0, 35));
                    address = address.substring(35);
                    continue;
                }
                addressList.add(address);
                address = "";
            }
        }
    }

    private void resetFromAddress() {
        if (this.fromAddress == null) {
            this.fromAddress = new ShipFromType();
            this.fromAddress.setPhone(new ShipPhoneType());
            this.fromAddress.setAddress(new ShipAddressType());
        }
        this.fromAddress.setName("");
        this.fromAddress.setAttentionName("");
        this.fromAddress.getPhone().setNumber("");
        this.fromAddress.getAddress().getAddressLine().clear();
        this.fromAddress.getAddress().setCity("");
        this.fromAddress.getAddress().setPostalCode("");
        this.fromAddress.getAddress().setStateProvinceCode("");
        this.fromAddress.getAddress().setCountryCode("");
        this.fromAddressAccepted = false;
    }

    private void resetToAddress() {
        if (this.toAddress == null) {
            this.toAddress = new ShipToType();
            this.toAddress.setPhone(new ShipPhoneType());
            this.toAddress.setAddress(new ShipToAddressType());
        }
        this.toAddress.setName("");
        this.toAddress.setAttentionName("");
        this.toAddress.getPhone().setNumber("");
        this.toAddress.getAddress().getAddressLine().clear();
        this.toAddress.getAddress().setCity("");
        this.toAddress.getAddress().setPostalCode("");
        this.toAddress.getAddress().setStateProvinceCode("");
        this.toAddress.getAddress().setCountryCode("");
        this.toAddressAccepted = false;
    }

    private void setFrom(Address from) {
        this.resetFromAddress();
        if (from != null) {
            String fullName = GenericFunctions.getInstance().prepareString(from.getFullName());
            String phoneNumber = GenericFunctions.getInstance().prepareString(from.getPhoneNumber());
            String address1 = GenericFunctions.getInstance().prepareString(from.getAddress1());
            String address2 = GenericFunctions.getInstance().prepareString(from.getAddress2());
            String address3 = GenericFunctions.getInstance().prepareString(from.getAddress3());
            String fullAddress = (address1 + " " + address2 + " " + address3).trim();
            String city = GenericFunctions.getInstance().prepareString(from.getCity());
            String zipCode = GenericFunctions.getInstance().prepareString(from.getZIPCode());
            String state = GenericFunctions.getInstance().prepareString(from.getState());
            String country = GenericFunctions.getInstance().prepareString(from.getCountry());
            if (!(fullName.isEmpty() || phoneNumber.isEmpty() || fullAddress.isEmpty() || city.isEmpty() || zipCode.isEmpty() || state.isEmpty() || country.isEmpty())) {
                this.fromAddress.setName(fullName);
                this.fromAddress.setAttentionName(fullName);
                this.fromAddress.getPhone().setNumber(phoneNumber);
                this.splitAddress(this.fromAddress.getAddress().getAddressLine(), fullAddress);
                this.fromAddress.getAddress().setCity(city);
                this.fromAddress.getAddress().setPostalCode(zipCode);
                this.fromAddress.getAddress().setStateProvinceCode(state);
                this.fromAddress.getAddress().setCountryCode(country);
                this.fromAddressAccepted = true;
            }
        }
    }

    private void setTo(Address to) {
        this.resetToAddress();
        if (to != null) {
            String state;
            String fullName = GenericFunctions.getInstance().prepareString(to.getFullName());
            String phoneNumber = GenericFunctions.getInstance().prepareString(to.getPhoneNumber());
            String address1 = GenericFunctions.getInstance().prepareString(to.getAddress1());
            String address2 = GenericFunctions.getInstance().prepareString(to.getAddress2());
            String address3 = GenericFunctions.getInstance().prepareString(to.getAddress3());
            String fullAddress = (address1 + " " + address2 + " " + address3).trim();
            String city = GenericFunctions.getInstance().prepareString(to.getCity());
            String zipCode = GenericFunctions.getInstance().prepareString(to.getZIPCode());
            if (zipCode.isEmpty()) {
                zipCode = GenericFunctions.getInstance().prepareString(to.getPostalCode());
            }
            if ((state = GenericFunctions.getInstance().prepareString(to.getState())).isEmpty()) {
                state = GenericFunctions.getInstance().prepareString(to.getProvince());
            }
            String country = GenericFunctions.getInstance().prepareString(to.getCountry());
            if (!(fullName.isEmpty() || phoneNumber.isEmpty() || fullAddress.isEmpty() || city.isEmpty() || zipCode.isEmpty() || state.isEmpty() || country.isEmpty())) {
                this.toAddress.setName(fullName);
                this.toAddress.setAttentionName(fullName);
                this.toAddress.getPhone().setNumber(phoneNumber);
                this.splitAddress(this.toAddress.getAddress().getAddressLine(), fullAddress);
                this.toAddress.getAddress().setCity(city);
                this.toAddress.getAddress().setPostalCode(zipCode);
                this.toAddress.getAddress().setStateProvinceCode(state);
                this.toAddress.getAddress().setCountryCode(country);
                this.toAddressAccepted = true;
            }
        }
    }

    private void resetShipperAddress() {
        if (this.shipperAddress == null) {
            this.shipperAddress = new ShipperType();
            this.shipperAddress.setPhone(new ShipPhoneType());
            this.shipperAddress.setAddress(new ShipAddressType());
        }
        this.shipperAddress.setShipperNumber("");
        this.shipperAddress.setName("");
        this.shipperAddress.setAttentionName("");
        this.shipperAddress.getPhone().setNumber("");
        this.shipperAddress.getAddress().getAddressLine().clear();
        this.shipperAddress.getAddress().setCity("");
        this.shipperAddress.getAddress().setPostalCode("");
        this.shipperAddress.getAddress().setStateProvinceCode("");
        this.shipperAddress.getAddress().setCountryCode("");
        this.shipperAddressAccepted = false;
    }

    private void setShipper(Address shipper, String shipperNumber) {
        this.resetShipperAddress();
        if (shipper != null) {
            String fullName = GenericFunctions.getInstance().prepareString(shipper.getFullName());
            String phoneNumber = GenericFunctions.getInstance().prepareString(shipper.getPhoneNumber());
            String address1 = GenericFunctions.getInstance().prepareString(shipper.getAddress1());
            String address2 = GenericFunctions.getInstance().prepareString(shipper.getAddress2());
            String address3 = GenericFunctions.getInstance().prepareString(shipper.getAddress3());
            String fullAddress = (address1 + " " + address2 + " " + address3).trim();
            String city = GenericFunctions.getInstance().prepareString(shipper.getCity());
            String zipCode = GenericFunctions.getInstance().prepareString(shipper.getZIPCode());
            String state = GenericFunctions.getInstance().prepareString(shipper.getState());
            String country = GenericFunctions.getInstance().prepareString(shipper.getCountry());
            shipperNumber = GenericFunctions.getInstance().prepareString(shipperNumber);
            if (!(fullName.isEmpty() || phoneNumber.isEmpty() || fullAddress.isEmpty() || city.isEmpty() || zipCode.isEmpty() || state.isEmpty() || country.isEmpty() || shipperNumber.isEmpty())) {
                this.shipperAddress.setShipperNumber(shipperNumber);
                this.shipperAddress.setName(fullName);
                this.shipperAddress.setAttentionName(fullName);
                this.shipperAddress.getPhone().setNumber(phoneNumber);
                this.splitAddress(this.shipperAddress.getAddress().getAddressLine(), fullAddress);
                this.shipperAddress.getAddress().setCity(city);
                this.shipperAddress.getAddress().setPostalCode(zipCode);
                this.shipperAddress.getAddress().setStateProvinceCode(state);
                this.shipperAddress.getAddress().setCountryCode(country);
                this.shipperAddressAccepted = true;
            }
        }
    }

    private void resetService() {
        if (this.service == null) {
            this.service = new ServiceType();
        }
        this.service.setCode("");
        this.service.setDescription("");
        this.serviceAccepted = false;
    }

    private void setService(String code, String name) {
        this.resetService();
        code = GenericFunctions.getInstance().prepareString(code);
        name = GenericFunctions.getInstance().prepareString(name);
        if (!code.isEmpty() && !name.isEmpty()) {
            this.service.setCode(code);
            this.service.setDescription(name);
            this.serviceAccepted = true;
        }
    }

    private void setService(MailClass serviceType) {
        this.resetService();
        if (serviceType != null) {
            this.setService(serviceType.code, serviceType.actualName);
        }
    }

    private void resetRequestType() {
        if (this.requestType == null) {
            this.requestType = new RequestType();
            this.requestType.setTransactionReference(new TransactionReferenceType());
        }
        this.requestType.getRequestOption().clear();
        this.requestType.getRequestOption().addAll(this.options);
        this.requestType.getTransactionReference().setCustomerContext("");
        this.requestType.getTransactionReference().setTransactionIdentifier("");
        this.requestAccepted = false;
    }

    private void setRequestType(String customerContext, String transactionIdentifier) {
        this.resetRequestType();
        customerContext = GenericFunctions.getInstance().prepareString(customerContext);
        transactionIdentifier = GenericFunctions.getInstance().prepareString(transactionIdentifier);
        if (!customerContext.isEmpty() && !transactionIdentifier.isEmpty()) {
            this.requestType.getTransactionReference().setCustomerContext(customerContext);
            this.requestType.getTransactionReference().setTransactionIdentifier(transactionIdentifier);
            this.requestAccepted = true;
        }
    }

    private void resetShipConfirm() {
        if (this.shipConfirmRequest == null) {
            this.shipConfirmRequest = new ShipConfirmRequest();
        }
        this.shipConfirmRequest.setRequest(this.requestType);
        this.shipConfirmRequest.setShipment(this.shipment);
        this.shipConfirmRequest.setLabelSpecification(this.labelSpecType);
    }

    private void setShipAccept(String shipmentDigest) {
        this.resetShipAccept();
        shipmentDigest = GenericFunctions.getInstance().prepareString(shipmentDigest);
        if (!shipmentDigest.isEmpty()) {
            this.shipAcceptRequest.setShipmentDigest(shipmentDigest);
            this.shipAccepted = true;
        }
    }

    private void resetShipAccept() {
        if (this.shipAcceptRequest == null) {
            this.shipAcceptRequest = new ShipAcceptRequest();
        }
        this.shipAcceptRequest.setRequest(this.requestType);
        this.shipAcceptRequest.setShipmentDigest("");
        this.shipAccepted = false;
    }

    private void setPaymentInformation(String accountNumber) {
        this.resetPaymentInformation();
        accountNumber = GenericFunctions.getInstance().prepareString(accountNumber);
        if (!accountNumber.isEmpty()) {
            this.paymentInformation.getShipmentCharge().get(0).getBillShipper().setAccountNumber(accountNumber);
            this.paymentInformationAccepted = true;
        }
    }

    private void resetPaymentInformation() {
        if (this.paymentInformation == null) {
            this.paymentInformation = new PaymentInfoType();
        }
        this.paymentInformation.getShipmentCharge().clear();
        this.paymentInformation.getShipmentCharge().add(new ShipmentChargeType());
        this.paymentInformation.getShipmentCharge().get(0).setType("01");
        this.paymentInformation.getShipmentCharge().get(0).setBillShipper(new BillShipperType());
        this.paymentInformation.getShipmentCharge().get(0).getBillShipper().setAccountNumber("");
        this.paymentInformationAccepted = false;
    }

    private void setPackage(String code, String name, String weight, String weightType, String weightDescription) {
        this.resetPackage();
        code = GenericFunctions.getInstance().prepareString(code);
        name = GenericFunctions.getInstance().prepareString(name);
        weight = GenericFunctions.getInstance().prepareString(weight);
        weightType = GenericFunctions.getInstance().prepareString(weightType);
        weightDescription = GenericFunctions.getInstance().prepareString(weightDescription);
        if (!(weight.isEmpty() || code.isEmpty() || name.isEmpty() || weightDescription.isEmpty() || weightType.isEmpty() || this.packageType == null)) {
            this.packageType.getPackaging().setCode(code);
            this.packageType.getPackaging().setDescription(name);
            this.packageType.getPackageWeight().setWeight(weight);
            this.packageType.getPackageWeight().getUnitOfMeasurement().setCode(weightType);
            this.packageType.getPackageWeight().getUnitOfMeasurement().setDescription(weightDescription);
            this.packageTypeAccepted = true;
        }
    }

    private void setPackage(Packaging packageTypeEnum, String weight) {
        this.resetPackage();
        if (packageTypeEnum != null) {
            this.setPackage(packageTypeEnum.code, packageTypeEnum.actualName, weight, "LBS", "Pounds");
        }
    }

    private void setPackage(Packaging packageTypeEnum, String weight, String weightType, String weightDescription) {
        this.resetPackage();
        if (packageTypeEnum != null) {
            this.setPackage(packageTypeEnum.code, packageTypeEnum.actualName, weight, weightType, weightDescription);
        }
    }

    private void resetPackage() {
        if (this.packageType == null) {
            this.packageType = new PackageType();
            this.packageType.setPackaging(new PackagingType());
            this.packageType.setPackageWeight(new PackageWeightType());
            this.packageType.getPackageWeight().setUnitOfMeasurement(new ShipUnitOfMeasurementType());
            this.packageType.setPackageServiceOptions(new PackageServiceOptionsType());
            this.packageType.getPackageServiceOptions().setDeliveryConfirmation(new DeliveryConfirmationType());
        }
        this.packageType.getPackaging().setCode("");
        this.packageType.getPackaging().setDescription("");
        this.packageType.getPackageWeight().getUnitOfMeasurement().setCode("LBS");
        this.packageType.getPackageWeight().getUnitOfMeasurement().setDescription("POUNDS");
        this.packageType.getPackageWeight().setWeight("0");
        this.packageType.getPackageServiceOptions().getDeliveryConfirmation().setDCISType("4");
        this.packageTypeAccepted = false;
    }

    private void setVoidLabelRequest(String idNumber, String trackingNumber) {
        this.resetVoidLabelRequest();
        idNumber = GenericFunctions.getInstance().prepareString(idNumber);
        trackingNumber = GenericFunctions.getInstance().prepareString(trackingNumber);
        if (!idNumber.isEmpty() && !trackingNumber.isEmpty()) {
            this.voidLabel.getVoidShipment().getTrackingNumber().add(trackingNumber);
            this.voidLabel.getVoidShipment().setShipmentIdentificationNumber(idNumber);
            this.voidLabelAccepted = true;
        }
    }

    private void resetVoidLabelRequest() {
        if (this.voidLabel == null) {
            this.voidLabel = new VoidShipmentRequest();
            this.voidLabel.setVoidShipment(new VoidShipmentRequest.VoidShipment());
        }
        this.voidLabel.setRequest(this.requestType);
        this.voidLabel.getVoidShipment().setShipmentIdentificationNumber("");
        this.voidLabel.getVoidShipment().getTrackingNumber().clear();
        this.voidLabelAccepted = false;
    }

    private void resetLabel() {
        if (this.labelSpecType == null) {
            this.labelSpecType = new LabelSpecificationType();
            this.labelSpecType.setLabelImageFormat(new LabelImageFormatType());
        }
        this.labelSpecType.getLabelImageFormat().setCode("GIF");
        this.labelSpecType.getLabelImageFormat().setDescription("GIF");
        this.labelSpecType.setHTTPUserAgent("Mozilla/4.5");
    }

    private void setShipment(String description) {
        this.resetShipment();
        this.shipment.setDescription(description);
    }

    private void resetShipment() {
        if (this.shipment == null) {
            this.shipment = new ShipmentType();
            this.shipment.setDescription("Some Goods");
            this.shipment.setShipTo(this.toAddress);
            this.shipment.setShipFrom(this.fromAddress);
            this.shipment.setShipper(this.shipperAddress);
            this.shipment.setService(this.service);
            this.shipment.setPaymentInformation(this.paymentInformation);
            this.shipment.getPackage().add(this.packageType);
            this.shipment.setUSPSEndorsement("1");
            this.shipment.setCostCenter("Standard");
            this.shipment.setPackageID("Standard");
        }
    }

    private boolean checkAccepted(String function) {
        String errorMessage = "";
        String confirmShipment = "Confirm";
        String acceptShipment = "Accept";
        String voidShipment = "Void";
        if (!this.shipWSDLActive) {
            errorMessage = errorMessage + "Problem connecting to UPS servers for general shipping methods. ";
        }
        if (!this.voidWSDLActive && function.equalsIgnoreCase(voidShipment)) {
            errorMessage = errorMessage + "Problem connecting to UPS servers for voiding shipments. ";
        }
        if (!this.packageTypeAccepted && function.equalsIgnoreCase(confirmShipment)) {
            errorMessage = errorMessage + "Invalid Package Type Detected. ";
        }
        if (!this.serviceAccepted && function.equalsIgnoreCase(confirmShipment)) {
            errorMessage = errorMessage + "Invalid Service Type Detected. ";
        }
        if (!this.fromAddressAccepted && function.equalsIgnoreCase(confirmShipment)) {
            errorMessage = errorMessage + "Invalid From Address Detected. ";
        }
        if (!this.toAddressAccepted && function.equalsIgnoreCase(confirmShipment)) {
            errorMessage = errorMessage + "Invalid To Address Detected. ";
        }
        if (!this.shipperAddressAccepted && !this.fromAddressAccepted && function.equalsIgnoreCase(confirmShipment)) {
            errorMessage = errorMessage + "Invalid Shipper Number Detected. ";
        }
        if (!this.paymentInformationAccepted && function.equalsIgnoreCase(confirmShipment)) {
            errorMessage = errorMessage + "Invalid Payment Information Detected. ";
        }
        if (!this.requestAccepted && function.equalsIgnoreCase(confirmShipment)) {
            errorMessage = errorMessage + "Invalid Request Type Detected. ";
        }
        if (!this.shipAccepted && function.equalsIgnoreCase(acceptShipment)) {
            errorMessage = errorMessage + "Invalid Shipment Digest Detected. ";
        }
        if (!this.voidLabelAccepted && function.equalsIgnoreCase(voidShipment)) {
            errorMessage = errorMessage + "Invalid Void Label Request Detected. ";
        }
        if (!errorMessage.trim().isEmpty()) {
            this.actualError = errorMessage = "Error(s): " + errorMessage.trim();
        }
        return errorMessage.trim().isEmpty();
    }

    public boolean isLive() {
        return true;
    }

    public String getActualError() {
        return "Error!";
    }

    private void checkDefaults() {
        if (this.shipService == null) {
            this.trustAll();
            this.instantiateShipWSDL();
            this.instantiateVoidWSDL();
            this.options = new ArrayList<String>();
            this.options.add("nonvalidate");
            this.actualError = "Nothing Yet.";
            this.generateDefaults();
        }
    }

    private void trustAll() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance("SSL");
            HostnameVerifier hv = new HostnameVerifier(){

                @Override
                public boolean verify(String arg0, SSLSession arg1) {
                    return true;
                }
            };
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(hv);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }
}

